/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionEventSupport;
import com.ibm.as400.access.AS400JDBCConnectionHandle;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.PoolItemProperties;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class AS400JDBCPooledConnection
implements PooledConnection {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private PoolItemProperties properties_;
    private AS400JDBCConnectionEventSupport eventManager_;

    AS400JDBCPooledConnection(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = (AS400JDBCConnection)connection;
        this.properties_ = new PoolItemProperties();
        this.eventManager_ = new AS400JDBCConnectionEventSupport();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "A new AS400JDBCPooledConnection was created");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.eventManager_.addConnectionEventListener(connectionEventListener);
    }

    public synchronized void close() throws SQLException {
        if (this.connection_.isClosed()) {
            return;
        }
        this.connection_.close();
        this.properties_.clear();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "close() was called on this AS400JDBCPooledConnection");
        }
    }

    public void closeAll() throws SQLException {
        JDError.throwSQLException("IM001");
    }

    void fireConnectionCloseEvent(ConnectionEvent connectionEvent) {
        this.returned();
        this.eventManager_.fireCloseEvent(connectionEvent);
    }

    public synchronized Connection getConnection() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "AS400JDBCPooledConnection.getConnection() was called");
        }
        if (this.connection_.isClosed()) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "This AS400JDBCPooledConnection is invalid because connection is closed.");
            }
            JDError.throwSQLException(this, "08003");
        }
        if (this.isInUse()) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "This AS400JDBCPooledConnection is already in use.");
            }
            JDError.throwSQLException(this, "08001");
        }
        this.setInUse(true);
        return new AS400JDBCConnectionHandle(this, this.connection_);
    }

    AS400JDBCConnection getInternalConnection() {
        return this.connection_;
    }

    public long getInactivityTime() {
        return this.properties_.getInactivityTime();
    }

    public long getInUseTime() {
        return this.properties_.getInUseTime();
    }

    public long getLifeSpan() {
        return this.properties_.getLifeSpan();
    }

    public int getUseCount() {
        return this.properties_.getUseCount();
    }

    boolean isConnected() throws SQLException {
        return this.connection_.getAS400().isConnected(4);
    }

    public boolean isInUse() {
        return this.properties_.isInUse();
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.eventManager_.removeConnectionEventListener(connectionEventListener);
    }

    synchronized void returned() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "This AS400JDBCPooledConnection is being returned.");
        }
        this.setInUse(false);
    }

    synchronized void setInUse(boolean bl) {
        this.properties_.setInUse(bl);
    }
}

