/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLRPBDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.JDSimpleRowCache;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDecimal;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class AS400JDBCStatement
implements Statement {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final int MAX_CURSOR_NAME_LENGTH = 18;
    static final int RETURN_GENERATED_KEYS = 1;
    static final int NO_GENERATED_KEYS = 2;
    static final int GENERATED_KEYS_NOT_SPECIFIED = -9999;
    boolean allowImmediate_ = true;
    private int autoGeneratedKeys_;
    Vector batch_;
    private String blockCriteria_;
    private int blockSize_;
    private boolean cancelled_;
    private boolean closed_;
    AS400JDBCConnection connection_;
    JDCursor cursor_;
    private String cursorDefaultName_;
    private boolean escapeProcessing_;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_;
    private int fetchDirection_;
    private int fetchSize_;
    private AS400JDBCResultSet generatedKeys_;
    int id_;
    Object internalLock_;
    private boolean lastPrepareContainsLocator_;
    private int maxFieldSize_;
    private int maxRows_;
    int rowsInserted_;
    private String name_;
    private String nameOverride_;
    int numberOfResults_;
    int positionOfSyntaxError_;
    boolean prefetch_;
    private int queryTimeout_;
    AS400JDBCResultSet resultSet_;
    private int rowCountEstimate_;
    private boolean rpbCreated_;
    private boolean rpbQueryTimeoutChanged_;
    private boolean rpbSyncNeeded_;
    JDPackageManager packageManager_;
    int resultSetConcurrency_;
    int resultSetHoldability_;
    private int resultSetType_;
    SQLConversionSettings settings_;
    private SQLWarning sqlWarning_;
    JDTransactionManager transactionManager_;
    int updateCount_;
    private String packageCriteria_;
    int behaviorOverride_ = 0;
    private boolean associatedWithLocators_ = false;
    private boolean holdStatement_ = false;
    private boolean useVariableFieldCompression_ = false;

    AS400JDBCStatement(AS400JDBCConnection aS400JDBCConnection, int n, JDTransactionManager jDTransactionManager, JDPackageManager jDPackageManager, String string, int n2, boolean bl, String string2, int n3, int n4, int n5, int n6) throws SQLException {
        this.autoGeneratedKeys_ = n6;
        this.blockCriteria_ = string;
        this.blockSize_ = n2;
        this.cancelled_ = false;
        this.closed_ = false;
        this.connection_ = aS400JDBCConnection;
        this.escapeProcessing_ = true;
        this.fetchDirection_ = 1000;
        this.fetchSize_ = 0;
        this.id_ = n;
        this.internalLock_ = new Object();
        this.maxFieldSize_ = 0;
        this.maxRows_ = 0;
        this.numberOfResults_ = 0;
        this.prefetch_ = bl;
        this.queryTimeout_ = 0;
        this.resultSet_ = null;
        this.transactionManager_ = jDTransactionManager;
        this.updateCount_ = -1;
        this.packageManager_ = jDPackageManager;
        this.resultSetConcurrency_ = n4;
        this.resultSetHoldability_ = n5;
        this.resultSetType_ = n3;
        this.rpbCreated_ = false;
        this.rpbQueryTimeoutChanged_ = false;
        this.rpbSyncNeeded_ = true;
        this.settings_ = new SQLConversionSettings(this.connection_);
        this.sqlWarning_ = null;
        this.packageCriteria_ = string2;
        String string3 = "0000" + n;
        String string4 = string3.substring(string3.length() - 4);
        this.name_ = "STMT" + string4;
        if (this.resultSetType_ == 1003) {
            this.cursorDefaultName_ = "CRSR" + string4;
            if (this.connection_.getServerFunctionalLevel() >= 14 && this.connection_.getProperties().getBoolean(65)) {
                this.useVariableFieldCompression_ = true;
            }
        } else {
            this.cursorDefaultName_ = "SCRSR" + string4;
        }
        this.cursor_ = new JDCursor(this.connection_, this.id_, this.cursorDefaultName_, this.resultSetConcurrency_);
        if (n5 != -9999) {
            aS400JDBCConnection.setCheckStatementHoldability(true);
        }
        try {
            this.behaviorOverride_ = this.connection_.getProperties().getInt(50);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, this.connection_);
            JDTrace.logProperty((Object)this, "Escape processing", this.escapeProcessing_);
            JDTrace.logProperty((Object)this, "Fetch direction", this.fetchDirection_);
            JDTrace.logProperty((Object)this, "Fetch size", this.fetchSize_);
            JDTrace.logProperty((Object)this, "Max field size", this.maxFieldSize_);
            JDTrace.logProperty((Object)this, "Max rows", this.maxRows_);
            JDTrace.logProperty((Object)this, "Query timeout", this.queryTimeout_);
            JDTrace.logProperty((Object)this, "Result set concurrency", this.resultSetConcurrency_);
            JDTrace.logProperty((Object)this, "Result set holdability", this.resultSetHoldability_);
            JDTrace.logProperty((Object)this, "Result set type", this.resultSetType_);
            JDTrace.logProperty((Object)this, "Behavior Override", this.behaviorOverride_);
            String string5 = JDTrace.objectToString(this.cursor_);
            JDTrace.logInformation(this, "Data to correlate statement with cursor " + string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String string) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (jDSQLStatement.countParameters() > 0) {
                JDError.throwSQLException("07001");
            }
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            this.batch_.addElement(jDSQLStatement);
        }
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this.connection_.cancel(this.id_);
        this.cancelled_ = true;
        this.closeResultSet(241);
    }

    void checkOpen() throws SQLException {
        this.connection_.checkOpen();
        if (this.closed_) {
            JDError.throwSQLException("HY010");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            this.batch_.removeAllElements();
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            DBBaseRequestDS dBBaseRequestDS;
            if (this.isClosed()) {
                return;
            }
            if (!this.cursor_.isClosed()) {
                this.closeResultSet(240);
            }
            if (this.numberOfResults_ > 1) {
                this.getMoreResults();
                this.cursor_.close(240);
            }
            if (this.isAssociatedWithLocators() && this.connection_.getProperties().getBoolean(63) && !this.connection_.getAutoCommit()) {
                this.setHoldStatement(true);
                this.closed_ = true;
                return;
            }
            SQLException sQLException = null;
            if (this.rpbCreated_) {
                dBBaseRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBBaseRequestDS = DBDSPool.getDBSQLRPBDS(7426, this.id_, Integer.MIN_VALUE, 0);
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS, this.id_);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0) {
                        if (n2 < 0) {
                            try {
                                JDError.throwSQLException(this.connection_, this.id_, n, n2);
                            }
                            catch (SQLException sQLException2) {
                                sQLException = sQLException2;
                            }
                        } else {
                            this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n, n2));
                        }
                    }
                    Object var9_8 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                    throw throwable;
                }
            }
            dBBaseRequestDS = null;
            try {
                dBBaseRequestDS = DBDSPool.getDBSQLResultSetDS(7937, this.id_, 0, 0);
                this.connection_.send(dBBaseRequestDS, this.id_, false);
            }
            finally {
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.inUse_ = false;
                }
            }
            this.closed_ = true;
            this.connection_.notifyClose(this, this.id_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logClose(this);
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishClosing() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            DBBaseRequestDS dBBaseRequestDS;
            SQLException sQLException = null;
            if (this.rpbCreated_) {
                dBBaseRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBBaseRequestDS = DBDSPool.getDBSQLRPBDS(7426, this.id_, Integer.MIN_VALUE, 0);
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS, this.id_);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0) {
                        if (n2 < 0) {
                            try {
                                JDError.throwSQLException(this.connection_, this.id_, n, n2);
                            }
                            catch (SQLException sQLException2) {
                                sQLException = sQLException2;
                            }
                        } else {
                            this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n, n2));
                        }
                    }
                    Object var9_8 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                    throw throwable;
                }
            }
            dBBaseRequestDS = null;
            try {
                dBBaseRequestDS = DBDSPool.getDBSQLResultSetDS(7937, this.id_, 0, 0);
                this.connection_.send(dBBaseRequestDS, this.id_, false);
            }
            finally {
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.inUse_ = false;
                }
            }
            this.closed_ = true;
            this.setHoldStatement(false);
            this.connection_.notifyClose(this, this.id_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logClose(this);
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    void closeResultSet(int n) throws SQLException {
        if (this.resultSet_ != null) {
            if (!this.resultSet_.isClosed()) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
        }
        if (!this.cursor_.isClosed()) {
            this.cursor_.close(n);
        }
        this.updateCount_ = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commonExecute(JDSQLStatement jDSQLStatement, JDServerRow jDServerRow) throws SQLException {
        this.cancelled_ = false;
        if (!this.allowImmediate_ || !jDSQLStatement.isImmediatelyExecutable()) {
            this.syncRPB();
            boolean bl = false;
            boolean bl2 = jDServerRow != null;
            boolean bl3 = this.prefetch_ && bl2;
            try {
                int n = bl2 ? (bl3 ? 6158 : 6148) : 6149;
                DBSQLRequestDS dBSQLRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                int n2 = 0;
                try {
                    boolean bl4 = jDSQLStatement.getNativeType() == 3;
                    int n3 = -2113929216;
                    boolean bl5 = false;
                    if (this.connection_.getVRM() >= JDUtilities.vrm540 && bl4 && (bl5 = this.connection_.getProperties().getBoolean(48))) {
                        n3 += 131072;
                    }
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(n, this.id_, n3, 0);
                    n2 = this.cursor_.getOpenAttributes(jDSQLStatement, this.blockCriteria_);
                    if (bl2) {
                        dBSQLRequestDS.setOpenAttributes(n2);
                    } else if (bl5) {
                        dBSQLRequestDS.setExtendedColumnDescriptorOption(-15);
                    }
                    if (this.nameOverride_.length() != 0) {
                        dBSQLRequestDS.setPrepareStatementName(this.nameOverride_, this.connection_.converter_);
                        bl = true;
                    }
                    if (this.packageManager_.isEnabled() && jDSQLStatement.isPackaged()) {
                        dBSQLRequestDS.setPackageName(this.packageManager_.getName(), this.connection_.converter_);
                    }
                    if (bl3) {
                        dBSQLRequestDS.addOperationResultBitmap(0x4000000);
                        if (n == 6158 && this.useVariableFieldCompression_) {
                            dBSQLRequestDS.setVariableFieldCompression(true);
                            dBSQLRequestDS.setBufferSize(this.blockSize_ * 1024);
                        } else {
                            dBSQLRequestDS.setBlockingFactor(this.getBlockingFactor(jDSQLStatement, jDServerRow.getRowLength()));
                        }
                    }
                    String string = this.connection_.getProperties().getString(49);
                    if (this.connection_.getVRM() < JDUtilities.vrm520) {
                        if (this.resultSetType_ == 1003) {
                            dBSQLRequestDS.setScrollableCursorFlag(0);
                        } else {
                            dBSQLRequestDS.setScrollableCursorFlag(1);
                        }
                    } else if (this.resultSetType_ == 1003) {
                        if (string.equalsIgnoreCase("insensitive") && this.resultSetConcurrency_ == 1007) {
                            dBSQLRequestDS.setScrollableCursorFlag(5);
                        } else {
                            dBSQLRequestDS.setScrollableCursorFlag(0);
                        }
                    } else if (this.resultSetType_ == 1005) {
                        if (string.equalsIgnoreCase("sensitive")) {
                            dBSQLRequestDS.setScrollableCursorFlag(3);
                        } else {
                            dBSQLRequestDS.setScrollableCursorFlag(1);
                        }
                    } else {
                        dBSQLRequestDS.setScrollableCursorFlag(2);
                    }
                    if (this.connection_.getVRM() >= JDUtilities.vrm520) {
                        if (this.resultSetHoldability_ == 2) {
                            dBSQLRequestDS.setResultSetHoldabilityOption((byte)-43);
                        } else if (this.resultSetHoldability_ == 1) {
                            dBSQLRequestDS.setResultSetHoldabilityOption((byte)-24);
                        }
                    }
                    this.commonExecuteBefore(jDSQLStatement, dBSQLRequestDS);
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                    this.cursor_.processConcurrencyOverride(n2, dBReplyRequestedDS);
                    this.transactionManager_.processCommitOnReturn(dBReplyRequestedDS);
                    DBReplySQLCA dBReplySQLCA = dBReplyRequestedDS.getSQLCA();
                    DBData dBData = null;
                    if (bl3) {
                        dBData = dBReplyRequestedDS.getResultData();
                    }
                    this.rowsInserted_ = dBReplySQLCA.getErrd(3);
                    int n4 = dBReplyRequestedDS.getErrorClass();
                    int n5 = dBReplyRequestedDS.getReturnCode();
                    if (bl2 && (n4 != 1 || n5 != -666)) {
                        this.cursor_.setState(false);
                    }
                    boolean bl6 = false;
                    if ((n4 == 1 && n5 == 100 || n4 == 2 && n5 == 701) && n == 6158) {
                        bl6 = true;
                    } else if (n4 != 0) {
                        this.positionOfSyntaxError_ = dBReplySQLCA.getErrd(5);
                        if (n5 < 0) {
                            JDError.throwSQLException(this.connection_, this.id_, n4, n5);
                        } else {
                            this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n4, n5));
                        }
                    }
                    if (this.autoGeneratedKeys_ == 1 && this.connection_.getVRM() >= JDUtilities.vrm520) {
                        this.makeGeneratedKeyResultSet(n5, dBReplySQLCA);
                    }
                    if (bl2) {
                        JDServerRowCache jDServerRowCache = bl3 && dBData != null ? new JDServerRowCache(jDServerRow, this.connection_, this.id_, this.getBlockingFactor(jDSQLStatement, jDServerRow.getRowLength()), dBData, bl6, this.resultSetType_) : new JDServerRowCache(jDServerRow, this.connection_, this.id_, this.getBlockingFactor(jDSQLStatement, jDServerRow.getRowLength()), this.resultSetType_);
                        int n6 = this.resultSetConcurrency_ == 1008 ? this.cursor_.getConcurrency() : this.resultSetConcurrency_;
                        this.updateCount_ = -1;
                        this.rowCountEstimate_ = dBReplySQLCA.getErrd(3);
                        this.resultSet_ = new AS400JDBCResultSet(this, jDSQLStatement, jDServerRowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, n6, this.fetchDirection_, this.fetchSize_);
                        if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_) {
                            this.postWarning(JDError.getSQLWarning("01S02"));
                        }
                    } else {
                        this.updateCount_ = dBReplySQLCA.getErrd(3);
                        this.rowCountEstimate_ = -1;
                    }
                    this.numberOfResults_ = bl4 ? dBReplySQLCA.getErrd(2) : 0;
                    if (bl5) {
                        this.extendedColumnDescriptors_ = dBReplyRequestedDS.getExtendedColumnDescriptors();
                    }
                    if (jDSQLStatement != null && bl4 && this.numberOfResults_ > 0 && this.resultSet_ == null) {
                        boolean bl7 = this.connection_.getVRM() < JDUtilities.vrm530;
                        JDServerRow jDServerRow2 = new JDServerRow(this.connection_, this.id_, this.cursor_.openDescribe(n2, this.resultSetType_), this.settings_);
                        JDServerRowCache jDServerRowCache = new JDServerRowCache(jDServerRow2, this.connection_, this.id_, this.getBlockingFactor(jDSQLStatement, jDServerRow2.getRowLength()), bl7 ? 1003 : this.resultSetType_);
                        this.resultSet_ = bl7 ? new AS400JDBCResultSet(this, jDSQLStatement, jDServerRowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, 1003, 1007, this.fetchDirection_, this.fetchSize_) : new AS400JDBCResultSet(this, jDSQLStatement, jDServerRowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, 1007, this.fetchDirection_, this.fetchSize_);
                        if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_) {
                            this.postWarning(JDError.getSQLWarning("01S02"));
                        }
                    }
                    this.commonExecuteAfter(jDSQLStatement, dBReplyRequestedDS);
                    Object var23_25 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var23_26 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                    throw throwable;
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
            this.transactionManager_.statementExecuted();
            if (this.cancelled_) {
                JDError.throwSQLException("HY008");
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executed " + (bl ? this.nameOverride_ : this.name_ + "*") + ", SQL Statement --> [" + jDSQLStatement + "]");
                JDTrace.logInformation(this, "Update count = " + this.updateCount_);
                JDTrace.logInformation(this, "Result set = " + (this.resultSet_ != null));
                JDTrace.logInformation(this, "Number of result sets = " + this.numberOfResults_);
                JDTrace.logInformation(this, "Row count estimate = " + this.rowCountEstimate_);
            }
        }
    }

    void commonExecuteAfter(JDSQLStatement jDSQLStatement, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
    }

    void commonExecuteBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        this.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDServerRow commonPrepare(JDSQLStatement jDSQLStatement) throws SQLException {
        Object object;
        int n;
        this.cancelled_ = false;
        this.connection_.checkAccess(jDSQLStatement);
        JDServerRow jDServerRow = null;
        this.nameOverride_ = "";
        if (jDSQLStatement.isDRDAConnect()) {
            this.connection_.setDRDA(true);
        } else if (jDSQLStatement.isDRDADisconnect()) {
            this.connection_.setDRDA(false);
        }
        if (!this.packageManager_.isCreated()) {
            this.packageManager_.create();
        }
        if (this.packageManager_.isCached() && jDSQLStatement.isPackaged() && (n = this.packageManager_.getCachedStatementIndex(jDSQLStatement)) != -1) {
            object = this.packageManager_.getCachedDataFormat(n);
            jDServerRow = object == null ? null : new JDServerRow(this.connection_, this.id_, (DBDataFormat)object, this.settings_);
            this.commonPrepareBypass(jDSQLStatement, n);
            this.nameOverride_ = this.packageManager_.getCachedStatementName(n);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Statement [" + jDSQLStatement + "] was found " + "in the cached package as " + this.nameOverride_);
            }
        }
        if (this.nameOverride_.length() == 0) {
            int n2;
            int n3;
            int n4;
            if (jDSQLStatement.getNativeType() == 6) {
                this.syncRPB();
                DBSQLRequestDS dBSQLRequestDS = null;
                object = null;
                try {
                    Object var9_18;
                    try {
                        dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6153, this.id_, -2113929216, 0);
                        boolean bl = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            bl = true;
                        }
                        dBSQLRequestDS.setStatementText(jDSQLStatement.toString(), AS400JDBCConnection.unicodeConverter_, bl);
                        dBSQLRequestDS.setStatementType(jDSQLStatement.getNativeType());
                        if (this.packageManager_.isEnabled()) {
                            if (jDSQLStatement.isPackaged()) {
                                dBSQLRequestDS.setPrepareOption(1);
                                dBSQLRequestDS.setPackageName(this.packageManager_.getName(), this.connection_.converter_);
                            } else {
                                dBSQLRequestDS.setPrepareOption(0);
                                dBSQLRequestDS.setPackageName(null, this.connection_.converter_);
                            }
                        } else {
                            dBSQLRequestDS.setPrepareOption(0);
                        }
                        this.commonPrepareBefore(jDSQLStatement, dBSQLRequestDS);
                        this.commonExecuteBefore(jDSQLStatement, dBSQLRequestDS);
                        object = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                        n4 = ((DBBaseReplyDS)object).getErrorClass();
                        n3 = ((DBBaseReplyDS)object).getReturnCode();
                        if (n4 != 0) {
                            this.positionOfSyntaxError_ = ((DBBaseReplyDS)object).getSQLCA().getErrd(5);
                            if (n3 < 0) {
                                JDError.throwSQLException(this.connection_, this.id_, n4, n3);
                            } else {
                                this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n4, n3));
                            }
                        }
                        this.updateCount_ = 0;
                        this.numberOfResults_ = 0;
                        this.commonPrepareAfter(jDSQLStatement, (DBReplyRequestedDS)object);
                        this.commonExecuteAfter(jDSQLStatement, (DBReplyRequestedDS)object);
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        JDError.throwSQLException("HY000", dBDataStreamException);
                        var9_18 = null;
                        if (dBSQLRequestDS != null) {
                            dBSQLRequestDS.inUse_ = false;
                        }
                        if (object != null) {
                            ((ClientAccessDataStream)object).inUse_ = false;
                        }
                    }
                    var9_18 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (object != null) {
                        ((ClientAccessDataStream)object).inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_19 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (object != null) {
                        ((ClientAccessDataStream)object).inUse_ = false;
                    }
                    throw throwable;
                }
                this.transactionManager_.statementExecuted();
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executed connect " + this.name_ + "*, SQL Statement -->[" + jDSQLStatement + "]");
                }
            } else if (this.allowImmediate_ && jDSQLStatement.isImmediatelyExecutable()) {
                this.syncRPB();
                DBSQLRequestDS dBSQLRequestDS = null;
                object = null;
                try {
                    Object var17_31;
                    try {
                        int n5 = -2113929216;
                        n4 = 0;
                        if (this.connection_.getVRM() >= JDUtilities.vrm520 && (n4 = this.connection_.getProperties().getBoolean(48)) != 0) {
                            n5 += 131072;
                        }
                        dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6150, this.id_, n5, 0);
                        n3 = 0;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            n3 = 1;
                        }
                        dBSQLRequestDS.setStatementText(jDSQLStatement.toString(), AS400JDBCConnection.unicodeConverter_, n3 != 0);
                        dBSQLRequestDS.setStatementType(jDSQLStatement.getNativeType());
                        n2 = this.cursor_.getOpenAttributes(jDSQLStatement, this.blockCriteria_);
                        dBSQLRequestDS.setOpenAttributes(n2);
                        if (this.packageManager_.isEnabled()) {
                            if (jDSQLStatement.isPackaged()) {
                                dBSQLRequestDS.setPrepareOption(1);
                                dBSQLRequestDS.setPackageName(this.packageManager_.getName(), this.connection_.converter_);
                            } else {
                                dBSQLRequestDS.setPrepareOption(0);
                                dBSQLRequestDS.setPackageName(null, this.connection_.converter_);
                            }
                        } else {
                            dBSQLRequestDS.setPrepareOption(0);
                        }
                        if (n4 != 0) {
                            dBSQLRequestDS.setExtendedColumnDescriptorOption(-15);
                        }
                        this.commonPrepareBefore(jDSQLStatement, dBSQLRequestDS);
                        this.commonExecuteBefore(jDSQLStatement, dBSQLRequestDS);
                        object = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                        int n6 = ((DBBaseReplyDS)object).getErrorClass();
                        int n7 = ((DBBaseReplyDS)object).getReturnCode();
                        DBReplySQLCA dBReplySQLCA = ((DBBaseReplyDS)object).getSQLCA();
                        if (n6 != 0) {
                            this.positionOfSyntaxError_ = dBReplySQLCA.getErrd(5);
                            if (n7 < 0) {
                                JDError.throwSQLException(this.connection_, this.id_, n6, n7);
                            } else {
                                this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n6, n7));
                            }
                        }
                        this.transactionManager_.processCommitOnReturn((DBBaseReplyDS)object);
                        this.updateCount_ = dBReplySQLCA.getErrd(3);
                        this.rowCountEstimate_ = -1;
                        if (n4 != 0) {
                            this.extendedColumnDescriptors_ = ((DBBaseReplyDS)object).getExtendedColumnDescriptors();
                        }
                        if (this.autoGeneratedKeys_ == 1 && this.connection_.getVRM() >= JDUtilities.vrm520) {
                            this.makeGeneratedKeyResultSet(n7, dBReplySQLCA);
                        }
                        boolean bl = jDSQLStatement.getNativeType() == 3;
                        this.numberOfResults_ = bl ? dBReplySQLCA.getErrd(2) : 0;
                        if (bl && this.numberOfResults_ > 0) {
                            boolean bl2 = this.connection_.getVRM() < JDUtilities.vrm530;
                            JDServerRow jDServerRow2 = new JDServerRow(this.connection_, this.id_, this.cursor_.openDescribe(n2, this.resultSetType_), this.settings_);
                            JDServerRowCache jDServerRowCache = new JDServerRowCache(jDServerRow2, this.connection_, this.id_, this.getBlockingFactor(jDSQLStatement, jDServerRow2.getRowLength()), bl2 ? 1003 : this.resultSetType_);
                            this.resultSet_ = bl2 ? new AS400JDBCResultSet(this, jDSQLStatement, jDServerRowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, 1003, 1007, this.fetchDirection_, this.fetchSize_) : new AS400JDBCResultSet(this, jDSQLStatement, jDServerRowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, 1007, this.fetchDirection_, this.fetchSize_);
                            if (this.resultSet_.getConcurrency() != this.resultSetConcurrency_) {
                                this.postWarning(JDError.getSQLWarning("01S02"));
                            }
                        }
                        this.commonPrepareAfter(jDSQLStatement, (DBReplyRequestedDS)object);
                        this.commonExecuteAfter(jDSQLStatement, (DBReplyRequestedDS)object);
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        JDError.throwSQLException("HY000", dBDataStreamException);
                        var17_31 = null;
                        if (dBSQLRequestDS != null) {
                            dBSQLRequestDS.inUse_ = false;
                        }
                        if (object != null) {
                            ((ClientAccessDataStream)object).inUse_ = false;
                        }
                    }
                    var17_31 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (object != null) {
                        ((ClientAccessDataStream)object).inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_32 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (object != null) {
                        ((ClientAccessDataStream)object).inUse_ = false;
                    }
                    throw throwable;
                }
                this.transactionManager_.statementExecuted();
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Executed immediately " + this.name_ + "*, SQL Statement -->[" + jDSQLStatement + "]");
                    JDTrace.logInformation(this, "Update count = " + this.updateCount_);
                    JDTrace.logInformation(this, "Result set = " + (this.resultSet_ != null));
                    JDTrace.logInformation(this, "Number of result sets = " + this.numberOfResults_);
                }
            } else {
                this.syncRPB();
                DBSQLRequestDS dBSQLRequestDS = null;
                object = null;
                try {
                    Object var19_34;
                    try {
                        DBDataFormat dBDataFormat;
                        int n8 = -1979711488;
                        n4 = 0;
                        if (this.connection_.getVRM() >= JDUtilities.vrm520 && (n4 = this.connection_.getProperties().getBoolean(48)) != 0) {
                            n8 += 131072;
                        }
                        dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6147, this.id_, n8, 0);
                        n3 = 0;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            n3 = 1;
                        }
                        dBSQLRequestDS.setStatementText(jDSQLStatement.toString(), AS400JDBCConnection.unicodeConverter_, n3 != 0);
                        dBSQLRequestDS.setStatementType(jDSQLStatement.getNativeType());
                        if (this.packageManager_.isEnabled()) {
                            if (jDSQLStatement.isPackaged()) {
                                dBSQLRequestDS.setPrepareOption(1);
                                dBSQLRequestDS.setPackageName(this.packageManager_.getName(), this.connection_.converter_);
                            } else {
                                dBSQLRequestDS.setPrepareOption(0);
                                dBSQLRequestDS.setPackageName(null, this.connection_.converter_);
                            }
                        } else {
                            dBSQLRequestDS.setPrepareOption(0);
                        }
                        if (n4 != 0) {
                            dBSQLRequestDS.setExtendedColumnDescriptorOption(-15);
                        }
                        this.commonPrepareBefore(jDSQLStatement, dBSQLRequestDS);
                        object = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                        n2 = ((DBBaseReplyDS)object).getErrorClass();
                        int n9 = ((DBBaseReplyDS)object).getReturnCode();
                        if (n2 != 0) {
                            this.positionOfSyntaxError_ = ((DBBaseReplyDS)object).getSQLCA().getErrd(5);
                            if (n9 < 0) {
                                JDError.throwSQLException(this.connection_, this.id_, n2, n9);
                            } else {
                                this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n2, n9));
                            }
                        }
                        jDServerRow = (dBDataFormat = ((DBBaseReplyDS)object).getDataFormat()) == null ? null : new JDServerRow(this.connection_, this.id_, dBDataFormat, this.settings_);
                        if (n4 != 0) {
                            this.extendedColumnDescriptors_ = ((DBBaseReplyDS)object).getExtendedColumnDescriptors();
                        }
                        this.commonPrepareAfter(jDSQLStatement, (DBReplyRequestedDS)object);
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        JDError.throwSQLException("HY000", dBDataStreamException);
                        var19_34 = null;
                        if (dBSQLRequestDS != null) {
                            dBSQLRequestDS.inUse_ = false;
                        }
                        if (object != null) {
                            ((ClientAccessDataStream)object).inUse_ = false;
                        }
                    }
                    var19_34 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (object != null) {
                        ((ClientAccessDataStream)object).inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_35 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (object != null) {
                        ((ClientAccessDataStream)object).inUse_ = false;
                    }
                    throw throwable;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Prepared " + this.name_ + "*, SQL Statement -->[" + jDSQLStatement + "]");
                }
            }
        }
        if (this.cancelled_) {
            JDError.throwSQLException("HY008");
        }
        this.lastPrepareContainsLocator_ = false;
        if (jDServerRow != null) {
            n = jDServerRow.getFieldCount();
            for (int i = 1; i <= n; ++i) {
                SQLData sQLData = jDServerRow.getSQLData(i);
                if (sQLData.getSQLType() != 8 && sQLData.getSQLType() != 4 && sQLData.getSQLType() != 12) continue;
                this.lastPrepareContainsLocator_ = true;
            }
        }
        return jDServerRow;
    }

    void commonPrepareAfter(JDSQLStatement jDSQLStatement, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
    }

    void commonPrepareBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        this.closeResultSet(241);
    }

    void commonPrepareBypass(JDSQLStatement jDSQLStatement, int n) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executing SQL Statement -->[" + jDSQLStatement + "]");
            }
            if (jDSQLStatement.countParameters() > 0) {
                JDError.throwSQLException("07001");
            }
            JDServerRow jDServerRow = this.commonPrepare(jDSQLStatement);
            this.commonExecute(jDSQLStatement, jDServerRow);
            return this.resultSet_ != null;
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm520) {
            JDError.throwSQLException("IM001");
        }
        AS400JDBCStatement.verifyGeneratedKeysParameter(n);
        this.autoGeneratedKeys_ = n;
        return this.execute(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        JDError.throwSQLException("IM001");
        return false;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        JDError.throwSQLException("IM001");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            int n = this.batch_.size();
            int[] nArray = new int[n];
            int n2 = 0;
            try {
                Enumeration enumeration = this.batch_.elements();
                while (enumeration.hasMoreElements()) {
                    JDServerRow jDServerRow;
                    JDSQLStatement jDSQLStatement = (JDSQLStatement)enumeration.nextElement();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Executing from batch SQL Statement -->[" + jDSQLStatement + "]");
                    }
                    if ((jDServerRow = this.commonPrepare(jDSQLStatement)) != null) {
                        JDError.throwSQLException("24000");
                    }
                    this.commonExecute(jDSQLStatement, jDServerRow);
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException("24000");
                    }
                    nArray[n2++] = this.updateCount_;
                }
            }
            catch (SQLException sQLException) {
                int[] nArray2 = new int[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                this.batch_.removeAllElements();
                throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
            }
            this.batch_.removeAllElements();
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executing query, SQL Statement -->[" + jDSQLStatement + "]");
            }
            if (jDSQLStatement.countParameters() > 0) {
                JDError.throwSQLException("07001");
            }
            JDServerRow jDServerRow = this.commonPrepare(jDSQLStatement);
            this.commonExecute(jDSQLStatement, jDServerRow);
            if ((this.behaviorOverride_ & 1) == 0 && this.resultSet_ == null) {
                JDError.throwSQLException("24000");
            }
            return this.resultSet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            JDServerRow jDServerRow;
            this.checkOpen();
            JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.settings_.getDecimalSeparator(), this.escapeProcessing_, this.packageCriteria_, this.connection_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Executing update, SQL Statement -->[" + jDSQLStatement + "]");
            }
            if (jDSQLStatement.countParameters() > 0) {
                JDError.throwSQLException("07001");
            }
            if ((jDServerRow = this.commonPrepare(jDSQLStatement)) != null) {
                JDError.throwSQLException("24000");
            }
            this.commonExecute(jDSQLStatement, jDServerRow);
            if (this.resultSet_ != null) {
                this.closeResultSet(241);
                JDError.throwSQLException("24000");
            }
            return this.updateCount_;
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm520) {
            JDError.throwSQLException("IM001");
        }
        AS400JDBCStatement.verifyGeneratedKeysParameter(n);
        this.autoGeneratedKeys_ = n;
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        JDError.throwSQLException("IM001");
        return 0;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        JDError.throwSQLException("IM001");
        return 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    int getBlockingFactor(JDSQLStatement jDSQLStatement, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        if (this.cursor_.getConcurrency() != 1008 && !this.lastPrepareContainsLocator_) {
            if (this.blockCriteria_.equalsIgnoreCase("0")) {
                bl = true;
                bl2 = true;
            }
            if (jDSQLStatement != null) {
                if (this.blockCriteria_.equalsIgnoreCase("1") && jDSQLStatement.isForFetchOnly()) {
                    bl = true;
                } else if (this.blockCriteria_.equalsIgnoreCase("2") && !jDSQLStatement.isForUpdate()) {
                    bl = true;
                }
            } else if (this.blockCriteria_.equalsIgnoreCase("2")) {
                bl = true;
            }
        }
        if (bl) {
            if (bl2) {
                n2 = this.fetchSize_;
            } else {
                n2 = this.blockSize_ * 1024 / n;
                if (n2 > Short.MAX_VALUE) {
                    n2 = Short.MAX_VALUE;
                } else if (n2 <= 0) {
                    n2 = 1;
                }
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    public Connection getConnection() throws SQLException {
        return this.connection_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCursorName() {
        Object object = this.internalLock_;
        synchronized (object) {
            return this.cursor_.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBExtendedColumnDescriptors getExtendedColumnDescriptors() {
        Object object = this.internalLock_;
        synchronized (object) {
            return this.extendedColumnDescriptors_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.fetchDirection_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.fetchSize_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getGeneratedKeys() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (this.connection_.getVRM() < JDUtilities.vrm520) {
                JDError.throwSQLException("IM001");
                return null;
            }
            this.checkOpen();
            return this.generatedKeys_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFieldSize() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.maxFieldSize_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRows() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.maxRows_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.cancelled_ = false;
            this.checkOpen();
            this.closeResultSet(242);
            if (--this.numberOfResults_ > 0) {
                DBSQLRequestDS dBSQLRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    block27: {
                        try {
                            Object object2;
                            dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6148, this.id_, -1979711488, 0);
                            int n = this.cursor_.getOpenAttributes(null, this.blockCriteria_);
                            dBSQLRequestDS.setOpenAttributes(n);
                            if (this.connection_.getVRM() >= JDUtilities.vrm530) {
                                object2 = this.connection_.getProperties().getString(49);
                                if (this.resultSetType_ == 1003) {
                                    if (((String)object2).equalsIgnoreCase("insensitive")) {
                                        dBSQLRequestDS.setScrollableCursorFlag(5);
                                    } else {
                                        dBSQLRequestDS.setScrollableCursorFlag(0);
                                    }
                                } else if (this.resultSetType_ == 1005) {
                                    if (((String)object2).equalsIgnoreCase("asensitive")) {
                                        dBSQLRequestDS.setScrollableCursorFlag(1);
                                    } else {
                                        dBSQLRequestDS.setScrollableCursorFlag(3);
                                    }
                                } else {
                                    dBSQLRequestDS.setScrollableCursorFlag(2);
                                }
                            }
                            dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                            object2 = dBReplyRequestedDS.getSQLCA();
                            DBDataFormat dBDataFormat = dBReplyRequestedDS.getDataFormat();
                            int n2 = dBReplyRequestedDS.getErrorClass();
                            int n3 = dBReplyRequestedDS.getReturnCode();
                            if (n2 != 0) {
                                if (n3 < 0) {
                                    JDError.throwSQLException(this.connection_, this.id_, n2, n3);
                                } else {
                                    this.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n2, n3));
                                }
                            }
                            this.cursor_.processConcurrencyOverride(n, dBReplyRequestedDS);
                            this.cursor_.setState(false);
                            JDServerRow jDServerRow = new JDServerRow(this.connection_, this.id_, dBDataFormat, this.settings_);
                            JDServerRowCache jDServerRowCache = new JDServerRowCache(jDServerRow, this.connection_, this.id_, this.getBlockingFactor(null, jDServerRow.getRowLength()), this.resultSetType_);
                            int n4 = this.resultSetConcurrency_ == 1008 ? this.cursor_.getConcurrency() : this.resultSetConcurrency_;
                            this.resultSet_ = new AS400JDBCResultSet(this, null, jDServerRowCache, this.connection_.getCatalog(), this.cursor_.getName(), this.maxRows_, this.resultSetType_, n4, this.fetchDirection_, this.fetchSize_);
                            if (this.resultSet_.getConcurrency() == this.resultSetConcurrency_) break block27;
                            this.postWarning(JDError.getSQLWarning("01S02"));
                        }
                        catch (DBDataStreamException dBDataStreamException) {
                            JDError.throwSQLException("HY000", dBDataStreamException);
                            Object var13_14 = null;
                            if (dBSQLRequestDS != null) {
                                dBSQLRequestDS.inUse_ = false;
                            }
                            if (dBReplyRequestedDS != null) {
                                dBReplyRequestedDS.inUse_ = false;
                            }
                        }
                    }
                    Object var13_13 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                    throw throwable;
                }
            }
            if (this.cancelled_) {
                JDError.throwSQLException("HY008");
            }
            this.updateCount_ = -1;
            return this.resultSet_ != null;
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        JDError.throwSQLException("IM001");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPositionOfSyntaxError() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.positionOfSyntaxError_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryTimeout() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.queryTimeout_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.resultSet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetConcurrency() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.resultSetConcurrency_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetHoldability() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.resultSetHoldability_ == 1 || this.resultSetHoldability_ == 2) {
                return this.resultSetHoldability_;
            }
            return this.connection_.getHoldability();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetType() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.resultSetType_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdateCount() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.resultSet_ != null ? -1 : this.updateCount_;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    void setHoldStatement(boolean bl) {
        this.holdStatement_ = bl;
    }

    boolean isHoldStatement() {
        return this.holdStatement_;
    }

    void setAssociatedWithLocators(boolean bl) {
        this.associatedWithLocators_ = bl;
    }

    boolean isAssociatedWithLocators() {
        return this.associatedWithLocators_;
    }

    boolean isClosed() {
        return this.closed_;
    }

    private void makeGeneratedKeyResultSet(int n, DBReplySQLCA dBReplySQLCA) throws SQLException {
        if (this.generatedKeys_ != null) {
            this.generatedKeys_.close();
        }
        BigDecimal bigDecimal = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "returnCode is: " + n);
        }
        if (n < 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "return code was not 0, generated key is null");
            }
        } else {
            bigDecimal = dBReplySQLCA.getGeneratedKey();
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "generated key from server is: " + bigDecimal);
            }
        }
        String[] stringArray = new String[]{""};
        SQLData[] sQLDataArray = new SQLData[]{new SQLDecimal(30, 0, this.settings_, this.connection_.getVRM(), this.connection_.getProperties())};
        int[] nArray = new int[]{0};
        JDSimpleRow jDSimpleRow = new JDSimpleRow(stringArray, sQLDataArray, nArray);
        boolean[][] blArrayArray = new boolean[][]{{false}};
        boolean[][] blArrayArray2 = new boolean[][]{{false}};
        JDSimpleRowCache jDSimpleRowCache = null;
        if (bigDecimal == null) {
            jDSimpleRowCache = new JDSimpleRowCache(jDSimpleRow);
        } else {
            Object[][] objectArray = new Object[][]{{bigDecimal}};
            jDSimpleRowCache = new JDSimpleRowCache(jDSimpleRow, objectArray, blArrayArray, blArrayArray2);
        }
        this.generatedKeys_ = new AS400JDBCResultSet(jDSimpleRowCache, "", "");
    }

    void markCursorClosed(boolean bl) throws SQLException {
        boolean bl2 = this.connection_.getProperties().getBoolean(64);
        if (bl2) {
            bl = false;
        }
        if (this.getResultSetHoldability() == 2 || bl) {
            if (this.resultSet_ != null) {
                if (!this.resultSet_.isClosed()) {
                    this.resultSet_.close();
                }
                this.resultSet_ = null;
            }
            this.updateCount_ = -1;
        }
    }

    void notifyClose() throws SQLException {
        if (!this.cursor_.isClosed()) {
            if (this.numberOfResults_ > 1) {
                this.cursor_.close(242);
            } else {
                this.cursor_.close(241);
            }
        }
    }

    void postWarning(SQLWarning sQLWarning) {
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sQLWarning;
        } else {
            this.sqlWarning_.setNextWarning(sQLWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorName(String string) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            int n;
            this.checkOpen();
            if (this.resultSet_ != null) {
                if (!this.resultSet_.isClosed()) {
                    JDError.throwSQLException("24000");
                } else {
                    this.closeResultSet(241);
                }
            }
            if (string == null) {
                string = this.cursorDefaultName_;
            }
            if ((n = string.length()) > 18 || n == 0) {
                JDError.throwSQLException("34000");
            }
            if (!string.equals(this.cursor_.getName())) {
                if (this.connection_.isCursorNameUsed(string)) {
                    JDError.throwSQLException("3C000");
                }
                this.cursor_.setName(string);
                this.rpbSyncNeeded_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeProcessing(boolean bl) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            this.escapeProcessing_ = bl;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Escape processing", this.escapeProcessing_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (n != 1000 && n != 1001 && n != 1002 || this.resultSetType_ == 1003 && n != 1000) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchDirection_ = n;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Fetch direction", this.fetchDirection_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (n < 0 || n > this.maxRows_ && this.maxRows_ > 0) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchSize_ = n;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Fetch size", this.fetchSize_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 0) {
                JDError.throwSQLException("HY024");
            }
            this.maxFieldSize_ = n;
            this.settings_.setMaxFieldSize(this.maxFieldSize_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Max field size", this.maxFieldSize_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 0) {
                JDError.throwSQLException("HY024");
            }
            this.maxRows_ = n;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Max rows", this.maxRows_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 0) {
                JDError.throwSQLException("HY024");
            }
            if (this.queryTimeout_ != n) {
                this.queryTimeout_ = n;
                this.rpbSyncNeeded_ = true;
                this.rpbQueryTimeoutChanged_ = true;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Query timeout", this.queryTimeout_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRPB() throws SQLException {
        if (this.rpbSyncNeeded_) {
            int n = this.rpbCreated_ ? 7427 : 7424;
            DBSQLRPBDS dBSQLRPBDS = null;
            try {
                dBSQLRPBDS = DBDSPool.getDBSQLRPBDS(n, this.id_, 0, 0);
                dBSQLRPBDS.setPrepareStatementName(this.name_, this.connection_.converter_);
                dBSQLRPBDS.setCursorName(this.cursor_.getName(), this.connection_.converter_);
                if (this.packageManager_.isEnabled()) {
                    dBSQLRPBDS.setLibraryName(this.packageManager_.getLibraryName(), this.connection_.converter_);
                }
                if (this.rpbQueryTimeoutChanged_) {
                    if (this.queryTimeout_ > 0) {
                        dBSQLRPBDS.setQueryTimeout(this.queryTimeout_);
                    } else {
                        dBSQLRPBDS.setQueryTimeout(-1);
                    }
                }
                if (!this.connection_.getMustSpecifyForUpdate() && this.resultSetConcurrency_ == 1008) {
                    dBSQLRPBDS.setOpenAttributes(240);
                }
                this.connection_.send(dBSQLRPBDS, this.id_);
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
            finally {
                if (dBSQLRPBDS != null) {
                    dBSQLRPBDS.inUse_ = false;
                }
            }
            this.rpbCreated_ = true;
            this.rpbSyncNeeded_ = false;
        }
    }

    public String toString() {
        return this.name_;
    }

    static final void verifyGeneratedKeysParameter(int n) throws SQLException {
        if (n != 2 && n != 1) {
            JDError.throwSQLException("HY024");
        }
    }
}

