/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Structure
implements AS400DataType {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private AS400DataType[] elements = null;
    private static final int defaultValue = 0;
    private boolean allowChanges = true;

    public AS400Structure() {
    }

    public AS400Structure(AS400DataType[] aS400DataTypeArray) {
        AS400DataType[] aS400DataTypeArray2 = new AS400DataType[aS400DataTypeArray.length];
        for (int i = 0; i < aS400DataTypeArray.length; ++i) {
            aS400DataTypeArray2[i] = (AS400DataType)aS400DataTypeArray[i].clone();
        }
        this.allowChanges = false;
        this.elements = aS400DataTypeArray2;
    }

    public Object clone() {
        try {
            AS400Structure aS400Structure = (AS400Structure)super.clone();
            AS400DataType[] aS400DataTypeArray = this.elements;
            if (aS400DataTypeArray == null) {
                return aS400Structure;
            }
            AS400DataType[] aS400DataTypeArray2 = new AS400DataType[aS400DataTypeArray.length];
            for (int i = 0; i < aS400DataTypeArray.length; ++i) {
                aS400DataTypeArray2[i] = (AS400DataType)aS400DataTypeArray[i].clone();
            }
            aS400Structure.elements = aS400DataTypeArray2;
            return aS400Structure;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        AS400DataType[] aS400DataTypeArray = this.elements;
        if (aS400DataTypeArray == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        this.allowChanges = false;
        int n = aS400DataTypeArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += aS400DataTypeArray[i].getByteLength();
        }
        return n2;
    }

    public Object getDefaultValue() {
        return new Object[0];
    }

    public int getInstanceType() {
        return 8;
    }

    public int getNumberOfMembers() {
        return this.elements == null ? -1 : this.elements.length;
    }

    public AS400DataType[] getMembers() {
        AS400DataType[] aS400DataTypeArray = this.elements;
        if (aS400DataTypeArray == null) {
            return null;
        }
        AS400DataType[] aS400DataTypeArray2 = new AS400DataType[aS400DataTypeArray.length];
        for (int i = 0; i < aS400DataTypeArray.length; ++i) {
            aS400DataTypeArray2[i] = (AS400DataType)aS400DataTypeArray[i].clone();
        }
        return aS400DataTypeArray2;
    }

    public AS400DataType getMembers(int n) {
        if (this.elements == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        return (AS400DataType)this.elements[n].clone();
    }

    public void setMembers(AS400DataType[] aS400DataTypeArray) {
        if (!this.allowChanges) {
            throw new ExtendedIllegalStateException("Members", 5);
        }
        AS400DataType[] aS400DataTypeArray2 = new AS400DataType[aS400DataTypeArray.length];
        for (int i = 0; i < aS400DataTypeArray.length; ++i) {
            aS400DataTypeArray2[i] = (AS400DataType)aS400DataTypeArray[i].clone();
        }
        this.elements = aS400DataTypeArray2;
    }

    public void setMembers(int n, AS400DataType aS400DataType) {
        if (!this.allowChanges) {
            throw new ExtendedIllegalStateException("Members", 5);
        }
        if (this.elements == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        this.elements[n] = (AS400DataType)aS400DataType.clone();
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.getByteLength()];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        AS400DataType[] aS400DataTypeArray = this.elements;
        if (aS400DataTypeArray == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        this.allowChanges = false;
        Object[] objectArray = (Object[])object;
        int n2 = aS400DataTypeArray.length;
        if (objectArray.length != n2) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 1);
        }
        for (int i = 0; i < n2; ++i) {
            n += aS400DataTypeArray[i].toBytes(objectArray[i], byArray, n);
        }
        return this.getByteLength();
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        AS400DataType[] aS400DataTypeArray = this.elements;
        if (aS400DataTypeArray == null) {
            throw new ExtendedIllegalStateException("Members", 4);
        }
        this.allowChanges = false;
        int n2 = aS400DataTypeArray.length;
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = aS400DataTypeArray[i].toObject(byArray, n);
            n += aS400DataTypeArray[i].getByteLength();
        }
        return objectArray;
    }
}

