/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.Serializable;

public class BidiConversionProperties
implements Serializable {
    static final long serialVersionUID = 4L;
    private int bidiStringType_ = 0;
    boolean removeMarksOnImplicitToVisual_ = false;
    BidiTransform transformOptions_ = new BidiTransform();

    public BidiConversionProperties() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing BidiConversionProperties.");
        }
    }

    BidiConversionProperties(int n) {
        this.setBidiStringType(n);
    }

    BidiConversionProperties(int n, BidiTransform bidiTransform, boolean bl) {
        this.setBidiStringType(n);
        BidiConversionProperties.copyOptionsTo(bidiTransform, this.transformOptions_);
        this.removeMarksOnImplicitToVisual_ = bl;
        if (bl) {
            this.transformOptions_.removeMarkers = false;
        }
        this.transformOptions_.dstToSrcMap = bidiTransform.dstToSrcMap;
        this.transformOptions_.srcToDstMap = bidiTransform.srcToDstMap;
        this.transformOptions_.propertyMap = bidiTransform.propertyMap;
        this.transformOptions_.inpCount = bidiTransform.inpCount;
        this.transformOptions_.outCount = bidiTransform.outCount;
    }

    public void setBidiStringType(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi string type:", n);
        }
        if (n != -1 && n != 0 && (n < 4 || n > 11)) {
            Trace.log(2, "Value of parameter 'bidiStringType' is not valid:", n);
            throw new ExtendedIllegalArgumentException("bidiStringType", 2);
        }
        this.bidiStringType_ = n;
    }

    public int getBidiStringType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting bidi string type:", this.bidiStringType_);
        }
        return this.bidiStringType_;
    }

    public void setBidiRemoveMarksOnImplicitToVisual(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi remove the directional marks only when transforming from logical to visual property:", bl);
        }
        this.removeMarksOnImplicitToVisual_ = bl;
    }

    public boolean isBidiRemoveMarksOnImplicitToVisual() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if remove the directional marks only when transforming from logical to visual property is set:", this.removeMarksOnImplicitToVisual_);
        }
        return this.removeMarksOnImplicitToVisual_;
    }

    BidiTransform getTransformOptions() {
        return this.transformOptions_;
    }

    void copyOptionsTo(BidiTransform bidiTransform) {
        BidiConversionProperties.copyOptionsTo(this.transformOptions_, bidiTransform);
    }

    static void copyOptionsTo(BidiTransform bidiTransform, BidiTransform bidiTransform2) {
        bidiTransform2.impToImp = bidiTransform.impToImp;
        bidiTransform2.roundTrip = bidiTransform.roundTrip;
        bidiTransform2.winCompatible = bidiTransform.winCompatible;
        bidiTransform2.insertMarkers = bidiTransform.insertMarkers;
        bidiTransform2.removeMarkers = bidiTransform.removeMarkers;
        bidiTransform2.options = bidiTransform.options;
        bidiTransform2.wordBreak = bidiTransform.wordBreak;
        bidiTransform2.destinationRequired = bidiTransform.destinationRequired;
        bidiTransform2.srcToDstMapRequired = bidiTransform.srcToDstMapRequired;
        bidiTransform2.dstToSrcMapRequired = bidiTransform.dstToSrcMapRequired;
        bidiTransform2.propertyMapRequired = bidiTransform.propertyMapRequired;
        bidiTransform2.continuation = bidiTransform.continuation;
    }

    public void setBidiImplicitReordering(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi implicit LTR-RTL reordering:", bl);
        }
        this.transformOptions_.impToImp = bl;
    }

    public boolean isBidiImplicitReordering() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi implicit LTR-RTL reordering:", this.transformOptions_.impToImp);
        }
        return this.transformOptions_.impToImp;
    }

    public void setBidiNumericOrderingRoundTrip(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi numeric ordering round trip:", bl);
        }
        this.transformOptions_.roundTrip = bl;
    }

    public boolean isBidiNumericOrderingRoundTrip() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi numeric ordering round trip:", this.transformOptions_.roundTrip);
        }
        return this.transformOptions_.roundTrip;
    }

    public void setBidiWindowCompatibility(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi window compatibility:", bl);
        }
        this.transformOptions_.winCompatible = bl;
    }

    public boolean isBidiWindowCompatibility() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi window compatibility:", this.transformOptions_.winCompatible);
        }
        return this.transformOptions_.winCompatible;
    }

    public void setBidiInsertDirectionalMarks(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi insert directional marks:", bl);
        }
        this.transformOptions_.insertMarkers = bl;
    }

    public boolean isBidiInsertDirectionalMarks() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi insert directional marks:", this.transformOptions_.insertMarkers);
        }
        return this.transformOptions_.insertMarkers;
    }

    public void setBidiRemoveDirectionalMarks(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi remove directional marks:", bl);
        }
        this.transformOptions_.removeMarkers = bl;
    }

    public boolean isBidiRemoveDirectionalMarks() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi remove directional marks:", this.transformOptions_.removeMarkers);
        }
        return this.transformOptions_.removeMarkers;
    }

    public void setBidiWordBreak(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi word break:", bl);
        }
        this.transformOptions_.wordBreak = bl;
    }

    public boolean isBidiWordBreak() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi consider white space to always follow base orientation:", this.transformOptions_.wordBreak);
        }
        return this.transformOptions_.wordBreak;
    }

    public void setBidiDestinationRequired(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi destination required:", bl);
        }
        this.transformOptions_.destinationRequired = bl;
    }

    public boolean isBidiDestinationRequired() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi destination required:", this.transformOptions_.destinationRequired);
        }
        return this.transformOptions_.destinationRequired;
    }

    public void setBidiCreateSourceToDestinationMapping(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi create a source to destination mapping property:", bl);
        }
        this.transformOptions_.srcToDstMapRequired = bl;
    }

    public boolean isBidiCreateSourceToDestinationMapping() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if create a source to destination mapping property is set:", this.transformOptions_.srcToDstMapRequired);
        }
        return this.transformOptions_.srcToDstMapRequired;
    }

    public void setBidiCreateDestinationToSourceMapping(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi create a destination to source mapping property:", bl);
        }
        this.transformOptions_.dstToSrcMapRequired = bl;
    }

    public boolean isBidiCreateDestinationToSourceMapping() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if create a destination to source mapping property is set:", this.transformOptions_.dstToSrcMapRequired);
        }
        return this.transformOptions_.dstToSrcMapRequired;
    }

    public void setBidiCreatePropertyMap(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi create property map property:", bl);
        }
        this.transformOptions_.propertyMapRequired = bl;
    }

    public boolean isBidiCreatePropertyMap() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi create property map property is set:", this.transformOptions_.propertyMapRequired);
        }
        return this.transformOptions_.propertyMapRequired;
    }

    public int getInputCount() {
        return this.transformOptions_.inpCount;
    }

    public int getOutputCount() {
        return this.transformOptions_.outCount;
    }

    public int[] getSourceToDestinationMap() {
        return this.transformOptions_.srcToDstMap;
    }

    public int[] getDestinationToSourceMap() {
        return this.transformOptions_.dstToSrcMap;
    }

    public byte[] getPropertyMap() {
        return this.transformOptions_.propertyMap;
    }
}

