/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiText;
import com.ibm.as400.access.BidiTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

class BidiOrder {
    private static final int UBAT_B = 0;
    private static final int UBAT_S = 1;
    private static final int UBAT_L = 2;
    private static final int UBAT_R = 3;
    private static final int UBAT_EN = 4;
    private static final int UBAT_AN = 5;
    private static final int UBAT_W = 6;
    private static final int UBAT_N = 7;
    private static final int UBAT_BD = 8;
    private static final int UBAT_AL = 9;
    private static final int UBAT_ET = 10;
    private static final int UBAT_ES = 11;
    private static final int UBAT_CS = 12;
    private static final int UBAT_NSM = 13;
    private static final int ITIL = 8;
    private static final int ITCOND = 9;
    private static final byte UBAT_N_SWAP = -7;
    private static final byte IMP_LTR = 4;
    private static final byte IMP_RTL = 8;
    private static final byte ORIG = 0;
    private static final byte FINAL = 1;
    private static final char LRM = '\u200e';
    private static final char RLM = '\u200f';
    private static final int BEFORE = 0;
    private static final int AFTER = 65536;
    private static final char[][] notSpacing = new char[][]{{'\u0300', '\u0385'}, {'\u0483', '\u0486'}, {'\u05b0', '\u05bd'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05f5', '\u05f5'}, {'\u064b', '\u0652'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0901', '\u0902'}, {'\u093c', '\u093c'}, {'\u0941', '\u0948'}, {'\u094d', '\u094d'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0981'}, {'\u09bc', '\u09bc'}, {'\u09c1', '\u09c4'}, {'\u09cd', '\u09cd'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a41', '\u0a4c'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a82'}, {'\u0abc', '\u0abc'}, {'\u0ac1', '\u0ac8'}, {'\u0acd', '\u0acd'}, {'\u0b01', '\u0b01'}, {'\u0b3c', '\u0b3c'}, {'\u0b3f', '\u0b3f'}, {'\u0b41', '\u0b43'}, {'\u0b4d', '\u0b4d'}, {'\u0bc0', '\u0bc0'}, {'\u0bcd', '\u0bcd'}, {'\u0c3e', '\u0c40'}, {'\u0c46', '\u0c56'}, {'\u0cbf', '\u0cbf'}, {'\u0cc6', '\u0cc6'}, {'\u0ccc', '\u0ccd'}, {'\u0d41', '\u0d43'}, {'\u0d4d', '\u0d4d'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4d'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u1026', '\u102a'}, {'\u102e', '\u102e'}, {'\u1030', '\u1030'}, {'\u1036', '\u1037'}, {'\u103b', '\u103b'}, {'\u103d', '\u103e'}, {'\u104b', '\u104c'}, {'\u20d0', '\u20ff'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}};
    private static final char[][] symPairs = new char[][]{{'(', ')'}, {')', '('}, {'<', '>'}, {'>', '<'}, {'[', ']'}, {']', '['}, {'{', '}'}, {'}', '{'}, {'\u00ab', '\u00bb'}, {'\u00bb', '\u00ab'}, {'\u207d', '\u207e'}, {'\u207e', '\u207d'}, {'\u208d', '\u208e'}, {'\u208e', '\u208d'}, {'\u2329', '\u232a'}, {'\u232a', '\u2329'}, {'\ufe59', '\ufe5a'}, {'\ufe5a', '\ufe59'}, {'\ufe5b', '\ufe5c'}, {'\ufe5c', '\ufe5b'}, {'\ufe5d', '\ufe5e'}, {'\ufe5e', '\ufe5d'}, {'\ufe64', '\ufe65'}, {'\ufe65', '\ufe64'}};
    private static final short[][] impTab_LTR = new short[][]{{0, 0, 0, 3, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 3, 0, 1, 2, 2, 2, 0}, {0, 0, 0, 3, 0, 17, 2, 2, 0, 1}, {0, 0, 0, 3, 5, 5, 4, 4, 1, 0}, {0, 0, 0, 3, 21, 21, 4, 4, 0, 1}, {0, 0, 0, 3, 5, 5, 4, 4, 2, 0}};
    private static final short[][] impTab_RTL = new short[][]{{0, 0, 2, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 2, 0, 1, 1, 0, 0, 1, 0}, {0, 0, 2, 0, 2, 1, 3, 3, 1, 0}, {0, 0, 2, 0, 2, 33, 3, 3, 0, 1}};
    private static final short[][] impTab_LTR_r = new short[][]{{0, 0, 0, 2, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 1, 3, 3, 2, 0}, {0, 0, 0, 2, 4, 1, 3, 3, 1, 0}, {0, 0, 0, 34, 4, 4, 3, 3, 1, 1}, {0, 0, 0, 34, 4, 4, 3, 3, 2, 1}};
    private static final short[][] impTab_RTL_r = new short[][]{{0, 0, 3, 0, 1, 2, 0, 0, 0, 0}, {32, 32, 3, 32, 1, 34, 5, 5, 1, 1}, {0, 0, 3, 0, 1, 2, 0, 0, 1, 0}, {0, 0, 3, 0, 3, 2, 4, 4, 1, 0}, {0, 0, 3, 0, 3, 34, 4, 4, 0, 1}, {32, 32, 3, 32, 1, 34, 5, 5, 0, 1}};
    private static final short[][] impTab_LTR_w = new short[][]{{0, 0, 0, 2, 5, 1, 0, 0, 0, 0}, {0, 0, 0, 2, 5, 1, 0, 0, 2, 0}, {0, 0, 0, 2, 4, 6, 3, 3, 1, 0}, {0, 0, 0, 2, 20, 22, 3, 3, 1, 1}, {0, 0, 0, 2, 4, 6, 3, 3, 2, 0}, {0, 0, 0, 2, 5, 1, 0, 0, 2, 0}, {0, 0, 0, 2, 5, 6, 3, 3, 2, 0}};
    private static final short[][] impTab_LTR_m = new short[][]{{0, 0, 0, 99, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 99, 0, 1, 2, 2, 2, 0}, {0, 0, 0, 99, 0, 33, 2, 2, 1, 1}, {0, 0, 0, 99, 85, 86, 4, 4, 1, 0}, {48, 48, 48, 67, 85, 86, 4, 4, 1, 1}, {48, 48, 48, 67, 5, 86, 4, 4, 2, 0}, {48, 48, 48, 67, 85, 6, 4, 4, 2, 0}};
    private static final short[][] impTab_RTL_m = new short[][]{{0, 0, 3, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 115, 0, 1, 1, 2, 2, 1, 0}, {0, 0, 115, 0, 1, 1, 2, 2, 0, 0}, {0, 0, 3, 0, 3, 134, 4, 4, 1, 0}, {144, 144, 163, 144, 5, 134, 4, 4, 0, 1}, {144, 144, 163, 144, 5, 134, 4, 4, 1, 1}, {144, 144, 163, 144, 6, 6, 4, 4, 1, 1}};
    int ucb_ix;
    byte ucb_outLev;
    byte ucb_basLev;
    byte ucb_curLev;
    int ucb_impSta;
    int ucb_condPos;
    int ucb_xType;
    byte ucb_wTarget;
    BidiFlag ics_num_flag;
    boolean ics_symmetric;
    BidiFlag ics_orient_in;
    BidiFlag ics_orient_out;
    BidiFlag ics_type_in;
    BidiFlag ics_type_out;
    BidiTransform myBdx;
    int ics_size;
    char[] ics_buffer_in;
    char[] ics_buffer_out;
    boolean invertInput;
    boolean visToVis;
    short[][] impTab;
    byte[][] typeArray;
    boolean insertMarkers;
    int insertCnt;
    int removeCnt;
    int startL2EN;
    int lastStrongRTL;
    boolean reqImpToImp;
    int impToImpOrient;
    int impToImpPhase;

    BidiOrder() {
    }

    private static boolean odd(int n) {
        return (n & 1) == 1;
    }

    private static boolean even(int n) {
        return (n & 1) == 0;
    }

    private static void invertMap(int[] nArray, int n, int n2) {
        while (n < n2) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            ++n;
            --n2;
        }
    }

    private static void invertMap(byte[] byArray, int n, int n2) {
        while (n < n2) {
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
            ++n;
            --n2;
        }
    }

    private static boolean UCQSPAC(char c) {
        int n = 0;
        int n2 = notSpacing.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (c < notSpacing[n3][0]) {
                n2 = n3 - 1;
                continue;
            }
            if (c > notSpacing[n3][1]) {
                n = n3 + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static char UCQSYMM(char c) {
        int n = 0;
        int n2 = 23;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            char c2 = symPairs[n3][0];
            if (c < c2) {
                n2 = n3 - 1;
                continue;
            }
            if (c > c2) {
                n = n3 + 1;
                continue;
            }
            return symPairs[n3][1];
        }
        return c;
    }

    private void fillTypeArray() {
        boolean bl = false;
        byte[][] byArray = this.typeArray;
        block12: for (int i = 0; i < this.ics_size; ++i) {
            byte by;
            byArray[i][0] = by = BidiOrder.getChType(this.ics_buffer_in[i], this.myBdx.wordBreak);
            byArray[i][1] = 7;
            if (this.visToVis) continue;
            switch (by) {
                case 0: {
                    bl = false;
                    byArray[i][1] = 0;
                    continue block12;
                }
                case 1: {
                    byArray[i][1] = 1;
                    continue block12;
                }
                case 2: {
                    bl = false;
                    byArray[i][1] = 2;
                    continue block12;
                }
                case 3: {
                    bl = false;
                    byArray[i][1] = 3;
                    continue block12;
                }
                case 9: {
                    bl = true;
                    byArray[i][1] = 3;
                    continue block12;
                }
                case 4: {
                    int n;
                    if (bl) {
                        n = 5;
                    } else {
                        n = 4;
                        if (i >= 2 && byArray[i - 1][0] == 11 && byArray[i - 2][0] == 4) {
                            byArray[i - 1][1] = 4;
                        }
                        int n2 = i - 1;
                        while (n2 >= 0 && byArray[n2][0] == 10) {
                            byArray[n2--][1] = 4;
                        }
                    }
                    if (i >= 2 && byArray[i - 1][0] == 12 && byArray[i - 2][0] == 4) {
                        byArray[i - 1][1] = n;
                    }
                    byArray[i][1] = n;
                    continue block12;
                }
                case 5: {
                    if (i >= 2 && byArray[i - 1][0] == 12 && byArray[i - 2][1] == 5) {
                        byArray[i - 1][1] = 5;
                    }
                    byArray[i][1] = 5;
                    continue block12;
                }
                case 6: {
                    byArray[i][1] = 6;
                    continue block12;
                }
                case 10: {
                    if (i <= 0 || byArray[i - 1][1] != 4) continue block12;
                    byArray[i][1] = 4;
                    continue block12;
                }
                case 13: {
                    if (i <= 0) continue block12;
                    byArray[i][1] = byArray[i - 1][1];
                }
            }
        }
    }

    private void fillTypeArray2() {
        boolean bl = false;
        byte[][] byArray = this.typeArray;
        block11: for (int i = 0; i < this.ics_size; ++i) {
            int n = this.myBdx.dstToSrcMap[i];
            byte by = byArray[n][0];
            byArray[n][1] = 7;
            switch (by) {
                case 0: {
                    bl = false;
                    byArray[n][1] = 0;
                    continue block11;
                }
                case 1: {
                    byArray[n][1] = 1;
                    continue block11;
                }
                case 2: {
                    bl = false;
                    byArray[n][1] = 2;
                    continue block11;
                }
                case 3: {
                    bl = false;
                    byArray[n][1] = 3;
                    continue block11;
                }
                case 9: {
                    bl = true;
                    byArray[n][1] = 3;
                    continue block11;
                }
                case 4: {
                    int n2;
                    if (bl) {
                        n2 = 5;
                    } else {
                        n2 = 4;
                        if (i >= 2 && byArray[this.myBdx.dstToSrcMap[i - 1]][0] == 11 && byArray[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                            byArray[this.myBdx.dstToSrcMap[i - 1]][1] = 4;
                        }
                        int n3 = i - 1;
                        while (n3 >= 0 && byArray[this.myBdx.dstToSrcMap[n3]][0] == 10) {
                            byArray[this.myBdx.dstToSrcMap[n3--]][1] = 4;
                        }
                    }
                    if (i >= 2 && byArray[this.myBdx.dstToSrcMap[i - 1]][0] == 12 && byArray[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                        byArray[this.myBdx.dstToSrcMap[i - 1]][1] = n2;
                    }
                    byArray[n][1] = n2;
                    continue block11;
                }
                case 5: {
                    if (i >= 2 && byArray[this.myBdx.dstToSrcMap[i - 1]][0] == 12 && byArray[this.myBdx.dstToSrcMap[i - 2]][0] == 5) {
                        byArray[this.myBdx.dstToSrcMap[i - 1]][1] = 5;
                    }
                    byArray[n][1] = 5;
                    continue block11;
                }
                case 6: {
                    byArray[n][1] = 6;
                    continue block11;
                }
                case 10: {
                    if (i <= 0 || byArray[this.myBdx.dstToSrcMap[i - 1]][1] != 4) continue block11;
                    byArray[n][1] = 4;
                    continue block11;
                }
            }
        }
    }

    private void addPoint(int n, int n2, char c) {
        if (this.myBdx.insertPoints == null) {
            this.myBdx.insertPoints = new Vector(10, 50);
        }
        this.myBdx.insertPoints.addElement(new Long((n << 17) + n2 + c));
    }

    private int afterAN(int n) {
        while (n < this.ics_size && this.typeArray[n][1] == 5) {
            ++n;
        }
        return n;
    }

    private int afterENAN(int n) {
        while (n < this.ics_size && (this.typeArray[n][1] == 4 || this.typeArray[n][1] == 5)) {
            ++n;
        }
        return n;
    }

    private int beforeENAN(int n) {
        while (n >= 0 && (this.typeArray[n][1] == 4 || this.typeArray[n][1] == 5)) {
            --n;
        }
        return n;
    }

    private void implicitProcessing() {
        short s;
        int n;
        int n2;
        int n3 = this.impTab[this.ucb_impSta][this.ucb_xType];
        short s2 = (short)(n3 >> 4);
        n3 = (short)(n3 & 0xF);
        short s3 = this.impTab[n3][8];
        byte by = (byte)(this.ucb_curLev + s3);
        if (s2 > 0) {
            switch (s2) {
                case 1: {
                    for (n2 = this.ucb_condPos; n2 < this.ucb_ix; ++n2) {
                        this.myBdx.propertyMap[n2] = (byte)(this.ucb_curLev + 1);
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 2: {
                    this.ucb_condPos = -1;
                    break;
                }
                case 3: {
                    if (this.startL2EN >= 0) {
                        this.addPoint(this.startL2EN, 0, '\u200e');
                    }
                    this.startL2EN = -1;
                    if (this.myBdx.insertPoints == null || this.myBdx.insertPoints.size() <= this.insertCnt) {
                        this.lastStrongRTL = -1;
                        break;
                    }
                    for (n2 = this.lastStrongRTL + 1; n2 < this.ucb_ix; ++n2) {
                        this.myBdx.propertyMap[n2] = by;
                        this.typeArray[n2][0] = (byte)Math.abs(this.typeArray[n2][0]);
                    }
                    this.insertCnt = this.myBdx.insertPoints.size();
                    this.lastStrongRTL = -1;
                    break;
                }
                case 4: {
                    if (this.myBdx.insertPoints != null) {
                        this.myBdx.insertPoints.setSize(this.insertCnt);
                    }
                    this.startL2EN = -1;
                    this.lastStrongRTL = this.ucb_ix;
                    break;
                }
                case 5: {
                    this.ucb_condPos = -1;
                    if (this.ucb_xType == 5 && this.typeArray[this.ucb_ix][0] == 5) {
                        if (this.startL2EN == -1) {
                            this.lastStrongRTL = this.afterAN(this.ucb_ix) - 1;
                            break;
                        }
                        if (this.startL2EN >= 0) {
                            this.addPoint(this.startL2EN, 0, '\u200e');
                            this.startL2EN = -2;
                        }
                        this.addPoint(this.ucb_ix, 0, '\u200e');
                        break;
                    }
                    if (this.startL2EN != -1) break;
                    this.startL2EN = this.ucb_ix;
                    break;
                }
                case 6: {
                    this.lastStrongRTL = this.ucb_ix;
                    break;
                }
                case 7: {
                    n2 = this.beforeENAN(this.ucb_ix - 1);
                    this.addPoint(this.ics_size - n2 - 1, 0, '\u200f');
                    this.insertCnt = this.myBdx.insertPoints.size();
                    break;
                }
                case 8: {
                    n = this.afterENAN(this.ucb_ix);
                    n2 = this.beforeENAN(this.ucb_ix);
                    if ((n >= this.ics_size || this.typeArray[n][1] == 2 || this.typeArray[n][1] == 3) && n2 >= 0 && this.typeArray[n2][1] == 2) break;
                    this.addPoint(n - 1, 65536, '\u200e');
                    this.addPoint(n2 + 1, 0, '\u200e');
                    break;
                }
                case 9: {
                    if (this.myBdx.insertPoints != null) {
                        this.myBdx.insertPoints.setSize(this.insertCnt);
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 10: {
                    if (this.myBdx.insertPoints == null) break;
                    this.insertCnt = this.myBdx.insertPoints.size();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("invalid action number");
                }
            }
        }
        if ((s = this.impTab[n3][9]) == 0) {
            if (this.ucb_condPos > -1) {
                for (n2 = this.ucb_condPos; n2 < this.ucb_ix; ++n2) {
                    byte by2 = this.myBdx.propertyMap[n2];
                    this.myBdx.propertyMap[n2] = by;
                    if (!this.ics_symmetric || !BidiOrder.odd(by2 ^ by)) continue;
                    n = this.impToImpPhase == 2 ? this.myBdx.dstToSrcMap[n2] : n2;
                    if (this.typeArray[n][0] == 7) {
                        this.typeArray[n][0] = -7;
                        continue;
                    }
                    if (this.typeArray[n][0] != -7) continue;
                    this.typeArray[n][0] = 7;
                }
                this.ucb_condPos = -1;
            }
        } else if (this.ucb_condPos == -1) {
            this.ucb_condPos = this.ucb_ix;
        }
        this.ucb_impSta = n3;
        this.ucb_wTarget = by;
    }

    private static byte getChType(char c, boolean bl) {
        if (bl && c == ' ') {
            return 1;
        }
        return BidiOrder.getChType(c);
    }

    private static byte getChType(char c) {
        if (c == '\n' || c == '\r' || c >= '\u001c' && c <= '\u001e' || c == '\u0085' || c == '\u2029') {
            return 0;
        }
        if (c == '\t' || c == '\u000b' || c == '\u001f') {
            return 1;
        }
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u058f' || c >= '\u0900' && c <= '\u10ff' || c == '\u200e' || c >= '\u20d0' && c <= '\u20ff' || c >= '\u2160' && c <= '\u2182' || c >= '\u3040' && c <= '\u9fff' || c >= '\uf900' && c <= '\ufb17' || c == '\ufe60' || c == '\ufe6b' || c == '\uff06' || c >= '\uff20' && c <= '\uff3a' || c >= '\uff41' && c <= '\uff5a' || c >= '\uff60' && c <= '\uffdf') {
            return 2;
        }
        if (c >= '\u0591' && c <= '\u05ff' || c == '\u200f' || c >= '\ufb1d' && c <= '\ufb4f') {
            return 3;
        }
        if (c >= '\u0600' && c <= '\u065f' || c >= '\u066e' && c <= '\u06ef' || c >= '\u06fa' && c <= '\u08ff' || c >= '\ufb50' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufefc') {
            return 9;
        }
        if (c >= '0' && c <= '9' || c >= '\u00b2' && c <= '\u00b3' || c == '\u00b9' || c >= '\u06f0' && c <= '\u06f9' || c == '\u2070' || c >= '\u2074' && c <= '\u2079' || c >= '\u2080' && c <= '\u2089' || c >= '\u2460' && c <= '\u249b' || c == '\u24ea' || c >= '\uff10' && c <= '\uff19') {
            return 4;
        }
        if (c >= '\u0660' && c <= '\u0669' || c >= '\u066b' && c <= '\u066c') {
            return 5;
        }
        if (c >= '#' && c <= '%' || c >= '\u00a2' && c <= '\u00a5' || c >= '\u00b0' && c <= '\u00b1' || c == '\u066a' || c >= '\u09f2' && c <= '\u09f3' || c == '\u0af1' || c == '\u0bf9' || c == '\u0e3f' || c == '\u17db' || c >= '\u2030' && c <= '\u2034' || c >= '\u207a' && c <= '\u207b' || c >= '\u208a' && c <= '\u208b' || c >= '\u20a0' && c <= '\u20b1' || c == '\u212e' || c >= '\u2212' && c <= '\u2213' || c == '\ufb29' || c == '\ufe5f' || c >= '\ufe62' && c <= '\ufe63' || c >= '\ufe69' && c <= '\ufe6a' || c >= '\uff03' && c <= '\uff05' || c == '\uff0b' || c == '\uff0d' || c >= '\uffe0' && c <= '\uffe1' || c >= '\uffe5' && c <= '\uffe6') {
            return 10;
        }
        if (c == '+' || c == '-' || c == '/' || c == '\uff0f') {
            return 11;
        }
        if (c == ',' || c == '.' || c == ':' || c == '\u00a0' || c == '\u060c' || c == '\ufe50' || c == '\ufe52' || c == '\ufe55' || c == '\uff0c' || c == '\uff0e' || c == '\uff1a') {
            return 12;
        }
        if (c == '\f' || c == ' ' || c == '\u1680' || c == '\u180e' || c >= '\u2000' && c <= '\u200a' || c == '\u2028' || c == '\u202f' || c == '\u205f' || c == '\u3000') {
            return 6;
        }
        if (c >= '\u202a' && c <= '\u202e' || c >= '\u206c' && c <= '\u206f') {
            return 8;
        }
        return 7;
    }

    private static int firstStrong(BidiText bidiText) {
        int n = bidiText.offset + bidiText.count;
        for (int i = bidiText.offset; i < n; ++i) {
            byte by = BidiOrder.getChType(bidiText.data[i]);
            if (by != 2 && by != 3) continue;
            return by;
        }
        return 7;
    }

    private static int lastStrong(BidiText bidiText) {
        int n = bidiText.offset + bidiText.count;
        for (int i = n - 1; i >= bidiText.offset; --i) {
            byte by = BidiOrder.getChType(bidiText.data[i]);
            if (by != 2 && by != 3) continue;
            return by;
        }
        return 7;
    }

    private void BaseLvl() {
        this.visToVis = false;
        this.ucb_basLev = this.ics_orient_in == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_outLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_curLev = this.ucb_basLev;
        if (this.ucb_basLev == 0 && this.ucb_outLev == 1) {
            this.ucb_curLev = (byte)2;
        }
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_VISUAL) {
            this.visToVis = true;
        }
        if (this.myBdx.roundTrip) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL_r : impTab_LTR_r;
        } else if (this.myBdx.winCompatible) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR_w;
        } else if (this.insertMarkers) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL_m : impTab_LTR_m;
            this.startL2EN = -1;
            this.lastStrongRTL = -1;
            if (this.myBdx.insertPoints != null) {
                this.myBdx.insertPoints.setSize(0);
            }
        } else {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR;
        }
        this.insertCnt = 0;
        this.removeCnt = 0;
        this.ucb_impSta = 0;
        this.ucb_condPos = -1;
    }

    private void pass2() {
        byte by;
        int n;
        byte by2 = 100;
        byte by3 = 0;
        int n2 = 0;
        int n3 = this.ics_size - 1;
        for (n = 0; n < this.ics_size; ++n) {
            if (this.impToImpPhase != 2) {
                this.myBdx.dstToSrcMap[n] = n;
            }
            if ((by = this.myBdx.propertyMap[n]) < by2) {
                by2 = by;
            }
            if (by <= by3) continue;
            by3 = by;
        }
        if (this.reqImpToImp && this.impToImpOrient == 0) {
            return;
        }
        by2 = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)(by2 + 1 & 0xFFFFFFFE) : (byte)((byte)(by2 | 1));
        for (byte by4 = by3; by4 >= by2; by4 = (byte)(by4 - 1)) {
            n = 0;
            while (n < this.ics_size) {
                by = this.myBdx.propertyMap[n];
                if (by < by4) {
                    ++n;
                    continue;
                }
                n2 = n;
                for (n = n2 + 1; n < this.ics_size && this.myBdx.propertyMap[n] >= by4; ++n) {
                }
                n3 = n - 1;
                BidiOrder.invertMap(this.myBdx.dstToSrcMap, n2, n3);
            }
        }
    }

    private void pass3() {
        for (int i = 0; i < this.ics_size; ++i) {
            int n = this.myBdx.dstToSrcMap[i];
            char c = this.ics_buffer_in[n];
            byte by = this.typeArray[n][0];
            if (by == 4) {
                if (this.ics_num_flag == BidiFlag.NUMERALS_NATIONAL || this.ics_num_flag == BidiFlag.NUMERALS_CONTEXTUAL && this.typeArray[n][1] == 5) {
                    c = (char)(c + 1584);
                }
            } else if (by == 5) {
                if (this.ics_num_flag == BidiFlag.NUMERALS_NOMINAL) {
                    c = (char)(c - 1584);
                }
            } else if (by == -7) {
                c = BidiOrder.UCQSYMM(c);
            }
            this.ics_buffer_out[i] = c;
        }
    }

    synchronized void order(BidiText bidiText, BidiText bidiText2, BidiTransform bidiTransform) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4 = 0;
        boolean bl2 = false;
        if (bidiText.count < 1) {
            if (bidiText2.data == null) {
                bidiText2.data = new char[0];
            }
            bidiTransform.inpCount = 0;
            bidiTransform.outCount = 0;
            return;
        }
        this.myBdx = bidiTransform;
        this.ics_orient_in = bidiText.flags.getOrientation();
        this.ics_orient_out = bidiText2.flags.getOrientation();
        if (this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            n3 = BidiOrder.firstStrong(bidiText);
            switch (n3) {
                case 2: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 7: {
                    this.ics_orient_in = this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            n3 = BidiOrder.firstStrong(bidiText);
            switch (n3) {
                case 2: {
                    n3 = BidiOrder.lastStrong(bidiText);
                    if (n3 == 3) {
                        this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                        break;
                    }
                    this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 7: {
                    this.ics_orient_out = this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        this.ics_type_in = bidiText.flags.getType();
        this.ics_type_out = bidiText2.flags.getType();
        boolean bl3 = this.reqImpToImp = this.ics_type_in == BidiFlag.TYPE_IMPLICIT && this.ics_type_out == BidiFlag.TYPE_IMPLICIT;
        this.impToImpOrient = this.myBdx.impToImp && this.reqImpToImp && this.ics_orient_in != this.ics_orient_out ? (this.ics_orient_in == BidiFlag.ORIENTATION_LTR ? 4 : 8) : 0;
        this.insertMarkers = this.myBdx.insertMarkers;
        if (this.insertMarkers) {
            if (this.ics_type_in != BidiFlag.TYPE_VISUAL || this.ics_type_out != BidiFlag.TYPE_IMPLICIT || this.ics_orient_in != BidiFlag.ORIENTATION_LTR || this.myBdx.removeMarkers) {
                this.insertMarkers = false;
            } else if (this.ics_orient_out == BidiFlag.ORIENTATION_RTL) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            }
        }
        this.ics_buffer_in = new char[bidiText.count];
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_IMPLICIT && this.ics_orient_in != this.ics_orient_out && !this.insertMarkers) {
            this.invertInput = true;
            n3 = bidiText.offset + bidiText.count - 1;
            for (int i = 0; i < bidiText.count; ++i) {
                this.ics_buffer_in[i] = bidiText.data[n3 - i];
            }
            this.ics_orient_in = this.ics_orient_out;
        } else {
            this.invertInput = false;
            System.arraycopy(bidiText.data, bidiText.offset, this.ics_buffer_in, 0, bidiText.count);
        }
        this.ics_size = bidiText.count;
        this.ics_num_flag = bidiText2.flags.getNumerals();
        this.ics_symmetric = this.reqImpToImp ? false : bidiText2.flags.getSwap() != bidiText.flags.getSwap();
        this.ics_buffer_out = new char[bidiText.count];
        this.typeArray = new byte[bidiText.count][2];
        if (this.myBdx.propertyMap == null || this.myBdx.propertyMap.length < bidiText.count) {
            this.myBdx.propertyMap = new byte[bidiText.count];
        }
        if (this.myBdx.dstToSrcMap == null || this.myBdx.dstToSrcMap.length < bidiText.count) {
            this.myBdx.dstToSrcMap = new int[bidiText.count];
        }
        if (this.impToImpOrient > 0) {
            this.impToImpPhase = 1;
            BidiFlag bidiFlag = this.ics_orient_out;
            this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            this.ics_symmetric = bidiText.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                this.ucb_xType = this.typeArray[this.ucb_ix][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (this.typeArray[this.ucb_ix][0] == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    this.typeArray[this.ucb_ix][0] = -7;
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_out = bidiFlag;
            this.impToImpPhase = 2;
            bidiFlag = this.ics_orient_in;
            if (this.impToImpOrient == 4) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                BidiOrder.invertMap(this.myBdx.dstToSrcMap, 0, this.ics_size - 1);
            } else {
                this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
            }
            this.ics_symmetric = bidiText2.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray2();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                n2 = this.myBdx.dstToSrcMap[this.ucb_ix];
                this.ucb_xType = this.typeArray[n2][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (Math.abs(this.typeArray[n2][0]) == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    byte[] byArray = this.typeArray[n2];
                    byArray[0] = (byte)(byArray[0] * -1);
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_in = bidiFlag;
            this.ics_symmetric = true;
        } else {
            this.BaseLvl();
            this.fillTypeArray();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                this.ucb_xType = this.typeArray[this.ucb_ix][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (this.typeArray[this.ucb_ix][0] == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    this.typeArray[this.ucb_ix][0] = -7;
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
        }
        this.pass3();
        boolean bl4 = bl = this.myBdx.dstToSrcMapRequired || this.myBdx.srcToDstMapRequired;
        if (bl && this.invertInput) {
            for (n4 = 0; n4 < bidiText.count; ++n4) {
                this.myBdx.dstToSrcMap[n4] = bidiText.count - this.myBdx.dstToSrcMap[n4] - 1;
            }
        }
        if (this.myBdx.removeMarkers) {
            for (n = 0; n < bidiText.count; ++n) {
                n3 = this.ics_buffer_out[n];
                if (n3 == 8206 || n3 == 8207) {
                    ++this.removeCnt;
                    continue;
                }
                if (this.removeCnt <= 0) continue;
                this.ics_buffer_out[n - this.removeCnt] = this.ics_buffer_out[n];
                this.myBdx.dstToSrcMap[n - this.removeCnt] = this.myBdx.dstToSrcMap[n];
            }
        }
        bidiText2.count = bidiText.count - this.removeCnt + this.insertCnt;
        if (bidiText2.data == null) {
            bidiText2.data = bidiText2.offset == 0 && this.insertCnt == 0 ? this.ics_buffer_out : new char[bidiText2.offset + bidiText2.count];
        }
        if (bidiText2.offset + bidiText2.count > bidiText2.data.length) {
            char[] cArray = new char[bidiText2.offset + bidiText2.count];
            if (bidiText2.offset > 0) {
                System.arraycopy(bidiText2.data, 0, cArray, 0, bidiText2.offset);
            }
            bidiText2.data = cArray;
            cArray = null;
        }
        if (this.insertCnt > 0) {
            char c;
            int n5;
            int[] nArray = null;
            for (n4 = 0; n4 < this.insertCnt; ++n4) {
                long l = (Long)this.myBdx.insertPoints.get(n4);
                n2 = (int)(l >> 17);
                n5 = (int)(l & 0x10000L);
                c = (char)l;
                if ((this.ucb_basLev != 1 || c != '\u200e') && (this.ucb_basLev == 1 || c != '\u200f')) continue;
                for (n = 0; n < bidiText.count; ++n) {
                    if (n2 != this.myBdx.dstToSrcMap[n]) continue;
                    n2 = n;
                    break;
                }
                this.myBdx.insertPoints.setElementAt(new Long((n2 << 17) + n5 + c), n4);
            }
            if (this.ucb_basLev == 1) {
                Collections.sort(this.myBdx.insertPoints);
            }
            if (bl) {
                nArray = new int[bidiText2.count];
            }
            n = 0;
            for (n4 = 0; n4 < this.insertCnt; ++n4) {
                long l = (Long)this.myBdx.insertPoints.get(n4);
                n2 = (int)(l >> 17);
                n5 = (int)(l & 0x10000L);
                c = (char)l;
                System.arraycopy(this.ics_buffer_out, n, bidiText2.data, bidiText2.offset + n + n4, (n2 += n5 >> 16) - n);
                bidiText2.data[bidiText2.offset + n2 + n4] = c;
                if (bl) {
                    System.arraycopy(this.myBdx.dstToSrcMap, n, nArray, n + n4, n2 - n);
                    nArray[n2 + n4] = -1;
                }
                n = n2;
            }
            System.arraycopy(this.ics_buffer_out, n, bidiText2.data, bidiText2.offset + n + this.insertCnt, bidiText2.count - n - this.insertCnt);
            if (bl) {
                System.arraycopy(this.myBdx.dstToSrcMap, n, nArray, n + this.insertCnt, bidiText2.count - n - this.insertCnt);
                this.myBdx.dstToSrcMap = nArray;
            }
        } else if (bidiText2.data != this.ics_buffer_out) {
            System.arraycopy(this.ics_buffer_out, 0, bidiText2.data, bidiText2.offset, bidiText2.count);
        }
        if (this.myBdx.srcToDstMapRequired) {
            if (this.myBdx.srcToDstMap == null || this.myBdx.srcToDstMap.length < bidiText.count) {
                this.myBdx.srcToDstMap = new int[bidiText.count];
            }
            if (this.removeCnt > 0) {
                Arrays.fill(this.myBdx.srcToDstMap, 0, bidiText.count, -1);
            }
            for (n4 = 0; n4 < bidiText2.count; ++n4) {
                n = this.myBdx.dstToSrcMap[n4];
                if (n < 0) continue;
                this.myBdx.srcToDstMap[n] = n4;
            }
        }
        if (this.myBdx.propertyMapRequired) {
            for (n4 = 0; n4 < bidiText.count; ++n4) {
                if (this.typeArray[n4][0] == 13) continue;
                int n6 = n4;
                bidiTransform.propertyMap[n6] = (byte)(bidiTransform.propertyMap[n6] | 0x80);
            }
            if (this.invertInput) {
                BidiOrder.invertMap(this.myBdx.propertyMap, 0, bidiText.count - 1);
            }
        }
        this.myBdx.inpCount = bidiText.count;
        this.myBdx.outCount = bidiText2.count;
    }
}

