/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCloseRep;
import com.ibm.as400.access.IFSCloseReq;
import com.ibm.as400.access.IFSCommitReq;
import com.ibm.as400.access.IFSCopyReq;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSExchangeAttrRep;
import com.ibm.as400.access.IFSExchangeAttrReq;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileOutputStreamImplRemote;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSLockBytesRep;
import com.ibm.as400.access.IFSLockBytesReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSRandomAccessFileImplRemote;
import com.ibm.as400.access.IFSReadRep;
import com.ibm.as400.access.IFSReadReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.IFSUnlockBytesReq;
import com.ibm.as400.access.IFSWriteRep;
import com.ibm.as400.access.IFSWriteReq;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;

class IFSFileDescriptorImplRemote
implements IFSFileDescriptorImpl {
    private static final int UNINITIALIZED = -1;
    private static final int MAX_BYTES_PER_READ = 16000000;
    ConverterImplRemote converter_;
    private int fileHandle_ = -1;
    int preferredServerCCSID_;
    private int fileDataCCSID_ = -1;
    int serverDatastreamLevel_;
    int requestedDatastreamLevel_;
    private int fileOffset_;
    boolean isOpen_;
    boolean isOpenAllowed_ = true;
    private Object parent_;
    String path_ = "";
    AS400Server server_;
    private int shareOption_;
    AS400ImplRemote system_;
    private Boolean fileOffsetLock_ = new Boolean("true");
    private int maxDataBlockSize_ = 1024;
    private boolean determinedSystemVRM_ = false;
    private int systemVRM_;
    private static final boolean DEBUG = false;

    IFSFileDescriptorImplRemote() {
    }

    static IFSFileDescriptorImplRemote castImplToImplRemote(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        try {
            return (IFSFileDescriptorImplRemote)iFSFileDescriptorImpl;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "Argument is not an instance of IFSFileDescriptorImplRemote", (Throwable)classCastException);
            throw new InternalErrorException(10);
        }
    }

    int checkAccess(int n, int n2) throws IOException {
        return this.checkAccess(n, n2, false);
    }

    int checkAccess(int n, int n2, boolean bl) throws IOException {
        int n3;
        block8: {
            n3 = 2;
            try {
                byte[] byArray = this.converter_.stringToByteArray(this.path_);
                IFSOpenReq iFSOpenReq = new IFSOpenReq(byArray, this.preferredServerCCSID_, 0, n, 0, 0, n2);
                ClientAccessDataStream clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSOpenReq);
                if (clientAccessDataStream instanceof IFSOpenRep) {
                    int n4;
                    n3 = 0;
                    this.fileHandle_ = n4 = ((IFSOpenRep)clientAccessDataStream).getFileHandle();
                    if (bl) {
                        this.isOpen_ = true;
                    } else {
                        this.close0();
                    }
                    break block8;
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "IFSReturnCodeRep return code ", n3);
                    }
                    break block8;
                }
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost", (Throwable)connectionDroppedException);
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
        return n3;
    }

    public void close() {
        this.isOpen_ = false;
        this.fileHandle_ = -1;
    }

    void close0() throws IOException {
        if (this.fileHandle_ != -1) {
            ClientAccessDataStream clientAccessDataStream = null;
            IFSCloseReq iFSCloseReq = new IFSCloseReq(this.fileHandle_);
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCloseReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream connection lost during close", (Throwable)connectionDroppedException);
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
            finally {
                this.close();
            }
            if (clientAccessDataStream instanceof IFSCloseRep) {
                int n = ((IFSCloseRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSCloseRep return code ", n);
                    throw new ExtendedIOException(n);
                }
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code ", n);
                    throw new ExtendedIOException(n);
                }
            } else {
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
        }
    }

    void connect() throws AS400SecurityException, IOException {
        if (this.server_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            try {
                this.server_ = this.system_.getConnection(0, false);
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Access to byte stream server on '" + this.system_.getSystemName() + "' denied.");
                throw aS400SecurityException;
            }
            this.exchangeServerAttributes();
        }
    }

    void connectionDropped(ConnectionDroppedException connectionDroppedException) throws ConnectionDroppedException {
        if (this.server_ != null) {
            this.system_.disconnectServer(this.server_);
            this.server_ = null;
            this.close();
        }
        Trace.log(2, "Byte stream connection lost.");
        throw connectionDroppedException;
    }

    boolean copyTo(String string, boolean bl) throws AS400SecurityException, IOException {
        ClientAccessDataStream clientAccessDataStream = null;
        IFSCopyReq iFSCopyReq = new IFSCopyReq(this.path_, string, bl);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCopyReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream connection lost during copy", (Throwable)connectionDroppedException);
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                throw new ExtendedIOException(n);
            }
            return true;
        }
        Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exchangeServerAttributes() throws IOException {
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            DataStream dataStream = this.server_.getExchangeAttrReply();
            IFSExchangeAttrRep iFSExchangeAttrRep = null;
            try {
                iFSExchangeAttrRep = (IFSExchangeAttrRep)dataStream;
            }
            catch (ClassCastException classCastException) {
                if (dataStream instanceof IFSReturnCodeRep) {
                    int n = ((IFSReturnCodeRep)dataStream).getReturnCode();
                    Trace.log(2, "Unexpected IFSReturnCodeRep, return code ", n);
                    throw new ExtendedIOException(n);
                }
                String string = dataStream == null ? "null" : dataStream.getClass().getName();
                Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + string);
                throw new InternalErrorException(2);
            }
            this.requestedDatastreamLevel_ = this.getSystemVRM() >= 328448 ? 8 : (this.getSystemVRM() >= 263424 ? 2 : 0);
            if (iFSExchangeAttrRep == null) {
                dataStream = null;
                try {
                    int[] nArray = this.getSystemVRM() >= 328448 ? new int[]{1200, 13488, 61952} : (this.getSystemVRM() >= 263424 ? new int[]{13488, 61952} : new int[]{61952});
                    dataStream = this.server_.sendExchangeAttrRequest(new IFSExchangeAttrReq(true, false, 2, -1, this.requestedDatastreamLevel_, nArray));
                    iFSExchangeAttrRep = (IFSExchangeAttrRep)dataStream;
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                catch (IOException iOException) {
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    Trace.log(2, "I/O error during attribute exchange.");
                    throw iOException;
                }
                catch (ClassCastException classCastException) {
                    if (dataStream instanceof IFSReturnCodeRep) {
                        int n = ((IFSReturnCodeRep)dataStream).getReturnCode();
                        Trace.log(2, "Unexpected IFSReturnCodeRep, return code ", n);
                        throw new ExtendedIOException(n);
                    }
                    String string = dataStream == null ? "null" : dataStream.getClass().getName();
                    Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + string);
                    throw new InternalErrorException(2);
                }
            }
            if (!(iFSExchangeAttrRep instanceof IFSExchangeAttrRep)) {
                this.system_.disconnectServer(this.server_);
                this.server_ = null;
                if (iFSExchangeAttrRep != null) {
                    Trace.log(2, "Unknown reply data stream ", iFSExchangeAttrRep.data_);
                    throw new InternalErrorException(Integer.toHexString(iFSExchangeAttrRep.getReqRepID()), 2);
                }
                Trace.log(2, "Null reply data stream");
                throw new InternalErrorException(2);
            }
            this.maxDataBlockSize_ = iFSExchangeAttrRep.getMaxDataBlockSize();
            this.preferredServerCCSID_ = iFSExchangeAttrRep.getPreferredCCSID();
            this.serverDatastreamLevel_ = iFSExchangeAttrRep.getDataStreamLevel();
            this.setConverter(ConverterImplRemote.getConverter(this.preferredServerCCSID_, this.system_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalize0() throws IOException {
        if (this.fileHandle_ != -1) {
            IFSCloseReq iFSCloseReq = new IFSCloseReq(this.fileHandle_);
            try {
                this.server_.sendAndDiscardReply(iFSCloseReq);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                Trace.log(2, "Error during finalization.", (Throwable)exception);
            }
            finally {
                this.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    void flush() throws IOException {
        IFSCommitReq iFSCommitReq = new IFSCommitReq(this.fileHandle_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCommitReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                throw new ExtendedIOException(n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    ConverterImplRemote getConverter() {
        return this.converter_;
    }

    public int getCCSID() throws IOException {
        if (this.fileDataCCSID_ != -1) {
            return this.fileDataCCSID_;
        }
        try {
            ClientAccessDataStream clientAccessDataStream = null;
            byte[] byArray = this.getConverter().stringToByteArray(this.getPath());
            IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(this.getFileHandle(), 68);
            clientAccessDataStream = (ClientAccessDataStream)this.getServer().sendAndReceive(iFSListAttrsReq);
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                if (clientAccessDataStream instanceof IFSListAttrsRep) {
                    if (bl2) {
                        Trace.log(1, "Received multiple replies from ListAttributes request.");
                    }
                    this.fileDataCCSID_ = ((IFSListAttrsRep)clientAccessDataStream).getCCSID(this.serverDatastreamLevel_);
                    bl2 = true;
                } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n != 18 && n != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code = ", n);
                        throw new ExtendedIOException(n);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                if (bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain()) continue;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.getServer().receive(iFSListAttrsReq.getCorrelation());
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            }
            if (!bl2) {
                Trace.log(2, "Unable to determine CCSID of file " + this.path_);
                throw new ExtendedIOException(25);
            }
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        return this.fileDataCCSID_;
    }

    int getFileHandle() {
        return this.fileHandle_;
    }

    public int getFileOffset() {
        return this.fileOffset_;
    }

    Object getParent() {
        return this.parent_;
    }

    String getPath() {
        return this.path_;
    }

    int getPreferredCCSID() {
        return this.preferredServerCCSID_;
    }

    AS400Server getServer() {
        return this.server_;
    }

    int getShareOption() {
        return this.shareOption_;
    }

    AS400ImplRemote getSystem() {
        return this.system_;
    }

    int getSystemVRM() {
        if (!this.determinedSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.determinedSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFileOffset(int n) {
        Boolean bl = this.fileOffsetLock_;
        synchronized (bl) {
            this.fileOffset_ += n;
        }
    }

    public void initialize(int n, Object object, String string, int n2, AS400Impl aS400Impl) {
        this.fileOffset_ = n;
        this.parent_ = object;
        this.path_ = string;
        this.shareOption_ = n2;
        this.system_ = (AS400ImplRemote)aS400Impl;
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    boolean isOpenAllowed() {
        return this.isOpenAllowed_;
    }

    IFSKey lock(int n) throws IOException {
        return this.lock(this.fileOffset_, n);
    }

    IFSKey lock(int n, int n2) throws IOException {
        int n3;
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            IFSLockBytesReq iFSLockBytesReq = new IFSLockBytesReq(this.fileHandle_, true, false, n, n2);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLockBytesReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSLockBytesRep) {
            n3 = ((IFSLockBytesRep)clientAccessDataStream).getReturnCode();
            if (n3 != 0) {
                Trace.log(2, "IFSLockBytesRep return code ", n3);
                throw new ExtendedIOException(n3);
            }
        } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n3 != 0) {
                Trace.log(2, "IFSReturnCodeRep return code", n3);
                throw new ExtendedIOException(n3);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        IFSKey iFSKey = new IFSKey(this.fileHandle_, n, n2, true);
        return iFSKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        boolean bl = false;
        while (true) {
            ClientAccessDataStream clientAccessDataStream;
            IFSReadReq iFSReadReq;
            if (n3 < n2 && !bl) {
                int n5 = Math.min(n4, 16000000);
                iFSReadReq = new IFSReadReq(this.fileHandle_, this.fileOffset_, n5);
                clientAccessDataStream = null;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSReadReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            } else {
                if (bl && n3 == 0) {
                    return -1;
                }
                int n6 = n3;
                return n6;
            }
            boolean bl2 = false;
            int n7 = 0;
            do {
                if (clientAccessDataStream instanceof IFSReadRep) {
                    byte[] byArray2 = ((IFSReadRep)clientAccessDataStream).getData();
                    if (byArray2.length > 0) {
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n7 += byArray2.length;
                        n += byArray2.length;
                    } else {
                        n7 = -1;
                        bl = true;
                    }
                } else {
                    if (!(clientAccessDataStream instanceof IFSReturnCodeRep)) {
                        Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                    }
                    int n8 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n8 != 0) {
                        if (n8 != 22) {
                            Trace.log(2, "IFSReturnCodeRep return code ", n8);
                            throw new ExtendedIOException(n8);
                        }
                        n7 = -1;
                        bl = true;
                    }
                }
                bl2 = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
                if (bl2) continue;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.server_.receive(iFSReadReq.getCorrelation());
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            } while (!bl2);
            if (n7 <= 0) continue;
            this.incrementFileOffset(n7);
            n3 += n7;
            n4 -= n7;
        }
    }

    void setConverter(ConverterImplRemote converterImplRemote) {
        this.converter_ = converterImplRemote;
    }

    void setFileHandle(int n) {
        if (n == -1) {
            Trace.log(2, "Called setOpen with invalid file handle: " + n);
            throw new InternalErrorException(10);
        }
        this.fileHandle_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileOffset(int n) {
        Boolean bl = this.fileOffsetLock_;
        synchronized (bl) {
            this.fileOffset_ = n;
        }
    }

    boolean setLength(int n) throws IOException {
        ClientAccessDataStream clientAccessDataStream = null;
        boolean bl = false;
        try {
            byte[] byArray = this.converter_.stringToByteArray(this.path_);
            if (this.fileHandle_ == -1) {
                int n2 = this.checkAccess(2, 8, true);
                if (n2 != 0) {
                    Trace.log(2, "Failed to open file: IFSReturnCodeRep return code = ", n2);
                    return false;
                }
                bl = true;
            }
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(this.fileHandle_, n);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        boolean bl2 = false;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n3 == 0) {
                bl2 = true;
            } else {
                Trace.log(2, "Error resetting file length: IFSReturnCodeRep return code = ", n3);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        if (this.fileOffset_ > n) {
            this.fileOffset_ = n;
        }
        if (bl) {
            this.close0();
        }
        return bl2;
    }

    void setOpen(boolean bl, int n) {
        if (bl) {
            this.setFileHandle(n);
        }
        this.isOpen_ = bl;
    }

    void setOpenAllowed(boolean bl) {
        this.isOpenAllowed_ = bl;
    }

    void setPreferredCCSID(int n) {
        this.preferredServerCCSID_ = n;
    }

    void setServer(AS400Server aS400Server) {
        this.server_ = aS400Server;
    }

    public void sync() throws IOException {
        if (this.parent_ == null) {
            Trace.log(2, "IFSFileDescriptor.sync() was called when parent is null.");
        } else if (this.parent_ instanceof IFSRandomAccessFileImplRemote) {
            ((IFSRandomAccessFileImplRemote)this.parent_).flush();
        } else if (this.parent_ instanceof IFSFileOutputStreamImplRemote) {
            ((IFSFileOutputStreamImplRemote)this.parent_).flush();
        } else {
            Trace.log(4, "IFSFileDescriptor.sync() was called when parent is neither an IFSRandomAccessFile nor an IFSFileOutputStream.");
        }
    }

    void unlock(IFSKey iFSKey) throws IOException {
        if (iFSKey.fileHandle_ != this.fileHandle_) {
            Trace.log(2, "Attempt to use IFSKey on different file stream.");
            throw new ExtendedIllegalArgumentException("key", 2);
        }
        ClientAccessDataStream clientAccessDataStream = null;
        IFSUnlockBytesReq iFSUnlockBytesReq = new IFSUnlockBytesReq(iFSKey.fileHandle_, iFSKey.offset_, iFSKey.length_, iFSKey.isMandatory_);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSUnlockBytesReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                throw new ExtendedIOException(n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2, false);
    }

    void writeBytes(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        while (n2 > 0) {
            int n3 = n2 > this.maxDataBlockSize_ ? this.maxDataBlockSize_ : n2;
            IFSWriteReq iFSWriteReq = new IFSWriteReq(this.fileHandle_, this.fileOffset_, byArray, n, n3, 65535, bl);
            if (n2 - n3 > 0) {
                iFSWriteReq.setChainIndicator(1);
            }
            ClientAccessDataStream clientAccessDataStream = null;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSWriteReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
            if (clientAccessDataStream instanceof IFSWriteRep) {
                IFSWriteRep iFSWriteRep = (IFSWriteRep)clientAccessDataStream;
                int n4 = iFSWriteRep.getReturnCode();
                if (n4 != 0) {
                    Trace.log(2, "IFSWriteRep return code ", n4);
                    throw new ExtendedIOException(n4);
                }
                int n5 = n3 - iFSWriteRep.getLengthNotWritten();
                this.incrementFileOffset(n5);
                n += n5;
                n2 -= n5;
                if (n5 == n3) continue;
                Trace.log(2, "Incomplete write.  Only " + Integer.toString(n5) + " bytes of a requested " + Integer.toString(n3) + " were written.");
                throw new ExtendedIOException(25);
            }
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n6 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n6 == 0) continue;
                throw new ExtendedIOException(n6);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSCloseRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSExchangeAttrRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSLockBytesRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSWriteRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReadRep(), 0);
    }
}

