/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTableWriter;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSKey;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class IFSFileWriter
extends Writer {
    private static final String copyright = "Copyright (C) 2004-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    private transient ConvTableWriter writer_;
    private IFSFileOutputStream outputStream_;

    public IFSFileWriter(IFSFile iFSFile) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n = iFSFile.getCCSID();
        this.outputStream_ = new IFSFileOutputStream(iFSFile);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public IFSFileWriter(IFSFile iFSFile, int n) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public IFSFileWriter(IFSFile iFSFile, boolean bl) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n = iFSFile.getCCSID();
        this.outputStream_ = new IFSFileOutputStream(iFSFile, -1, bl);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public IFSFileWriter(IFSFile iFSFile, boolean bl, int n) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n2 = iFSFile.getCCSID();
        this.outputStream_ = new IFSFileOutputStream(iFSFile, n, bl);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n2);
    }

    public IFSFileWriter(IFSFile iFSFile, boolean bl, int n, int n2) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile, n, bl);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n2);
    }

    public IFSFileWriter(IFSFileDescriptor iFSFileDescriptor) throws AS400SecurityException, IOException {
        int n = iFSFileDescriptor.getCCSID();
        this.outputStream_ = new IFSFileOutputStream(iFSFileDescriptor);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    public Writer append(CharSequence charSequence) throws IOException {
        this.write(charSequence == null ? "null" : ((Object)charSequence).toString());
        return this;
    }

    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        this.write(charSequence == null ? new String("null").substring(n, Math.min(n2, 4)) : ((Object)charSequence.subSequence(n, n2)).toString());
        return this;
    }

    public void close() throws IOException {
        this.writer_.close();
    }

    public void flush() throws IOException {
        this.writer_.flush();
    }

    public int getCCSID() {
        return this.writer_.getCcsid();
    }

    public String getEncoding() {
        return this.writer_.getEncoding();
    }

    public IFSKey lockBytes(int n) throws IOException {
        return this.outputStream_.lock(n);
    }

    public void unlockBytes(IFSKey iFSKey) throws IOException {
        this.outputStream_.unlock(iFSKey);
    }

    public void write(int n) throws IOException {
        this.writer_.write(n);
    }

    public void write(char[] cArray) throws IOException {
        this.writer_.write(cArray);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer_.write(cArray, n, n2);
    }

    public void write(String string) throws IOException {
        this.writer_.write(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.writer_.write(string, n, n2);
    }
}

