/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDEscapeClause;
import com.ibm.as400.access.JDSQLTokenizer;
import com.ibm.as400.access.JDUtilities;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;

class JDSQLStatement {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final int TYPE_UNDETERMINED = 0;
    static final int TYPE_OTHER = 1;
    static final int TYPE_SELECT = 2;
    static final int TYPE_CALL = 3;
    static final int TYPE_COMMIT = 4;
    static final int TYPE_ROLLBACK = 5;
    static final int TYPE_CONNECT = 6;
    static final int TYPE_BLOCK_INSERT = 7;
    private static final String AS_ = "AS";
    private static final String CALL_ = "CALL";
    private static final String CALL0_ = "?";
    private static final String CALL1_ = "?=";
    private static final String CALL2_ = "?=CALL";
    private static final String COMMA_ = ",";
    private static final String CONNECT_ = "CONNECT";
    private static final String CONNECTION_ = "CONNECTION";
    private static final String CROSS_ = "CROSS";
    private static final String CURRENT_ = "CURRENT";
    private static final String DECLARE_ = "DECLARE";
    private static final String DELETE_ = "DELETE";
    private static final String DISCONNECT_ = "DISCONNECT";
    private static final String EXCEPTION_ = "EXCEPTION";
    private static final String FETCH_ = "FETCH";
    private static final String FOR_ = "FOR";
    private static final String FROM_ = "FROM";
    private static final String INNER_ = "INNER";
    private static final String INSERT_ = "INSERT";
    private static final String JOIN_ = "JOIN";
    private static final String LEFT_ = "LEFT";
    private static final String LPAREN_ = "(";
    private static final String OF_ = "OF";
    private static final String ONLY_ = "ONLY";
    private static final String READ_ = "READ";
    private static final String RELEASE_ = "RELEASE";
    private static final String ROWS_ = "ROWS";
    private static final String SELECT_ = "SELECT";
    private static final String SET_ = "SET";
    private static final String UPDATE_ = "UPDATE";
    private static final String VALUES_ = "VALUES";
    private static final String WITH_ = "WITH";
    private boolean canBeBatched_ = false;
    private String correlationName_ = null;
    private String csProcedure_ = null;
    private String csSchema_ = null;
    private boolean hasReturnValueParameter_ = false;
    private boolean isCall_ = false;
    private boolean isDeclare_ = false;
    private boolean isCurrentOf_ = false;
    private boolean isDRDAConnect_ = false;
    private boolean isDRDADisconnect_ = false;
    private boolean isForFetchOrReadOnly_ = false;
    private boolean isForUpdate_ = false;
    private boolean isImmediatelyExecutable_ = false;
    boolean isInsert_ = false;
    private boolean isSelect_ = false;
    private boolean isSet_ = false;
    private boolean isSubSelect_ = false;
    private boolean isPackaged_ = false;
    private boolean isUpdateOrDelete_ = false;
    private int nativeType_ = 1;
    private int numberOfParameters_;
    private String selectTable_ = null;
    private JDSQLTokenizer tokenizer_ = null;
    private String value_;
    private String valueForServer_ = null;
    private boolean selectTableNotSet_ = true;

    JDSQLStatement(String string) throws SQLException {
        this(string, "", false, "default", null);
    }

    JDSQLStatement(String string, String string2, boolean bl, String string3, Connection connection) throws SQLException {
        int n;
        int n2;
        int n3;
        String string4;
        Object object;
        int n4;
        if (string == null) {
            JDError.throwSQLException("42601");
        }
        if (string.trim().length() == 0) {
            JDError.throwSQLException("43617");
        }
        if ((n4 = string.length()) > Short.MAX_VALUE) {
            object = new JDSQLTokenizer(string, " \t\n\r\f", true, false);
            string = ((JDSQLTokenizer)object).toString();
        }
        this.value_ = bl ? JDEscapeClause.parse(string, string2, ((AS400JDBCConnection)connection).getVRM()) : string;
        this.tokenizer_ = new JDSQLTokenizer(this.value_, " \t\n\r\f", false, false);
        this.numberOfParameters_ = this.tokenizer_.getNumberOfParameters();
        object = "";
        while (((String)object).length() == 0 && this.tokenizer_.hasMoreTokens()) {
            string4 = this.tokenizer_.nextToken();
            n3 = string4.length();
            for (n2 = 0; n2 < n3 && string4.charAt(n2) == '('; ++n2) {
            }
            if (n2 >= n3) continue;
            object = string4.substring(n2).toUpperCase();
        }
        if (((String)object).startsWith(SELECT_) || ((String)object).equals(WITH_)) {
            this.isSelect_ = true;
            this.nativeType_ = 2;
        } else if (((String)object).equals(CALL_)) {
            this.isCall_ = true;
            this.nativeType_ = 3;
        } else if (((String)object).equals(CALL0_) || ((String)object).equals(CALL1_) || ((String)object).equals(CALL2_)) {
            this.isCall_ = true;
            this.nativeType_ = 3;
            this.hasReturnValueParameter_ = true;
            --this.numberOfParameters_;
        } else if (((String)object).equals(CONNECT_) || ((String)object).equals(CONNECTION_) || ((String)object).equals(DISCONNECT_)) {
            this.nativeType_ = 6;
            if (((String)object).equals(CONNECT_)) {
                this.isDRDAConnect_ = true;
            } else if (((String)object).equals(DISCONNECT_)) {
                this.isDRDADisconnect_ = true;
            }
        } else if (((String)object).equals(RELEASE_)) {
            string4 = this.value_.toUpperCase();
            n2 = string4.indexOf("SAVEPOINT");
            if (n2 < 0) {
                this.nativeType_ = 6;
            }
        } else if (((String)object).equals(INSERT_)) {
            int n5;
            this.isInsert_ = true;
            string4 = this.value_.toUpperCase();
            n2 = string4.indexOf(ROWS_);
            n3 = string4.length();
            if (n2 != -1) {
                n2 += 4;
                while (n2 < n3 && Character.isWhitespace(string4.charAt(n2))) {
                    ++n2;
                }
                if (string4.regionMatches(n2, VALUES_, 0, 6)) {
                    this.nativeType_ = 7;
                }
            }
            if ((n5 = string4.indexOf(VALUES_)) != -1) {
                StringTokenizer stringTokenizer;
                String string5;
                n5 += 6;
                while (n5 < n3 && Character.isWhitespace(string4.charAt(n5))) {
                    ++n5;
                }
                int n6 = string4.lastIndexOf(")");
                if (n6 >= 1 && n6 > n5) {
                    string5 = string4.substring(n5 + 1, n6);
                    stringTokenizer = new StringTokenizer(string5, ", ?");
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.canBeBatched_ = true;
                    }
                } else {
                    string5 = string4.substring(n5);
                    if (string5.trim().equals(CALL0_)) {
                        this.canBeBatched_ = true;
                    } else {
                        stringTokenizer = new StringTokenizer(string5, COMMA_);
                        if (stringTokenizer.countTokens() > 1) {
                            JDError.throwSQLException(this, "42601");
                        }
                    }
                }
            }
        } else if (((String)object).equals(UPDATE_) || ((String)object).equals(DELETE_)) {
            this.isUpdateOrDelete_ = true;
        } else if (((String)object).equals(DECLARE_)) {
            this.isDeclare_ = true;
        } else if (((String)object).equals(SET_)) {
            this.isSet_ = true;
            this.nativeType_ = 0;
        }
        if (this.isCall_) {
            int n7;
            while (this.tokenizer_.hasMoreTokens() && !((String)object).endsWith(CALL_)) {
                object = this.tokenizer_.nextToken().toUpperCase();
            }
            string4 = this.tokenizer_.nextToken();
            n2 = string4.indexOf(40);
            if (n2 != -1) {
                string4 = string4.substring(0, n2);
            }
            String string6 = ((AS400JDBCConnection)connection).getProperties().getString(9).equalsIgnoreCase("sql") ? "." : "/";
            String string7 = null;
            StringBuffer stringBuffer = null;
            int n8 = string4.indexOf(string6);
            if (string4.indexOf(34) == -1 && n8 > 0 && n8 < string4.length() - 1) {
                string7 = string4;
            } else if (string4.endsWith(string6)) {
                if (this.tokenizer_.hasMoreTokens()) {
                    stringBuffer = new StringBuffer(string4);
                    stringBuffer.append(this.tokenizer_.nextToken());
                }
            } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().equals(string6)) {
                stringBuffer = new StringBuffer(string4);
                stringBuffer.append(this.tokenizer_.nextToken());
                if (this.tokenizer_.hasMoreTokens()) {
                    stringBuffer.append(this.tokenizer_.nextToken());
                }
            } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().startsWith(string6)) {
                stringBuffer = new StringBuffer(string4);
                stringBuffer.append(this.tokenizer_.nextToken());
            } else {
                string7 = string4;
            }
            if (stringBuffer != null && (n7 = (string7 = stringBuffer.toString()).indexOf(40)) != -1) {
                string7 = string7.substring(0, n7);
            }
            stringBuffer = null;
            n2 = string7.indexOf(string6);
            if (n2 == -1) {
                this.csProcedure_ = JDUtilities.upperCaseIfNotQuoted(string7);
                this.csSchema_ = "";
            } else {
                this.csProcedure_ = JDUtilities.upperCaseIfNotQuoted(string7.substring(n2 + 1));
                this.csSchema_ = JDUtilities.upperCaseIfNotQuoted(string7.substring(0, n2));
            }
        }
        boolean bl2 = true;
        while (this.tokenizer_.hasMoreTokens()) {
            String string8 = this.tokenizer_.nextToken().toUpperCase();
            if (this.isInsert_ && string8.equals(SELECT_)) {
                this.isSubSelect_ = true;
            } else if (string8.equals(CURRENT_) && this.tokenizer_.hasMoreTokens() && this.tokenizer_.nextToken().equalsIgnoreCase(OF_)) {
                this.isCurrentOf_ = true;
            } else if (string8.equals(FOR_)) {
                this.parseFor();
            } else if (this.isSelect_ && string8.equals(FROM_) && this.selectTableNotSet_) {
                this.selectTableNotSet_ = false;
                if (this.tokenizer_.hasMoreTokens() && !(string8 = this.tokenizer_.nextToken()).startsWith(LPAREN_)) {
                    String string9 = ((AS400JDBCConnection)connection).getProperties().getString(9).equalsIgnoreCase("sql") ? "." : "/";
                    if (string8.endsWith(string9)) {
                        StringBuffer stringBuffer = new StringBuffer(string8);
                        if (this.tokenizer_.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer_.nextToken());
                        }
                        this.selectTable_ = stringBuffer.toString();
                    } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().equals(string9)) {
                        StringBuffer stringBuffer = new StringBuffer(string8);
                        stringBuffer.append(this.tokenizer_.nextToken());
                        if (this.tokenizer_.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer_.nextToken());
                        }
                        this.selectTable_ = stringBuffer.toString();
                    } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().startsWith(string9)) {
                        StringBuffer stringBuffer = new StringBuffer(string8);
                        stringBuffer.append(this.tokenizer_.nextToken());
                        this.selectTable_ = stringBuffer.toString();
                    } else {
                        this.selectTable_ = string8;
                    }
                    if (this.tokenizer_.hasMoreTokens()) {
                        string8 = this.tokenizer_.nextToken().toUpperCase();
                        if (string8.equals(AS_) && this.tokenizer_.hasMoreTokens()) {
                            this.correlationName_ = this.tokenizer_.nextToken().toUpperCase();
                        } else if (string8.equals(FOR_)) {
                            this.parseFor();
                        }
                    }
                }
            } else if (this.isSet_ && bl2 && string8.equals(CONNECTION_)) {
                this.nativeType_ = 6;
            }
            bl2 = false;
        }
        boolean bl3 = this.numberOfParameters_ > 0 || this.isInsert_ && this.isSubSelect_ || this.isCurrentOf_ && this.isUpdateOrDelete_;
        this.isImmediatelyExecutable_ = !bl3 && !this.isSelect_;
        boolean bl4 = this.isPackaged_ = this.numberOfParameters_ > 0 && !this.isCurrentOf_ && !this.isUpdateOrDelete_ || this.isInsert_ && this.isSubSelect_ || this.isSelect_ && this.isForUpdate_ || this.isDeclare_;
        if (string3.equalsIgnoreCase("select")) {
            boolean bl5 = this.isPackaged_ = this.isPackaged_ || this.isSelect_;
        }
        if (this.hasReturnValueParameter_ && (n = this.value_.toUpperCase().indexOf(CALL_)) != -1) {
            this.value_ = this.value_.substring(n);
        }
        this.value_ = this.value_.trim();
    }

    boolean canBatch() {
        return this.canBeBatched_;
    }

    int countParameters() {
        return this.numberOfParameters_;
    }

    String getCorrelationName() {
        return this.correlationName_;
    }

    int getNativeType() {
        return this.nativeType_;
    }

    int getNumOfParameters() {
        return this.numberOfParameters_;
    }

    String getProcedure() {
        return this.csProcedure_;
    }

    String getSchema() {
        return this.csSchema_;
    }

    String getSelectTable() {
        return this.selectTable_;
    }

    boolean hasReturnValueParameter() {
        return this.hasReturnValueParameter_;
    }

    boolean isDRDAConnect() {
        return this.isDRDAConnect_;
    }

    boolean isDRDADisconnect() {
        return this.isDRDADisconnect_;
    }

    boolean isForFetchOnly() {
        return this.isForFetchOrReadOnly_;
    }

    boolean isForUpdate() {
        return this.isForUpdate_;
    }

    boolean isImmediatelyExecutable() {
        return this.isImmediatelyExecutable_;
    }

    boolean isPackaged() {
        return this.isPackaged_;
    }

    boolean isProcedureCall() {
        return this.isCall_;
    }

    boolean isSelect() {
        return this.isSelect_;
    }

    private void parseFor() {
        if (this.tokenizer_.hasMoreTokens()) {
            String string = this.tokenizer_.nextToken().toUpperCase();
            if (string.equals(FETCH_) || string.equals(READ_)) {
                if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.nextToken().equalsIgnoreCase(ONLY_)) {
                    this.isForFetchOrReadOnly_ = true;
                }
            } else if (string.equals(UPDATE_)) {
                this.isForUpdate_ = true;
            }
        }
    }

    public void setNativeType(int n) {
        this.nativeType_ = n;
    }

    public String toString() {
        return this.value_;
    }
}

