/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.Closeable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.DriverManager;

final class JDTrace {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static int JDBCLevel_ = 10;

    private JDTrace() {
    }

    static boolean isTraceOn() {
        if (Trace.traceOn_ && Trace.traceJDBC_) {
            return true;
        }
        if (JDBCLevel_ > 10 && DriverManager.getLogWriter() != null) {
            return true;
        }
        return DriverManager.getLogStream() != null;
    }

    static void logDataEvenIfTracingIsOff(Object object, String string) {
        JDTrace.logInformation(object, string);
    }

    static void logInformation(String string) {
        if (JDTrace.isTraceOn()) {
            String string2 = "as400: " + string;
            JDTrace.log(string2);
        }
    }

    static void logException(Object object, String string, Exception exception) {
        if (JDTrace.isTraceOn()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.write("as400: ");
            if (object != null) {
                printWriter.write(JDTrace.objectToString(object));
            } else {
                printWriter.write("static method");
            }
            printWriter.write(": ");
            printWriter.write(string);
            printWriter.write(".");
            exception.printStackTrace(printWriter);
            JDTrace.log(stringWriter.toString());
        }
    }

    static void logException(Object object, Object object2, String string, Exception exception) {
        if (JDTrace.isTraceOn()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.write("as400: ");
            if (object != null) {
                printWriter.write(JDTrace.objectToString(object));
            } else {
                printWriter.write("static method ");
            }
            if (object2 != null) {
                printWriter.write(JDTrace.objectToString(object2));
            }
            printWriter.write(": ");
            printWriter.write(string);
            printWriter.write(".");
            exception.printStackTrace(printWriter);
            JDTrace.log(stringWriter.toString());
        }
    }

    static void logInformation(Object object, String string) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(": ");
            stringBuffer.append(string);
            stringBuffer.append(".");
            JDTrace.log(stringBuffer.toString());
        }
    }

    static void logProperty(Object object, String string, String string2) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(": ");
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            stringBuffer.append(string2);
            stringBuffer.append("\".");
            JDTrace.log(stringBuffer.toString());
        }
    }

    static void logProperty(Object object, String string, boolean bl) {
        if (JDTrace.isTraceOn()) {
            Boolean bl2 = new Boolean(bl);
            JDTrace.logProperty(object, string, bl2.toString());
        }
    }

    static void logProperty(Object object, String string, int n) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty(object, string, Integer.toString(n));
        }
    }

    static void logOpen(Object object, Object object2) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(" open.");
            if (object2 != null) {
                stringBuffer.append(" Parent: ");
                stringBuffer.append(JDTrace.objectToString(object2));
                stringBuffer.append(".");
            }
            JDTrace.log(stringBuffer.toString());
        }
    }

    private static void log(String string) {
        Closeable closeable;
        if (JDBCLevel_ > 10 && (closeable = DriverManager.getLogWriter()) != null) {
            ((PrintWriter)closeable).println(string);
        }
        if ((closeable = DriverManager.getLogStream()) != null) {
            ((PrintStream)closeable).println(string);
        }
        Trace.log(8, string);
    }

    static void logClose(Object object) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(" closed.");
            JDTrace.log(stringBuffer.toString());
        }
    }

    static String objectToString(Object object) {
        String string = object.getClass().getName();
        String string2 = string.startsWith("com.ibm.as400.access.AS400JDBC") ? string.substring(30) : (string.startsWith("com.ibm.as400.access.JD") ? string.substring(23) : "Unknown");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(object.toString());
        stringBuffer.append(" (");
        stringBuffer.append(object.hashCode());
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    static void setTraceOn(boolean bl) {
        Trace.setTraceJDBCOn(bl);
        if (bl) {
            Trace.setTraceOn(bl);
        }
    }

    static {
        try {
            Class.forName("java.sql.Blob");
            JDBCLevel_ = 20;
            Class.forName("java.sql.Savepoint");
            JDBCLevel_ = 30;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

