/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDProperties;
import java.sql.SQLException;

class SQLConversionSettings {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    public static final int DATE_FORMAT_JULIAN = 0;
    public static final int DATE_FORMAT_MDY = 1;
    public static final int DATE_FORMAT_DMY = 2;
    public static final int DATE_FORMAT_YMD = 3;
    public static final int DATE_FORMAT_USA = 4;
    public static final int DATE_FORMAT_ISO = 5;
    public static final int DATE_FORMAT_EUR = 6;
    public static final int DATE_FORMAT_JIS = 7;
    public static final int TIME_FORMAT_HMS = 0;
    public static final int TIME_FORMAT_USA = 1;
    public static final int TIME_FORMAT_ISO = 2;
    public static final int TIME_FORMAT_EUR = 3;
    public static final int TIME_FORMAT_JIS = 4;
    private int dateFormat_;
    private String dateSeparator_;
    private String decimalSeparator_;
    private int maxFieldSize_;
    private int timeFormat_;
    private String timeSeparator_;
    private boolean useBigDecimal_;
    private int bidiStringType_;
    private boolean bidiImplicitReordering_;
    private boolean bidiNumericOrdering_;

    SQLConversionSettings(AS400JDBCConnection aS400JDBCConnection) throws SQLException {
        JDProperties jDProperties = aS400JDBCConnection.getProperties();
        this.dateFormat_ = jDProperties.getIndex(3);
        this.dateSeparator_ = jDProperties.getString(4);
        this.decimalSeparator_ = jDProperties.getString(5);
        this.timeFormat_ = jDProperties.getIndex(24);
        this.timeSeparator_ = jDProperties.getString(25);
        this.bidiStringType_ = this.getInt(jDProperties.getString(42));
        this.bidiImplicitReordering_ = jDProperties.getBoolean(60);
        this.bidiNumericOrdering_ = jDProperties.getBoolean(61);
        if (this.dateSeparator_.equalsIgnoreCase("b")) {
            this.dateSeparator_ = " ";
        }
        if (this.timeSeparator_.equalsIgnoreCase("b")) {
            this.timeSeparator_ = " ";
        }
        this.maxFieldSize_ = 0;
        this.useBigDecimal_ = jDProperties.getBoolean(37);
    }

    int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    int getBidiStringType() {
        return this.bidiStringType_;
    }

    boolean getBidiImplicitReordering() {
        return this.bidiImplicitReordering_;
    }

    boolean getBidiNumericOrdering() {
        return this.bidiNumericOrdering_;
    }

    int getDateFormat() {
        return this.dateFormat_;
    }

    String getDateSeparator() {
        return this.dateSeparator_;
    }

    String getDecimalSeparator() {
        return this.decimalSeparator_;
    }

    int getMaxFieldSize() {
        return this.maxFieldSize_;
    }

    int getTimeFormat() {
        return this.timeFormat_;
    }

    String getTimeSeparator() {
        return this.timeSeparator_;
    }

    void setMaxFieldSize(int n) {
        this.maxFieldSize_ = n;
    }

    boolean useBigDecimal() {
        return this.useBigDecimal_;
    }
}

