/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.Serializable;

public class SocketProperties
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6818790247993750518L;
    boolean keepAliveSet_ = false;
    boolean keepAlive_ = false;
    boolean receiveBufferSizeSet_ = false;
    int receiveBufferSize_ = 0;
    boolean sendBufferSizeSet_ = false;
    int sendBufferSize_ = 0;
    boolean soLingerSet_ = false;
    int soLinger_ = 0;
    boolean soTimeoutSet_ = false;
    int soTimeout_ = 0;
    boolean tcpNoDelaySet_ = false;
    boolean tcpNoDelay_ = false;

    void copyValues(SocketProperties socketProperties) {
        this.keepAliveSet_ = socketProperties.keepAliveSet_;
        this.keepAlive_ = socketProperties.keepAlive_;
        this.receiveBufferSizeSet_ = socketProperties.receiveBufferSizeSet_;
        this.receiveBufferSize_ = socketProperties.receiveBufferSize_;
        this.sendBufferSizeSet_ = socketProperties.sendBufferSizeSet_;
        this.sendBufferSize_ = socketProperties.sendBufferSize_;
        this.soLingerSet_ = socketProperties.soLingerSet_;
        this.soLinger_ = socketProperties.soLinger_;
        this.soTimeoutSet_ = socketProperties.soTimeoutSet_;
        this.soTimeout_ = socketProperties.soTimeout_;
        this.tcpNoDelaySet_ = socketProperties.tcpNoDelaySet_;
        this.tcpNoDelay_ = socketProperties.tcpNoDelay_;
    }

    public boolean equals(Object object) {
        try {
            SocketProperties socketProperties = (SocketProperties)object;
            return this.keepAliveSet_ == socketProperties.keepAliveSet_ && this.keepAlive_ == socketProperties.keepAlive_ && this.receiveBufferSizeSet_ == socketProperties.receiveBufferSizeSet_ && this.receiveBufferSize_ == socketProperties.receiveBufferSize_ && this.sendBufferSizeSet_ == socketProperties.sendBufferSizeSet_ && this.sendBufferSize_ == socketProperties.sendBufferSize_ && this.soLingerSet_ == socketProperties.soLingerSet_ && this.soLinger_ == socketProperties.soLinger_ && this.soTimeoutSet_ == socketProperties.soTimeoutSet_ && this.soTimeout_ == socketProperties.soTimeout_ && this.tcpNoDelaySet_ == socketProperties.tcpNoDelaySet_ && this.tcpNoDelay_ == socketProperties.tcpNoDelay_;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int getReceiveBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting receive buffer size:", this.receiveBufferSize_);
        }
        return this.receiveBufferSize_;
    }

    public int getSendBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting send buffer size:", this.sendBufferSize_);
        }
        return this.sendBufferSize_;
    }

    public int getSoLinger() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so linger:", this.soLinger_);
        }
        return this.soLinger_;
    }

    public int getSoTimeout() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so timeout:", this.soTimeout_);
        }
        return this.soTimeout_;
    }

    public boolean isKeepAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if keep alive:", this.keepAlive_);
        }
        return this.keepAlive_;
    }

    public boolean isKeepAliveSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if keep alive is set:", this.keepAliveSet_);
        }
        return this.keepAliveSet_;
    }

    public boolean isReceiveBufferSizeSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting receive buffer size is set:", this.receiveBufferSizeSet_);
        }
        return this.receiveBufferSizeSet_;
    }

    public boolean isSendBufferSizeSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting send buffer size is set:", this.sendBufferSizeSet_);
        }
        return this.sendBufferSizeSet_;
    }

    public boolean isSoLingerSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so linger is set:", this.soLingerSet_);
        }
        return this.soLingerSet_;
    }

    public boolean isSoTimeoutSet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting so timeout is set:", this.soTimeoutSet_);
        }
        return this.soTimeoutSet_;
    }

    public boolean isTcpNoDelay() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if TCP no delay:", this.tcpNoDelay_);
        }
        return this.tcpNoDelay_;
    }

    public boolean isTcpNoDelaySet() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if TCP no delay is set:", this.tcpNoDelaySet_);
        }
        return this.tcpNoDelaySet_;
    }

    public void setKeepAlive(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting keep alive:", bl);
        }
        this.keepAliveSet_ = true;
        this.keepAlive_ = bl;
    }

    public void setReceiveBufferSize(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting receive buffer size:", n);
        }
        this.receiveBufferSizeSet_ = true;
        this.receiveBufferSize_ = n;
    }

    public void setSendBufferSize(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting send buffer size:", n);
        }
        this.sendBufferSizeSet_ = true;
        this.sendBufferSize_ = n;
    }

    public void setSoLinger(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting so linger:", n);
        }
        this.soLingerSet_ = true;
        this.soLinger_ = n;
    }

    public void setSoTimeout(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting so timeout:", n);
        }
        this.soTimeoutSet_ = true;
        this.soTimeout_ = n;
    }

    public void setTcpNoDelay(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting TCP no delay:", bl);
        }
        this.tcpNoDelaySet_ = true;
        this.tcpNoDelay_ = bl;
    }

    public void unsetKeepAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting keep alive.");
        }
        this.keepAliveSet_ = false;
    }

    public void unsetReceiveBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting receive buffer size.");
        }
        this.receiveBufferSizeSet_ = false;
    }

    public void unsetSendBufferSize() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting send buffer size.");
        }
        this.sendBufferSizeSet_ = false;
    }

    public void unsetSoLinger() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting so linger.");
        }
        this.soLingerSet_ = false;
    }

    public void unsetSoTimeout() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting so timeout.");
        }
        this.soTimeoutSet_ = false;
    }

    public void unsetTcpNoDelay() {
        if (Trace.traceOn_) {
            Trace.log(1, "Unsetting TCP no delay.");
        }
        this.tcpNoDelaySet_ = false;
    }
}

