/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PoolInformationFormat;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SSTS0100Format;
import com.ibm.as400.access.SSTS0200Format;
import com.ibm.as400.access.SSTS0300Format;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatusFormat;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SystemStatus
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 as400_;
    private Vector poolsVector_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient boolean connected_;
    private transient boolean cacheChanges_;
    private SSTS0100Format format0100_;
    private SSTS0200Format format0200_;
    private SSTS0300Format format0300_;
    private Hashtable fieldToFormatMap_ = new Hashtable();
    private Hashtable formatToRecordMap_ = new Hashtable(3);

    private void mapFormat(SystemStatusFormat systemStatusFormat) {
        String[] stringArray = systemStatusFormat.getFieldNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fieldToFormatMap_.put(stringArray[i], systemStatusFormat);
        }
    }

    public SystemStatus() {
        this.initializeTransient();
    }

    public SystemStatus(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = aS400;
        this.initializeTransient();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void connect() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.as400_ == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (!this.connected_) {
            this.initializeFormats();
            this.refreshCache();
            this.connected_ = true;
        }
    }

    private Object get(String string) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (!this.connected_) {
            this.connect();
        }
        if (!this.cacheChanges_) {
            this.refreshCache();
        }
        SystemStatusFormat systemStatusFormat = (SystemStatusFormat)this.fieldToFormatMap_.get(string);
        this.loadInformation(systemStatusFormat);
        return ((Record)this.formatToRecordMap_.get(systemStatusFormat)).getField(string);
    }

    public int getBatchJobsEndedWithPrinterOutputWaitingToPrint() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsEndedWithPrinterOutputWaitingToPrint");
    }

    public int getBatchJobsEnding() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsEnding");
    }

    public int getBatchJobsHeldOnJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsHeldOnAJobQueue");
    }

    public int getBatchJobsHeldWhileRunning() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsHeldWhileRunning");
    }

    public int getBatchJobsOnUnassignedJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsOnAnUnassignedJobQueue");
    }

    public int getBatchJobsRunning() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsRunning");
    }

    public int getBatchJobsWaitingForMessage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsWaitingForMessages");
    }

    public int getBatchJobsWaitingToRunOrAlreadyScheduled() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("batchJobsWaitingToRunOrAlreadyScheduled");
    }

    public float getCurrentProcessingCapacity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (float)((Integer)this.get("currentProcessingCapacity")).intValue() / 100.0f;
    }

    public int getCurrentUnprotectedStorageUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("currentUnprotectedStorageUsed");
    }

    public Date getDateAndTimeStatusGathered() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        byte[] byArray = (byte[])this.get("currentDateAndTime");
        DateTimeConverter dateTimeConverter = new DateTimeConverter(this.as400_);
        return dateTimeConverter.convert(byArray, "*DTS");
    }

    public int getElapsedTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int n;
        int n2;
        int n3;
        String string = ((String)this.get("elapsedTime")).trim();
        try {
            n3 = Integer.parseInt(string.substring(0, 2));
            n2 = Integer.parseInt(string.substring(2, 4));
            n = Integer.parseInt(string.substring(4, 6));
        }
        catch (NumberFormatException numberFormatException) {
            Trace.log(2, "Error parsing system status elapsed time string: '" + string + "'", (Throwable)numberFormatException);
            throw numberFormatException;
        }
        return n + n2 * 60 + n3 * 3600;
    }

    public int getJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("jobsInSystem");
    }

    public int getMaximumUnprotectedStorageUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("maximumUnprotectedStorageUsed");
    }

    public int getNumberOfProcessors() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("numberOfProcessors");
    }

    public float getPercentCurrentInteractivePerformance() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("percentCurrentInteractivePerformance")).intValue();
    }

    public float getPercentDBCapability() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int n = (Integer)this.get("percentDBCapability");
        if (n == -1) {
            return n;
        }
        return (float)n / 10.0f;
    }

    public float getPercentPermanentAddresses() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (float)((Integer)this.get("percentPermanentAddresses")).intValue() / 1000.0f;
    }

    public float getPercentProcessingUnitUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (float)((Integer)this.get("percentProcessingUnitUsed")).intValue() / 10.0f;
    }

    public float getPercentSystemASPUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (float)((Integer)this.get("percentSystemASPUsed")).intValue() / 10000.0f;
    }

    public float getPercentTemporaryAddresses() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (float)((Integer)this.get("percentTemporaryAddresses")).intValue() / 1000.0f;
    }

    public int getPoolsNumber() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this.connect();
        this.loadInformation(this.format0300_);
        Record record = (Record)this.formatToRecordMap_.get(this.format0300_);
        return (Integer)record.getField("numberOfPools");
    }

    public int getProcessorSharingAttribute() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        String string = ((String)this.get("processorSharingAttribute")).trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.log(2, "Error parsing system status 'processor sharing attribute' string: '" + string + "'", (Throwable)numberFormatException);
            throw numberFormatException;
        }
    }

    public boolean getRestrictedStateFlag() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("restrictedStateFlag")).trim().equals("1");
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public int getSystemASP() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("systemASP");
    }

    public Enumeration getSystemPools() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (!this.cacheChanges_) {
            this.refreshCache();
        }
        if (this.poolsVector_ != null) {
            return this.poolsVector_.elements();
        }
        this.connect();
        this.loadInformation(this.format0300_);
        this.poolsVector_ = new Vector();
        Record record = (Record)this.formatToRecordMap_.get(this.format0300_);
        int n = (Integer)record.getField("offsetToPoolInformation");
        int n2 = (Integer)record.getField("numberOfPools");
        int n3 = (Integer)record.getField("lengthOfPoolInformationEntry");
        byte[] byArray = record.getContents();
        PoolInformationFormat poolInformationFormat = new PoolInformationFormat(this.as400_);
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i * n3;
            Record record2 = poolInformationFormat.getNewRecord(byArray, n4);
            SystemPool systemPool = new SystemPool(this.as400_, (String)record2.getField("poolName"));
            this.poolsVector_.addElement(systemPool);
        }
        return this.poolsVector_.elements();
    }

    public int getTotalAuxiliaryStorage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("totalAuxiliaryStorage");
    }

    public int getUsersCurrentSignedOn() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("usersCurrentlySignedOn");
    }

    public int getUsersSignedOffWithPrinterOutputWaitingToPrint() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("usersSignedOffWithPrinterOutputWaitingToPrint");
    }

    public int getUsersSuspendedBySystemRequest() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("usersSuspendedBySystemRequest");
    }

    public int getUsersTemporarilySignedOff() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("usersTemporarilySignedOff");
    }

    private void initializeFormats() {
        this.format0100_ = new SSTS0100Format(this.as400_);
        this.format0200_ = new SSTS0200Format(this.as400_);
        this.format0300_ = new SSTS0300Format(this.as400_);
        this.format0300_.addFieldDescription(new HexFieldDescription(new AS400ByteArray(1000), "poolInformation"));
        this.mapFormat(this.format0100_);
        this.mapFormat(this.format0200_);
    }

    private void initializeTransient() {
        this.connected_ = false;
        this.cacheChanges_ = false;
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
    }

    public boolean isCaching() {
        return this.cacheChanges_;
    }

    private void loadInformation(SystemStatusFormat systemStatusFormat) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if ((Record)this.formatToRecordMap_.get(systemStatusFormat) != null) {
            return;
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName("QSYS", "QWCRSSTS", "PGM");
        AS400Bin4 aS400Bin4 = new AS400Bin4();
        int n = this.as400_.getCcsid();
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        int n2 = systemStatusFormat.getNewRecord().getRecordLength();
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(aS400Bin4.toBytes(n2));
        AS400Text aS400Text = new AS400Text(8, n, this.as400_);
        programParameterArray[2] = new ProgramParameter(aS400Text.toBytes(systemStatusFormat.getName()));
        aS400Text = new AS400Text(10, n, this.as400_);
        programParameterArray[3] = new ProgramParameter(aS400Text.toBytes("*NO"));
        byte[] byArray = new byte[32];
        programParameterArray[4] = new ProgramParameter(byArray, 0);
        ProgramCall programCall = new ProgramCall(this.as400_);
        try {
            programCall.setProgram(qSYSObjectPathName.getPath(), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "Retrieving system status information.");
        }
        if (!programCall.run()) {
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Error retrieving system status information:");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    Trace.log(2, aS400MessageArray[i].toString());
                }
            }
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray2 = programParameterArray[0].getOutputData();
        Record record = systemStatusFormat.getNewRecord(byArray2);
        if (systemStatusFormat.getName().equals("SSTS0300") && this.resizeFormat(record)) {
            this.loadInformation(this.format0300_);
            return;
        }
        this.formatToRecordMap_.put(systemStatusFormat, systemStatusFormat.getNewRecord(byArray2));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshCache() {
        this.formatToRecordMap_.clear();
        this.poolsVector_ = null;
    }

    private boolean resizeFormat(Record record) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int n;
        int n2 = (Integer)record.getField("numberOfBytesAvailable");
        if (n2 > (n = ((Integer)record.getField("numberOfBytesReturned")).intValue())) {
            int n3 = (Integer)record.getField("numberOfPools");
            int n4 = (Integer)record.getField("offsetToPoolInformation");
            int n5 = (Integer)record.getField("lengthOfPoolInformationEntry");
            if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "Resizing SSTS0300 format to hold more system status pool information.");
                Trace.log(1, "  Old pool information: " + n3 + ", " + n4 + ", " + n5);
            }
            this.formatToRecordMap_.remove(this.format0300_);
            this.format0300_ = new SSTS0300Format(this.as400_);
            int n6 = this.format0300_.getNewRecord().getRecordLength();
            int n7 = n3 * n5 + (n4 - n6);
            this.format0300_.addFieldDescription(new HexFieldDescription(new AS400ByteArray(n7), "poolInformation"));
            return true;
        }
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setCaching(boolean bl) {
        this.cacheChanges_ = bl;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.vetos_.fireVetoableChange("system", this.as400_, aS400);
        AS400 aS4002 = this.as400_;
        this.as400_ = aS400;
        this.changes_.firePropertyChange("system", aS4002, this.as400_);
    }
}

