/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

class ToolboxLogger {
    private static final String copyright = "Copyright (C) 2005-2005 International Business Machines Corporation and others.";
    private static Logger logger_ = null;
    private static boolean JDK14_OR_LATER = false;

    private ToolboxLogger() {
    }

    final void config(String string) {
        logger_.config(string);
    }

    static final ToolboxLogger getLogger() {
        if (logger_ == null && JDK14_OR_LATER) {
            logger_ = LogManager.getLogManager().getLogger("com.ibm.as400.access");
        }
        if (logger_ != null) {
            return new ToolboxLogger();
        }
        return null;
    }

    final void info(String string) {
        logger_.info(string);
    }

    final boolean isLoggable(int n) {
        return logger_.isLoggable(ToolboxLogger.mapTracingLevel(n));
    }

    final boolean isLoggingOff() {
        return logger_.getLevel() == Level.OFF;
    }

    final void log(int n, String string) {
        logger_.log(ToolboxLogger.mapTracingLevel(n), string);
    }

    final void log(int n, String string, Throwable throwable) {
        logger_.log(ToolboxLogger.mapTracingLevel(n), string, throwable);
    }

    private static final Level mapTracingLevel() {
        Level level = Level.OFF;
        if (Trace.traceOn_) {
            if (Trace.traceError_) {
                level = Level.SEVERE;
            }
            if (Trace.traceWarning_) {
                level = Level.WARNING;
            }
            if (Trace.traceInfo_) {
                level = Level.INFO;
            }
            if (Trace.traceDiagnostic_) {
                level = Level.FINE;
            }
            if (Trace.traceJDBC_ || Trace.tracePCML_ || Trace.traceProxy_ || Trace.traceThread_) {
                level = Level.FINER;
            }
            if (Trace.traceConversion_ || Trace.traceDatastream_) {
                level = Level.FINEST;
            }
        } else {
            level = Level.OFF;
        }
        return level;
    }

    private static final Level mapTracingLevel(int n) {
        switch (n) {
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.WARNING;
            }
            case 2: {
                return Level.SEVERE;
            }
            case 1: {
                return Level.FINE;
            }
            case 6: 
            case 7: 
            case 8: {
                return Level.FINER;
            }
            case 0: 
            case 5: {
                return Level.FINEST;
            }
        }
        throw new ExtendedIllegalArgumentException("category (" + Integer.toString(n) + ")", 2);
    }

    final void setLevel() throws SecurityException {
        logger_.setLevel(ToolboxLogger.mapTracingLevel());
    }

    static {
        try {
            Class.forName("java.util.logging.LogManager");
            logger_ = LogManager.getLogManager().getLogger("com.ibm.as400.access");
            JDK14_OR_LATER = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

