/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ResourceMetaData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceMetaDataTable
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Hashtable metaDataByID_ = new Hashtable();
    private ResourceMetaData[] metaData_ = null;
    private transient PresentationLoader presentationLoader_ = null;
    private transient String presentationKey_ = null;

    public ResourceMetaDataTable() {
    }

    public ResourceMetaDataTable(PresentationLoader presentationLoader, String string) {
        this.presentationLoader_ = presentationLoader;
        this.presentationKey_ = string;
    }

    public ResourceMetaDataTable(ResourceMetaData[] resourceMetaDataArray) {
        this.metaData_ = resourceMetaDataArray == null ? new ResourceMetaData[0] : resourceMetaDataArray;
        for (int i = 0; i < this.metaData_.length; ++i) {
            this.metaDataByID_.put(this.metaData_[i].getID(), this.metaData_[i]);
        }
    }

    public ResourceMetaData add(Object object, Class clazz) {
        return this.add(object, clazz, false, null, null, false, false);
    }

    public ResourceMetaData add(Object object, Class clazz, boolean bl) {
        return this.add(object, clazz, bl, null, null, false, false);
    }

    public ResourceMetaData add(Object object, Class clazz, Object object2) {
        return this.add(object, clazz, false, null, object2, false, false);
    }

    public ResourceMetaData add(Object object, Class clazz, boolean bl, Object[] objectArray, Object object2, boolean bl2) {
        return this.add(object, clazz, bl, objectArray, object2, bl2, false);
    }

    public ResourceMetaData add(Object object, Class clazz, boolean bl, Object[] objectArray, Object object2, boolean bl2, boolean bl3) {
        return this.add(object, clazz, bl, objectArray, object2, bl2, bl3, null);
    }

    public ResourceMetaData add(Object object, Class clazz, boolean bl, Object[] objectArray, Object object2, boolean bl2, boolean bl3, String[] stringArray) {
        Presentation presentation = null;
        if (this.presentationLoader_ != null) {
            presentation = this.presentationLoader_.getPresentation(this.presentationKey_, object.toString());
        }
        Presentation[] presentationArray = null;
        if (objectArray != null) {
            presentationArray = new Presentation[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(object);
                stringBuffer.append('_');
                String string = null;
                string = stringArray == null ? (objectArray[i] instanceof byte[] ? Byte.toString(((byte[])objectArray[i])[0]) : objectArray[i].toString()) : stringArray[i];
                int n = string.length();
                for (int j = 0; j < n; ++j) {
                    char c = string.charAt(j);
                    if (c == ' ') {
                        stringBuffer.append('_');
                        continue;
                    }
                    if (c == '*') continue;
                    stringBuffer.append(c);
                }
                String string2 = stringBuffer.toString();
                if (n == 1 && string.charAt(0) == '*') {
                    string2 = "__";
                }
                presentationArray[i] = this.presentationLoader_.getPresentation(this.presentationKey_, stringBuffer.toString());
            }
        }
        this.metaData_ = null;
        ResourceMetaData resourceMetaData = new ResourceMetaData(object, clazz, bl, objectArray, object2, bl2, bl3, presentation, presentationArray);
        this.metaDataByID_.put(object, resourceMetaData);
        return resourceMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceMetaData[] getMetaData() {
        ResourceMetaDataTable resourceMetaDataTable = this;
        synchronized (resourceMetaDataTable) {
            Object[] objectArray;
            Vector<Object[]> vector = new Vector<Object[]>(this.metaDataByID_.size());
            boolean bl = false;
            Enumeration enumeration = this.metaDataByID_.elements();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                vector.addElement(objectArray);
            }
            objectArray = new ResourceMetaData[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceMetaData[] getMetaData(String string) {
        if (string == null) {
            throw new NullPointerException("level");
        }
        ResourceMetaDataTable resourceMetaDataTable = this;
        synchronized (resourceMetaDataTable) {
            Object[] objectArray;
            Vector<Object[]> vector = new Vector<Object[]>(this.metaDataByID_.size());
            boolean bl = false;
            Enumeration enumeration = this.metaDataByID_.elements();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                if (!objectArray.getLevel().checkLevel(string)) continue;
                vector.addElement(objectArray);
            }
            objectArray = new ResourceMetaData[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public ResourceMetaData getMetaData(Object object) {
        return this.validateID(object);
    }

    ResourceMetaData validateID(Object object) {
        if (object == null) {
            throw new NullPointerException("id(" + object.toString() + ")");
        }
        if (!this.metaDataByID_.containsKey(object)) {
            throw new ExtendedIllegalArgumentException("id(" + object.toString() + ")", 2);
        }
        return (ResourceMetaData)this.metaDataByID_.get(object);
    }

    void validateIDs(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("id(" + objectArray.toString() + ")");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.metaDataByID_.containsKey(objectArray[i])) continue;
            throw new ExtendedIllegalArgumentException("id[" + i + "](" + objectArray.toString() + ")", 2);
        }
    }
}

