/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Frame;
import com.ibm.as400.util.commtrace.Progress;
import com.ibm.as400.util.commtrace.Prolog;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;

public class Format {
    private final String ALL = "*ALL";
    private final String NO = "*NO";
    private final String CLASS = "Format";
    private AS400 sys;
    private boolean createdSys;
    private InputStream file;
    private Progress progress;
    private byte[] data;
    private Prolog pro_;
    private String filename;
    private String outfile;
    private String fmtBroadcast;
    private BitBuf nxtRecLen;
    private int ifsrecs;
    private int tcprecs;
    private int numrecs;
    private FormatProperties filter_;
    private ObjectInputStream serin;

    public Format() {
        this.ALL = "*ALL";
        this.NO = "*NO";
        this.CLASS = "Format";
        this.sys = null;
        this.createdSys = false;
        this.file = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfile = null;
        this.fmtBroadcast = "Y";
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
    }

    public Format(AS400 aS400) {
        this.ALL = "*ALL";
        this.NO = "*NO";
        this.CLASS = "Format";
        this.sys = null;
        this.createdSys = false;
        this.file = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfile = null;
        this.fmtBroadcast = "Y";
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.sys = aS400;
    }

    public Format(FormatProperties formatProperties, String string, String string2) {
        this.ALL = "*ALL";
        this.NO = "*NO";
        this.CLASS = "Format";
        this.sys = null;
        this.createdSys = false;
        this.file = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfile = null;
        this.fmtBroadcast = "Y";
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.filter_ = formatProperties;
        this.outfile = string;
        this.filename = string2;
        if (string2 == null) {
            this.close();
            return;
        }
        try {
            this.file = new BufferedInputStream(new FileInputStream(string2));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format()Error opening:" + string2, (Throwable)iOException);
            }
            this.close();
            return;
        }
        this.formatProlog();
    }

    public Format(String[] stringArray) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        CommandLineArguments commandLineArguments;
        block43: {
            String string6;
            this.ALL = "*ALL";
            this.NO = "*NO";
            this.CLASS = "Format";
            this.sys = null;
            this.createdSys = false;
            this.file = null;
            this.progress = null;
            this.data = null;
            this.pro_ = null;
            this.filename = null;
            this.outfile = null;
            this.fmtBroadcast = "Y";
            this.ifsrecs = 0;
            this.tcprecs = 0;
            this.numrecs = 0;
            Vector<String> vector = new Vector<String>();
            vector.addElement("-userID");
            vector.addElement("-password");
            vector.addElement("-trace");
            vector.addElement("-filename");
            vector.addElement("-outfile");
            vector.addElement("-current");
            vector.addElement("-verbose");
            vector.addElement("-logfile");
            vector.addElement("-country");
            vector.addElement("-language");
            vector.addElement("-ipaddress");
            vector.addElement("-ipaddress2");
            vector.addElement("-port");
            vector.addElement("-broadcast");
            vector.addElement("-starttime");
            vector.addElement("-endtime");
            vector.addElement("-starttimelong");
            vector.addElement("-endtimelong");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("-u", "-userID");
            hashtable.put("-p", "-password");
            hashtable.put("-t", "-trace");
            hashtable.put("-o", "-outfile");
            hashtable.put("-c", "-current");
            hashtable.put("-v", "-verbose");
            hashtable.put("-l", "-language");
            hashtable.put("-co", "-country");
            hashtable.put("-ip", "-ipaddress");
            hashtable.put("-ip2", "-ipaddress2");
            commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
            string5 = commandLineArguments.getOptionValue("");
            string4 = commandLineArguments.getOptionValue("-userID");
            string3 = commandLineArguments.getOptionValue("-password");
            string2 = commandLineArguments.getOptionValue("-current");
            this.filename = string = commandLineArguments.getOptionValue("-trace");
            this.outfile = string6 = commandLineArguments.getOptionValue("-outfile");
            String string7 = commandLineArguments.getOptionValue("-verbose");
            String string8 = commandLineArguments.getOptionValue("-logfile");
            String string9 = commandLineArguments.getOptionValue("-language");
            String string10 = commandLineArguments.getOptionValue("-country");
            if (string7 != null && string7.equals("true")) {
                Trace.setTraceErrorOn(true);
                Trace.setTraceWarningOn(true);
                Trace.setTraceInformationOn(true);
                Trace.setTraceOn(true);
            }
            if (string8 != null) {
                try {
                    Trace.setFileName(string8);
                }
                catch (IOException iOException) {
                    if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block43;
                    Trace.log(2, "Format.FormatCan't set trace file name, defaulting to outputing trace data to standard out");
                }
            }
        }
        this.filter_ = new FormatProperties();
        String string11 = commandLineArguments.getOptionValue("-ipaddress");
        String string12 = commandLineArguments.getOptionValue("-ipaddress2");
        String string13 = commandLineArguments.getOptionValue("-port");
        String string14 = commandLineArguments.getOptionValue("-broadcast");
        String string15 = commandLineArguments.getOptionValue("-starttime");
        String string16 = commandLineArguments.getOptionValue("-endtime");
        String string17 = commandLineArguments.getOptionValue("-starttimelong");
        String string18 = commandLineArguments.getOptionValue("-endtimelong");
        boolean bl = false;
        if (string11 != null && !string11.equals("*ALL")) {
            this.filter_.setIPAddress(string11);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() IP Filtering enabled");
            }
        }
        if (string12 != null && !string12.equals("*ALL")) {
            this.filter_.setSecondIPAddress(string12);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() IP Filtering enabled");
            }
        }
        if (string14 != null && !string14.equals("*ALL")) {
            this.filter_.setBroadcast(string14);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Broadcast Filtering enabled");
            }
        }
        if (string13 != null && !string13.equals("*ALL")) {
            this.filter_.setPort(string13);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Port Filtering enabled");
            }
        }
        if (string15 != null && !string15.equals("*ALL")) {
            this.filter_.setStartTime(string15);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Beginning Timestamp Filtering enabled");
            }
            bl = true;
        }
        if (string16 != null && !string16.equals("*ALL")) {
            this.filter_.setEndTime(string16);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() End Timestamp Filtering enabled");
            }
        }
        if (string17 != null && !string17.equals("*ALL")) {
            if (string16 != null) {
                Object var24_25 = null;
                this.filter_.setEndTime(null);
            }
            this.filter_.setStartTime(string17);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Beginning Timestamp Filtering enabled");
            }
        }
        if (string18 != null && !string18.equals("*ALL")) {
            this.filter_.setEndTime(string18);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() End Timestamp Filtering enabled");
            }
        }
        if (string == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Outfile not specified");
            }
            return;
        }
        if (string2 != null) {
            this.sys = new AS400();
            this.createdSys = true;
            try {
                this.file = new IFSFileInputStream(this.sys, string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
                }
                return;
            }
            catch (IOException iOException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() Error opening " + string, (Throwable)iOException);
                }
                return;
            }
            catch (AS400SecurityException aS400SecurityException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() Security exception opening file", (Throwable)aS400SecurityException);
                }
                return;
            }
        }
        if (string5 == null || string4 == null || string3 == null) {
            try {
                this.file = new BufferedInputStream(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
                }
                return;
            }
        }
        this.sys = new AS400(string5, string4, string3);
        this.createdSys = true;
        try {
            this.file = new IFSFileInputStream(this.sys, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
            }
            return;
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Error opening" + string, (Throwable)iOException);
            }
            return;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Security exception opening file", (Throwable)aS400SecurityException);
            }
            return;
        }
        if (!this.formatProlog() && bl) {
            this.setUpFilters();
        }
    }

    public Format(String string) {
        this.ALL = "*ALL";
        this.NO = "*NO";
        this.CLASS = "Format";
        this.sys = null;
        this.createdSys = false;
        this.file = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfile = null;
        this.fmtBroadcast = "Y";
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.filename = string;
        if (string == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File not specified");
            }
            return;
        }
        try {
            this.file = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
            }
            return;
        }
    }

    public Format(IFSFileInputStream iFSFileInputStream) {
        this.ALL = "*ALL";
        this.NO = "*NO";
        this.CLASS = "Format";
        this.sys = null;
        this.createdSys = false;
        this.file = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfile = null;
        this.fmtBroadcast = "Y";
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.file = iFSFileInputStream;
        this.formatProlog();
    }

    private void setUpFilters() {
        block7: {
            if (this.filter_ == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.setUpFilters() Filters are not initialized");
                }
                return;
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyyyykkmmssSSS");
                String string = this.filter_.getStartTime();
                String string2 = this.filter_.getEndTime();
                if (string != null || string2 != null) {
                    if (string2 == null) {
                        this.filter_.setStartTime(Long.toString(simpleDateFormat.parse(string).getTime()));
                    } else {
                        this.filter_.setStartTime(Long.toString(simpleDateFormat.parse(string).getTime()));
                        this.filter_.setEndTime(Long.toString(simpleDateFormat.parse(string2).getTime()));
                    }
                }
            }
            catch (ParseException parseException) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block7;
                Trace.log(2, "Format.setUpFilters() Invalid Time argument", (Throwable)parseException);
            }
        }
    }

    public void setFilterProperties(FormatProperties formatProperties) {
        this.filter_ = formatProperties;
    }

    public void setOutFile(String string) {
        this.outfile = string;
    }

    public void setInFileStream(InputStream inputStream) {
        this.file = inputStream;
    }

    public void setSystem(AS400 aS400) {
        this.sys = aS400;
    }

    public int toIFSTxtFile() {
        IFSTextFileOutputStream iFSTextFileOutputStream;
        if (this.sys == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSTxtFile() Error the system wasn't specified");
            }
            return 1;
        }
        if (this.outfile == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSTxtFile() Error the out file wasn't specified");
            }
            return 1;
        }
        try {
            iFSTextFileOutputStream = new IFSTextFileOutputStream(this.sys, this.outfile);
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSTxtFile() Error opening " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSTxtFile() Security exception opening file", (Throwable)aS400SecurityException);
            }
            return 1;
        }
        int n = 0;
        try {
            Frame frame;
            iFSTextFileOutputStream.write(this.pro_.toString());
            while ((frame = this.getNextRecord()) != null) {
                if (n % 5 == 0) {
                    iFSTextFileOutputStream.write(this.addBanner());
                }
                iFSTextFileOutputStream.write(frame.toString());
                ++n;
            }
            iFSTextFileOutputStream.write(this.addEndBanner());
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSTxtFile() Error writing to " + this.filename, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    public int toLclTxtFile() {
        BufferedWriter bufferedWriter;
        if (this.outfile == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error the out file wasn't specified");
            }
            return 1;
        }
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.outfile));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error opening " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        int n = 0;
        try {
            Frame frame;
            bufferedWriter.write(this.pro_.toString());
            while ((frame = this.getNextRecord()) != null) {
                if (n % 5 == 0) {
                    bufferedWriter.write(this.addBanner());
                }
                bufferedWriter.write(frame.toString());
                ++n;
            }
            bufferedWriter.write(this.addEndBanner());
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error writing to " + this.filename, (Throwable)iOException);
            }
            return 1;
        }
        try {
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error closing " + this.filename, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    public int toIFSBinFile() {
        ObjectOutputStream objectOutputStream;
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error the prolog wasn't formatted");
            }
            return 1;
        }
        if (this.pro_.invalidData()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Not a valid iSeries CommTrace");
            }
            return 1;
        }
        try {
            objectOutputStream = new ObjectOutputStream(new IFSFileOutputStream(this.sys, this.outfile));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error opening " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Security exception opening file " + this.outfile, (Throwable)aS400SecurityException);
            }
            return 1;
        }
        try {
            Frame frame;
            objectOutputStream.writeUTF(this.pro_.toString());
            objectOutputStream.writeInt(this.ifsrecs);
            while ((frame = this.getNextRecord()) != null) {
                String string = frame.toString(this.filter_);
                if (string == "") continue;
                objectOutputStream.writeUTF(string);
            }
            objectOutputStream.writeUTF(this.addEndBanner());
        }
        catch (NotSerializableException notSerializableException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error object not serializable " + this.outfile, (Throwable)notSerializableException);
            }
            return 1;
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error writing file " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        try {
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    public int toLclBinFile() {
        ObjectOutputStream objectOutputStream;
        Object object;
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error the prolog wasn't formatted");
            }
            return 1;
        }
        if (this.pro_.invalidData()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Not a valid iSeries CommTrace");
            }
            return 1;
        }
        String string = this.filter_.getProgress();
        if (string != null && string.equals("True")) {
            this.progress = new Progress("Formating " + this.filename, this.ifsrecs, " records");
            object = new Thread((Runnable)this.progress, "ProgDiag");
            this.progress.setThread((Thread)object);
            ((Thread)object).start();
        }
        if (this.outfile == null) {
            // empty if block
        }
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.outfile));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error opening " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        try {
            objectOutputStream.writeUTF(this.pro_.toString());
            objectOutputStream.writeInt(this.ifsrecs);
            if (this.progress == null) {
                Frame frame;
                while ((frame = this.getNextRecord()) != null) {
                    object = frame.toString(this.filter_);
                    if (object == "") continue;
                    objectOutputStream.writeUTF((String)object);
                }
            } else {
                Frame frame;
                while ((frame = this.getNextRecord()) != null && !this.progress.isCanceled()) {
                    object = frame.toString(this.filter_);
                    if (object == "") continue;
                    objectOutputStream.writeUTF((String)object);
                }
            }
            objectOutputStream.writeUTF(this.addEndBanner());
        }
        catch (NotSerializableException notSerializableException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error object not serializable " + this.outfile, (Throwable)notSerializableException);
            }
            return 1;
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error writing file " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        try {
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    private int toBinFile(ObjectOutputStream objectOutputStream) {
        try {
            Frame frame;
            objectOutputStream.writeUTF(this.pro_.toString());
            objectOutputStream.writeInt(this.ifsrecs);
            while ((frame = this.getNextRecord()) != null) {
                objectOutputStream.writeUTF(frame.toString());
            }
            objectOutputStream.writeUTF(this.addEndBanner());
        }
        catch (NotSerializableException notSerializableException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toBinFile() Error object not serializable " + this.outfile, (Throwable)notSerializableException);
            }
            return 1;
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toBinFile() Error writing file " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        try {
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toBinFile() Error closing file " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    public int openIFSFile() {
        return this.openIFSFile(this.outfile);
    }

    public int openIFSFile(String string) {
        this.outfile = string;
        if (string == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Outfile not specified");
            }
            return 1;
        }
        try {
            this.serin = new ObjectInputStream(new IFSFileInputStream(this.sys, string));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Error opening " + string, (Throwable)iOException);
            }
            return 1;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Security exception opening file " + string, (Throwable)aS400SecurityException);
            }
            return 1;
        }
        return 0;
    }

    public int openLclFile() {
        return this.openLclFile(this.outfile);
    }

    public int openLclFile(String string) {
        this.outfile = string;
        if (string == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openLclFile() Outfile not specified");
            }
            return 1;
        }
        try {
            this.serin = new ObjectInputStream(new FileInputStream(string));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openLclFile() Error opening " + string, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    public int close() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Format.close()");
        }
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.close() Error closing " + this.filename, (Throwable)iOException);
            }
            return 1;
        }
        try {
            if (this.serin != null) {
                this.serin.close();
            }
            if (this.sys != null && this.createdSys) {
                this.sys.disconnectAllServices();
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.close() Error closing " + this.outfile, (Throwable)iOException);
            }
            return 1;
        }
        if (this.progress != null) {
            this.progress.setThread(null);
        }
        return 0;
    }

    public String getRecFromFile() {
        String string = null;
        try {
            string = this.serin.readUTF();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getRecFromFile() Error reading file", (Throwable)iOException);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getRecFromFile() Error file not opened ", (Throwable)nullPointerException);
            }
            return null;
        }
        return string;
    }

    public int getIntFromFile() {
        int n = 0;
        try {
            n = this.serin.readInt();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getIntFromFile() Error reading file", (Throwable)iOException);
            }
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getIntFromFile() Error file not opened", (Throwable)nullPointerException);
            }
            return -1;
        }
        return n;
    }

    public boolean formatProlog() {
        if (this.file == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.formatProlog() Input file not opened");
            }
            return false;
        }
        this.read(0, 258);
        BitBuf bitBuf = new BitBuf(this.data);
        this.nxtRecLen = new BitBuf(bitBuf, 2048, 16);
        this.pro_ = new Prolog(bitBuf, this.filter_);
        this.ifsrecs = this.pro_.getNumRecs();
        return this.pro_.invalidData();
    }

    public Frame getNextRecord() {
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getNextRecord() Prolog not formatted.");
            }
            return null;
        }
        if (!this.pro_.invalidData()) {
            Frame frame = this.getNext();
            while (frame != null) {
                if (!frame.isTCP()) {
                    frame = this.getNext();
                    continue;
                }
                ++this.tcprecs;
                return frame;
            }
            return frame;
        }
        return null;
    }

    private Frame getNext() {
        int n = 0;
        if (this.progress != null) {
            this.progress.updateProgress(this.numrecs);
        }
        if (this.numrecs < this.ifsrecs) {
            BitBuf bitBuf;
            ++this.numrecs;
            if (this.numrecs == this.ifsrecs) {
                this.read(0, this.nxtRecLen.toInt());
                bitBuf = new BitBuf(this.data);
                n = (this.nxtRecLen.toInt() - 2) * 8;
            } else {
                this.read(0, this.nxtRecLen.toInt());
                bitBuf = new BitBuf(this.data);
                n = this.nxtRecLen.toInt() * 8 - 16;
                this.nxtRecLen = new BitBuf(bitBuf, n, 16);
            }
            return new Frame(this.pro_, bitBuf.slice(0, n));
        }
        return null;
    }

    private void read(int n, int n2) {
        block2: {
            this.data = new byte[n + n2];
            try {
                this.file.read(this.data, n, n2);
            }
            catch (IOException iOException) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block2;
                Trace.log(2, "Format.read() Error reading file", (Throwable)iOException);
            }
        }
    }

    public String addBanner() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ResourceBundleLoader_ct.getText("Record");
        String string2 = ResourceBundleLoader_ct.getText("MACAddress");
        stringBuffer.append(this.pro_.getTitle());
        stringBuffer.append(this.pro_.getDate());
        stringBuffer.append(string);
        stringBuffer.append("       ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Data"));
        stringBuffer.append("      ");
        stringBuffer.append(string);
        stringBuffer.append("                     ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Destination"));
        stringBuffer.append("     ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Source"));
        stringBuffer.append("           ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Frame"));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Number"));
        stringBuffer.append("  ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("S/R"));
        stringBuffer.append("  ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Length"));
        stringBuffer.append("    ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Timer"));
        stringBuffer.append("                      ");
        stringBuffer.append(string2);
        stringBuffer.append("     ");
        stringBuffer.append(string2);
        stringBuffer.append("      ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Format"));
        stringBuffer.append("\n");
        stringBuffer.append("------  ---  ------    ------------               --------------  --------------   ------");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String addEndBanner() {
        return "\n* * * * * * * * * * * * *    " + ResourceBundleLoader_ct.getText("EOCP") + "    * * * * * * * * * * * * *\n";
    }

    public int getRecsProcessed() {
        return this.numrecs;
    }

    public Prolog getProlog() {
        return this.pro_;
    }

    public int getNumberOfTCPRecords() {
        return this.tcprecs;
    }

    public static void main(String[] stringArray) {
        Format format = new Format(stringArray);
        format.toIFSBinFile();
    }
}

