/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemValue;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemValue;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class VSystemValueDetailsPropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VSystemValue object_;
    private SystemValue systemValue_;
    private ChangeEventSupport changeEventSupport_;
    private ErrorEventSupport errorEventSupport_;
    private VObjectEventSupport objectEventSupport_;
    private WorkingEventSupport workingEventSupport_;
    private static final String valueDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION") + ": ";
    private static final String valueInformation_ = ResourceLoader.getText("COLUMN_VALUE") + ": ";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static DateFormat timeFormat_ = DateFormat.getTimeInstance();

    public VSystemValueDetailsPropertiesPane(VSystemValue vSystemValue, SystemValue systemValue) {
        if (systemValue != null) {
            this.systemValue_ = systemValue;
        }
        this.changeEventSupport_ = new ChangeEventSupport(this);
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.object_ = vSystemValue;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void applyChanges() throws Exception {
    }

    private Component getArrayTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(valueDescription_, this.object_.getDescription(), jPanel, gridBagLayout, n++);
        try {
            Object[] objectArray = (Object[])this.systemValue_.getValue();
            int n2 = objectArray.length;
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = (String)objectArray[i];
            }
            VUtilities.constrain(new JLabel(valueInformation_), new JList<String>(stringArray), jPanel, gridBagLayout, n++);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return jPanel;
    }

    public Component getComponent() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        switch (this.systemValue_.getType()) {
            case 1: 
            case 2: 
            case 3: {
                jTabbedPane.addTab(generalTabText_, this.getDisplayTab());
                break;
            }
            case 4: {
                jTabbedPane.addTab(generalTabText_, this.getArrayTab());
                break;
            }
            case 5: {
                jTabbedPane.addTab(generalTabText_, this.getDateTab());
            }
        }
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    private Component getDateTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        DateFormat dateFormat = null;
        if (this.systemValue_.getName().equals("QDATE")) {
            dateFormat = dateFormat_;
        } else if (this.systemValue_.getName().equals("QTIME")) {
            dateFormat = timeFormat_;
        }
        int n = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(valueDescription_, this.object_.getDescription(), jPanel, gridBagLayout, n++);
        try {
            VUtilities.constrain(valueInformation_, dateFormat.format(this.systemValue_.getValue()), jPanel, gridBagLayout, n++);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return jPanel;
    }

    private Component getDisplayTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(valueDescription_, this.object_.getDescription(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(valueInformation_, this.object_.getValue().toString(), jPanel, gridBagLayout, n++);
        return jPanel;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
        timeFormat_.setTimeZone(TimeZone.getDefault());
    }
}

