/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class AS400JDBCResultSet
implements ResultSet {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final int HOLDABILITY_NOT_SPECIFIED = -9999;
    static final int HOLD_CURSORS_OVER_COMMIT = 1;
    static final int CLOSE_CURSORS_AT_COMMIT = 2;
    private String catalog_;
    private boolean closed_;
    private int columnCount_;
    private int concurrency_;
    private Connection connection_;
    private String correlationName_;
    private String cursorName_;
    private boolean dataTruncation_;
    private PreparedStatement deleteStatement_;
    private int fetchDirection_;
    private int fetchSize_;
    private Object internalLock_;
    private int maxRows_;
    private InputStream openInputStream_;
    private Reader openReader_;
    private JDRow row_;
    private JDRowCache rowCache_;
    private String selectTable_;
    private SQLWarning sqlWarning_;
    private AS400JDBCStatement statement_;
    private int type_;
    private boolean[] updateNulls_;
    private JDRow updateRow_;
    private boolean[] updateSet_;
    private boolean wasNull_;
    private boolean wasDataMappingError_;
    private static final int NOT_KNOWN = -9999;
    private int positionFromFirst_ = 0;
    private int positionFromLast_ = -1;
    private boolean positionInsert_ = false;
    private boolean positionValid_ = false;
    private int totalRows_ = -9999;
    private int highestKnownRow_ = -9999;

    AS400JDBCResultSet(AS400JDBCStatement aS400JDBCStatement, JDSQLStatement jDSQLStatement, JDRowCache jDRowCache, String string, String string2, int n, int n2, int n3, int n4, int n5) throws SQLException {
        this.catalog_ = string;
        this.closed_ = false;
        this.concurrency_ = n3;
        this.connection_ = aS400JDBCStatement != null ? aS400JDBCStatement.getConnection() : null;
        this.cursorName_ = string2;
        this.deleteStatement_ = null;
        this.fetchDirection_ = n4;
        this.fetchSize_ = n5;
        this.internalLock_ = aS400JDBCStatement != null ? aS400JDBCStatement.internalLock_ : new Object();
        this.maxRows_ = n;
        this.openInputStream_ = null;
        this.openReader_ = null;
        this.row_ = jDRowCache.getRow();
        this.rowCache_ = jDRowCache;
        this.sqlWarning_ = null;
        this.statement_ = aS400JDBCStatement;
        this.type_ = n2;
        this.wasNull_ = false;
        this.wasDataMappingError_ = false;
        this.columnCount_ = this.row_.getFieldCount();
        this.rowCache_.open();
        if (this.connection_ == null || jDSQLStatement == null || ((AS400JDBCConnection)this.connection_).getMustSpecifyForUpdate() && !jDSQLStatement.isForUpdate()) {
            this.selectTable_ = null;
            this.correlationName_ = null;
            this.concurrency_ = 1007;
        } else {
            this.selectTable_ = jDSQLStatement.getSelectTable();
            this.correlationName_ = jDSQLStatement.getCorrelationName();
        }
        if (this.concurrency_ == 1008) {
            this.updateRow_ = new JDSimpleRow(this.row_, true);
            this.updateSet_ = new boolean[this.columnCount_];
            this.updateNulls_ = new boolean[this.columnCount_];
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
                this.updateNulls_[i] = true;
            }
        }
        this.dataTruncation_ = this.connection_ != null ? ((AS400JDBCConnection)this.connection_).getProperties().getBoolean(33) : false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, this.statement_);
            JDTrace.logProperty((Object)this, "Conncurrency", this.concurrency_);
            JDTrace.logProperty((Object)this, "Fetch direction", this.fetchDirection_);
            JDTrace.logProperty((Object)this, "Fetch size", this.fetchSize_);
            JDTrace.logProperty((Object)this, "Max rows", this.maxRows_);
            JDTrace.logProperty((Object)this, "Type", this.type_);
        }
    }

    AS400JDBCResultSet(JDRowCache jDRowCache, String string, String string2) throws SQLException {
        this(null, null, jDRowCache, string, string2, 0, 1004, 1007, 1000, 0);
    }

    void checkOpen() throws SQLException {
        if (this.closed_) {
            JDError.throwSQLException("24000");
        }
    }

    private void clearCurrentRow() throws SQLException {
        this.clearCurrentValue();
        this.clearWarnings();
        if (this.concurrency_ == 1008) {
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateNulls_[i] = true;
                this.updateSet_[i] = false;
            }
        }
    }

    private void clearCurrentValue() {
        if (this.openInputStream_ != null) {
            try {
                this.openInputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openInputStream_ = null;
        }
        if (this.openReader_ != null) {
            try {
                this.openReader_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openReader_ = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.rowCache_.close();
            this.closed_ = true;
            if (this.statement_ != null) {
                this.statement_.notifyClose();
            }
            if (this.deleteStatement_ != null) {
                this.deleteStatement_.close();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logClose(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed_) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.row_.findField(string != null ? string : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.concurrency_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.cursorName_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.fetchDirection_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.fetchSize_;
        }
    }

    JDRowCache getRowCache() {
        return this.rowCache_;
    }

    public Statement getStatement() throws SQLException {
        return this.statement_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.type_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            try {
                String string = this.getString(n);
                if (string == null) {
                    return null;
                }
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                JDError.throwSQLException("HY105", malformedURLException);
                return null;
            }
        }
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    boolean isClosed() {
        return this.closed_;
    }

    void postWarning(SQLWarning sQLWarning) {
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sQLWarning;
        } else {
            this.sqlWarning_.setNextWarning(sQLWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (n != 1000 && n != 1001 && n != 1002 || this.type_ == 1003 && n != 1000) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchDirection_ = n;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Fetch direction", this.fetchDirection_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (n < 0 || n > this.maxRows_ && this.maxRows_ > 0) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchSize_ = n;
            if (this.rowCache_ instanceof JDServerRowCache) {
                ((JDServerRowCache)this.rowCache_).setFetchSize(this.fetchSize_);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "Fetch size", this.fetchSize_);
            }
        }
    }

    public String toString() {
        return this.cursorName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            int n2;
            if (n == 0) {
                this.beforeFirst();
                return false;
            }
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                if (n > 0) {
                    if (n > this.maxRows_) {
                        this.afterLast();
                        return false;
                    }
                } else {
                    if (this.totalRows_ == -9999) {
                        this.findLastRow();
                    }
                    if ((n2 = this.totalRows_ + n) < 0) {
                        this.beforeFirst();
                        return false;
                    }
                    n = n2 + 1;
                }
            }
            this.rowCache_.absolute(n);
            this.positionValid_ = this.rowCache_.isValid();
            if (n > 0) {
                this.positionFromFirst_ = this.positionValid_ ? n : -1;
                int n3 = this.positionFromLast_ = this.positionValid_ ? -1 : 0;
                if (this.positionValid_) {
                    if (this.highestKnownRow_ < n) {
                        this.highestKnownRow_ = n;
                    }
                    if (this.totalRows_ != -9999) {
                        this.positionFromLast_ = this.totalRows_ - n + 1;
                    }
                }
            } else {
                this.positionFromFirst_ = this.positionValid_ ? -1 : 0;
                int n4 = this.positionFromLast_ = this.positionValid_ ? -n : -1;
                if (this.positionValid_ && this.totalRows_ != -9999) {
                    n2 = this.totalRows_ + n;
                    if (this.highestKnownRow_ < n2) {
                        this.highestKnownRow_ = n2;
                    }
                    this.positionFromFirst_ = n2 + 1;
                }
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.last();
            this.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.first();
            this.previous();
        }
    }

    private void beforePositioning(boolean bl) throws SQLException {
        this.checkOpen();
        if (bl && this.type_ == 1003) {
            JDError.throwSQLException("24000");
        }
        this.clearCurrentRow();
        this.positionInsert_ = false;
    }

    private void findLastRow() throws SQLException {
        this.checkOpen();
        if (this.totalRows_ != -9999) {
            return;
        }
        if (this.highestKnownRow_ > 0) {
            if (this.highestKnownRow_ >= this.maxRows_) {
                this.highestKnownRow_ = this.maxRows_;
            } else {
                this.rowCache_.absolute(this.highestKnownRow_);
                this.rowCache_.next();
                while (this.rowCache_.isValid()) {
                    ++this.highestKnownRow_;
                    if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                        this.rowCache_.next();
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.rowCache_.first();
            if (!this.rowCache_.isValid()) {
                return;
            }
            this.highestKnownRow_ = 0;
            while (this.rowCache_.isValid()) {
                ++this.highestKnownRow_;
                if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                    this.rowCache_.next();
                    continue;
                }
                break;
            }
        }
        this.totalRows_ = this.highestKnownRow_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(true);
            this.rowCache_.first();
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = 1;
                this.positionFromLast_ = this.totalRows_ == -9999 ? -1 : this.totalRows_;
                this.positionValid_ = true;
                if (this.highestKnownRow_ < 1) {
                    this.highestKnownRow_ = 1;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.positionInsert_ || !this.positionValid_ || this.isBeforeFirst() || this.isAfterLast()) {
                return 0;
            }
            if (this.positionFromFirst_ > 0) {
                return this.positionFromFirst_;
            }
            if (this.isLast()) {
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                    return this.positionFromFirst_;
                }
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.previous();
                return this.positionFromFirst_;
            }
            if (this.positionFromLast_ > 0) {
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_ - this.positionFromLast_ + 1;
                    return this.positionFromFirst_;
                }
                int n = this.positionFromLast_;
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.absolute(this.totalRows_ - n + 1);
                return this.positionFromFirst_;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Could not determine row number in getRow().");
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.positionFromLast_ == 0 && this.positionFromFirst_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.positionFromFirst_ == 0 && this.positionFromLast_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.positionFromFirst_ == 1 && !this.positionInsert_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.positionInsert_ || this.positionFromLast_ > 1 || !this.positionValid_) {
                return false;
            }
            if (this.positionFromLast_ == 1 || this.positionFromFirst_ == this.maxRows_ && this.maxRows_ > 0) {
                return true;
            }
            boolean bl = !this.next();
            this.previous();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                this.findLastRow();
                if (this.totalRows_ >= this.maxRows_) {
                    this.rowCache_.absolute(this.maxRows_);
                } else {
                    this.rowCache_.last();
                }
            } else {
                this.rowCache_.last();
            }
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 1;
                this.positionValid_ = true;
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(true);
            this.beforeUpdate();
            this.positionInsert_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(false);
            if (this.maxRows_ > 0 && this.positionFromFirst_ >= this.maxRows_) {
                this.rowCache_.absolute(this.maxRows_ + 1);
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 0;
                this.positionValid_ = false;
                this.totalRows_ = this.maxRows_;
                this.highestKnownRow_ = this.maxRows_;
                return false;
            }
            this.rowCache_.next();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    ++this.positionFromFirst_;
                }
                if (this.positionFromLast_ > 0) {
                    --this.positionFromLast_;
                }
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
                this.positionValid_ = true;
            } else {
                if (!this.rowCache_.isEmpty()) {
                    if (this.positionFromLast_ != 0 && this.positionFromFirst_ >= 0) {
                        this.totalRows_ = this.positionFromFirst_++;
                    }
                    this.positionFromLast_ = 0;
                } else if (this.highestKnownRow_ > 0) {
                    this.positionFromFirst_ = this.totalRows_ = this.highestKnownRow_;
                    this.positionFromLast_ = 0;
                }
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(true);
            this.rowCache_.previous();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ > 0) {
                    --this.positionFromFirst_;
                }
                if (this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionValid_ = true;
            } else {
                if (this.positionFromFirst_ != 0 && this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionFromFirst_ = 0;
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            this.beforePositioning(true);
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.concurrency_ == 1008) {
                for (int i = 0; i < this.columnCount_; ++i) {
                    this.updateSet_[i] = false;
                }
            }
            this.rowCache_.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforePositioning(true);
            if (this.positionFromFirst_ == 0 || this.positionFromLast_ == 0) {
                return false;
            }
            if (this.maxRows_ > 0 && this.positionFromFirst_ == -1) {
                this.getRow();
            }
            if (this.positionFromFirst_ >= 0 && this.positionFromFirst_ + n > this.maxRows_ && this.maxRows_ > 0) {
                this.afterLast();
                return false;
            }
            this.rowCache_.relative(n);
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    this.positionFromFirst_ += n;
                }
                if (this.positionFromLast_ >= 0) {
                    this.positionFromLast_ -= n;
                }
                this.positionValid_ = true;
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
            } else {
                if (n >= 0) {
                    this.positionFromFirst_ = -1;
                    this.positionFromLast_ = 0;
                } else {
                    this.positionFromFirst_ = 0;
                    this.positionFromLast_ = -1;
                }
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    public Array getArray(int n) throws SQLException {
        JDError.throwSQLException("07006");
        return null;
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            InputStream inputStream;
            SQLData sQLData = this.getValue(n);
            this.openInputStream_ = inputStream = sQLData == null ? null : sQLData.getAsciiStream();
            this.testDataTruncation(n, sQLData);
            return inputStream;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            BigDecimal bigDecimal = sQLData == null ? null : sQLData.getBigDecimal(-1);
            this.testDataTruncation(n, sQLData);
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY094");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            BigDecimal bigDecimal = sQLData == null ? null : sQLData.getBigDecimal(n2);
            this.testDataTruncation(n, sQLData);
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            InputStream inputStream;
            SQLData sQLData = this.getValue(n);
            this.openInputStream_ = inputStream = sQLData == null ? null : sQLData.getBinaryStream();
            this.testDataTruncation(n, sQLData);
            return inputStream;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            Blob blob = sQLData == null ? null : sQLData.getBlob();
            this.testDataTruncation(n, sQLData);
            return blob;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            boolean bl = sQLData == null ? false : sQLData.getBoolean();
            this.testDataTruncation(n, sQLData);
            return bl;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            byte by = sQLData == null ? (byte)0 : sQLData.getByte();
            this.testDataTruncation(n, sQLData);
            return by;
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            byte[] byArray;
            SQLData sQLData = this.getValue(n);
            if (sQLData != null && sQLData.getSQLType() != 2 && sQLData.getSQLType() != 29 && sQLData.getSQLType() != 3 && sQLData.getSQLType() != 4 && sQLData.getSQLType() != 6 && sQLData.getSQLType() != 20 && sQLData.getSQLType() != 31 && sQLData.getSQLType() != 25 && this.row_ instanceof JDServerRow) {
                byArray = ((JDServerRow)this.row_).getRawBytes(n);
            } else {
                byArray = sQLData == null ? null : sQLData.getBytes();
                this.testDataTruncation(n, sQLData);
            }
            return byArray;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            Reader reader;
            SQLData sQLData = this.getValue(n);
            this.openReader_ = reader = sQLData == null ? null : sQLData.getCharacterStream();
            this.testDataTruncation(n, sQLData);
            return reader;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            Clob clob = sQLData == null ? null : sQLData.getClob();
            this.testDataTruncation(n, sQLData);
            return clob;
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        return this.internalGetDate(n, null);
    }

    public Date getDate(String string) throws SQLException {
        return this.internalGetDate(this.findColumn(string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date internalGetDate(int n, Calendar calendar) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            Date date = sQLData == null ? null : sQLData.getDate(calendar);
            this.testDataTruncation(n, sQLData);
            return date;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetDate(n, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            double d = sQLData == null ? 0.0 : sQLData.getDouble();
            this.testDataTruncation(n, sQLData);
            return d;
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            float f = sQLData == null ? 0.0f : sQLData.getFloat();
            this.testDataTruncation(n, sQLData);
            return f;
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            int n2 = sQLData == null ? 0 : sQLData.getInt();
            this.testDataTruncation(n, sQLData);
            return n2;
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            long l = sQLData == null ? 0L : sQLData.getLong();
            this.testDataTruncation(n, sQLData);
            return l;
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            ConvTable convTable = null;
            DBExtendedColumnDescriptors dBExtendedColumnDescriptors = null;
            if (this.statement_ != null && (dBExtendedColumnDescriptors = this.statement_.getExtendedColumnDescriptors()) != null) {
                convTable = ((AS400JDBCConnection)this.connection_).converter_;
            }
            return new AS400JDBCResultSetMetaData(this.catalog_, this.concurrency_, this.cursorName_, this.row_, dBExtendedColumnDescriptors, convTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            Object object2 = sQLData == null ? null : sQLData.getObject();
            this.testDataTruncation(n, sQLData);
            return object2;
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (map == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (map == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        JDError.throwSQLException("07006");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            short s = sQLData == null ? (short)0 : sQLData.getShort();
            this.testDataTruncation(n, sQLData);
            return s;
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            String string = sQLData == null ? null : sQLData.getString();
            this.testDataTruncation(n, sQLData);
            return string;
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        return this.internalGetTime(n, null);
    }

    public Time getTime(String string) throws SQLException {
        return this.internalGetTime(this.findColumn(string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time internalGetTime(int n, Calendar calendar) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            Time time = sQLData == null ? null : sQLData.getTime(calendar);
            this.testDataTruncation(n, sQLData);
            return time;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.internalGetTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.internalGetTimestamp(this.findColumn(string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp internalGetTimestamp(int n, Calendar calendar) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            SQLData sQLData = this.getValue(n);
            Timestamp timestamp = sQLData == null ? null : sQLData.getTimestamp(calendar);
            this.testDataTruncation(n, sQLData);
            return timestamp;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            InputStream inputStream;
            SQLData sQLData = this.getValue(n);
            this.openInputStream_ = inputStream = sQLData == null ? null : sQLData.getUnicodeStream();
            this.testDataTruncation(n, sQLData);
            return inputStream;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    private SQLData getValue(int n) throws SQLException {
        this.checkOpen();
        this.clearCurrentValue();
        if (!this.positionValid_ && !this.positionInsert_) {
            JDError.throwSQLException("HY109");
        }
        if (n < 1 || n > this.columnCount_) {
            JDError.throwSQLException("07009");
        }
        if (this.concurrency_ == 1008 && (this.updateSet_[n - 1] || this.positionInsert_)) {
            this.wasNull_ = this.updateNulls_[n - 1];
            this.wasDataMappingError_ = false;
            if (this.wasNull_) {
                return null;
            }
            return this.updateRow_.getSQLData(n);
        }
        this.wasNull_ = this.row_.isNull(n);
        this.wasDataMappingError_ = this.row_.isDataMappingError(n);
        SQLData sQLData = this.row_.getSQLType(n);
        if (sQLData.getSQLType() == 8 || sQLData.getSQLType() == 4 || sQLData.getSQLType() == 12) {
            this.statement_.setAssociatedWithLocators(true);
        }
        if (this.wasNull_ || this.wasDataMappingError_) {
            return null;
        }
        return this.row_.getSQLData(n);
    }

    private void testDataTruncation(int n, SQLData sQLData) {
        int n2;
        if (this.wasDataMappingError_) {
            this.postWarning(new DataTruncation(n, false, true, -1, -1));
        }
        if (sQLData != null && (n2 = sQLData.getTruncated()) > 0) {
            int n3 = sQLData.getActualSize();
            this.postWarning(new DataTruncation(n, false, true, n3, n3 - n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return this.wasNull_;
        }
    }

    private void beforeUpdate() throws SQLException {
        this.checkOpen();
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforeUpdate();
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforeUpdate();
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Deleting a row.");
            }
            if (this.deleteStatement_ == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DELETE FROM ");
                stringBuffer.append(this.selectTable_);
                stringBuffer.append(" WHERE CURRENT OF \"");
                stringBuffer.append(this.cursorName_);
                stringBuffer.append("\"");
                this.deleteStatement_ = this.connection_.prepareStatement(stringBuffer.toString());
            }
            this.deleteStatement_.execute();
            this.positionValid_ = false;
            this.rowCache_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.beforeUpdate();
            if (!this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this.selectTable_);
            stringBuffer.append(" (");
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                if (n++ > 0) {
                    stringBuffer.append(",");
                    stringBuffer2.append(",");
                }
                stringBuffer.append("\"");
                stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                stringBuffer.append("\"");
                stringBuffer2.append("?");
            }
            if (n == 0) {
                stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(1)));
            }
            stringBuffer.append(") VALUES (");
            if (n == 0) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(stringBuffer2.toString());
            }
            stringBuffer.append(")");
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Inserting a row: " + stringBuffer);
            }
            PreparedStatement preparedStatement = this.connection_.prepareStatement(stringBuffer.toString());
            int n2 = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                Object object2 = this.updateRow_.getSQLData(i + 1).getObject();
                if (this.updateNulls_[i]) {
                    preparedStatement.setNull(++n2, this.row_.getSQLType(i + 1).getType());
                } else {
                    preparedStatement.setObject(++n2, object2);
                }
                this.updateSet_[i] = false;
            }
            preparedStatement.executeUpdate();
            SQLWarning sQLWarning = preparedStatement.getWarnings();
            if (sQLWarning != null) {
                this.postWarning(sQLWarning);
            }
            preparedStatement.close();
            this.rowCache_.flush();
        }
    }

    private static final String prepareQuotes(String string) {
        return JDUtilities.prepareForDoubleQuotes(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowDeleted() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            return !this.positionValid_ && !this.positionInsert_ && (this.positionFromFirst_ > 0 || this.positionFromLast_ > 0);
        }
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    private void testDataTruncation2(int n, SQLData sQLData) throws DataTruncation {
        int n2;
        if (sQLData != null && (n2 = sQLData.getTruncated()) > 0) {
            int n3 = sQLData.getActualSize();
            throw new DataTruncation(n, false, false, n3 + n2, n3);
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        JDError.throwSQLException("07006");
    }

    public void updateArray(String string, Array array) throws SQLException {
        JDError.throwSQLException("07006");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToString(inputStream, n2, "ISO8859_1"), null, -1);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal, null, -1);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream, n2), null, -1);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateValue(n, new Short((short)(bl ? 1 : 0)), null, -1);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateValue(n, blob, null, -1);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateValue(this.findColumn(string), blob, null, -1);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, new Short(by), null, -1);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray, null, -1);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader, n2), null, -1);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateValue(n, clob, null, -1);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateValue(this.findColumn(string), clob, null, -1);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, date, null, -1);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateValue(n, new Double(d), null, -1);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateValue(n, new Float(f), null, -1);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateValue(n, new Integer(n2), null, -1);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateValue(n, new Long(l), null, -1);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.updateValue(n, null, null, -1);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateValue(n, object, null, -1);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY094");
        }
        this.updateValue(n, object, null, n2);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        JDError.throwSQLException("07006");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        JDError.throwSQLException("07006");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        this.beforeUpdate();
        DBExtendedColumnDescriptors dBExtendedColumnDescriptors = null;
        ConvTable convTable = null;
        if (this.positionInsert_ || !this.positionValid_) {
            JDError.throwSQLException("24000");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.selectTable_);
        if (this.correlationName_ != null) {
            stringBuffer.append(" AS ");
            stringBuffer.append(this.correlationName_);
        }
        stringBuffer.append(" SET ");
        int n = 0;
        for (int i = 0; i < this.columnCount_; ++i) {
            if (!this.updateSet_[i]) continue;
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\"");
            if (this.statement_ != null) {
                dBExtendedColumnDescriptors = this.statement_.getExtendedColumnDescriptors();
                if (dBExtendedColumnDescriptors != null) {
                    convTable = ((AS400JDBCConnection)this.connection_).converter_;
                    String string = dBExtendedColumnDescriptors.getColumnDescriptors(i + 1).getBaseColumnName(convTable);
                    if (string != null) {
                        if (((AS400JDBCConnection)this.connection_).getVRM() < JDUtilities.vrm540) {
                            stringBuffer.append(JDUtilities.stripOuterDoubleQuotes(string));
                        } else {
                            stringBuffer.append(AS400JDBCResultSet.prepareQuotes(string));
                        }
                    } else {
                        stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                    }
                } else {
                    stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                }
            } else {
                stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
            }
            stringBuffer.append("\"=?");
        }
        stringBuffer.append(" WHERE CURRENT OF \"");
        stringBuffer.append(this.cursorName_);
        stringBuffer.append("\"");
        if (n > 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Updating a row: " + stringBuffer);
            }
            PreparedStatement preparedStatement = this.connection_.prepareStatement(stringBuffer.toString());
            try {
                int n2 = 0;
                for (int i = 0; i < this.columnCount_; ++i) {
                    if (!this.updateSet_[i]) continue;
                    Object object = this.updateRow_.getSQLData(i + 1).getObject();
                    if (this.updateNulls_[i]) {
                        preparedStatement.setNull(++n2, this.row_.getSQLType(i + 1).getType());
                        continue;
                    }
                    preparedStatement.setObject(++n2, object);
                }
                preparedStatement.executeUpdate();
                SQLWarning sQLWarning = preparedStatement.getWarnings();
                if (sQLWarning != null) {
                    this.postWarning(sQLWarning);
                }
            }
            finally {
                preparedStatement.close();
            }
            this.rowCache_.flush();
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateValue(n, new Short(s), null, -1);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateValue(n, string, null, -1);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateValue(n, time, null, -1);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateValue(n, timestamp, null, -1);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(int n, Object object, Calendar calendar, int n2) throws SQLException {
        Object object2 = this.internalLock_;
        synchronized (object2) {
            this.beforeUpdate();
            if (!this.positionValid_ && !this.positionInsert_) {
                JDError.throwSQLException("HY109");
            }
            if (n < 1 || n > this.columnCount_) {
                JDError.throwSQLException("07009");
            }
            SQLData sQLData = this.updateRow_.getSQLType(n);
            int n3 = n - 1;
            if (object != null && (sQLData.getSQLType() == 8 || sQLData.getSQLType() == 4 || sQLData.getSQLType() == 12)) {
                SQLLocator sQLLocator;
                this.statement_.setAssociatedWithLocators(true);
                try {
                    sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(((AS400JDBCBlobLocator)object).getHandle());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                try {
                    sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(((AS400JDBCClobLocator)object).getHandle());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (object != null) {
                sQLData.set(object, calendar, n2);
            }
            this.updateNulls_[n3] = object == null;
            this.updateSet_[n3] = true;
            if (this.dataTruncation_) {
                this.testDataTruncation2(n, sQLData);
            }
        }
    }
}

