/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;

public class AS400Message
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int COMPLETION = 1;
    public static final int DIAGNOSTIC = 2;
    public static final int INFORMATIONAL = 4;
    public static final int INQUIRY = 5;
    public static final int SENDERS_COPY = 6;
    public static final int REQUEST = 8;
    public static final int REQUEST_WITH_PROMPTING = 10;
    public static final int NOTIFY = 14;
    public static final int ESCAPE = 15;
    public static final int NOTIFY_NOT_HANDLED = 16;
    public static final int ESCAPE_NOT_HANDLED = 17;
    public static final int REPLY_NOT_VALIDITY_CHECKED = 21;
    public static final int REPLY_VALIDITY_CHECKED = 22;
    public static final int REPLY_MESSAGE_DEFAULT_USED = 23;
    public static final int REPLY_SYSTEM_DEFAULT_USED = 24;
    public static final int REPLY_FROM_SYSTEM_REPLY_LIST = 25;
    public static final int MESSAGE_OPTION_UP_TO_10 = 0;
    public static final int MESSAGE_OPTION_NONE = 1;
    public static final int MESSAGE_OPTION_ALL = 2;
    private Calendar date_;
    private String dateSent_;
    private String timeSent_;
    private String fileName_;
    private String id_;
    private String libraryName_;
    private String defaultReply_;
    private int severity_ = -1;
    private byte[] substitutionData_;
    private String text_;
    private int type_ = -1;
    private String help_;
    private transient AS400 system_;
    private transient boolean messageLoaded_ = false;

    AS400Message() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400Message object.");
        }
    }

    AS400Message(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400Message object, ID: " + string + " text: " + string2);
        }
        this.id_ = string;
        this.text_ = string2;
    }

    AS400Message(String string, String string2, String string3, String string4, int n, int n2, byte[] byArray, String string5) {
        this.id_ = string;
        this.text_ = string2;
        this.fileName_ = string3;
        this.libraryName_ = string4;
        this.severity_ = n;
        this.type_ = n2;
        this.substitutionData_ = byArray;
        this.help_ = string5;
    }

    AS400Message(String string, String string2, String string3, String string4, int n, int n2, byte[] byArray, String string5, String string6, String string7, String string8) {
        this.id_ = string;
        this.text_ = string2;
        this.fileName_ = string3;
        this.libraryName_ = string4;
        this.severity_ = n;
        this.type_ = n2;
        this.substitutionData_ = byArray;
        this.help_ = string5;
        this.setDate(string6, string7);
        this.defaultReply_ = string8;
    }

    public Calendar getDate() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting date: " + this.date_);
        }
        if (this.date_ == null && (this.dateSent_ != null || this.timeSent_ != null)) {
            this.setDate();
        }
        return this.date_;
    }

    public String getDefaultReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting default reply: " + this.defaultReply_);
        }
        return this.defaultReply_;
    }

    public String getFileName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file name: " + this.fileName_);
        }
        return this.fileName_;
    }

    public String getHelp() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message help: " + this.help_);
        }
        return this.help_;
    }

    public String getID() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message ID: " + this.id_);
        }
        return this.id_;
    }

    public String getLibraryName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file library: " + this.libraryName_);
        }
        return this.libraryName_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file path, file name: " + this.fileName_ + " library: " + this.libraryName_);
        }
        if (this.fileName_ == null || this.libraryName_ == null || this.fileName_.length() == 0 || this.libraryName_.length() == 0) {
            return null;
        }
        return QSYSObjectPathName.toPath(this.libraryName_, this.fileName_, "MSGF");
    }

    public int getSeverity() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message severity:", this.severity_);
        }
        return this.severity_;
    }

    public byte[] getSubstitutionData() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message substitution data:", this.substitutionData_);
        }
        return this.substitutionData_;
    }

    public String getText() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message text: " + this.text_);
        }
        return this.text_;
    }

    public int getType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message type:", this.type_);
        }
        return this.type_;
    }

    public void load() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.load(0);
    }

    public void load(int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading additional message information.");
        }
        if (this.messageLoaded_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Repeat message load not necessary.");
            }
            return;
        }
        if (this.libraryName_ == null || this.fileName_ == null || this.libraryName_.trim().length() == 0 || this.fileName_.trim().length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "No message file associated with this message: " + this.toString());
            }
            return;
        }
        MessageFile messageFile = new MessageFile(this.system_, QSYSObjectPathName.toPath(this.libraryName_, this.fileName_, "MSGF"));
        try {
            messageFile.setHelpTextFormatting(n);
            AS400Message aS400Message = messageFile.getMessage(this.id_, this.substitutionData_);
            if (this.defaultReply_ == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting default reply: " + aS400Message.defaultReply_);
                }
                this.defaultReply_ = aS400Message.defaultReply_;
            }
            if (this.severity_ == -1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting message severity:", aS400Message.severity_);
                }
                this.severity_ = aS400Message.severity_;
            }
            if (this.text_ == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting message text: " + aS400Message.text_);
                }
                this.text_ = aS400Message.text_;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Setting message help: " + aS400Message.help_);
            }
            this.help_ = aS400Message.help_;
            this.messageLoaded_ = true;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
    }

    private void setDate() {
        if (this.dateSent_ == null && this.timeSent_ == null) {
            return;
        }
        if (this.dateSent_ != null && this.dateSent_.trim().length() == 0 && this.timeSent_ != null && this.timeSent_.trim().length() == 0) {
            this.dateSent_ = null;
            this.timeSent_ = null;
            return;
        }
        this.date_ = Calendar.getInstance();
        this.date_.clear();
        if (this.dateSent_ != null && this.dateSent_.trim().length() > 0) {
            this.date_.set(1, Integer.parseInt(this.dateSent_.substring(0, 3)) + 1900);
            this.date_.set(2, Integer.parseInt(this.dateSent_.substring(3, 5)) - 1);
            this.date_.set(5, Integer.parseInt(this.dateSent_.substring(5, 7)));
        }
        if (this.timeSent_ != null && this.timeSent_.trim().length() > 0) {
            this.date_.set(10, Integer.parseInt(this.timeSent_.substring(0, 2)));
            this.date_.set(12, Integer.parseInt(this.timeSent_.substring(2, 4)));
            this.date_.set(13, Integer.parseInt(this.timeSent_.substring(4, 6)));
        }
        this.dateSent_ = null;
        this.timeSent_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Date: " + this.date_);
        }
    }

    void setDate(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting date, date: " + string + " time: " + string2);
        }
        this.dateSent_ = string;
        this.timeSent_ = string2;
    }

    void setDefaultReply(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting default reply: " + string);
        }
        this.defaultReply_ = string;
    }

    void setFileName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file name: " + string);
        }
        this.fileName_ = string;
    }

    void setHelp(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message help: " + string);
        }
        this.help_ = string;
    }

    void setID(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message ID: " + string);
        }
        this.id_ = string;
    }

    void setLibraryName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file library: " + string);
        }
        this.libraryName_ = string;
    }

    void setSeverity(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message severity:", n);
        }
        this.severity_ = n;
    }

    void setSubstitutionData(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message substitution data:", byArray);
        }
        this.substitutionData_ = byArray;
    }

    void setSystem(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file system: " + aS400);
        }
        this.system_ = aS400;
    }

    void setText(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message text: " + string);
        }
        this.text_ = string;
    }

    void setType(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message type:", n);
        }
        this.type_ = n;
    }

    public String toString() {
        return "AS400Message (ID: " + this.id_ + " text: " + this.text_ + "):" + super.toString();
    }

    String toStringM2() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getID();
        String string2 = this.getText();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().trim();
    }
}

