/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolEventSupport;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ConnectionPoolProperties;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Log;
import com.ibm.as400.access.PoolItem;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

final class ConnectionList {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private String systemName_;
    private String userID_;
    private ConnectionPoolProperties properties_;
    private Log log_;
    private Vector connectionList_ = new Vector();

    ConnectionList(String string, String string2, ConnectionPoolProperties connectionPoolProperties) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("systemName", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("userID");
        }
        if (string2.length() == 0) {
            throw new ExtendedIllegalArgumentException("userID", 1);
        }
        if (connectionPoolProperties == null) {
            throw new NullPointerException("properties");
        }
        this.systemName_ = string;
        this.userID_ = string2;
        this.properties_ = connectionPoolProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.log_ != null) {
            this.log(ResourceBundleLoader.getText("CL_CLEANUP", new String[]{this.systemName_, this.userID_}));
        }
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                poolItem.getAS400Object().disconnectAllServices();
            }
            this.connectionList_.removeAllElements();
        }
        this.log(ResourceBundleLoader.getText("CL_CLEANUPCOMP"));
    }

    private PoolItem createNewConnection(int n, boolean bl, boolean bl2, ConnectionPoolEventSupport connectionPoolEventSupport, Locale locale, String string, SocketProperties socketProperties) throws AS400SecurityException, IOException, ConnectionPoolException {
        if (this.log_ != null) {
            this.log(ResourceBundleLoader.getText("CL_CREATING", new String[]{this.systemName_, this.userID_}));
        }
        if (this.properties_.getMaxConnections() > 0 && this.getConnectionCount() >= this.properties_.getMaxConnections()) {
            this.log(ResourceBundleLoader.getText("CL_CLEANUPEXP"));
            this.removeAndReplace(connectionPoolEventSupport);
            if (this.getConnectionCount() >= this.properties_.getMaxConnections()) {
                this.log(ResourceBundleLoader.getText("CL_CLEANUPOLD"));
                this.shutDownOldest();
                if (this.getConnectionCount() >= this.properties_.getMaxConnections()) {
                    throw new ConnectionPoolException(1);
                }
            }
        }
        boolean bl3 = this.properties_.isThreadUsed();
        PoolItem poolItem = new PoolItem(this.systemName_, this.userID_, string, bl2, locale, n, bl, bl3, socketProperties);
        poolItem.setInUse(true);
        this.connectionList_.addElement(poolItem);
        if (connectionPoolEventSupport != null) {
            ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 1);
            connectionPoolEventSupport.fireConnectionCreatedEvent(connectionPoolEvent);
        }
        if (this.log_ != null) {
            this.log(ResourceBundleLoader.getText("CL_CREATED", new String[]{this.systemName_, this.userID_}));
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem findElement(AS400 aS400) {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.getAS400Object().equals(aS400)) continue;
                return poolItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveConnectionCount() {
        int n = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.connectionList_.size();
            for (int i = 0; i < n2; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.isInUse()) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableConnectionCount() {
        int n = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.connectionList_.size();
            for (int i = 0; i < n2; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (poolItem.isInUse()) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem getConnection(boolean bl, ConnectionPoolEventSupport connectionPoolEventSupport, Locale locale, String string, SocketProperties socketProperties) throws AS400SecurityException, IOException, ConnectionPoolException {
        PoolItem poolItem = null;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem2 = (PoolItem)this.connectionList_.elementAt(i);
                if (poolItem2.isInUse()) continue;
                if (bl && poolItem2.getAS400Object() instanceof SecureAS400 && (poolItem2.getLocale().equals("") && locale == null || locale != null && poolItem2.getLocale().equals(locale.toString()))) {
                    poolItem = poolItem2;
                    break;
                }
                if (bl || poolItem2.getAS400Object() instanceof SecureAS400 || (!poolItem2.getLocale().equals("") || locale != null) && (locale == null || !poolItem2.getLocale().equals(locale.toString()))) continue;
                poolItem = poolItem2;
                break;
            }
            if (poolItem != null) {
                poolItem.setInUse(true);
            }
        }
        if (poolItem == null) {
            poolItem = this.createNewConnection(0, false, bl, connectionPoolEventSupport, locale, string, socketProperties);
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem getConnection(int n, boolean bl, ConnectionPoolEventSupport connectionPoolEventSupport, Locale locale, String string, SocketProperties socketProperties) throws AS400SecurityException, IOException, ConnectionPoolException {
        PoolItem poolItem = null;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            PoolItem poolItem2;
            int n2;
            int n3 = this.connectionList_.size();
            for (n2 = 0; n2 < n3; ++n2) {
                poolItem2 = (PoolItem)this.connectionList_.elementAt(n2);
                if (poolItem2.isInUse()) continue;
                if (bl && poolItem2.getAS400Object() instanceof SecureAS400 && poolItem2.getAS400Object().isConnected(n) && (poolItem2.getLocale().equals("") && locale == null || locale != null && poolItem2.getLocale().equals(locale.toString()))) {
                    Trace.log(3, "Using already connected connection");
                    poolItem = poolItem2;
                    break;
                }
                if (bl || poolItem2.getAS400Object() instanceof SecureAS400 || !poolItem2.getAS400Object().isConnected(n) || (!poolItem2.getLocale().equals("") || locale != null) && (locale == null || !poolItem2.getLocale().equals(locale.toString()))) continue;
                Trace.log(3, "Using already connected connection");
                poolItem = poolItem2;
                break;
            }
            if (poolItem == null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    poolItem2 = (PoolItem)this.connectionList_.elementAt(n2);
                    if (poolItem2.isInUse()) continue;
                    if (bl && poolItem2.getAS400Object() instanceof SecureAS400 && (poolItem2.getLocale().equals("") && locale == null || locale != null && poolItem2.getLocale().equals(locale.toString()))) {
                        Trace.log(3, "Must not have found a suitable connection, using first available");
                        poolItem = poolItem2;
                        break;
                    }
                    if (bl || poolItem2.getAS400Object() instanceof SecureAS400 || (!poolItem2.getLocale().equals("") || locale != null) && (locale == null || !poolItem2.getLocale().equals(locale.toString()))) continue;
                    Trace.log(3, "Must not have found a suitable connection, using first available");
                    poolItem = poolItem2;
                    break;
                }
            }
            if (poolItem != null) {
                if (!poolItem.getAS400Object().isConnected(n)) {
                    poolItem.getAS400Object().connectService(n);
                }
                poolItem.setInUse(true);
            }
        }
        if (poolItem == null) {
            poolItem = this.createNewConnection(n, true, bl, connectionPoolEventSupport, locale, string, socketProperties);
        }
        return poolItem;
    }

    public int getConnectionCount() {
        return this.connectionList_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasConnectedConnection() {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.getAS400Object().isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    private void log(String string) {
        if (Trace.isTraceOn()) {
            Trace.log(3, string);
        }
        if (this.log_ != null) {
            this.log_.log(string);
        }
    }

    private void log(Exception exception, String string) {
        if (Trace.isTraceOn()) {
            Trace.log(2, string, (Throwable)exception);
        }
        if (this.log_ != null) {
            this.log_.log(string, exception);
        }
    }

    private void reconnectAllServices(PoolItem poolItem, PoolItem poolItem2) throws IOException, AS400SecurityException {
        if (poolItem == null) {
            throw new NullPointerException("oldItem");
        }
        if (poolItem2 == null) {
            throw new NullPointerException("newItem");
        }
        AS400 aS400 = poolItem.getAS400Object();
        AS400 aS4002 = poolItem2.getAS400Object();
        if (aS400.isConnected(0)) {
            Trace.log(3, "replacing connection to service FILE");
            aS4002.connectService(0);
        }
        if (aS400.isConnected(1)) {
            Trace.log(3, "replacing connection to service PRINT");
            aS4002.connectService(1);
        }
        if (aS400.isConnected(2)) {
            Trace.log(3, "replacing connection to service COMMAND");
            aS4002.connectService(2);
        }
        if (aS400.isConnected(3)) {
            Trace.log(3, "replacing connection to service DATAQUEUE");
            aS4002.connectService(3);
        }
        if (aS400.isConnected(4)) {
            Trace.log(3, "replacing connection to service DATABASE");
            aS4002.connectService(4);
        }
        if (aS400.isConnected(5)) {
            Trace.log(3, "replacing connection to service RECORDACCESS");
            aS4002.connectService(5);
        }
        if (aS400.isConnected(6)) {
            Trace.log(3, "replacing connection to service CENTRAL");
            aS4002.connectService(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAndReplace(ConnectionPoolEventSupport connectionPoolEventSupport) throws AS400SecurityException, IOException {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = n - 1; i >= 0; --i) {
                ConnectionPoolEvent connectionPoolEvent;
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (this.properties_.getMaxInactivity() >= 0L && poolItem.getInactivityTime() >= this.properties_.getMaxInactivity()) {
                    if (this.log_ != null) {
                        this.log(ResourceBundleLoader.getText("CL_REMUNUSED", new String[]{this.systemName_, this.userID_}));
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport == null) continue;
                    connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                    connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    continue;
                }
                if (this.properties_.getMaxUseCount() >= 0 && poolItem.getUseCount() >= this.properties_.getMaxUseCount()) {
                    if (this.log_ != null) {
                        this.log(ResourceBundleLoader.getText("CL_REPUSE", new String[]{this.systemName_, this.userID_}));
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport != null) {
                        connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                        connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    }
                }
                if (this.properties_.getMaxLifetime() >= 0L && poolItem.getLifeSpan() >= this.properties_.getMaxLifetime()) {
                    if (this.log_ != null) {
                        this.log(ResourceBundleLoader.getText("CL_REPLIFE", new String[]{this.systemName_, this.userID_}));
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport != null) {
                        connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                        connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    }
                }
                if (this.properties_.getMaxUseTime() < 0L || poolItem.getInUseTime() < this.properties_.getMaxUseTime()) continue;
                poolItem.getAS400Object().disconnectAllServices();
                this.connectionList_.removeElementAt(i);
                if (connectionPoolEventSupport == null) continue;
                connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnusedElements() {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            if (this.connectionList_.size() > 0) {
                int n = this.connectionList_.size();
                if (n == 0) {
                    return false;
                }
                for (int i = n - 1; i >= 0; --i) {
                    PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                    if (poolItem.isInUse()) continue;
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElement(AS400 aS400) {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.getAS400Object().equals(aS400)) continue;
                this.connectionList_.removeElement(poolItem);
                return;
            }
        }
    }

    void setLog(Log log) {
        this.log_ = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutDownOldest() {
        if (this.log_ != null) {
            this.log(ResourceBundleLoader.getText("CL_REMOLD", new String[]{this.systemName_, this.userID_}));
        }
        int n = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.getConnectionCount() - this.properties_.getMaxConnections() + 1;
            for (int i = 0; i < n2; ++i) {
                n = 0;
                if (this.connectionList_.size() <= 0) continue;
                long l = 0L;
                int n3 = this.connectionList_.size();
                for (int j = 0; j < n3; ++j) {
                    PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(j);
                    if (poolItem.isInUse() || poolItem.getInactivityTime() <= l && n != 0) continue;
                    n = j;
                    l = poolItem.getInactivityTime();
                }
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(n);
                if (poolItem.isInUse()) continue;
                poolItem.getAS400Object().disconnectAllServices();
                this.connectionList_.removeElementAt(n);
                if (this.log_ == null) continue;
                this.log(ResourceBundleLoader.getText("CL_REMOLDCOMP", new String[]{this.systemName_, this.userID_}));
            }
        }
    }
}

