/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import java.io.CharConversionException;

class DBExtendedDataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int FIXED_LENGTH_ = 16;
    private static final int REPEATED_LENGTH_ = 64;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int length_ = -1;

    public DBExtendedDataFormat() {
    }

    public DBExtendedDataFormat(int n) {
        this.numberOfFields_ = n;
        this.length_ = 16 + this.numberOfFields_ * 64;
    }

    public void overlay(byte[] byArray, int n) {
        this.rawBytes_ = byArray;
        this.offset_ = n;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToInt(this.rawBytes_, n + 4);
            this.length_ = 16 + this.numberOfFields_ * 64;
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    public int getLength() {
        return this.length_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    public int getRecordSize() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 12);
    }

    public int getFieldSQLType(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 18 + n * 64);
    }

    public int getFieldLength(int n) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 20 + n * 64);
    }

    public int getFieldScale(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 24 + n * 64);
    }

    public int getFieldPrecision(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 26 + n * 64);
    }

    public int getFieldCCSID(int n) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 28 + n * 64);
    }

    public int getFieldParameterType(int n) {
        return this.rawBytes_[this.offset_ + 30 + n * 64];
    }

    public int getFieldLOBLocator(int n) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 33 + n * 64);
    }

    public int getFieldLOBMaxSize(int n) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 42 + n * 64);
    }

    public int getFieldNameLength(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 46 + n * 64);
    }

    public int getFieldNameCCSID(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 48 + n * 64);
    }

    public String getFieldName(int n, ConvTable convTable) {
        return convTable.byteArrayToString(this.rawBytes_, this.offset_ + 50 + n * 64, this.getFieldNameLength(n));
    }

    public void setConsistencyToken(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_);
    }

    public void setNumberOfFields(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_ + 4);
    }

    public void setRecordSize(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_ + 12);
    }

    public void setFieldDescriptionLength(int n) {
        BinaryConverter.shortToByteArray((short)64, this.rawBytes_, this.offset_ + n * 64 + 16);
    }

    public void setFieldSQLType(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 64 + 18);
    }

    public void setFieldLength(int n, int n2) {
        BinaryConverter.intToByteArray(n2, this.rawBytes_, this.offset_ + n * 64 + 20);
    }

    public void setFieldScale(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 64 + 24);
    }

    public void setFieldPrecision(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 64 + 26);
    }

    public void setFieldCCSID(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 64 + 28);
    }

    public void setFieldParameterType(int n, int n2) {
        this.rawBytes_[this.offset_ + n * 64 + 30] = (byte)n2;
    }

    public void setFieldNameLength(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 64 + 46);
    }

    public void setFieldNameCCSID(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 64 + 48);
    }

    public void setFieldName(int n, String string, ConvTable convTable) throws DBDataStreamException {
        try {
            convTable.stringToByteArray(string, this.rawBytes_, this.offset_ + n * 64 + 50);
        }
        catch (CharConversionException charConversionException) {
            throw new DBDataStreamException();
        }
        int n2 = string.length();
        int n3 = this.offset_ + n * 64 + 50;
        for (int i = n2; i < 30; ++i) {
            this.rawBytes_[n3 + i] = 0;
        }
    }
}

