/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.FTPEvent;
import com.ibm.as400.access.FTPInputStream;
import com.ibm.as400.access.FTPListener;
import com.ibm.as400.access.FTPOutputStream;
import com.ibm.as400.access.FTPThread;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class FTP
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    private String server_;
    private String user_;
    private transient String clearPassword_ = null;
    private transient byte[] encryptedPassword_ = null;
    private transient byte[] mask_ = null;
    private transient byte[] adder_ = null;
    private transient boolean encrypted_ = false;
    private static final int PARKED = 0;
    private static final int ACTIVE = 1;
    private static final int FAILED = 2;
    private transient int connectionState_ = 0;
    private transient boolean inConnect_ = false;
    transient String lastMessage_ = "";
    private int port_ = 21;
    private transient Socket controlSocket_;
    private transient BufferedReader reader_;
    private transient PrintWriter ps_;
    private transient boolean externallyConnected_ = false;
    boolean reuseSocket_ = true;
    transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    transient VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    transient Vector listeners_ = new Vector();
    private int bufferSize_ = 4096;
    private int mode_ = 11;
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    public static final int ACTIVE_MODE = 10;
    public static final int PASSIVE_MODE = 11;
    private transient FTPThread activeModeObject_;
    private transient Thread activeModeThread_;

    public FTP() {
        this.checkSocketProperty();
    }

    public FTP(String string) {
        try {
            this.setServer(string);
            this.checkSocketProperty();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public FTP(String string, String string2, String string3) {
        try {
            this.setServer(string);
            this.setUser(string2);
            this.setPassword(string3);
            this.checkSocketProperty();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addFTPListener(FTPListener fTPListener) {
        if (fTPListener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners_.addElement(fTPListener);
    }

    public synchronized OutputStream append(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering append(file)");
        }
        if (string == null) {
            throw new NullPointerException("file");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("file");
        }
        return this.doAppendOrPut(string, "APPE");
    }

    public synchronized boolean append(String string, String string2) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering append(String, String)");
        }
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (string2 == null) {
            throw new NullPointerException("target");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        boolean bl = this.append(new File(string), string2);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving append(String, String)");
        }
        return bl;
    }

    public synchronized boolean append(File file, String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering append(File, String)");
        }
        if (file == null) {
            throw new NullPointerException("source");
        }
        if (string == null) {
            throw new NullPointerException("target");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        this.connect();
        byte[] byArray = new byte[this.bufferSize_];
        FileInputStream fileInputStream = new FileInputStream(file);
        OutputStream outputStream = this.append(string);
        int n = fileInputStream.read(byArray);
        while (n > 0) {
            outputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray);
        }
        outputStream.close();
        fileInputStream.close();
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving append(String, String)");
        }
        return true;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized boolean cd(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering cd()");
        }
        if (string == null) {
            throw new NullPointerException("directory");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("directory");
        }
        this.connect();
        this.issueCommand("CWD " + string);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving cd()");
        }
        return this.lastMessage_.startsWith("250");
    }

    public synchronized boolean connect() throws UnknownHostException, IOException, IllegalStateException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering connect()");
        }
        this.inConnect_ = true;
        if (this.connectionState_ == 2) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "leaving  connect(), state=failed");
            }
            this.inConnect_ = false;
            return false;
        }
        if (this.connectionState_ == 1) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "leaving  connect(), state=active");
            }
            this.inConnect_ = false;
            return true;
        }
        if (this.server_ == null || this.server_.length() == 0) {
            this.inConnect_ = false;
            throw new IllegalStateException("server");
        }
        if (this.user_ == null || this.user_.length() == 0) {
            this.inConnect_ = false;
            throw new IllegalStateException("user");
        }
        String string = this.getPassword();
        if (string == null || string.length() == 0) {
            this.inConnect_ = false;
            throw new IllegalStateException("password");
        }
        this.controlSocket_ = new Socket(this.server_, this.port_);
        this.reader_ = new BufferedReader(new InputStreamReader(this.controlSocket_.getInputStream()));
        this.ps_ = new PrintWriter(this.controlSocket_.getOutputStream(), true);
        String string2 = this.readReply();
        this.login(this.user_, string);
        if (!this.lastMessage_.startsWith("230")) {
            this.ps_.close();
            this.reader_.close();
            this.controlSocket_.close();
            this.connectionState_ = 0;
            this.inConnect_ = false;
            throw new SecurityException();
        }
        this.connectionState_ = 1;
        this.inConnect_ = false;
        if (this.connectionState_ == 1) {
            this.fireEvent(0);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving  connect(), state = " + this.connectionState_);
        }
        return this.connectionState_ == 1;
    }

    private byte[] decode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.decode(byArray, 0, byArray.length, byArray2, byArray3);
    }

    private byte[] decode(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) {
        int n3;
        byte[] byArray4 = new byte[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray4[n3] = (byte)(byArray2[n3 % byArray2.length] ^ byArray[n + n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            byArray4[n3] = (byte)(byArray4[n3] - byArray3[n3 % byArray3.length]);
        }
        return byArray4;
    }

    public synchronized String[] dir() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering dir(), (note, no exit dir() entry)");
        }
        return this.list(true, null);
    }

    public synchronized String[] dir(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering dir(), (note, no exit dir() entry)");
        }
        return this.list(true, string);
    }

    public synchronized void disconnect() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering disconnect()");
        }
        if (this.connectionState_ == 1) {
            try {
                this.issueCommand("QUIT");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.activeModeThread_ != null) {
                    this.activeModeThread_.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ps_.close();
            this.reader_.close();
            this.controlSocket_.close();
            this.connectionState_ = 0;
            this.fireEvent(1);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving disconnect()");
        }
    }

    OutputStream doAppendOrPut(String string, String string2) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering doAppendOrPut(file)");
        }
        this.connect();
        Socket socket = null;
        if (this.mode_ == 11) {
            socket = this.getDataSocket();
        } else {
            this.initiateActiveMode();
        }
        String string3 = this.issueCommand(string2 + " " + string);
        if (string3.startsWith("4") || string3.startsWith("5")) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "put failed " + string3);
            }
            if (socket != null) {
                socket.close();
            }
            throw new IOException(string3);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving put(file)");
        }
        if (socket == null) {
            socket = this.activeModeObject_.getSocket();
        }
        this.fireEvent(3);
        return new FTPOutputStream(socket, this);
    }

    private byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[byArray.length];
        for (n = 0; n < byArray.length; ++n) {
            byArray4[n] = (byte)(byArray[n] + byArray3[n % byArray3.length]);
        }
        for (n = 0; n < byArray4.length; ++n) {
            byArray4[n] = (byte)(byArray4[n] ^ byArray2[n % byArray2.length]);
        }
        return byArray4;
    }

    void externallyConnected(String string, Socket socket, BufferedReader bufferedReader, PrintWriter printWriter) {
        this.connectionState_ = 1;
        this.externallyConnected_ = true;
        this.server_ = string;
        this.controlSocket_ = socket;
        this.reader_ = bufferedReader;
        this.ps_ = printWriter;
    }

    private int extractPortAddress(String string) throws IOException {
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering extractPortAddress() " + string);
        }
        if ((stringTokenizer = new StringTokenizer(string, ",")).countTokens() < 6) {
            throw new IOException("Unable to extract port address from PASV response: " + string);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            stringTokenizer.nextToken();
        }
        try {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf(")");
            int n4 = n3 != -1 ? Integer.parseInt(string2.substring(0, n3)) : Integer.parseInt(string2);
            n = n2 * 256 + n4;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Unable to extract port address from PASV response: " + string);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving extractPortAddress()");
        }
        return n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }

    void fireEvent(int n) {
        if (!this.listeners_.isEmpty()) {
            Vector vector = (Vector)this.listeners_.clone();
            FTPEvent fTPEvent = new FTPEvent(this, n);
            for (int i = 0; i < vector.size(); ++i) {
                FTPListener fTPListener = (FTPListener)vector.elementAt(i);
                if (n == 0) {
                    fTPListener.connected(fTPEvent);
                    continue;
                }
                if (n == 1) {
                    fTPListener.disconnected(fTPEvent);
                    continue;
                }
                if (n == 2) {
                    fTPListener.retrieved(fTPEvent);
                    continue;
                }
                if (n == 3) {
                    fTPListener.put(fTPEvent);
                    continue;
                }
                if (n != 4) continue;
                fTPListener.listed(fTPEvent);
            }
        }
    }

    public synchronized InputStream get(String string) throws IOException, FileNotFoundException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering get(file)");
        }
        if (string == null) {
            throw new NullPointerException("file");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("file");
        }
        this.connect();
        Socket socket = null;
        if (this.mode_ == 11) {
            socket = this.getDataSocket();
        } else {
            this.initiateActiveMode();
        }
        this.issueCommand("RETR " + string);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving get(file)");
        }
        if (this.lastMessage_.startsWith("426") || this.lastMessage_.startsWith("501") || this.lastMessage_.startsWith("550")) {
            if (socket != null) {
                socket.close();
            }
            throw new FileNotFoundException();
        }
        if (socket == null) {
            socket = this.activeModeObject_.getSocket();
        }
        this.fireEvent(2);
        return new FTPInputStream(socket, this);
    }

    public synchronized boolean get(String string, String string2) throws IOException, FileNotFoundException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering get(String, String");
        }
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (string2 == null) {
            throw new NullPointerException("target");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        boolean bl = this.get(string, new File(string2));
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving get(String, String");
        }
        return bl;
    }

    public synchronized boolean get(String string, File file) throws IOException, FileNotFoundException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering get(String, file)");
        }
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (file == null) {
            throw new NullPointerException("target");
        }
        boolean bl = true;
        this.connect();
        byte[] byArray = new byte[this.bufferSize_];
        InputStream inputStream = this.get(string);
        if (inputStream != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = inputStream.read(byArray);
            while (n > 0) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            fileOutputStream.close();
        } else {
            bl = false;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving get(String, file");
        }
        return bl;
    }

    public int getBufferSize() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getBufferSize(), (no leaving entry)");
        }
        return this.bufferSize_;
    }

    public synchronized String getCurrentDirectory() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering pwd(), (no leaving entry)");
        }
        return this.pwd();
    }

    public synchronized String getLastMessage() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering lastMessage(), (no leaving entry)");
        }
        return this.lastMessage_;
    }

    public int getMode() {
        return this.mode_;
    }

    private String getPassword() {
        if (this.encrypted_) {
            if (this.encryptedPassword_ == null) {
                return null;
            }
            return new String(this.decode(this.encryptedPassword_, this.mask_, this.adder_));
        }
        return this.clearPassword_;
    }

    public int getPort() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getPort(), (no leaving entry)");
        }
        return this.port_;
    }

    public String getServer() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getServer(), (no leaving entry)");
        }
        return this.server_;
    }

    public String getUser() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getUser(), (no leaving entry)");
        }
        return this.user_;
    }

    public boolean isReuseSocket() {
        return this.reuseSocket_;
    }

    public synchronized String issueCommand(String string) throws IOException {
        if (Trace.isTraceOn()) {
            String string2 = string;
            if (string.startsWith("PASS")) {
                string2 = "PASS " + "********************".substring(0, string.length() - 5);
            }
            Trace.log(1, "entering issueCommand(), command is: " + string2);
        }
        if (!this.inConnect_) {
            this.connect();
        }
        this.ps_.print(string + "\r\n");
        this.ps_.flush();
        this.readReply();
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving  issueCommand(), message is: " + this.lastMessage_);
        }
        return this.lastMessage_;
    }

    private void initiateActiveMode() throws IOException {
        if (!this.activeModeThread_.isAlive()) {
            this.activeModeObject_.setLocalAddress(this.controlSocket_.getLocalAddress());
            this.activeModeThread_.start();
            this.activeModeObject_.waitUntilStarted();
        }
        this.activeModeObject_.issuePortCommand();
    }

    String[] list(boolean bl, String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering list");
        }
        this.connect();
        Socket socket = null;
        if (this.mode_ == 11) {
            socket = this.getDataSocket();
        } else {
            this.initiateActiveMode();
        }
        String string2 = bl ? "LIST" : "NLST";
        if (string != null) {
            string2 = string2 + " " + string;
        }
        this.issueCommand(string2);
        Object[] objectArray = new String[]{};
        if (this.lastMessage_.startsWith("125") || this.lastMessage_.startsWith("150")) {
            String string3;
            if (socket == null) {
                socket = this.activeModeObject_.getSocket();
            }
            InputStream inputStream = socket.getInputStream();
            Vector<String> vector = new Vector<String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                vector.addElement(string3);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            bufferedReader.close();
            inputStream.close();
            socket.close();
            this.readReply();
            this.fireEvent(4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving list()");
        }
        return objectArray;
    }

    private String login(String string, String string2) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering login");
        }
        String string3 = this.issueCommand("USER " + string);
        String string4 = this.issueCommand("PASS " + string2);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving login");
        }
        return string3 + "\n" + string4;
    }

    public synchronized String[] ls() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering ls(), (no leaving entry)");
        }
        return this.list(false, null);
    }

    public synchronized String[] ls(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering ls(), (no leaving entry)");
        }
        return this.list(false, string);
    }

    public synchronized boolean noop() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering noop");
        }
        if (!this.inConnect_) {
            this.connect();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving noop()");
        }
        return this.issueCommand("NOOP").startsWith("200");
    }

    public synchronized OutputStream put(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering put(file)");
        }
        if (string == null) {
            throw new NullPointerException("file");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("file");
        }
        return this.doAppendOrPut(string, "STOR");
    }

    public synchronized boolean put(String string, String string2) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering put(String, String)");
        }
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (string2 == null) {
            throw new NullPointerException("target");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        boolean bl = this.put(new File(string), string2);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving put(String, String)");
        }
        return bl;
    }

    public synchronized boolean put(File file, String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering put(File, String)");
        }
        if (file == null) {
            throw new NullPointerException("source");
        }
        if (string == null) {
            throw new NullPointerException("target");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        this.connect();
        byte[] byArray = new byte[this.bufferSize_];
        FileInputStream fileInputStream = new FileInputStream(file);
        OutputStream outputStream = this.put(string);
        int n = fileInputStream.read(byArray);
        while (n > 0) {
            outputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray);
        }
        outputStream.close();
        fileInputStream.close();
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving put(String, String)");
        }
        return true;
    }

    public synchronized String pwd() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering pwd(), (no leaving entry)");
        }
        this.connect();
        return this.issueCommand("PWD");
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeFTPListener(FTPListener fTPListener) {
        if (fTPListener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners_.removeElement(fTPListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.connectionState_ = 0;
        this.inConnect_ = false;
        this.lastMessage_ = "";
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.listeners_ = new Vector();
        this.externallyConnected_ = false;
    }

    String readReply() throws IOException {
        String string;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering readReply()");
        }
        if ((string = this.reader_.readLine()) == null || string.length() == 0) {
            throw new IOException();
        }
        String string2 = string.substring(0, 3);
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = true;
        while (bl) {
            if (string.length() > 3 && string.substring(0, 3).equals(string2) && string.charAt(3) == ' ') {
                bl = false;
                continue;
            }
            string = this.reader_.readLine();
            stringBuffer.append("\n" + string);
        }
        this.lastMessage_ = stringBuffer.toString();
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving readReply()");
        }
        return this.lastMessage_;
    }

    public synchronized void setBufferSize(int n) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setBufferSize()");
        }
        if (n < 1) {
            throw new IllegalArgumentException("bufferSize");
        }
        int n2 = this.bufferSize_;
        this.vetos_.fireVetoableChange("bufferSize", new Integer(n2), new Integer(n));
        this.bufferSize_ = n;
        this.changes_.firePropertyChange("bufferSize", new Integer(n2), new Integer(n));
    }

    public synchronized boolean setCurrentDirectory(String string) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setCurrentDirectory(), (no leaving entry)");
        }
        return this.cd(string);
    }

    public synchronized void setDataTransferType(int n) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setDataTransferType()");
        }
        if (n == 0 || n == 1) {
            this.connect();
            if (n == 0) {
                this.issueCommand("TYPE A");
            } else {
                this.issueCommand("TYPE I");
            }
        } else {
            throw new IllegalArgumentException("transferType");
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving setDataTransferType()");
        }
    }

    public void setMode(int n) {
        if (n != 10 && n != 11) {
            throw new IllegalArgumentException("mode");
        }
        if (n == 10 && this.activeModeThread_ == null) {
            this.activeModeObject_ = new FTPThread(this);
            this.activeModeThread_ = new Thread(this.activeModeObject_);
            this.activeModeThread_.setDaemon(true);
        }
        this.mode_ = n;
    }

    public synchronized void setPassword(String string) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setPassword(), (no leaving entry)");
        }
        if (string == null) {
            throw new NullPointerException("password");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("password");
        }
        try {
            Date date = new Date();
            Random random = new Random(date.getTime());
            this.mask_ = new byte[7];
            random.nextBytes(this.mask_);
            this.adder_ = new byte[9];
            random.nextBytes(this.adder_);
            this.encryptedPassword_ = this.encode(string.getBytes(), this.mask_, this.adder_);
            this.encrypted_ = true;
        }
        catch (Exception exception) {
            this.encrypted_ = false;
            this.clearPassword_ = string;
        }
    }

    public synchronized void setPort(int n) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setPort()");
        }
        if (n < 1) {
            throw new IllegalArgumentException("port");
        }
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        int n2 = this.port_;
        this.vetos_.fireVetoableChange("port", new Integer(n2), new Integer(n));
        this.port_ = n;
        this.changes_.firePropertyChange("port", new Integer(n2), new Integer(n));
    }

    public void setReuseSocket(boolean bl) {
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        this.reuseSocket_ = bl;
    }

    public synchronized void setServer(String string) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setServer(), (no leaving entry)");
        }
        if (string == null) {
            throw new NullPointerException("server");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("server");
        }
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        String string2 = this.server_;
        this.vetos_.fireVetoableChange("server", string2, string);
        this.server_ = string;
        this.changes_.firePropertyChange("server", string2, string);
    }

    public synchronized void setUser(String string) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getUser(), (no leaving entry)");
        }
        if (string == null) {
            throw new NullPointerException("user");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("user");
        }
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        String string2 = this.user_;
        this.vetos_.fireVetoableChange("user", string2, string);
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.user_ = string;
        this.changes_.firePropertyChange("user", string2, string);
    }

    public synchronized int ren(String string, String string2) throws IOException {
        int n = 0;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering ren(), from file name is " + string + ", to file name is " + string2 + ".");
        }
        if (string == null) {
            throw new NullPointerException("fromName");
        }
        if (string2 == null) {
            throw new NullPointerException("toName");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("fromName");
        }
        if (string2.trim().length() == 0) {
            throw new IllegalArgumentException("toName");
        }
        String[] stringArray = this.ls(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.issueCommand("RNFR " + stringArray[i]);
            if (!this.lastMessage_.startsWith("35")) continue;
            this.issueCommand("RNTO " + FTP.generateNewName(stringArray[i], string2));
            if (!this.lastMessage_.startsWith("25")) continue;
            ++n;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving ren(). renamedCount = " + n);
        }
        return n;
    }

    public static String generateNewName(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("fromName");
        }
        if (string2 == null) {
            throw new NullPointerException("toName");
        }
        if ((string = string.trim()).length() < 1) {
            throw new IllegalArgumentException("fromName");
        }
        if ((string2 = string2.trim()).length() < 1) {
            throw new IllegalArgumentException("toName");
        }
        if (string2.indexOf(42) < 0) {
            return string2;
        }
        if (string2.indexOf(46) < 0) {
            return FTP.newNamePart(string, string2);
        }
        String[] stringArray = FTP.splitName(string, '.');
        String[] stringArray2 = FTP.splitName(string2, '.');
        String string3 = FTP.newNamePart(stringArray[0], stringArray2[0]);
        String string4 = FTP.newNamePart(stringArray[1], stringArray2[1]);
        String string5 = string3;
        if (string4.length() > 0) {
            string5 = string5 + "." + string4;
        }
        return string5;
    }

    static String newNamePart(String string, String string2) {
        int n = string2.indexOf(42);
        if (n < 0) {
            return string2;
        }
        if (n < string2.length() - 1 && string2.indexOf(42, n + 1) > 0) {
            throw new IllegalArgumentException("toName");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(string2.substring(0, n));
        }
        stringBuffer.append(string);
        if (n < string2.length() - 1) {
            stringBuffer.append(string2.substring(n + 1));
        }
        return stringBuffer.toString();
    }

    static String[] splitName(String string, char c) {
        String[] stringArray = new String[2];
        int n = string.lastIndexOf(c);
        if (n >= 0) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = n < string.length() - 1 ? string.substring(n + 1) : "";
        } else {
            stringArray[0] = string;
            stringArray[1] = "";
        }
        return stringArray;
    }

    final Socket getDataSocket() throws IOException {
        String string = this.issueCommand("PASV");
        int n = this.extractPortAddress(string);
        return new Socket(this.server_, n);
    }

    private void checkSocketProperty() {
        String string = SystemProperties.getProperty("com.ibm.as400.access.FTP.reuseSocket");
        if (Trace.traceOn_) {
            Trace.log(1, "FTP.reuseSocket system property: " + string);
        }
        if (string != null) {
            this.reuseSocket_ = string.equalsIgnoreCase("true");
        }
    }
}

