/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDCursor {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int OPEN_READONLY_ = 128;
    private static final int OPEN_ALL_ = 240;
    private static final int FULL_OPEN_ = 1;
    static final int REUSE_NO = 240;
    static final int REUSE_YES = 241;
    static final int REUSE_RESULT_SET = 242;
    private boolean closed_ = true;
    private AS400JDBCConnection connection_;
    private int id_;
    private boolean lazyClose_;
    private String name_;
    private int concurrency_;

    JDCursor(AS400JDBCConnection aS400JDBCConnection, int n, String string, int n2) throws SQLException {
        this.concurrency_ = n2;
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.name_ = string;
        this.lazyClose_ = this.connection_.getProperties().getBoolean(40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(int n) throws SQLException {
        DBSQLRequestDS dBSQLRequestDS = null;
        boolean bl = false;
        try {
            block9: {
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6154, this.id_, 0, 0);
                    dBSQLRequestDS.setReuseIndicator(n);
                    if (this.lazyClose_) {
                        bl = true;
                        this.connection_.sendAndHold(dBSQLRequestDS, this.id_);
                        break block9;
                    }
                    this.connection_.send(dBSQLRequestDS, this.id_);
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException("HY000", dBDataStreamException);
                    Object var6_5 = null;
                    if (dBSQLRequestDS != null && !bl) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                }
            }
            Object var6_4 = null;
            if (dBSQLRequestDS != null && !bl) {
                dBSQLRequestDS.inUse_ = false;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (dBSQLRequestDS != null && !bl) {
                dBSQLRequestDS.inUse_ = false;
            }
            throw throwable;
        }
        this.closed_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Closing with reuse flag = " + n);
            JDTrace.logClose(this);
        }
    }

    String getName() {
        return this.name_;
    }

    int getOpenAttributes(JDSQLStatement jDSQLStatement, String string) throws SQLException {
        int n = 240;
        if (jDSQLStatement == null) {
            n = 128;
        } else if (jDSQLStatement.isProcedureCall()) {
            n = 128;
        } else if (jDSQLStatement.isSelect() && !string.equalsIgnoreCase("0") && (this.connection_.isReadOnly() || !jDSQLStatement.isForUpdate() && this.concurrency_ != 1008)) {
            n = 128;
        }
        if (this.connection_.getProperties().getBoolean(45) && this.connection_.getServerFunctionalLevel() >= 9) {
            n |= 1;
        }
        return n;
    }

    int getConcurrency() {
        return this.concurrency_;
    }

    boolean isClosed() {
        return this.closed_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBDataFormat openDescribe(int n, int n2) throws SQLException {
        DBDataFormat dBDataFormat = null;
        try {
            DBSQLRequestDS dBSQLRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6148, this.id_, -1979711488, 0);
                dBSQLRequestDS.setOpenAttributes(n);
                String string = this.connection_.getProperties().getString(49);
                if (this.connection_.getVRM() <= JDUtilities.vrm520) {
                    dBSQLRequestDS.setScrollableCursorFlag(0);
                } else if (n2 == 1003) {
                    if (string.equalsIgnoreCase("insensitive")) {
                        dBSQLRequestDS.setScrollableCursorFlag(5);
                    } else {
                        dBSQLRequestDS.setScrollableCursorFlag(0);
                    }
                } else if (n2 == 1005) {
                    if (string.equalsIgnoreCase("asensitive")) {
                        dBSQLRequestDS.setScrollableCursorFlag(1);
                    } else {
                        dBSQLRequestDS.setScrollableCursorFlag(3);
                    }
                } else {
                    dBSQLRequestDS.setScrollableCursorFlag(2);
                }
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                int n3 = dBReplyRequestedDS.getErrorClass();
                int n4 = dBReplyRequestedDS.getReturnCode();
                if (n3 != 0) {
                    JDError.throwSQLException(this.connection_, this.id_, n3, n4);
                }
                this.processConcurrencyOverride(n, dBReplyRequestedDS);
                dBDataFormat = dBReplyRequestedDS.getDataFormat();
                Object var10_10 = null;
                if (dBSQLRequestDS != null) {
                    dBSQLRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (dBSQLRequestDS != null) {
                    dBSQLRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        this.closed_ = false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, null);
        }
        return dBDataFormat;
    }

    void processConcurrencyOverride(int n, DBBaseReplyDS dBBaseReplyDS) throws DBDataStreamException {
        DBReplySQLCA dBReplySQLCA = dBBaseReplyDS.getSQLCA();
        switch (dBReplySQLCA.getWarn5()) {
            case -15: 
            case -14: {
                this.concurrency_ = 1007;
                break;
            }
            case -12: {
                this.concurrency_ = 1008;
            }
        }
    }

    void setName(String string) {
        this.name_ = string;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "Name", this.name_);
        }
    }

    void setState(boolean bl) {
        this.closed_ = bl;
        if (JDTrace.isTraceOn()) {
            if (this.closed_) {
                JDTrace.logClose(this);
            } else {
                JDTrace.logOpen(this, null);
            }
        }
    }

    public String toString() {
        return this.name_;
    }
}

