/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.sql.SQLException;
import java.util.Hashtable;

class JDServerRow
implements JDRow {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int[] parameterTypes_;
    private AS400JDBCConnection connection_;
    private int[] ccsids_;
    private int[] dataLength_;
    private int[] dataOffset_;
    private String[] fieldNames_;
    private int[] lobLocatorHandles_;
    private int[] precisions_;
    private byte[] rawBytes_;
    private int rowDataOffset_;
    private int rowIndex_;
    private int[] scales_;
    private DBData serverData_;
    private DBDataFormat serverFormat_;
    private SQLData[] sqlData_;
    private int[] sqlTypes_;
    private boolean[] translated_;
    private boolean wasCompressed = false;
    private Hashtable insensitiveColumnNames_;

    JDServerRow(AS400JDBCConnection aS400JDBCConnection, int n, DBDataFormat dBDataFormat, SQLConversionSettings sQLConversionSettings) throws SQLException {
        this.initialize(aS400JDBCConnection, n, dBDataFormat, sQLConversionSettings);
    }

    byte[] getRawBytes(int n) {
        int n2 = n - 1;
        byte[] byArray = new byte[this.dataLength_[n2]];
        System.arraycopy(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[n2], byArray, 0, this.dataLength_[n2]);
        return byArray;
    }

    private void initialize(AS400JDBCConnection aS400JDBCConnection, int n, DBDataFormat dBDataFormat, SQLConversionSettings sQLConversionSettings) throws SQLException {
        this.connection_ = aS400JDBCConnection;
        this.rawBytes_ = null;
        this.rowDataOffset_ = -1;
        this.rowIndex_ = -1;
        this.serverData_ = null;
        this.serverFormat_ = dBDataFormat;
        try {
            int n2 = this.serverFormat_ == null ? 0 : this.serverFormat_.getNumberOfFields();
            this.ccsids_ = new int[n2];
            this.dataLength_ = new int[n2];
            this.dataOffset_ = new int[n2];
            this.fieldNames_ = new String[n2];
            this.lobLocatorHandles_ = new int[n2];
            this.precisions_ = new int[n2];
            this.scales_ = new int[n2];
            this.sqlData_ = new SQLData[n2];
            this.sqlTypes_ = new int[n2];
            this.translated_ = new boolean[n2];
            this.insensitiveColumnNames_ = null;
            if (n2 > 0) {
                int n3 = 0;
                boolean bl = aS400JDBCConnection.getProperties().getBoolean(28);
                for (int i = 0; i < n2; ++i) {
                    this.ccsids_[i] = this.serverFormat_.getFieldCCSID(i);
                    this.dataOffset_[i] = n3;
                    this.dataLength_[i] = this.serverFormat_.getFieldLength(i);
                    this.lobLocatorHandles_[i] = this.serverFormat_.getFieldLOBLocator(i);
                    n3 += this.dataLength_[i];
                    this.scales_[i] = this.serverFormat_.getFieldScale(i);
                    this.precisions_[i] = this.serverFormat_.getFieldPrecision(i);
                    this.sqlTypes_[i] = this.serverFormat_.getFieldSQLType(i);
                    int n4 = this.serverFormat_.getFieldLOBMaxSize(i);
                    this.sqlData_[i] = SQLDataFactory.newData(aS400JDBCConnection, n, this.sqlTypes_[i] & 0xFFFE, this.dataLength_[i], this.precisions_[i], this.scales_[i], this.ccsids_[i], bl, sQLConversionSettings, n4, i + 1);
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
    }

    void setOriginalData() throws SQLException {
        try {
            int n = 0;
            if (this.serverFormat_ != null) {
                n = this.serverFormat_.getNumberOfFields();
            }
            if (n > 0) {
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    this.dataOffset_[i] = n2;
                    this.dataLength_[i] = this.serverFormat_.getFieldLength(i);
                    n2 += this.dataLength_[i];
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
    }

    void setServerData(DBData dBData) throws SQLException {
        this.serverData_ = dBData;
        try {
            this.rawBytes_ = this.serverData_.getRawBytes();
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
    }

    void setRowIndex(int n) throws SQLException {
        int n2;
        this.rowIndex_ = n;
        try {
            if (this.serverData_ != null) {
                this.rowDataOffset_ = this.serverData_.getRowDataOffset(this.rowIndex_);
                if (this.serverData_.isVariableFieldsCompressed() && this.rowDataOffset_ != -1) {
                    this.wasCompressed = true;
                    n2 = 0;
                    int n3 = this.serverFormat_.getNumberOfFields();
                    for (int i = 0; i < n3; ++i) {
                        String string = this.sqlData_[i].getTypeName();
                        int n4 = 0;
                        this.dataOffset_[i] = n2;
                        if (string.equals("VARCHAR") || string.equals("VARCHAR() FOR BIT DATA") || string.equals("LONG VARCHAR") || string.equals("LONG VARCHAR FOR BIT DATA") || string.equals("VARBINARY") || string.equals("DATALINK")) {
                            n4 = BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.rowDataOffset_ + n2);
                            n4 += 2;
                        } else if (string.equals("VARGRAPHIC") || string.equals("LONG VARGRAPHIC")) {
                            n4 = 2 * BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.rowDataOffset_ + n2);
                            n4 += 2;
                        } else {
                            n4 = this.serverFormat_.getFieldLength(i);
                        }
                        n2 += n4;
                        this.dataLength_[i] = n4;
                    }
                } else if (this.wasCompressed) {
                    this.wasCompressed = false;
                    this.setOriginalData();
                }
            } else {
                this.rowDataOffset_ = -1;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        for (n2 = 0; n2 < this.translated_.length; ++n2) {
            this.translated_[n2] = false;
        }
    }

    public int findField(String string) throws SQLException {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = JDUtilities.stripOuterDoubleQuotes(string);
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                if (!string.equals(this.getFieldName(i))) continue;
                return i;
            }
        } else {
            Integer n;
            String string2;
            if (this.insensitiveColumnNames_ == null) {
                this.insensitiveColumnNames_ = new Hashtable(this.sqlData_.length);
                for (int i = 1; i <= this.sqlData_.length; ++i) {
                    string2 = this.getFieldName(i);
                    this.insensitiveColumnNames_.put(string2, new Integer(i));
                }
            }
            if ((n = (Integer)this.insensitiveColumnNames_.get(string)) != null) {
                return n;
            }
            string2 = string.toUpperCase();
            n = (Integer)this.insensitiveColumnNames_.get(string2);
            if (n != null) {
                this.insensitiveColumnNames_.put(string, n);
                return n;
            }
        }
        JDError.throwSQLException("42703");
        return -1;
    }

    public int getFieldCount() {
        return this.sqlData_.length;
    }

    public int getFieldLOBLocatorHandle(int n) throws SQLException {
        return this.lobLocatorHandles_[n - 1];
    }

    public String getFieldName(int n) throws SQLException {
        try {
            int n2 = n - 1;
            if (this.fieldNames_[n2] == null) {
                this.fieldNames_[n2] = this.serverFormat_.getFieldName(n2, this.connection_.getConverter(this.serverFormat_.getFieldNameCCSID(n2))).trim();
            }
            return this.fieldNames_[n2];
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return null;
        }
    }

    public SQLData getSQLData(int n) throws SQLException {
        try {
            int n2 = n - 1;
            if (this.rowIndex_ >= 0 && !this.translated_[n2]) {
                ConvTable convTable = this.connection_.getConverter(this.ccsids_[n2]);
                if (this.rawBytes_ != null) {
                    this.sqlData_[n2].convertFromRawBytes(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[n2], convTable);
                    this.translated_[n2] = true;
                }
            }
            return this.sqlData_[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return null;
        }
    }

    public SQLData getSQLType(int n) throws SQLException {
        return this.sqlData_[n - 1];
    }

    public boolean isDataMappingError(int n) throws SQLException {
        try {
            return this.serverData_ != null && this.serverData_.getIndicator(this.rowIndex_, n - 1) == -2;
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return false;
        }
    }

    public boolean isNull(int n) throws SQLException {
        try {
            return this.serverData_ != null && this.serverData_.getIndicator(this.rowIndex_, n - 1) == -1;
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return false;
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            return (this.sqlTypes_[n - 1] & 1) != 0 ? 1 : 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return 0;
        }
    }

    public int getCCSID(int n) throws SQLException {
        return this.ccsids_[n - 1];
    }

    public int getLength(int n) throws SQLException {
        return this.dataLength_[n - 1];
    }

    int getRowLength() throws SQLException {
        try {
            return this.serverFormat_.getRecordSize();
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return -1;
        }
    }

    private synchronized void initParmTypes() {
        int n = this.getFieldCount();
        this.parameterTypes_ = new int[n];
        for (int i = 0; i < n; ++i) {
            this.parameterTypes_[i] = -1;
        }
    }

    boolean isInput(int n) throws SQLException {
        int n2;
        if (this.parameterTypes_ == null) {
            this.initParmTypes();
        }
        if (this.parameterTypes_[n2 = n - 1] == -1) {
            try {
                this.parameterTypes_[n2] = this.serverFormat_.getFieldParameterType(n2) & 0xFF;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("07009", dBDataStreamException);
            }
        }
        return this.parameterTypes_[n2] == 240 || this.parameterTypes_[n2] == 242;
    }

    boolean isOutput(int n) throws SQLException {
        int n2;
        if (this.parameterTypes_ == null) {
            this.initParmTypes();
        }
        if (this.parameterTypes_[n2 = n - 1] == -1) {
            try {
                this.parameterTypes_[n2] = this.serverFormat_.getFieldParameterType(n2) & 0xFF;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("07009", dBDataStreamException);
            }
        }
        return this.parameterTypes_[n2] == 241 || this.parameterTypes_[n2] == 242;
    }
}

