/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IntegerHashtable;
import com.ibm.as400.access.JobHashtable;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Product;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class ObjectDescription {
    public static final int ALLOW_CHANGE_BY_PROGRAM = 308;
    public static final int APAR = 413;
    public static final String ASP_NAME_UNKNOWN = "*N";
    public static final int AUDITING = 310;
    public static final String AUDITING_ALL = "*ALL";
    public static final String AUDITING_CHANGE = "*CHANGE";
    public static final String AUDITING_NONE = "*NONE";
    public static final String AUDITING_USER_PROFILE = "*USRPRF";
    public static final int CHANGE_DATE = 305;
    public static final int CHANGED_BY_PROGRAM = 309;
    static final int COMBINATION_200 = 200;
    static final int COMBINATION_300 = 300;
    static final int COMBINATION_400 = 400;
    static final int COMBINATION_500 = 500;
    static final int COMBINATION_600 = 600;
    static final int COMBINATION_700 = 700;
    public static final int COMPILER = 408;
    public static final int COMPRESSION = 307;
    public static final String COMPRESSION_INELIGIBLE = "X";
    public static final String COMPRESSION_NO = "N";
    public static final String COMPRESSION_STORAGE_FREED = "F";
    public static final String COMPRESSION_TEMPORARY = "T";
    public static final String COMPRESSION_YES = "Y";
    public static final int CREATION_DATE = 304;
    public static final int CREATOR_SYSTEM = 406;
    public static final int CREATOR_USER_PROFILE = 405;
    public static final String CURRENT_LIBRARY = "*CURLIB";
    public static final int DAYS_USED = 603;
    public static final int DIGITALLY_SIGNED = 311;
    public static final int DIGITALLY_SIGNED_MULTIPLE = 313;
    public static final int DIGITALLY_SIGNED_TRUSTED = 312;
    public static final int DOMAIN = 303;
    public static final String DOMAIN_SYSTEM = "*S";
    public static final String DOMAIN_USER = "*U";
    public static final int EXTENDED_ATTRIBUTE = 202;
    static final int INFORMATION_STATUS = 201;
    public static final int JOURNAL_STATUS = 513;
    public static final int JOURNAL = 514;
    static final int JOURNAL_LIBRARY = 515;
    public static final int JOURNAL_IMAGES = 516;
    public static final int JOURNAL_OMITTED_ENTRIES = 517;
    public static final int JOURNAL_START_DATE = 518;
    public static final int LAST_USED_DATE = 601;
    public static final int LIBRARY = 10001;
    public static final int LIBRARY_ASP_DEVICE_NAME = 606;
    public static final int LIBRARY_ASP_NUMBER = 314;
    public static final String LIBRARY_LIST = "*LIBL";
    public static final int LICENSED_PROGRAM = 411;
    public static final int NAME = 10000;
    public static final int OBJECT_ASP_DEVICE_NAME = 605;
    public static final int OBJECT_ASP_NUMBER = 301;
    public static final int OBJECT_LEVEL = 409;
    public static final int OBJECT_SIZE = 701;
    static final int OBJECT_SIZE_MULTIPLIER = 702;
    public static final int ORDER_IN_LIBRARY_LIST = 205;
    public static final int OVERFLOWED_ASP = 703;
    public static final int OWNER = 302;
    public static final int PRIMARY_GROUP = 414;
    public static final String PRIMARY_GROUP_NONE = "*NONE";
    public static final int PTF = 412;
    public static final int RESET_DATE = 602;
    public static final int RESTORE_DATE = 502;
    public static final int SAVE_ACTIVE_DATE = 512;
    public static final int SAVE_COMMAND = 506;
    public static final int SAVE_DATE = 501;
    public static final int SAVE_DEVICE = 508;
    public static final String SAVE_DEVICE_DISKETTE = "*DKT";
    public static final String SAVE_DEVICE_NOT_SAVED = "";
    public static final String SAVE_DEVICE_OPTICAL = "*OPT";
    public static final String SAVE_DEVICE_SAVE_FILE = "*SAVF";
    public static final String SAVE_DEVICE_TAPE = "*TAP";
    public static final int SAVE_FILE = 509;
    static final int SAVE_FILE_LIBRARY = 510;
    public static final int SAVE_LABEL = 511;
    public static final int SAVE_SEQUENCE_NUMBER = 505;
    public static final int SAVE_SIZE = 503;
    static final int SAVE_SIZE_MULTIPLIER = 504;
    public static final int SAVE_VOLUME_ID = 507;
    public static final int SOURCE_FILE = 401;
    static final int SOURCE_FILE_LIBRARY = 402;
    static final int SOURCE_FILE_MEMBER = 403;
    public static final int SOURCE_FILE_UPDATED_DATE = 404;
    public static final byte STATUS_DAMAGED = -60;
    public static final byte STATUS_LOCKED = -45;
    public static final byte STATUS_NO_AUTHORITY = -63;
    public static final byte STATUS_NO_ERRORS = 64;
    public static final byte STATUS_PARTIALLY_DAMAGED = -41;
    public static final byte STATUS_UNKNOWN = 0;
    public static final int STORAGE_STATUS = 306;
    public static final String STORAGE_STATUS_FREE = "*FREE";
    public static final String STORAGE_STATUS_KEEP = "*KEEP";
    public static final int SYSTEM_LEVEL = 407;
    public static final String SYSTEM_OR_BASIC_ASP = "*SYSBAS";
    public static final int TEXT_DESCRIPTION = 203;
    public static final int TYPE = 10002;
    public static final int USAGE_INFO_UPDATED = 604;
    public static final int USER_CHANGED = 410;
    public static final int USER_DEFINED_ATTRIBUTE = 204;
    static final IntegerHashtable keyLengths_ = new IntegerHashtable();
    private AS400 system_;
    private String library_;
    private String name_;
    private String type_;
    private byte status_;
    private final JobHashtable values_ = new JobHashtable();

    public ObjectDescription(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
        this.type_ = qSYSObjectPathName.getObjectType();
    }

    public ObjectDescription(AS400 aS400, String string, String string2, String string3) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        if (string3 == null) {
            throw new NullPointerException("type");
        }
        this.system_ = aS400;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, string2, string3);
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
        this.type_ = qSYSObjectPathName.getObjectType();
    }

    ObjectDescription(AS400 aS400, String string, String string2, String string3, byte by) {
        this.system_ = aS400;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, string2, string3);
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
        this.type_ = qSYSObjectPathName.getObjectType();
        this.status_ = by;
    }

    public boolean equals(Object object) {
        try {
            ObjectDescription objectDescription = (ObjectDescription)object;
            if (!objectDescription.getSystem().getSystemName().equals(this.system_.getSystemName())) {
                return false;
            }
            if (!objectDescription.getLibrary().equals(this.library_)) {
                return false;
            }
            if (!objectDescription.getName().equals(this.name_)) {
                return false;
            }
            return objectDescription.getType().equals(this.type_);
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, exception);
            }
            return false;
        }
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            this.refresh();
        }
        catch (AS400Exception aS400Exception) {
            String string = aS400Exception.getAS400Message().getID().trim();
            if (string.equalsIgnoreCase("CPF9801") || string.equalsIgnoreCase("CPF9810") || string.equalsIgnoreCase("CPF9812")) {
                return false;
            }
            throw aS400Exception;
        }
        return true;
    }

    private final Date getDate(Object object) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (object instanceof String) {
            String string = ((String)object).trim();
            switch (string.length()) {
                case 7: {
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)));
                    return calendar.getTime();
                }
                case 13: {
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(7, 9)), Integer.parseInt(string.substring(9, 11)), Integer.parseInt(string.substring(11, 13)));
                    return calendar.getTime();
                }
            }
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            DateTimeConverter dateTimeConverter = new DateTimeConverter(this.system_);
            return dateTimeConverter.convert(byArray, "*DTS");
        }
        return null;
    }

    public String getLibrary() {
        return this.library_;
    }

    public String getName() {
        return this.name_;
    }

    public String getPath() {
        return QSYSObjectPathName.toPath(this.library_, this.name_, this.type_);
    }

    public byte getStatus() {
        return this.status_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getType() {
        return this.type_;
    }

    public Object getValue(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        switch (n) {
            case 10000: {
                return this.getName();
            }
            case 10001: {
                return this.getLibrary();
            }
            case 10002: {
                return this.getType();
            }
        }
        Object object = this.values_.get(n);
        if (object == null) {
            if (n == 205) {
                return new Integer(-1);
            }
            this.retrieve(n);
            object = this.values_.get(n);
        }
        switch (n) {
            case 304: 
            case 305: 
            case 404: 
            case 501: 
            case 502: 
            case 512: 
            case 518: 
            case 601: 
            case 602: {
                return this.getDate(object);
            }
            case 514: {
                String string = (String)object;
                if (string.length() > 0) {
                    String string2 = (String)this.getValue(515);
                    return QSYSObjectPathName.toPath(string2, string, "JRN");
                }
                return string;
            }
            case 509: {
                String string = (String)object;
                if (string.length() > 0) {
                    String string3 = (String)this.getValue(510);
                    return QSYSObjectPathName.toPath(string3, string, "SAVF");
                }
                return string;
            }
            case 401: {
                String string = (String)object;
                if (string.length() > 0) {
                    String string4 = (String)this.getValue(402);
                    String string5 = (String)this.getValue(403);
                    return QSYSObjectPathName.toPath(string4, string, string5, "MBR");
                }
                return string;
            }
            case 701: {
                long l = ((Integer)this.getValue(702)).longValue();
                long l2 = ((Integer)object).longValue();
                return new Long(l * l2);
            }
            case 503: {
                long l = ((Integer)this.getValue(504)).longValue();
                long l3 = ((Integer)object).longValue();
                return new Long(l * l3);
            }
            case 408: 
            case 411: {
                String string = (String)object;
                if (string.length() == 0) {
                    return null;
                }
                if (string.length() < 16) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "Disregarding COMPILER attribute value in nonstandard format: " + string);
                    }
                    return null;
                }
                String string6 = string.substring(0, 7);
                StringBuffer stringBuffer = new StringBuffer(6);
                stringBuffer.append('V');
                stringBuffer.append(Integer.parseInt(string.substring(8, 2)));
                stringBuffer.append('R');
                stringBuffer.append(Integer.parseInt(string.substring(11, 2)));
                stringBuffer.append('M');
                stringBuffer.append(Integer.parseInt(string.substring(14, 2)));
                return new Product(this.system_, string6, "*BASE", stringBuffer.toString(), "*CODE");
            }
            case 308: 
            case 309: 
            case 311: 
            case 312: 
            case 313: 
            case 410: 
            case 513: 
            case 516: 
            case 703: {
                return new Boolean(((String)object).charAt(0) == '1');
            }
            case 604: {
                return new Boolean(((String)object).charAt(0) == 'Y');
            }
            case 517: {
                return new Boolean(((String)object).charAt(0) == '0');
            }
        }
        return object;
    }

    public String getValueAsString(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n == 408) {
            String string;
            Object object = this.values_.get(n);
            if (object == null) {
                if (n == 205) {
                    return "-1";
                }
                this.retrieve(n);
                object = this.values_.get(n);
            }
            if ((string = (String)object).length() == 0) {
                return null;
            }
            return string;
        }
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    private static final int lookupFormat(int n) {
        switch (n) {
            case 202: 
            case 203: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 401: 
            case 402: 
            case 403: 
            case 10000: 
            case 10001: 
            case 10002: {
                return 200;
            }
            case 306: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 501: 
            case 502: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 602: {
                return 300;
            }
            case 204: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 414: 
            case 503: 
            case 504: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 601: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 701: 
            case 702: 
            case 703: {
                return 400;
            }
        }
        throw new ExtendedIllegalArgumentException("attribute", 2);
    }

    private static final int lookupSize(int n) {
        switch (n) {
            case 100: {
                return 90;
            }
            case 200: {
                return 180;
            }
            case 300: {
                return 460;
            }
            case 400: {
                return 598;
            }
        }
        return 0;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(313);
    }

    private void retrieve(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n2;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        int n3 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n3, null);
        int n4 = ObjectDescription.lookupFormat(n);
        int n5 = ObjectDescription.lookupSize(n4);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(n5);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n5));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("OBJD0" + n4));
        byte[] byArray = new byte[20];
        AS400Text aS400Text = new AS400Text(10, n3, this.system_);
        aS400Text.toBytes(this.name_, byArray, 0);
        aS400Text.toBytes(this.library_, byArray, 10);
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(aS400Text.toBytes("*" + this.type_));
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QUSROBJD.PGM", programParameterArray);
        if (!ProgramCall.isThreadSafetyPropertySet()) {
            programCall.setThreadSafe(true);
        }
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray2 = programParameterArray[0].getOutputData();
        int n6 = BinaryConverter.byteArrayToInt(byArray2, 0);
        if (n6 < (n2 = BinaryConverter.byteArrayToInt(byArray2, 4))) {
            try {
                int n7 = n5 + (n2 - n6);
                if (Trace.traceOn_) {
                    Trace.log(1, "Calling QUSROBJD again with new parm size: " + n7);
                }
                programParameterArray[0].setOutputDataLength(n7);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n7));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray2 = programParameterArray[0].getOutputData();
        }
        this.name_ = convTable.byteArrayToString(byArray2, 8, 10).trim();
        this.type_ = convTable.byteArrayToString(byArray2, 28, 10).trim().substring(1);
        this.library_ = convTable.byteArrayToString(byArray2, 38, 10).trim();
        this.set(301, BinaryConverter.byteArrayToInt(byArray2, 48));
        this.set(302, convTable.byteArrayToString(byArray2, 52, 10).trim());
        this.set(303, convTable.byteArrayToString(byArray2, 62, 2));
        this.set(304, convTable.byteArrayToString(byArray2, 64, 13));
        this.set(305, convTable.byteArrayToString(byArray2, 77, 13));
        if (n4 >= 200) {
            this.set(202, convTable.byteArrayToString(byArray2, 90, 10).trim());
            this.set(203, convTable.byteArrayToString(byArray2, 100, 50).trim());
            this.set(401, convTable.byteArrayToString(byArray2, 150, 10).trim());
            this.set(402, convTable.byteArrayToString(byArray2, 160, 10).trim());
            this.set(403, convTable.byteArrayToString(byArray2, 170, 10).trim());
        }
        if (n4 >= 300) {
            this.set(404, convTable.byteArrayToString(byArray2, 180, 13));
            this.set(501, convTable.byteArrayToString(byArray2, 193, 13));
            this.set(502, convTable.byteArrayToString(byArray2, 206, 13));
            this.set(405, convTable.byteArrayToString(byArray2, 219, 10).trim());
            this.set(406, convTable.byteArrayToString(byArray2, 229, 8).trim());
            this.set(602, convTable.byteArrayToString(byArray2, 237, 7));
            this.set(505, BinaryConverter.byteArrayToInt(byArray2, 248));
            this.set(306, convTable.byteArrayToString(byArray2, 252, 10).trim());
            this.set(506, convTable.byteArrayToString(byArray2, 262, 10).trim());
            this.set(507, convTable.byteArrayToString(byArray2, 272, 71));
            this.set(508, convTable.byteArrayToString(byArray2, 343, 10).trim());
            this.set(509, convTable.byteArrayToString(byArray2, 353, 10).trim());
            this.set(510, convTable.byteArrayToString(byArray2, 363, 10).trim());
            this.set(511, convTable.byteArrayToString(byArray2, 373, 17).trim());
            this.set(407, convTable.byteArrayToString(byArray2, 390, 9));
            this.set(408, convTable.byteArrayToString(byArray2, 399, 16).trim());
            this.set(409, convTable.byteArrayToString(byArray2, 415, 8).trim());
            this.set(410, convTable.byteArrayToString(byArray2, 423, 1));
            this.set(411, convTable.byteArrayToString(byArray2, 424, 16).trim());
            this.set(412, convTable.byteArrayToString(byArray2, 440, 10).trim());
            this.set(413, convTable.byteArrayToString(byArray2, 450, 10).trim());
        }
        if (n4 >= 400) {
            this.set(601, convTable.byteArrayToString(byArray2, 460, 7).trim());
            this.set(604, convTable.byteArrayToString(byArray2, 467, 1));
            this.set(603, BinaryConverter.byteArrayToInt(byArray2, 468));
            this.set(701, BinaryConverter.byteArrayToInt(byArray2, 472));
            this.set(702, BinaryConverter.byteArrayToInt(byArray2, 476));
            this.set(307, convTable.byteArrayToString(byArray2, 480, 1));
            this.set(308, convTable.byteArrayToString(byArray2, 481, 1));
            this.set(309, convTable.byteArrayToString(byArray2, 482, 1));
            this.set(204, convTable.byteArrayToString(byArray2, 483, 10).trim());
            this.set(703, convTable.byteArrayToString(byArray2, 493, 1));
            this.set(512, convTable.byteArrayToString(byArray2, 494, 13));
            this.set(310, convTable.byteArrayToString(byArray2, 507, 10).trim());
            this.set(414, convTable.byteArrayToString(byArray2, 517, 10).trim());
            this.set(513, convTable.byteArrayToString(byArray2, 527, 1));
            this.set(514, convTable.byteArrayToString(byArray2, 528, 10).trim());
            this.set(515, convTable.byteArrayToString(byArray2, 538, 10).trim());
            this.set(516, convTable.byteArrayToString(byArray2, 548, 1));
            this.set(517, convTable.byteArrayToString(byArray2, 549, 1));
            this.set(518, convTable.byteArrayToString(byArray2, 550, 13).trim());
            this.set(311, convTable.byteArrayToString(byArray2, 563, 1));
            this.set(503, BinaryConverter.byteArrayToInt(byArray2, 564));
            this.set(504, BinaryConverter.byteArrayToInt(byArray2, 568));
            this.set(314, BinaryConverter.byteArrayToInt(byArray2, 572));
            this.set(605, convTable.byteArrayToString(byArray2, 576, 10).trim());
            this.set(606, convTable.byteArrayToString(byArray2, 586, 10).trim());
            this.set(312, convTable.byteArrayToString(byArray2, 596, 1));
            this.set(313, convTable.byteArrayToString(byArray2, 597, 1));
        }
    }

    void set(int n, int n2) {
        this.values_.put(n, new Integer(n2));
    }

    void set(int n, long l) {
        this.values_.put(n, new Long(l));
    }

    void set(int n, boolean bl) {
        this.values_.put(n, new Boolean(bl));
    }

    void set(int n, Object object) {
        this.values_.put(n, object);
    }

    public String toString() {
        return this.getPath();
    }

    static {
        keyLengths_.put(200, 80);
        keyLengths_.put(201, 1);
        keyLengths_.put(202, 10);
        keyLengths_.put(203, 50);
        keyLengths_.put(204, 10);
        keyLengths_.put(205, 4);
        keyLengths_.put(300, 144);
        keyLengths_.put(301, 4);
        keyLengths_.put(302, 10);
        keyLengths_.put(303, 2);
        keyLengths_.put(304, 8);
        keyLengths_.put(305, 8);
        keyLengths_.put(306, 10);
        keyLengths_.put(307, 1);
        keyLengths_.put(308, 1);
        keyLengths_.put(309, 1);
        keyLengths_.put(310, 10);
        keyLengths_.put(311, 1);
        keyLengths_.put(312, 1);
        keyLengths_.put(313, 1);
        keyLengths_.put(314, 4);
        keyLengths_.put(400, 296);
        keyLengths_.put(401, 10);
        keyLengths_.put(402, 10);
        keyLengths_.put(403, 10);
        keyLengths_.put(404, 13);
        keyLengths_.put(405, 10);
        keyLengths_.put(406, 8);
        keyLengths_.put(407, 9);
        keyLengths_.put(408, 16);
        keyLengths_.put(409, 8);
        keyLengths_.put(410, 1);
        keyLengths_.put(411, 16);
        keyLengths_.put(412, 10);
        keyLengths_.put(413, 10);
        keyLengths_.put(414, 10);
        keyLengths_.put(500, 504);
        keyLengths_.put(501, 8);
        keyLengths_.put(502, 8);
        keyLengths_.put(503, 4);
        keyLengths_.put(504, 4);
        keyLengths_.put(505, 4);
        keyLengths_.put(506, 10);
        keyLengths_.put(507, 71);
        keyLengths_.put(508, 10);
        keyLengths_.put(509, 10);
        keyLengths_.put(510, 10);
        keyLengths_.put(511, 17);
        keyLengths_.put(512, 8);
        keyLengths_.put(513, 1);
        keyLengths_.put(514, 10);
        keyLengths_.put(515, 10);
        keyLengths_.put(516, 1);
        keyLengths_.put(517, 1);
        keyLengths_.put(518, 8);
        keyLengths_.put(600, 548);
        keyLengths_.put(601, 8);
        keyLengths_.put(602, 8);
        keyLengths_.put(603, 4);
        keyLengths_.put(604, 1);
        keyLengths_.put(605, 10);
        keyLengths_.put(606, 10);
        keyLengths_.put(700, 560);
        keyLengths_.put(701, 4);
        keyLengths_.put(702, 4);
        keyLengths_.put(703, 1);
    }
}

