/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTFGroup;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroupList {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private AS400 system_;

    public PTFGroupList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(aS400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getPTFGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[4];
        programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray("JT4PTF    QTEMP     "));
        try {
            programParameterArray[0].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[1] = new ProgramParameter(convTable.stringToByteArray("LSTG0100"));
        try {
            programParameterArray[1].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[2] = new ProgramParameter(BinaryConverter.intToByteArray(n));
        try {
            programParameterArray[2].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[3] = new ProgramParameter(new byte[4]);
        try {
            programParameterArray[3].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroups", 0, programParameterArray);
        byte[] byArray = null;
        String string = "JT4PTF    QTEMP     ";
        synchronized ("JT4PTF    QTEMP     ") {
            int n2;
            UserSpace userSpace = new UserSpace(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC");
            userSpace.setMustUseProgramCall(true);
            userSpace.create(262144, true, "", (byte)0, "User space for PTF Group list", "*EXCLUDE");
            try {
                serviceProgramCall.setThreadSafe(true);
                if (!serviceProgramCall.run()) {
                    throw new AS400Exception(serviceProgramCall.getMessageList());
                }
                n2 = userSpace.getLength();
                byArray = new byte[n2];
                userSpace.read(byArray, 0);
            }
            finally {
                userSpace.close();
            }
            // ** MonitorExit[var6_10] (shouldn't be in output)
            int n3 = BinaryConverter.byteArrayToInt(byArray, 124);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 132);
            n2 = BinaryConverter.byteArrayToInt(byArray, 136);
            int n5 = BinaryConverter.byteArrayToInt(byArray, 140);
            convTable = ConvTable.getTable(n5, null);
            int n6 = 0;
            PTFGroup[] pTFGroupArray = new PTFGroup[n4];
            for (int i = 0; i < n4; ++i) {
                n6 = n3 + i * n2;
                String string2 = convTable.byteArrayToString(byArray, n6, 60);
                String string3 = convTable.byteArrayToString(byArray, n6 += 60, 100);
                int n7 = BinaryConverter.byteArrayToInt(byArray, n6 += 100);
                int n8 = BinaryConverter.byteArrayToInt(byArray, n6 += 4);
                n6 += 4;
                pTFGroupArray[i] = new PTFGroup(this.system_, string2, string3, n7, n8);
            }
            return pTFGroupArray;
        }
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public AS400 getSystem() {
        return this.system_;
    }
}

