/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessDLO
extends PermissionAccess {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    public PermissionAccessDLO(AS400 aS400) {
        super(aS400);
    }

    public void addUser(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessDLO.getAddCommand(this.as400_, string.toUpperCase(), userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    protected final String expandQuotes(String string) {
        return PermissionAccessDLO.expandQuotes0(string);
    }

    static String expandQuotes0(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.indexOf(39) != -1) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (stringBuffer.charAt(i) != '\'') continue;
                stringBuffer.insert(i, '\'');
            }
        }
        stringBuffer.insert(0, '\'');
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    private static CommandCall getAddCommand(AS400 aS400, String string, UserPermission userPermission) {
        DLOPermission dLOPermission = (DLOPermission)userPermission;
        String string2 = dLOPermission.getUserID();
        String string3 = dLOPermission.getDataAuthority();
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, aS400.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
        }
        int n = string.indexOf(47, 1);
        int n2 = string.lastIndexOf(47);
        String string4 = string.substring(n2 + 1);
        String string5 = n + 1 < n2 ? string.substring(n + 1, n2) : "*NONE";
        String string6 = "ADDDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string4) + ")" + " FLR('" + string5 + "')" + " USRAUT((" + string2 + " " + string3 + "))";
        CommandCall commandCall = new CommandCall(aS400, string6);
        return commandCall;
    }

    private static CommandCall getChgCommand(AS400 aS400, String string, UserPermission userPermission) {
        DLOPermission dLOPermission = (DLOPermission)userPermission;
        String string2 = dLOPermission.getUserID();
        String string3 = dLOPermission.getDataAuthority();
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, aS400.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
        }
        int n = string.indexOf(47, 1);
        int n2 = string.lastIndexOf(47);
        String string4 = string.substring(n2 + 1);
        String string5 = n + 1 < n2 ? string.substring(n + 1, n2) : "*NONE";
        String string6 = "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string4) + ")" + " FLR('" + string5 + "')" + " USRAUT((" + string2 + " " + string3 + "))";
        CommandCall commandCall = new CommandCall(aS400, string6);
        return commandCall;
    }

    private static CommandCall getRmvCommand(AS400 aS400, String string, String string2) {
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, aS400.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
        }
        int n = string.indexOf(47, 1);
        int n2 = string.lastIndexOf(47);
        String string3 = string.substring(n2 + 1);
        String string4 = n + 1 < n2 ? string.substring(n + 1, n2) : "*NONE";
        String string5 = "RMVDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string3) + ")" + " FLR('" + string4 + "')" + " USER((" + string2 + "))";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    public UserPermission getUserPermission(Record record) throws UnsupportedEncodingException {
        String string = ((String)record.getField("profileName")).trim();
        String string2 = ((String)record.getField("userOrGroup")).trim();
        String string3 = ((String)record.getField("dataAuthority")).trim();
        String string4 = ((String)record.getField("autListMgt")).trim();
        String string5 = ((String)record.getField("objMgt")).trim();
        String string6 = ((String)record.getField("objExistence")).trim();
        String string7 = ((String)record.getField("objAlter")).trim();
        String string8 = ((String)record.getField("objRef")).trim();
        String string9 = ((String)record.getField("objOperational")).trim();
        String string10 = ((String)record.getField("dataRead")).trim();
        String string11 = ((String)record.getField("dataAdd")).trim();
        String string12 = ((String)record.getField("dataUpdate")).trim();
        String string13 = ((String)record.getField("dataDelete")).trim();
        String string14 = ((String)record.getField("dataExecute")).trim();
        DLOPermission dLOPermission = new DLOPermission(string);
        dLOPermission.setGroupIndicator(this.getIntValue(string2));
        dLOPermission.setAuthorizationListManagement(this.getBooleanValue(string4));
        dLOPermission.setManagement(this.getBooleanValue(string5));
        dLOPermission.setExistence(this.getBooleanValue(string6));
        dLOPermission.setAlter(this.getBooleanValue(string7));
        dLOPermission.setReference(this.getBooleanValue(string8));
        dLOPermission.setOperational(this.getBooleanValue(string9));
        dLOPermission.setRead(this.getBooleanValue(string10));
        dLOPermission.setAdd(this.getBooleanValue(string11));
        dLOPermission.setUpdate(this.getBooleanValue(string12));
        dLOPermission.setDelete(this.getBooleanValue(string13));
        dLOPermission.setExecute(this.getBooleanValue(string14));
        if (string3.toUpperCase().equals("*AUTL")) {
            dLOPermission.setFromAuthorizationList(true);
        }
        return dLOPermission;
    }

    public void removeUser(String string, String string2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessDLO.getRmvCommand(this.as400_, string.toUpperCase(), string2);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthority(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessDLO.getChgCommand(this.as400_, string.toUpperCase(), userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthorizationList(String string, String string2, String string3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        string = string.toUpperCase();
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
        }
        int n = string.indexOf(47, 1);
        int n2 = string.lastIndexOf(47);
        String string4 = string.substring(n2 + 1);
        String string5 = n + 1 < n2 ? string.substring(n + 1, n2) : "*NONE";
        CommandCall commandCall = new CommandCall(this.as400_);
        String string6 = string2.toUpperCase().equals("*NONE") ? "RMVDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string4) + ")" + " FLR('" + string5 + "')" + " AUTL(" + string3 + ")" : "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string4) + ")" + " FLR('" + string5 + "')" + " AUTL(" + string2 + ")";
        commandCall.setCommand(string6);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setFromAuthorizationList(String string, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        string = string.toUpperCase();
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
        }
        int n = string.indexOf(47, 1);
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(n2 + 1);
        String string3 = n + 1 < n2 ? string.substring(n + 1, n2) : "*NONE";
        CommandCall commandCall = new CommandCall(this.as400_);
        String string4 = "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string2) + ")" + " FLR('" + string3 + "')" + " USRAUT((*PUBLIC *AUTL))";
        commandCall.setCommand(string4);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public void setPrimaryGroup(String string, String string2, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        super.setPrimaryGroup(string, string2, bl);
    }

    public void setOwner(String string, String string2, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        super.setOwner(string, string2, bl);
    }

    public synchronized void setSensitivity(String string, int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        string = string.toUpperCase();
        try {
            string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
        }
        int n2 = string.indexOf(47, 1);
        int n3 = string.lastIndexOf(47);
        String string2 = string.substring(n3 + 1);
        String string3 = n2 + 1 < n3 ? string.substring(n2 + 1, n3) : "*NONE";
        CommandCall commandCall = new CommandCall(this.as400_);
        String string4 = "";
        switch (n) {
            case 1: {
                string4 = "*NONE";
                break;
            }
            case 2: {
                string4 = "*PERSONAL";
                break;
            }
            case 3: {
                string4 = "*PRIVATE";
                break;
            }
            case 4: {
                string4 = "*CONFIDENTIAL";
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("sensitivity", 2);
            }
        }
        String string5 = "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(string2) + ")" + " FLR('" + string3 + "')" + " SENSITIV(" + string4 + ")";
        commandCall.setCommand(string5);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }
}

