/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Array;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ArrayFieldDescription;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.RecordDescriptionEvent;
import com.ibm.as400.access.RecordDescriptionListener;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Record
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private byte[] as400Data_;
    private FieldDescription[] fieldDescriptions_;
    private Object[] fields_;
    private int[] fieldOffsets_;
    private boolean hasDependentFields_;
    private boolean[] isConvertedToJava_;
    private boolean[] isConvertedToAS400_;
    private String name_ = "";
    private boolean[] nullFieldMap_;
    private transient PropertyChangeSupport changes_;
    private RecordFormat recordFormat_ = null;
    int recordLength_;
    int recordNumber_;
    Object[] returnFields_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector recordDescriptionListeners_;

    public Record() {
        this.initializeTransient();
    }

    public Record(RecordFormat recordFormat) {
        this.initializeTransient();
        this.initializeRecord(recordFormat);
    }

    public Record(RecordFormat recordFormat, String string) {
        this(recordFormat);
        if (string == null) {
            throw new NullPointerException("recordName");
        }
        this.name_ = string;
    }

    public Record(RecordFormat recordFormat, byte[] byArray) throws UnsupportedEncodingException {
        this(recordFormat, byArray, 0);
    }

    public Record(RecordFormat recordFormat, byte[] byArray, String string) throws UnsupportedEncodingException {
        this(recordFormat, byArray, 0, string);
    }

    public Record(RecordFormat recordFormat, byte[] byArray, int n) throws UnsupportedEncodingException {
        this.initializeTransient();
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (recordFormat.getNumberOfFields() == 0) {
            throw new ExtendedIllegalArgumentException("recordFormat", 2);
        }
        if (byArray == null) {
            throw new NullPointerException("contents");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        this.recordFormat_ = recordFormat;
        this.fieldDescriptions_ = recordFormat.getFieldDescriptions();
        this.hasDependentFields_ = this.recordFormat_.getHasDependentFields();
        this.fields_ = new Object[this.fieldDescriptions_.length];
        this.returnFields_ = new Object[this.fieldDescriptions_.length];
        this.fieldOffsets_ = new int[this.fieldDescriptions_.length];
        this.isConvertedToJava_ = new boolean[this.fieldDescriptions_.length];
        this.isConvertedToAS400_ = new boolean[this.fieldDescriptions_.length];
        this.nullFieldMap_ = new boolean[this.fields_.length];
        FieldDescription fieldDescription = null;
        int n2 = 0;
        int n3 = 0;
        this.recordLength_ = 0;
        for (int i = 0; i < this.fields_.length; ++i) {
            fieldDescription = this.fieldDescriptions_[i];
            this.fieldOffsets_[i] = n2;
            if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                n2 += 2;
                this.recordLength_ += 2;
            }
            n3 = fieldDescription.getDataType().getByteLength();
            n2 += n3;
            this.recordLength_ += n3;
            if (!this.hasDependentFields_) {
                this.isConvertedToAS400_[i] = true;
            }
            this.isConvertedToJava_[i] = false;
        }
        this.as400Data_ = new byte[this.recordLength_];
        if (!this.hasDependentFields_) {
            try {
                System.arraycopy(byArray, n, this.as400Data_, 0, this.as400Data_.length);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                for (int i = 0; i < this.isConvertedToAS400_.length; ++i) {
                    this.isConvertedToAS400_[i] = false;
                }
                throw arrayIndexOutOfBoundsException;
            }
        } else {
            this.setContents(byArray, n);
        }
    }

    public Record(RecordFormat recordFormat, byte[] byArray, int n, String string) throws UnsupportedEncodingException {
        this(recordFormat, byArray, n);
        if (string == null) {
            throw new NullPointerException("recordName");
        }
        this.name_ = string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addRecordDescriptionListener(RecordDescriptionListener recordDescriptionListener) {
        if (recordDescriptionListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.recordDescriptionListeners_ == null) {
            this.recordDescriptionListeners_ = new Vector();
        }
        this.recordDescriptionListeners_.addElement(recordDescriptionListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public boolean equals(Object object) {
        block8: {
            try {
                Record record = (Record)object;
                if (record.recordLength_ == this.recordLength_ && record.recordNumber_ == this.recordNumber_ && record.hasDependentFields_ == this.hasDependentFields_ && (record.name_ == null ? this.name_ == null : record.name_.equals(this.name_))) {
                    int n;
                    int n2 = this.getNumberOfFields();
                    if (n2 == (n = record.getNumberOfFields())) {
                        int n3;
                        int n4 = this.getNumberOfKeyFields();
                        if (n4 == (n3 = this.getNumberOfKeyFields())) {
                            for (int i = 0; i < n2; ++i) {
                                Object object2 = this.getField(i);
                                Object object3 = record.getField(i);
                                if (object2 == null) {
                                    if (object3 == null) continue;
                                    return false;
                                }
                                if (object3 == null) {
                                    return false;
                                }
                                if (object2.equals(object3)) continue;
                                return false;
                            }
                            break block8;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    private void fireFieldModifiedEvent() {
        if (this.recordDescriptionListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.recordDescriptionListeners_.clone();
        RecordDescriptionEvent recordDescriptionEvent = new RecordDescriptionEvent(this, 3);
        for (int i = 0; i < vector.size(); ++i) {
            RecordDescriptionListener recordDescriptionListener = (RecordDescriptionListener)vector.elementAt(i);
            recordDescriptionListener.fieldModified(recordDescriptionEvent);
        }
    }

    public byte[] getContents() throws CharConversionException, UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (this.hasDependentFields_) {
            int n = 0;
            Trace.log(3, "recordLength_: " + String.valueOf(this.recordLength_));
            byte[] byArray = new byte[this.recordLength_];
            for (int i = 0; i < this.fields_.length; ++i) {
                FieldDescription fieldDescription = this.fieldDescriptions_[i];
                if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                    int n2 = this.fields_[i] == null ? 0 : (fieldDescription instanceof HexFieldDescription ? ((byte[])this.fields_[i]).length : ((String)this.fields_[i]).length());
                    BinaryConverter.unsignedShortToByteArray(n2, byArray, n);
                    n += 2;
                }
                AS400DataType aS400DataType = fieldDescription.getDataType();
                if (this.fields_[i] != null) {
                    n += aS400DataType.toBytes(this.fields_[i], byArray, n);
                    continue;
                }
                n += aS400DataType.toBytes(aS400DataType.getDefaultValue(), byArray, n);
            }
            return byArray;
        }
        return this.as400Data_;
    }

    public void getContents(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        outputStream.write(this.getContents());
    }

    public Object getField(int n) throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (n < 0 || n > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        if (this.isConvertedToJava_[n]) {
            return this.fields_[n];
        }
        FieldDescription fieldDescription = this.fieldDescriptions_[n];
        AS400DataType aS400DataType = fieldDescription.getDataType();
        int n2 = this.fieldOffsets_[n];
        if (fieldDescription instanceof VariableLengthFieldDescription) {
            if (((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                int n3 = BinaryConverter.byteArrayToUnsignedShort(this.as400Data_, n2);
                n2 += 2;
                if (fieldDescription instanceof HexFieldDescription) {
                    byte[] byArray = new byte[n3];
                    System.arraycopy(this.as400Data_, n2, byArray, 0, n3);
                    this.fields_[n] = byArray;
                } else {
                    ConverterImpl converterImpl = ((AS400Text)aS400DataType).getConverter();
                    this.fields_[n] = converterImpl.byteArrayToString(this.as400Data_, n2, n3);
                }
            } else {
                this.fields_[n] = aS400DataType.toObject(this.as400Data_, n2);
            }
        } else {
            this.fields_[n] = aS400DataType.toObject(this.as400Data_, n2);
        }
        if (this.recordDescriptionListeners_ != null) {
            this.fireFieldModifiedEvent();
        }
        this.isConvertedToJava_[n] = true;
        return this.fields_[n];
    }

    public Object getField(String string) throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.getField(this.recordFormat_.getIndexOfFieldName(string));
    }

    public byte[] getFieldAsBytes(int n) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (n < 0 || n > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        if (this.hasDependentFields_) {
            int n4 = 0;
            for (int i = 0; i <= n; ++i) {
                n2 = n4;
                FieldDescription fieldDescription = this.fieldDescriptions_[i];
                AS400DataType aS400DataType = fieldDescription.getDataType();
                n3 = aS400DataType.getByteLength();
                int n5 = this.recordFormat_.getLengthDependency(i);
                int n6 = this.recordFormat_.getOffsetDependency(i);
                if (n6 != -1) {
                    n2 = ((Number)this.fields_[n6]).intValue();
                }
                if (n5 != -1) {
                    n3 = ((Number)this.fields_[n5]).intValue();
                }
                if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                    n3 += 2;
                }
                n4 = n2 + n3;
            }
        } else {
            n2 = this.fieldOffsets_[n];
            FieldDescription fieldDescription = this.fieldDescriptions_[n];
            AS400DataType aS400DataType = fieldDescription.getDataType();
            n3 = aS400DataType.getByteLength();
            if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                n3 += 2;
            }
        }
        byArray = new byte[n3];
        System.arraycopy(this.as400Data_, n2, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getFieldAsBytes(String string) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.getFieldAsBytes(this.recordFormat_.getIndexOfFieldName(string));
    }

    public Object[] getFields() throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            return new Object[0];
        }
        for (int i = 0; i < this.fields_.length; ++i) {
            this.returnFields_[i] = this.getField(i);
        }
        return this.returnFields_;
    }

    public Object[] getKeyFields() throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[this.recordFormat_.getNumberOfKeyFields()];
        String[] stringArray = this.recordFormat_.getKeyFieldNames();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getField(stringArray[i]);
        }
        return objectArray;
    }

    public byte[] getKeyFieldsAsBytes() {
        if (this.recordFormat_ == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String[] stringArray = this.recordFormat_.getKeyFieldNames();
        AS400DataType aS400DataType = null;
        FieldDescription fieldDescription = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.recordFormat_.getIndexOfFieldName(stringArray[i]);
            fieldDescription = this.fieldDescriptions_[n];
            aS400DataType = fieldDescription.getDataType();
            int n2 = aS400DataType.getByteLength();
            if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                n2 += 2;
            }
            byteArrayOutputStream.write(this.as400Data_, this.fieldOffsets_[n], n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getNumberOfFields() {
        return this.recordFormat_ == null ? 0 : this.fields_.length;
    }

    public int getNumberOfKeyFields() {
        return this.recordFormat_ == null ? 0 : this.recordFormat_.getNumberOfKeyFields();
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public int getRecordLength() {
        return this.recordLength_;
    }

    public String getRecordName() {
        return this.name_;
    }

    public int getRecordNumber() {
        return this.recordNumber_;
    }

    public int hashCode() {
        return this.recordNumber_ == 0 ? this.recordLength_ : this.recordNumber_;
    }

    private void initializeRecord(RecordFormat recordFormat) {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (recordFormat.getNumberOfFields() == 0) {
            throw new ExtendedIllegalArgumentException("recordFormat", 2);
        }
        this.recordFormat_ = recordFormat;
        this.fieldDescriptions_ = recordFormat.getFieldDescriptions();
        this.hasDependentFields_ = this.recordFormat_.getHasDependentFields();
        this.fields_ = new Object[this.fieldDescriptions_.length];
        this.returnFields_ = new Object[this.fieldDescriptions_.length];
        this.fieldOffsets_ = new int[this.fieldDescriptions_.length];
        this.isConvertedToJava_ = new boolean[this.fieldDescriptions_.length];
        this.isConvertedToAS400_ = new boolean[this.fieldDescriptions_.length];
        this.nullFieldMap_ = new boolean[this.fieldDescriptions_.length];
        FieldDescription fieldDescription = null;
        AS400DataType aS400DataType = null;
        byte[] byArray = new byte[2];
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.recordLength_ = 0;
        for (int i = 0; i < this.fields_.length; ++i) {
            fieldDescription = this.fieldDescriptions_[i];
            Object object = fieldDescription.getDFT();
            this.fieldOffsets_[i] = n;
            if (object == null) {
                if (fieldDescription.isDFTNull()) {
                    this.fields_[i] = fieldDescription.getDataType().getDefaultValue();
                    this.nullFieldMap_[i] = this.fieldDescriptions_[i].getALWNULL();
                } else if (fieldDescription.isDFTCurrent()) {
                    this.fields_[i] = fieldDescription.getDFTCurrentValue();
                } else {
                    this.fields_[i] = fieldDescription.getDataType().getDefaultValue();
                    if (this.fieldDescriptions_[i].getALWNULL()) {
                        this.nullFieldMap_[i] = true;
                        this.fields_[i] = null;
                    } else {
                        this.nullFieldMap_[i] = false;
                    }
                }
            } else {
                this.fields_[i] = object;
            }
            if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                int n2 = object == null ? 0 : (fieldDescription instanceof HexFieldDescription ? ((byte[])object).length : ((String)object).length());
                BinaryConverter.unsignedShortToByteArray(n2, byArray, 0);
                byteArrayOutputStream.write(byArray, 0, 2);
                n += 2;
                this.recordLength_ += 2;
            }
            aS400DataType = fieldDescription.getDataType();
            if (this.fields_[i] != null) {
                byteArrayOutputStream.write(aS400DataType.toBytes(this.fields_[i]), 0, aS400DataType.getByteLength());
            } else {
                byteArrayOutputStream.write(aS400DataType.toBytes(aS400DataType.getDefaultValue()), 0, aS400DataType.getByteLength());
            }
            this.isConvertedToJava_[i] = true;
            this.isConvertedToAS400_[i] = true;
            n += fieldDescription.getDataType().getByteLength();
            this.recordLength_ += fieldDescription.getDataType().getByteLength();
        }
        this.as400Data_ = byteArrayOutputStream.toByteArray();
        if (this.recordDescriptionListeners_ != null) {
            this.fireFieldModifiedEvent();
        }
    }

    void initializeTextObjects(AS400 aS400) {
        if (this.recordFormat_ != null) {
            this.recordFormat_.initializeTextObjects(aS400);
        }
        if (this.fieldDescriptions_ != null) {
            for (int i = 0; i < this.fieldDescriptions_.length; ++i) {
                AS400DataType aS400DataType = this.fieldDescriptions_[i].dataType_;
                if (aS400DataType.getInstanceType() != 9) continue;
                ((AS400Text)aS400DataType).setConverter(((AS400Text)aS400DataType).getConverter());
            }
        }
    }

    private void initializeTransient() {
    }

    public boolean isNullField(int n) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (n < 0 || n > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return this.nullFieldMap_[n];
    }

    public boolean isNullField(String string) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.nullFieldMap_[this.recordFormat_.getIndexOfFieldName(string)];
    }

    private int readFromStream(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2 && !bl) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                bl = true;
                continue;
            }
            n3 += n4;
        }
        return n3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeRecordDescriptionListener(RecordDescriptionListener recordDescriptionListener) {
        if (recordDescriptionListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.recordDescriptionListeners_ != null) {
            this.recordDescriptionListeners_.removeElement(recordDescriptionListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setContents(byte[] byArray) throws UnsupportedEncodingException {
        this.setContents(byArray, 0);
    }

    public void setContents(byte[] byArray, int n) throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (byArray == null) {
            throw new NullPointerException("contents");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (this.hasDependentFields_) {
            int n2 = this.recordFormat_.getNumberOfFields();
            this.recordLength_ = 0;
            for (int i = 0; i < n2; ++i) {
                Object object;
                FieldDescription fieldDescription = this.fieldDescriptions_[i];
                int n3 = this.recordFormat_.getLengthDependency(i);
                int n4 = this.recordFormat_.getOffsetDependency(i);
                AS400DataType aS400DataType = fieldDescription.getDataType();
                int n5 = aS400DataType.getByteLength();
                if (n4 != -1) {
                    n = ((Number)this.fields_[n4]).intValue();
                }
                if (n3 != -1) {
                    object = null;
                    n5 = ((Number)this.fields_[n3]).intValue();
                    boolean bl = false;
                    if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                        n += 2;
                        this.recordLength_ += 2;
                        bl = true;
                    }
                    if (fieldDescription instanceof HexFieldDescription) {
                        object = new AS400ByteArray(n5);
                    } else if (fieldDescription instanceof ArrayFieldDescription) {
                        object = new AS400Array(((AS400Array)aS400DataType).getType(), n5);
                    } else {
                        AS400Text aS400Text = (AS400Text)aS400DataType;
                        object = new AS400Text(n5, aS400Text.getCcsid());
                        ((AS400Text)object).setConverter(aS400Text.getConverter());
                    }
                    if (!bl) {
                        fieldDescription.setDataType((AS400DataType)object);
                    }
                    this.fields_[i] = object.toObject(byArray, n);
                    this.recordLength_ += fieldDescription.getDataType().getByteLength();
                } else if (fieldDescription instanceof VariableLengthFieldDescription) {
                    if (((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                        int n6 = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
                        n += 2;
                        this.recordLength_ += 2;
                        if (fieldDescription instanceof HexFieldDescription) {
                            object = new byte[n6];
                            System.arraycopy(byArray, n, object, 0, n6);
                            this.fields_[i] = object;
                        } else {
                            object = ((AS400Text)aS400DataType).getConverter();
                            this.fields_[i] = object.byteArrayToString(byArray, n, n6);
                        }
                        this.recordLength_ += aS400DataType.getByteLength();
                    } else {
                        this.fields_[i] = aS400DataType.toObject(byArray, n);
                        this.recordLength_ += aS400DataType.getByteLength();
                    }
                } else {
                    this.fields_[i] = aS400DataType.toObject(byArray, n);
                    this.recordLength_ += aS400DataType.getByteLength();
                }
                n += n5;
                this.isConvertedToJava_[i] = true;
                this.isConvertedToAS400_[i] = false;
            }
            if (this.recordDescriptionListeners_ != null) {
                this.fireFieldModifiedEvent();
            }
        } else {
            System.arraycopy(byArray, n, this.as400Data_, 0, this.as400Data_.length);
            for (int i = 0; i < this.isConvertedToJava_.length; ++i) {
                this.isConvertedToJava_[i] = false;
                this.isConvertedToAS400_[i] = true;
            }
        }
    }

    public void setContents(InputStream inputStream) throws IOException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        byte[] byArray = new byte[this.recordLength_];
        if (this.readFromStream(inputStream, byArray, 0, this.recordLength_) != this.recordLength_) {
            throw new ExtendedIOException("Unable to read " + String.valueOf(this.recordLength_) + "bytes", 25);
        }
        this.setContents(byArray, 0);
    }

    public void setField(int n, Object object) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (n < 0 || n > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        this.fields_[n] = object;
        if (this.recordDescriptionListeners_ != null) {
            this.fireFieldModifiedEvent();
        }
        this.nullFieldMap_[n] = object == null;
        this.isConvertedToJava_[n] = true;
        if (!this.hasDependentFields_) {
            int n2 = this.fieldOffsets_[n];
            FieldDescription fieldDescription = this.fieldDescriptions_[n];
            if (fieldDescription instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength()) {
                int n3 = this.fields_[n] == null ? 0 : (fieldDescription instanceof HexFieldDescription ? ((byte[])this.fields_[n]).length : ((String)this.fields_[n]).length());
                BinaryConverter.unsignedShortToByteArray(n3, this.as400Data_, n2);
                n2 += 2;
            }
            AS400DataType aS400DataType = fieldDescription.getDataType();
            if (this.fields_[n] != null) {
                aS400DataType.toBytes(this.fields_[n], this.as400Data_, n2);
            } else {
                aS400DataType.toBytes(aS400DataType.getDefaultValue(), this.as400Data_, n2);
            }
            this.isConvertedToAS400_[n] = true;
        } else {
            this.isConvertedToAS400_[n] = false;
        }
    }

    public void setField(String string, Object object) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        this.setField(this.recordFormat_.getIndexOfFieldName(string), object);
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordFormat", this.recordFormat_, recordFormat);
        }
        RecordFormat recordFormat2 = this.recordFormat_;
        this.initializeRecord(recordFormat);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordFormat", recordFormat2, this.recordFormat_);
        }
    }

    public void setRecordName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordName", this.name_, string);
        }
        String string2 = this.name_;
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordName", string2, this.name_);
        }
    }

    public void setRecordNumber(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("recordNumber", 4);
        }
        Integer n2 = null;
        Integer n3 = null;
        if (this.vetos_ != null || this.changes_ != null) {
            n2 = new Integer(this.recordNumber_);
            n3 = new Integer(n);
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordNumber", n2, n3);
        }
        this.recordNumber_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordNumber", n2, n3);
        }
    }

    public String toString() {
        if (this.recordFormat_ == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(0);
        Object object = null;
        for (int i = 0; i < this.fields_.length; ++i) {
            try {
                object = this.getField(i);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = null;
            }
            catch (Exception exception) {
                object = "???";
            }
            if (object == null) {
                stringBuffer.append("null");
            } else if (object instanceof byte[]) {
                stringBuffer.append(new String((byte[])object));
            } else {
                stringBuffer.append(object.toString());
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }
}

