/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SQLResultSetTableModel
extends AbstractTableModel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private boolean cacheAll_ = false;
    private SQLConnection sqlConnection_ = null;
    private String query_ = null;
    private ResultSet explicitResultSet_ = null;
    private transient Vector cachedRows_;
    private transient int cachedRowCount_;
    private transient int columnCount_;
    private transient boolean error_;
    private transient int firstCachedRow_;
    private transient Object internalMonitor_;
    private transient int lastCachedRow_;
    private transient ResultSet resultSet_;
    private transient ResultSetMetaData resultSetMetaData_;
    private transient int rowCount_;
    private transient boolean rowCountComplete_;
    private transient boolean scrollable_;
    private transient Statement statement_;
    private transient boolean updatable_;
    private static final int CACHE_SIZE_ = 500;
    private static final int READ_INCREMENT_ = 50;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    static /* synthetic */ Class class$java$lang$Object;

    public SQLResultSetTableModel() {
        this.initializeTransient();
    }

    public SQLResultSetTableModel(SQLConnection sQLConnection, String string) {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        if (string == null) {
            throw new NullPointerException("query");
        }
        this.sqlConnection_ = sQLConnection;
        this.query_ = string;
        this.initializeTransient();
    }

    public SQLResultSetTableModel(ResultSet resultSet, boolean bl) {
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        this.explicitResultSet_ = resultSet;
        this.cacheAll_ = bl;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void clearWarnings() {
        try {
            if (this.resultSet_ != null) {
                this.resultSet_.clearWarnings();
            }
            if (this.statement_ != null) {
                this.statement_.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            this.markError(sQLException);
        }
    }

    public void close() {
        try {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
            }
        }
        catch (SQLException sQLException) {
            this.markError(sQLException);
        }
        try {
            if (this.statement_ != null) {
                this.statement_.close();
                this.statement_ = null;
            }
        }
        catch (SQLException sQLException) {
            this.markError(sQLException);
        }
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Object == null ? (class$java$lang$Object = SQLResultSetTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnCount() {
        Object object = this.internalMonitor_;
        synchronized (object) {
            Trace.log(1, "SQLResultSetTableModel.getColumnCount() = " + this.columnCount_);
            return this.columnCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnID(int n) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (n < 0 || n >= this.columnCount_) {
                return null;
            }
            if (this.resultSet_ == null) {
                return null;
            }
            try {
                return this.resultSetMetaData_.getColumnName(n + 1);
            }
            catch (SQLException sQLException) {
                this.markError(sQLException);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(int n) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (n < 0 || n >= this.columnCount_) {
                return null;
            }
            if (this.resultSet_ == null) {
                return null;
            }
            try {
                return this.resultSetMetaData_.getColumnLabel(n + 1);
            }
            catch (SQLException sQLException) {
                this.markError(sQLException);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnType(int n) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (n < 0 || n >= this.columnCount_) {
                return 0;
            }
            if (this.resultSet_ == null) {
                return 0;
            }
            try {
                return this.resultSetMetaData_.getColumnType(n + 1);
            }
            catch (SQLException sQLException) {
                this.markError(sQLException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnWidth(int n) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (n < 0 || n >= this.columnCount_) {
                return 0;
            }
            if (this.resultSet_ == null) {
                return 0;
            }
            try {
                return Math.min(this.resultSetMetaData_.getColumnDisplaySize(n + 1), 50);
            }
            catch (SQLException sQLException) {
                this.markError(sQLException);
                return 0;
            }
        }
    }

    public SQLConnection getConnection() {
        return this.sqlConnection_;
    }

    public String getQuery() {
        return this.query_ == null ? "" : this.query_;
    }

    public ResultSet getResultSet() {
        return this.explicitResultSet_;
    }

    public int getRowCount() {
        if (this.resultSet_ == null) {
            return 0;
        }
        int n = this.rowCount_;
        if (!this.rowCountComplete_) {
            n += 2;
        }
        Trace.log(1, "SQLResultSetTableModel.getRowCount() = " + n + "(actually " + this.rowCount_ + ")");
        return n;
    }

    private Object getSingleValue(int n) throws SQLException {
        int n2 = this.resultSetMetaData_.getColumnType(n);
        if (n2 == -2 || n2 == -3 || n2 == -4) {
            return this.resultSet_.getBytes(n);
        }
        String string = this.resultSet_.getString(n);
        if (this.checkDataMappingWarning(this.resultSet_, n)) {
            string = "++++++++++++++";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        int n3;
        int n4;
        Object[] objectArray = null;
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (n2 < 0 || n2 >= this.columnCount_) {
                return null;
            }
            if (n < 0) {
                return null;
            }
            if (this.rowCountComplete_ && n >= this.rowCount_) {
                return null;
            }
            if (this.resultSet_ == null) {
                return null;
            }
            n4 = this.rowCount_;
            if (n >= this.firstCachedRow_ && n <= this.lastCachedRow_) {
                objectArray = (Object[])this.cachedRows_.elementAt(n - this.firstCachedRow_);
            } else if (n < this.firstCachedRow_ && !this.error_) {
                this.workingEventSupport_.fireStartWorking();
                for (int i = this.firstCachedRow_ - 1; i >= n; --i) {
                    try {
                        objectArray = new Object[this.columnCount_];
                        ResultSet resultSet = this.resultSet_;
                        synchronized (resultSet) {
                            if (i == this.resultSet_.getRow()) {
                                this.resultSet_.next();
                            } else {
                                this.resultSet_.absolute(i + 1);
                            }
                            for (int j = 0; j < this.columnCount_; ++j) {
                                objectArray[j] = this.getSingleValue(j + 1);
                            }
                        }
                        this.cachedRows_.insertElementAt(objectArray, 0);
                        --this.firstCachedRow_;
                        if (++this.cachedRowCount_ <= 500) continue;
                        this.cachedRows_.removeElementAt(--this.cachedRowCount_);
                        --this.lastCachedRow_;
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.markError(sQLException);
                    }
                }
                this.workingEventSupport_.fireStopWorking();
            } else if (n > this.lastCachedRow_ && !this.error_) {
                int n5 = n;
                if (!this.rowCountComplete_) {
                    n5 = n + 50;
                }
                this.workingEventSupport_.fireStartWorking();
                boolean bl = true;
                for (int i = this.lastCachedRow_ + 1; i <= n5 && bl; ++i) {
                    try {
                        ResultSet resultSet = this.resultSet_;
                        synchronized (resultSet) {
                            bl = i == this.resultSet_.getRow() || !this.scrollable_ ? this.resultSet_.next() : this.resultSet_.absolute(i + 1);
                            if (bl) {
                                Object[] objectArray2 = new Object[this.columnCount_];
                                for (int j = 0; j < this.columnCount_; ++j) {
                                    objectArray2[j] = this.getSingleValue(j + 1);
                                }
                                if (i == n) {
                                    objectArray = objectArray2;
                                }
                                this.cachedRows_.insertElementAt(objectArray2, this.cachedRowCount_++);
                                ++this.lastCachedRow_;
                                if (this.scrollable_ && this.cachedRowCount_ > 500) {
                                    this.cachedRows_.removeElementAt(0);
                                    --this.cachedRowCount_;
                                    ++this.firstCachedRow_;
                                }
                                if (!this.rowCountComplete_ && i >= this.rowCount_) {
                                    this.rowCount_ = i;
                                }
                            } else if (!this.rowCountComplete_) {
                                this.rowCountComplete_ = true;
                                this.rowCount_ = i;
                            }
                            continue;
                        }
                    }
                    catch (SQLException sQLException) {
                        this.markError(sQLException);
                    }
                }
                this.workingEventSupport_.fireStopWorking();
            }
            n3 = this.rowCount_;
        }
        if (n4 != n3) {
            this.fireTableRowsInserted(n4, this.getRowCount());
        }
        if (objectArray == null) {
            return null;
        }
        return objectArray[n2];
    }

    public SQLWarning getWarnings() {
        SQLWarning sQLWarning = null;
        try {
            if (this.resultSet_ != null) {
                sQLWarning = this.resultSet_.getWarnings();
            }
            if (this.statement_ != null) {
                if (sQLWarning == null) {
                    sQLWarning = this.statement_.getWarnings();
                } else {
                    sQLWarning.setNextWarning(this.statement_.getWarnings());
                }
            }
        }
        catch (SQLException sQLException) {
            this.markError(sQLException);
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCommon() {
        Object object = this.internalMonitor_;
        synchronized (object) {
            this.cachedRows_ = new Vector(500);
            this.cachedRowCount_ = 0;
            this.columnCount_ = 0;
            this.error_ = false;
            this.firstCachedRow_ = 0;
            this.lastCachedRow_ = -1;
            this.rowCount_ = 0;
            this.rowCountComplete_ = false;
        }
    }

    private void initializeTransient() {
        this.internalMonitor_ = new Object();
        this.initializeCommon();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
    }

    boolean isUpdatable() {
        return this.updatable_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCellEditable(int n, int n2) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (n2 < 0 || n2 >= this.columnCount_) {
                return false;
            }
            if (n < 0) {
                return false;
            }
            if (this.rowCountComplete_ && n >= this.rowCount_) {
                return false;
            }
            return this.resultSet_ != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Trace.log(1, "SQLResultSetTableModel.load()");
        this.workingEventSupport_.fireStartWorking();
        if (this.explicitResultSet_ == null) {
            if (this.sqlConnection_ == null) {
                throw new IllegalStateException("connection");
            }
            if (this.query_ == null) {
                throw new IllegalStateException("query");
            }
        }
        Object object = this.internalMonitor_;
        synchronized (object) {
            Object[] objectArray;
            this.initializeCommon();
            try {
                if (this.explicitResultSet_ == null) {
                    if (this.statement_ == null) {
                        objectArray = this.sqlConnection_.getConnection();
                        this.statement_ = objectArray.createStatement(1005, 1008);
                    }
                    this.resultSet_ = this.statement_.executeQuery(this.query_);
                } else {
                    this.resultSet_ = this.explicitResultSet_;
                }
                this.scrollable_ = this.resultSet_.getType() != 1003;
                this.updatable_ = this.resultSet_.getConcurrency() == 1008;
                this.resultSetMetaData_ = this.resultSet_.getMetaData();
                this.columnCount_ = this.resultSetMetaData_.getColumnCount();
                if (Trace.isTraceOn()) {
                    Trace.log(1, "SQLResultSetTableModel-scrollable? " + this.scrollable_);
                    Trace.log(1, "SQLResultSetTableModel-updatable? " + this.updatable_);
                }
            }
            catch (SQLException sQLException) {
                this.markError(sQLException);
                this.rowCountComplete_ = true;
            }
            if (this.cacheAll_) {
                try {
                    while (this.resultSet_.next()) {
                        objectArray = new Object[this.columnCount_];
                        for (int i = 0; i < this.columnCount_; ++i) {
                            objectArray[i] = this.getSingleValue(i + 1);
                        }
                        this.cachedRows_.addElement(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    this.markError(sQLException);
                }
                this.rowCount_ = this.lastCachedRow_ = this.cachedRows_.size();
                this.rowCountComplete_ = true;
            } else {
                this.getValueAt(0, 0);
            }
        }
        this.fireTableStructureChanged();
        this.workingEventSupport_.fireStopWorking();
    }

    private void markError(Exception exception) {
        if (Trace.isTraceOn()) {
            Trace.log(2, "Error gathering SQLResultSetTableModel data", (Throwable)exception);
        }
        if (!this.error_) {
            this.error_ = true;
            this.errorEventSupport_.fireError(exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setConnection(SQLConnection sQLConnection) throws PropertyVetoException {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        SQLConnection sQLConnection2 = this.sqlConnection_;
        this.vetoableChangeSupport_.fireVetoableChange("connection", sQLConnection2, sQLConnection);
        this.sqlConnection_ = sQLConnection;
        this.statement_ = null;
        this.propertyChangeSupport_.firePropertyChange("connection", sQLConnection2, sQLConnection);
    }

    public void setQuery(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("query");
        }
        String string2 = this.query_;
        this.vetoableChangeSupport_.fireVetoableChange("query", string2, string);
        this.query_ = string;
        this.propertyChangeSupport_.firePropertyChange("query", string2, string);
    }

    public void setResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        ResultSet resultSet2 = this.explicitResultSet_;
        this.explicitResultSet_ = resultSet;
        this.propertyChangeSupport_.firePropertyChange("resultSet", resultSet2, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.internalMonitor_;
        synchronized (object2) {
            if (n2 < 0 || n2 >= this.columnCount_) {
                return;
            }
            if (n < 0) {
                return;
            }
            if (this.rowCountComplete_ && n >= this.rowCount_) {
                return;
            }
            if (this.resultSet_ == null) {
                return;
            }
            if (!this.updatable_) {
                return;
            }
            if (this.scrollable_) {
                try {
                    ResultSet resultSet = this.resultSet_;
                    synchronized (resultSet) {
                        this.resultSet_.absolute(n + 1);
                        this.resultSet_.updateObject(n2 + 1, object);
                        this.resultSet_.updateRow();
                    }
                    ((Object[])this.cachedRows_.elementAt((int)(n - this.firstCachedRow_)))[n2] = object;
                }
                catch (SQLException sQLException) {
                    this.errorEventSupport_.fireError(sQLException);
                }
            }
        }
    }

    private boolean checkDataMappingWarning(ResultSet resultSet, int n) throws SQLException {
        boolean bl = false;
        SQLWarning sQLWarning = resultSet.getWarnings();
        if (sQLWarning != null) {
            do {
                if (!sQLWarning.getSQLState().equals("01004") || ((DataTruncation)sQLWarning).getDataSize() != -1 || ((DataTruncation)sQLWarning).getTransferSize() != -1 || ((DataTruncation)sQLWarning).getIndex() != n) continue;
                bl = true;
            } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

