/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AFPResource;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDAFPResource;
import com.ibm.as400.access.NPCPSelRes;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class AFPResourceList
extends PrintObjectList
implements Serializable {
    static final long serialVersionUID = 4L;
    private SpooledFile spooledFileFilter_;
    private static final String RESOURCE_FILTER = "resourceFilter";
    private static final String SPOOLED_FILE_FILTER = "spooledFileFilter";

    public AFPResourceList() {
        super(7, new NPCPSelRes());
    }

    public AFPResourceList(AS400 system) {
        super(7, new NPCPSelRes(), system);
    }

    void chooseImpl() {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use AFPResourceList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)system.loadImpl2("com.ibm.as400.access.AFPResourceListImplRemote", "com.ibm.as400.access.AFPResourceListImplProxy");
        super.setImpl();
    }

    public String getResourceFilter() {
        NPCPSelRes selectionCP = (NPCPSelRes)this.getSelectionCP();
        return selectionCP.getResource();
    }

    public SpooledFile getSpooledFileFilter() {
        return this.spooledFileFilter_;
    }

    PrintObject newNPObject(NPCPID cpid, NPCPAttribute cpattr) {
        return new AFPResource(this.system_, (NPCPIDAFPResource)cpid, cpattr);
    }

    public void setResourceFilter(String resourceFilter) throws PropertyVetoException {
        if (resourceFilter == null) {
            Trace.log(2, "Parameter 'resourceFilter' is null");
            throw new NullPointerException(RESOURCE_FILTER);
        }
        String oldResourceFilter = this.getResourceFilter();
        this.vetos.fireVetoableChange(RESOURCE_FILTER, oldResourceFilter, resourceFilter);
        NPCPSelRes selectionCP = (NPCPSelRes)this.getSelectionCP();
        selectionCP.setResource(resourceFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("resource", resourceFilter);
        }
        this.changes.firePropertyChange(RESOURCE_FILTER, oldResourceFilter, resourceFilter);
    }

    public void setSpooledFileFilter(SpooledFile spooledFileFilter) throws PropertyVetoException {
        SpooledFile oldSpooledFileFilter = this.getSpooledFileFilter();
        this.vetos.fireVetoableChange(SPOOLED_FILE_FILTER, oldSpooledFileFilter, spooledFileFilter);
        this.spooledFileFilter_ = spooledFileFilter;
        if (this.spooledFileFilter_ == null) {
            this.setIDCodePointFilter(null);
        } else {
            this.setIDCodePointFilter(this.spooledFileFilter_.getIDCodePoint());
        }
        this.changes.firePropertyChange(SPOOLED_FILE_FILTER, oldSpooledFileFilter, spooledFileFilter);
    }
}

