/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AS400AbstractTime
implements AS400DataType {
    static final long serialVersionUID = 4L;
    static final boolean DEBUG = false;
    static final Locale LOCALE_DEFAULT = Locale.US;
    static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT-0");
    static final Character AMPERSAND = new Character('&');
    static final Character BLANK = new Character(' ');
    static final Character COLON = new Character(':');
    static final Character COMMA = new Character(',');
    static final Character HYPHEN = new Character('-');
    static final Character PERIOD = new Character('.');
    static final Character SLASH = new Character('/');
    static final String DATE_PATTERN_XSD = "yyyy-MM-dd";
    static final String TIME_PATTERN_XSD = "HH:mm:ss";
    static final String TIMESTAMP_PATTERN_XSD = "yyyy-MM-dd'T'HH:mm:ss";
    private int length_;
    private transient GregorianCalendar calendar_;
    private transient SimpleDateFormat dateFormatter_;
    private transient CharConverter charConverter_;
    private static Hashtable hashDateFormatterXSD_ = null;
    private static Hashtable hashTimeFormatterXSD_ = null;
    private static Hashtable hashTimestampFormatterXSD_ = null;
    private transient Date[] centuryMap_;
    private int format_;
    private Character separator_;
    private boolean separatorHasBeenSet_ = false;
    private TimeZone timeZone_ = null;

    AS400AbstractTime() {
        this.timeZone_ = TIMEZONE_GMT;
    }

    AS400AbstractTime(TimeZone timeZone) {
        this.timeZone_ = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone_;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return this.length_;
    }

    public abstract Object getDefaultValue();

    public abstract int getInstanceType();

    public abstract Class getJavaType();

    synchronized GregorianCalendar getCalendar() {
        if (this.calendar_ == null) {
            TimeZone timezone = this.getTimeZone();
            if (Trace.traceOn_) {
                Trace.log(1, "AS400AbstractTime.getCalendar(): Setting internal timezone to " + timezone);
            }
            this.calendar_ = new GregorianCalendar(timezone, LOCALE_DEFAULT);
        }
        return this.calendar_;
    }

    synchronized GregorianCalendar getCalendar(Date date) {
        this.getCalendar().setTime(date);
        return this.calendar_;
    }

    private synchronized GregorianCalendar getCalendar(int year, int month, int dayOfMonth, int hoursIntoDay, int minutesIntoHour, int secondsIntoMinute) {
        this.getCalendar().set(year, month, dayOfMonth, hoursIntoDay, minutesIntoHour, secondsIntoMinute);
        return this.calendar_;
    }

    int getLength() {
        return this.length_;
    }

    synchronized int getFormat() {
        return this.format_;
    }

    synchronized Character getSeparator() {
        return this.separator_;
    }

    synchronized void setSeparator(Character separator) {
        this.separator_ = separator;
        this.separatorHasBeenSet_ = true;
    }

    synchronized void setFormat(int format) {
        Character sep = this.separatorHasBeenSet_ ? this.separator_ : this.defaultSeparatorFor(format);
        this.setFormat(format, sep);
    }

    synchronized void setFormat(int format, Character separator) {
        if (!this.isValidFormat(format)) {
            throw new ExtendedIllegalArgumentException("format (" + format + ")", 2);
        }
        this.format_ = format;
        this.separator_ = separator;
        this.length_ = this.lengthFor(this.format_);
        this.dateFormatter_ = null;
    }

    public byte[] toBytes(Object javaValue) {
        byte[] byteVal = new byte[this.length_];
        this.toBytes(javaValue, byteVal, 0);
        return byteVal;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        String dateString = this.toString(javaValue);
        try {
            this.getCharConverter().stringToByteArray(dateString, as400Value, offset);
        }
        catch (CharConversionException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        return this.length_;
    }

    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    public abstract Object toObject(byte[] var1, int var2);

    public abstract String toString(Object var1);

    CharConverter getCharConverter() {
        try {
            if (this.charConverter_ == null) {
                this.charConverter_ = new CharConverter(37);
            }
            return this.charConverter_;
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    synchronized SimpleDateFormat getDateFormatter() {
        if (this.dateFormatter_ == null) {
            this.dateFormatter_ = new SimpleDateFormat(this.patternFor(this.format_, this.separator_));
            this.dateFormatter_.setTimeZone(this.getTimeZone());
        }
        return this.dateFormatter_;
    }

    synchronized SimpleDateFormat getDateFormatter(Integer centuryDigit) {
        if (centuryDigit == null) {
            return this.getDateFormatter();
        }
        Date d = this.getStartDateForCentury(centuryDigit);
        this.getDateFormatter();
        this.dateFormatter_.set2DigitYearStart(d);
        return this.dateFormatter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static SimpleDateFormat getDateFormatterXSD(TimeZone timezone) {
        SimpleDateFormat dateFormatterXSD;
        if (hashDateFormatterXSD_ == null) {
            Class<AS400Date> clazz = AS400Date.class;
            // MONITORENTER : com.ibm.as400.access.AS400Date.class
            if (hashDateFormatterXSD_ == null) {
                hashDateFormatterXSD_ = new Hashtable();
            }
            // MONITOREXIT : clazz
        }
        if ((dateFormatterXSD = (SimpleDateFormat)hashDateFormatterXSD_.get(timezone)) != null) return dateFormatterXSD;
        Class<AS400Date> clazz = AS400Date.class;
        // MONITORENTER : com.ibm.as400.access.AS400Date.class
        dateFormatterXSD = (SimpleDateFormat)hashDateFormatterXSD_.get(timezone);
        if (dateFormatterXSD == null) {
            dateFormatterXSD = new SimpleDateFormat(DATE_PATTERN_XSD);
            dateFormatterXSD.setTimeZone(timezone);
            hashDateFormatterXSD_.put(timezone, dateFormatterXSD);
        }
        // MONITOREXIT : clazz
        return dateFormatterXSD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static SimpleDateFormat getTimeFormatterXSD(TimeZone timeZone) {
        SimpleDateFormat timeFormatterXSD;
        if (hashTimeFormatterXSD_ == null) {
            Class<AS400Time> clazz = AS400Time.class;
            // MONITORENTER : com.ibm.as400.access.AS400Time.class
            if (hashTimeFormatterXSD_ == null) {
                hashTimeFormatterXSD_ = new Hashtable();
            }
            // MONITOREXIT : clazz
        }
        if ((timeFormatterXSD = (SimpleDateFormat)hashTimeFormatterXSD_.get(timeZone)) != null) return timeFormatterXSD;
        Class<AS400Time> clazz = AS400Time.class;
        // MONITORENTER : com.ibm.as400.access.AS400Time.class
        timeFormatterXSD = (SimpleDateFormat)hashTimeFormatterXSD_.get(timeZone);
        if (timeFormatterXSD == null) {
            timeFormatterXSD = new SimpleDateFormat(TIME_PATTERN_XSD);
            timeFormatterXSD.setTimeZone(timeZone);
            hashTimeFormatterXSD_.put(timeZone, timeFormatterXSD);
        }
        // MONITOREXIT : clazz
        return timeFormatterXSD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static SimpleDateFormat getTimestampFormatterXSD(TimeZone timeZone) {
        SimpleDateFormat timestampFormatterXSD;
        if (hashTimestampFormatterXSD_ == null) {
            Class<AS400Timestamp> clazz = AS400Timestamp.class;
            // MONITORENTER : com.ibm.as400.access.AS400Timestamp.class
            if (hashTimestampFormatterXSD_ == null) {
                hashTimestampFormatterXSD_ = new Hashtable();
            }
            // MONITOREXIT : clazz
        }
        if ((timestampFormatterXSD = (SimpleDateFormat)hashTimestampFormatterXSD_.get(timeZone)) != null) return timestampFormatterXSD;
        Class<AS400Timestamp> clazz = AS400Timestamp.class;
        // MONITORENTER : com.ibm.as400.access.AS400Timestamp.class
        timestampFormatterXSD = (SimpleDateFormat)hashTimestampFormatterXSD_.get(timeZone);
        if (timestampFormatterXSD == null) {
            timestampFormatterXSD = new SimpleDateFormat(TIMESTAMP_PATTERN_XSD);
            timestampFormatterXSD.setTimeZone(timeZone);
            hashTimestampFormatterXSD_.put(timeZone, timestampFormatterXSD);
        }
        // MONITOREXIT : clazz
        return timestampFormatterXSD;
    }

    private synchronized Date getStartDateForCentury(int century) {
        if (this.centuryMap_ == null) {
            this.centuryMap_ = new Date[10];
        }
        if (this.centuryMap_[century] == null) {
            this.centuryMap_[century] = this.getCalendar(100 * (19 + century) + 1, 0, 1, 12, 0, 0).getTime();
        }
        return this.centuryMap_[century];
    }

    abstract String patternFor(int var1, Character var2);

    abstract Character defaultSeparatorFor(int var1);

    abstract boolean isValidFormat(int var1);

    abstract int lengthFor(int var1);
}

