/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Bin4
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 4;
    private static final int defaultValue = 0;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 4;
    }

    public Object getDefaultValue() {
        return new Integer(0);
    }

    public int getInstanceType() {
        return 2;
    }

    public Class getJavaType() {
        return Integer.class;
    }

    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[4];
        BinaryConverter.intToByteArray((Integer)javaValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(int intValue) {
        byte[] as400Value = new byte[4];
        BinaryConverter.intToByteArray(intValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        BinaryConverter.intToByteArray((Integer)javaValue, as400Value, 0);
        return 4;
    }

    public int toBytes(int intValue, byte[] as400Value) {
        BinaryConverter.intToByteArray(intValue, as400Value, 0);
        return 4;
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        BinaryConverter.intToByteArray((Integer)javaValue, as400Value, offset);
        return 4;
    }

    public int toBytes(int intValue, byte[] as400Value, int offset) {
        BinaryConverter.intToByteArray(intValue, as400Value, offset);
        return 4;
    }

    public int toInt(byte[] as400Value) {
        return BinaryConverter.byteArrayToInt(as400Value, 0);
    }

    public int toInt(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToInt(as400Value, offset);
    }

    public Object toObject(byte[] as400Value) {
        return new Integer(BinaryConverter.byteArrayToInt(as400Value, 0));
    }

    public Object toObject(byte[] as400Value, int offset) {
        return new Integer(BinaryConverter.byteArrayToInt(as400Value, offset));
    }
}

