/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400CertificateUsrPrfUtilImpl;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;

class AS400CertificateUsrPrfUtilImplRemote
extends AS400CertificateUsrPrfUtilImpl {
    AS400CertificateUsrPrfUtilImplRemote() {
    }

    int calladdCertificate(byte[] cert, int certlen, String userName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[6];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(201, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(cert);
        byte[] certlenB = new byte[4];
        BinaryConverter.intToByteArray(certlen, certlenB, 0);
        parmlist[2] = new ProgramParameter(certlenB);
        byte[] usrprfPathB = new byte[10];
        this.converter_.stringToByteArray(userName, usrprfPathB);
        parmlist[3] = new ProgramParameter(usrprfPathB);
        parmlist[4] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[5] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[5].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[4].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        return 0;
    }

    int calldeleteCertificate(byte[] cert, int certlen, String userName, int certType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[7];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(202, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(cert);
        byte[] certlenB = new byte[4];
        BinaryConverter.intToByteArray(certlen, certlenB, 0);
        parmlist[2] = new ProgramParameter(certlenB);
        byte[] usrprfPathB = new byte[10];
        this.converter_.stringToByteArray(userName, usrprfPathB);
        parmlist[3] = new ProgramParameter(usrprfPathB);
        byte[] certTypeB = new byte[4];
        BinaryConverter.intToByteArray(certType, certTypeB, 0);
        parmlist[4] = new ProgramParameter(certTypeB);
        parmlist[5] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[6] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[6].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[5].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        return 0;
    }

    int calllistCertificates(String userName, String usrSpaceName, boolean[] parmEntered, String[] attrS, byte[][] attrB) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int i;
        ProgramParameter[] parmlist = new ProgramParameter[9];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(203, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        byte[] usrprfPathB = new byte[10];
        this.converter_.stringToByteArray(userName, usrprfPathB);
        parmlist[1] = new ProgramParameter(usrprfPathB);
        byte[] usrSpaceNameB = new byte[20];
        this.converter_.stringToByteArray(usrSpaceName, usrSpaceNameB);
        parmlist[2] = new ProgramParameter(usrSpaceNameB);
        byte[] parmPresent = new byte[28];
        for (i = 0; i < 7; ++i) {
            if (parmEntered[i]) {
                BinaryConverter.intToByteArray(1, parmPresent, i * 4);
                continue;
            }
            BinaryConverter.intToByteArray(0, parmPresent, i * 4);
        }
        parmlist[3] = new ProgramParameter(parmPresent);
        int length = 0;
        int[] parmsize = new int[7];
        for (i = 0; i < attrS.length; ++i) {
            if (attrS[i] == null) continue;
            length += attrS[i].length();
        }
        for (int j = 0; j < attrB.length; ++j) {
            if (attrB[j] != null) {
                length += attrB[j].length;
                parmsize[i] = attrB[j].length;
            }
            ++i;
        }
        byte[] attrbytes = new byte[length * 2];
        byte[][] attrSbytes = new byte[attrS.length][];
        for (i = 0; i < attrS.length; ++i) {
            if (attrS[i] == null || 0 == attrS[i].length()) continue;
            attrSbytes[i] = this.converter_.stringToByteArray(attrS[i]);
            parmsize[i] = attrSbytes[i].length;
        }
        length = 0;
        byte[] parmsizeBytes = new byte[28];
        for (i = 0; i < attrS.length; ++i) {
            if (null != attrSbytes[i]) {
                System.arraycopy(attrSbytes[i], 0, attrbytes, length, attrSbytes[i].length);
                length += attrSbytes[i].length;
            }
            BinaryConverter.intToByteArray(parmsize[i], parmsizeBytes, i * 4);
        }
        for (i = 0; i < attrB.length; ++i) {
            if (null != attrB[i]) {
                System.arraycopy(attrB[i], 0, attrbytes, length, attrB[i].length);
                length += attrB[i].length;
            }
            BinaryConverter.intToByteArray(parmsize[6 + i], parmsizeBytes, (6 + i) * 4);
        }
        parmlist[4] = new ProgramParameter(parmsizeBytes);
        parmlist[5] = new ProgramParameter(attrbytes);
        parmlist[6] = new ProgramParameter(4);
        parmlist[7] = new ProgramParameter(100);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[8] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            this.numberCertificatesFound_ = 0;
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[8].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            this.numberCertificatesFound_ = 0;
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[7].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        byte[] numberCertificatesFoundB = parmlist[6].getOutputData();
        this.numberCertificatesFound_ = BinaryConverter.byteArrayToInt(numberCertificatesFoundB, 0);
        return rc;
    }

    int callfindCertificateUser(byte[] cert, int certlen, int certType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[7];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(204, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(cert);
        byte[] certlenB = new byte[4];
        BinaryConverter.intToByteArray(certlen, certlenB, 0);
        parmlist[2] = new ProgramParameter(certlenB);
        parmlist[3] = new ProgramParameter(10);
        byte[] certTypeB = new byte[4];
        BinaryConverter.intToByteArray(certType, certTypeB, 0);
        parmlist[4] = new ProgramParameter(certTypeB);
        parmlist[5] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[6] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[6].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[5].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        byte[] usrprfPathB = parmlist[3].getOutputData();
        this.userName_ = this.converter_.byteArrayToString(usrprfPathB, 0);
        return 0;
    }
}

