/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Certificate;
import com.ibm.as400.access.AS400CertificateUtilImpl;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;

class AS400CertificateUtilImplRemote
extends AS400CertificateUtilImpl {
    AS400CertificateUtilImplRemote() {
    }

    int callgetCertificates(String usrSpaceName, int buffSize, int nextCertificateToReturn, int nextCertificateOffsetIn) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[11];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(1, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        byte[] usrSpaceNameB = new byte[20];
        this.converter_.stringToByteArray(usrSpaceName, usrSpaceNameB);
        parmlist[1] = new ProgramParameter(usrSpaceNameB);
        byte[] buffSizeB = new byte[4];
        BinaryConverter.intToByteArray(buffSize, buffSizeB, 0);
        parmlist[2] = new ProgramParameter(buffSizeB);
        byte[] nextCertificateToReturnB = new byte[4];
        BinaryConverter.intToByteArray(nextCertificateToReturn, nextCertificateToReturnB, 0);
        parmlist[3] = new ProgramParameter(nextCertificateToReturnB);
        byte[] nextCertificateOffsetInB = new byte[4];
        BinaryConverter.intToByteArray(nextCertificateOffsetIn, nextCertificateOffsetInB, 0);
        parmlist[4] = new ProgramParameter(nextCertificateOffsetInB);
        parmlist[5] = new ProgramParameter(4);
        byte[] numberCertificatesFoundB = new byte[4];
        parmlist[6] = new ProgramParameter(4);
        byte[] numberCompleteCertsB = new byte[4];
        parmlist[7] = new ProgramParameter(4);
        parmlist[8] = new ProgramParameter(buffSize);
        byte[] errorInfoB = new byte[100];
        parmlist[9] = new ProgramParameter(100);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[10] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            this.numberCertificatesFound_ = 0;
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[10].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            this.numberCertificatesFound_ = 0;
            if (-1 == rc) {
                return rc;
            }
            errorInfoB = parmlist[9].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        byte[] nextCertificateOffsetOutB = parmlist[5].getOutputData();
        this.nextCertificateOffsetOut_ = BinaryConverter.byteArrayToInt(nextCertificateOffsetOutB, 0);
        numberCertificatesFoundB = parmlist[6].getOutputData();
        this.numberCertificatesFound_ = BinaryConverter.byteArrayToInt(numberCertificatesFoundB, 0);
        numberCompleteCertsB = parmlist[7].getOutputData();
        int numberCompleteCerts = BinaryConverter.byteArrayToInt(numberCompleteCertsB, 0);
        if (0 < numberCompleteCerts) {
            this.certificates_ = new AS400Certificate[numberCompleteCerts];
        }
        int length = 0;
        byte[] returnedBytes = parmlist[8].getOutputData();
        for (int i = 0; i < numberCompleteCerts; ++i) {
            int returnedLen = BinaryConverter.byteArrayToInt(returnedBytes, length);
            int certoffset = BinaryConverter.byteArrayToInt(returnedBytes, length + 4);
            int certLen = BinaryConverter.byteArrayToInt(returnedBytes, length + 8);
            byte[] certdata = new byte[certLen];
            System.arraycopy(returnedBytes, certoffset, certdata, 0, certLen);
            this.certificates_[i] = new AS400Certificate(certdata);
            length += returnedLen;
        }
        return 0;
    }

    int callgetHandle(byte[] certificate, int len) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[6];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(2, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(certificate);
        byte[] lenB = new byte[4];
        BinaryConverter.intToByteArray(certificate.length, lenB, 0);
        parmlist[2] = new ProgramParameter(lenB);
        parmlist[3] = new ProgramParameter(40);
        parmlist[4] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[5] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[5].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[4].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        this.handle_ = parmlist[3].getOutputData();
        return 0;
    }
}

