/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400CertificateAttribute;
import com.ibm.as400.access.AS400CertificateUtil;
import com.ibm.as400.access.AS400CertificateUtilImpl;
import com.ibm.as400.access.AS400CertificateVldlUtilImpl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class AS400CertificateVldlUtil
extends AS400CertificateUtil
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400CertificateVldlUtil";
    static final long serialVersionUID = 4L;
    transient AS400CertificateVldlUtilImpl vldlImpl_ = null;

    public AS400CertificateVldlUtil() {
    }

    public AS400CertificateVldlUtil(AS400 system, String path) {
        super(system, path);
        if (!this.objectType_.equalsIgnoreCase("VLDL") || this.objectName_.length() > 10) {
            throw new ExtendedIllegalArgumentException("path (" + path + ")", 3);
        }
    }

    void connect() throws IOException {
        if (this.system_ == null) {
            Trace.log(2, "Parameter 'system' is null at connect.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.ifsPathName_ == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new ExtendedIllegalStateException("ifsPathName", 4);
        }
        this.vldlImpl_ = (AS400CertificateVldlUtilImpl)this.system_.loadImpl("com.ibm.as400.access.AS400CertificateVldlUtilImplNative", "com.ibm.as400.access.AS400CertificateVldlUtilImplRemote");
        this.impl_ = (AS400CertificateUtilImpl)this.system_.loadImpl("com.ibm.as400.access.AS400CertificateUtilImplNative", "com.ibm.as400.access.AS400CertificateUtilImplRemote");
        this.vldlImpl_.system_ = this.system_;
        this.impl_.system_ = this.system_;
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        this.vldlImpl_.setConverter(conv);
        this.impl_.setConverter(conv);
        this.connected_ = true;
    }

    public void addCertificate(byte[] certificate) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int rc;
        if (null == certificate) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((rc = this.vldlImpl_.calladdCertificate(certificate, certificate.length, this.ifsPathName_, this.ifsPathName_.length())) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, rc);
        }
        this.fireAdd();
    }

    public boolean checkCertificate(byte[] certificate) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int rc;
        if (null == certificate) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((rc = this.vldlImpl_.callcheckCertificate(certificate, certificate.length, this.ifsPathName_, this.ifsPathName_.length(), 1)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, rc);
        }
        return this.vldlImpl_.present_ == 1;
    }

    public boolean checkCertificateByHandle(byte[] certificateHandle) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int rc;
        if (null == certificateHandle) {
            Trace.log(2, "Parameter 'certificateHandle' is null.");
            throw new NullPointerException("certificateHandle");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((rc = this.vldlImpl_.callcheckCertificate(certificateHandle, certificateHandle.length, this.ifsPathName_, this.ifsPathName_.length(), 2)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, rc);
        }
        return this.vldlImpl_.present_ == 1;
    }

    public void deleteCertificate(byte[] certificate) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int rc;
        if (null == certificate) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((rc = this.vldlImpl_.calldeleteCertificate(certificate, certificate.length, this.ifsPathName_, this.ifsPathName_.length(), 1)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, rc);
        }
        this.fireDelete();
    }

    public void deleteCertificateByHandle(byte[] certificateHandle) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int rc;
        if (null == certificateHandle) {
            Trace.log(2, "Parameter 'certificateHandle' is null.");
            throw new NullPointerException("certificateHandle");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((rc = this.vldlImpl_.calldeleteCertificate(certificateHandle, certificateHandle.length, this.ifsPathName_, this.ifsPathName_.length(), 2)) != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, rc);
        }
        this.fireDelete();
    }

    public int listCertificates(AS400CertificateAttribute[] certificateAttributes, String userSpaceName) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        boolean[] parmsEntered = this.setSearchAttributes(certificateAttributes);
        String as400usrSpaceName = this.getAS400UserSpaceName(userSpaceName);
        int rc = this.vldlImpl_.calllistCertificates(this.ifsPathName_, this.ifsPathName_.length(), as400usrSpaceName, parmsEntered, this.as400AttrS_, this.as400AttrB_);
        if (rc != 0) {
            this.throwException(this.vldlImpl_.cpfError_, this.ifsPathName_, rc);
        }
        return this.vldlImpl_.numberCertificatesFound_;
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path);
        String libName = ifs.getLibraryName();
        String objectName = ifs.getObjectName();
        String objectType = ifs.getObjectType();
        if (null == libName || null == objectName || objectName.length() > 10 || !objectType.equalsIgnoreCase("VLDL")) {
            throw new ExtendedIllegalArgumentException("path", 3);
        }
        if (this.ifsPathName_ == null) {
            this.ifsPathName_ = path;
            this.libName_ = libName;
            this.objectName_ = objectName;
            this.objectType_ = objectType;
        } else {
            if (this.system_ != null && this.isConnected()) {
                Trace.log(2, "Parameter 'path' is not changed (Connected=true).");
                throw new ExtendedIllegalStateException("path", 5);
            }
            String oldPath = this.ifsPathName_;
            this.vetos_.fireVetoableChange("path", oldPath, path);
            this.ifsPathName_ = path;
            this.libName_ = libName;
            this.objectName_ = objectName;
            this.objectType_ = objectType;
            this.changes_.firePropertyChange("path", oldPath, path);
        }
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

