/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImplBase;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMAS400MessageReply;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DDMEndUnitOfWorkReply;
import com.ibm.as400.access.DDMObjectDataStream;
import com.ibm.as400.access.DDMReplyDataStream;
import com.ibm.as400.access.DDMRequestDataStream;
import com.ibm.as400.access.DDMS38IOFB;
import com.ibm.as400.access.DDMS38OpenFeedback;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.util.Vector;

class AS400FileImplRemote
extends AS400FileImplBase
implements Serializable {
    static final long serialVersionUID = 4L;
    byte[] dclName_ = new byte[8];
    static long nextDCLName_ = 1L;
    static final Object nextDCLNameLock_ = new Object();
    private static byte[] s38Buffer = new byte[]{0, 5, -44, 5, 0};
    transient AS400Server server_ = null;
    private static int lastCorrelationId_ = 0;
    private static Object correlationIdLock_ = new Object();

    public AS400FileImplRemote() {
        this.setDCLName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        super.close();
        if (this.discardReplys_ && this.server_ != null) {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.sendAndDiscardReply(DDMRequestDataStream.getRequestS38CLOSE(this.dclName_), this.newCorrelationId());
            }
        } else {
            Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38CLOSE(this.dclName_), this.newCorrelationId());
            if (replys.size() != 1 || !this.verifyS38MSGRM((DDMDataStream)replys.elementAt(0), null, 0)) {
                this.handleErrorReply(replys, 0);
            }
        }
    }

    public void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestCMMUOW(), this.newCorrelationId());
        if (replys.size() == 1 && ((DDMDataStream)replys.elementAt(0)).getCodePoint() == 8716) {
            DDMEndUnitOfWorkReply uowReply = new DDMEndUnitOfWorkReply(((DDMDataStream)replys.elementAt((int)0)).data_);
            if (uowReply.getStatus() != 1) {
                Trace.log(2, "Wrong status returned from commit ds", uowReply.data_);
                throw new InternalErrorException(6, uowReply.getStatus());
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
    }

    public void connect() throws AS400SecurityException, ConnectionDroppedException, IOException, InterruptedException, ServerStartupException, UnknownHostException {
        if (this.server_ == null) {
            this.server_ = this.system_.getConnection(5, false, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createDDSSourceFile(RecordFormat recordFormat, String altSeq, String ccsid, String order, String ref, boolean unique, String format, String text) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        String line;
        AS400Message[] msgs = this.execute("QSYS/CRTSRCPF FILE(QTEMP/JT400DSSRC) RCDLEN(92) MBR(*FILE) TEXT('JT400 TEMPORARY DDS SOURCE FILE')");
        if (msgs.length <= 0) {
            Trace.log(2, "No messages from server.");
            throw new InternalErrorException(6);
        }
        if (msgs[0].getID().equals("CPF5813")) {
            msgs = this.execute("QSYS/CLRPFM QTEMP/JT400DSSRC");
            if (msgs.length <= 0) {
                Trace.log(2, "No messages were returned from QSYS/CLRPFM QTEMP/JT400DSSRC");
                throw new InternalErrorException("QTEMP/JT400DSSRC", 6);
            }
            if (!msgs[0].getID().equals("CPC3101")) {
                Trace.log(2, "QSYS/CLRPFM QTEMP/JT400DSSRC");
                throw new AS400Exception(msgs);
            }
        } else if (!msgs[0].getID().equals("CPC7301")) {
            Trace.log(2, "QSYS/CRTSRCPF FILE(QTEMP/JT400DSSRC) RCDLEN(92) MBR(*FILE) TEXT('JT400 TEMPORARY DDS SOURCE FILE')");
            throw new AS400Exception(msgs);
        }
        RecordFormat srcRF = new RecordFormat("JT400DSSRC");
        srcRF.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 2), "SRCSEQ"));
        srcRF.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 0), "SRCDAT"));
        srcRF.addFieldDescription(new CharacterFieldDescription(new AS400Text(80, this.system_.getCcsid()), "SRCDTA"));
        Vector<String> lines = new Vector<String>();
        if (altSeq != null) {
            line = "                                            ALTSEQ(" + altSeq + ")";
            lines.addElement(line);
        }
        if (ccsid != null) {
            line = "                                            CCSID(" + ccsid + ")";
            lines.addElement(line);
        }
        if (order != null) {
            line = "                                            " + order;
            lines.addElement(line);
        }
        if (ref != null) {
            line = "                                            REF(" + ref + ")";
            lines.addElement(line);
        }
        if (unique) {
            line = "                                            UNIQUE";
            lines.addElement(line);
        }
        line = "                R ";
        if (recordFormat.getName().length() > 10) {
            if (Trace.traceOn_) {
                Trace.log(4, "Record format name '" + recordFormat.getName() + "' too long. Using '" + recordFormat.getName().substring(0, 10) + "' instead.");
            }
            line = line + recordFormat.getName().substring(0, 10);
        } else {
            line = line + recordFormat.getName();
        }
        lines.addElement(line);
        if (format != null) {
            line = "                                            FORMAT(" + format + ")";
            lines.addElement(line);
        }
        if (text != null) {
            if (text.length() > 32) {
                line = "                                            TEXT('" + text.substring(0, 33) + "-";
                lines.addElement(line);
                line = "                                            " + text.substring(34) + "')";
                lines.addElement(line);
            } else {
                line = "                                            TEXT('" + text + "')";
                lines.addElement(line);
            }
        }
        int numberOfFields = recordFormat.getNumberOfFields();
        FieldDescription f = null;
        String[] dds = null;
        int i = 0;
        while (true) {
            String ddsDesc;
            if (i < numberOfFields) {
                f = recordFormat.getFieldDescription(i);
                dds = f.getDDSDescription();
                ddsDesc = "                  " + dds[0];
                lines.addElement(ddsDesc);
            } else {
                numberOfFields = recordFormat.getNumberOfKeyFields();
                break;
            }
            for (int j = 1; j < dds.length; ++j) {
                ddsDesc = "                                            " + dds[j];
                int length = ddsDesc.length();
                int beginningOffset = 0;
                if (length > 80) {
                    line = ddsDesc.substring(beginningOffset, 79) + "-";
                    lines.addElement(line);
                    length -= 79;
                    beginningOffset = 79;
                    line = "                                            " + ddsDesc.substring(beginningOffset);
                    lines.addElement(line);
                    continue;
                }
                lines.addElement(ddsDesc);
            }
            ++i;
        }
        for (i = 0; i < numberOfFields; ++i) {
            f = recordFormat.getKeyFieldDescription(i);
            line = "                K ";
            line = line + f.getDDSName();
            lines.addElement(line);
            String[] keyFuncs = f.getKeyFieldFunctions();
            if (keyFuncs == null) continue;
            for (int j = 0; j < keyFuncs.length; j = (int)((short)(j + 1))) {
                line = "                                            " + keyFuncs[j];
                lines.addElement(line);
            }
        }
        Record[] records = new Record[lines.size()];
        for (int i2 = 0; i2 < records.length; ++i2) {
            records[i2] = srcRF.getNewRecord();
            records[i2].setField("SRCSEQ", (Object)new BigDecimal(i2));
            records[i2].setField("SRCDAT", (Object)new BigDecimal(i2));
            records[i2].setField("SRCDTA", lines.elementAt(i2));
        }
        AS400FileImplRemote src = null;
        try {
            src = new AS400FileImplRemote();
            src.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT400DSSRC.FILE", srcRF, false, false, false);
            src.openFile2(2, records.length, 3, false);
            src.write(records);
            src.close();
            return;
        }
        catch (Exception e) {
            Trace.log(2, "Unable to write records to DDS source file:", (Throwable)e);
            try {
                if (src != null) {
                    src.close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (e instanceof AS400Exception) {
                throw (AS400Exception)e;
            }
            Trace.log(2, e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    public void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38DEL(this.dclName_), this.newCorrelationId());
        if (replys.size() != 1 || ((DDMDataStream)replys.elementAt(0)).getCodePoint() != 54274) {
            this.handleErrorReply(replys, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400Message[] execute(String cmd) throws AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector replys = null;
        if (this.discardReplys_) {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.sendAndDiscardReply(DDMRequestDataStream.getRequestS38CMD(cmd, this.system_), this.newCorrelationId());
            }
        } else {
            replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38CMD(cmd, this.system_), this.newCorrelationId());
        }
        return this.processReplys(replys);
    }

    public void handleErrorReply(Vector replys, int index) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int size = replys.size();
        Vector<AS400Message[]> as400MsgList = new Vector<AS400Message[]>();
        block4: for (int i = index; i < size; ++i) {
            DDMDataStream reply = (DDMDataStream)replys.elementAt(i);
            int codePoint = reply.getCodePoint();
            switch (codePoint) {
                case 53761: {
                    DDMAS400MessageReply msgReply = new DDMAS400MessageReply(this.system_, reply.data_);
                    as400MsgList.addElement(msgReply.getAS400MessageList());
                    continue block4;
                }
                case 4658: 
                case 4659: 
                case 4677: 
                case 4684: 
                case 4688: 
                case 4689: 
                case 4690: 
                case 4692: 
                case 4694: {
                    Trace.log(2, "handleErrorReply()", reply.data_);
                    throw new InternalErrorException(6, codePoint);
                }
                default: {
                    Trace.log(2, "handleErrorReply()", reply.data_);
                    throw new InternalErrorException(2, codePoint);
                }
            }
        }
        if (as400MsgList.size() > 0) {
            int numberOfMessages = 0;
            int msgListSize = as400MsgList.size();
            int msgNumber = 0;
            for (int i = 0; i < msgListSize; ++i) {
                numberOfMessages += ((AS400Message[])as400MsgList.elementAt(i)).length;
            }
            AS400Message[] msgs = new AS400Message[numberOfMessages];
            for (int i = 0; i < msgListSize; ++i) {
                AS400Message[] m = (AS400Message[])as400MsgList.elementAt(i);
                for (int j = 0; j < m.length; ++j) {
                    msgs[msgNumber++] = m[j];
                }
            }
            throw new AS400Exception(msgs);
        }
        Trace.log(2, "No messages from server.");
        throw new InternalErrorException(2);
    }

    public void logWarningMessages(Vector v, int index) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            for (int i = 0; i < index; ++i) {
                DDMAS400MessageReply msg = new DDMAS400MessageReply(this.system_, ((DDMDataStream)v.elementAt((int)i)).data_);
                AS400Message[] msgs = msg.getAS400MessageList();
                Trace.log(4, "AS400FileImplRemote.logWarningMessages():");
                for (int j = 0; j < msgs.length; ++j) {
                    Trace.log(4, msgs[j].toString());
                }
            }
        }
    }

    private int lookForCodePoint(int cp, Vector v) {
        int index = -1;
        int size = v.size();
        for (int i = 0; i < size && index == -1; ++i) {
            DDMDataStream ds = (DDMDataStream)v.elementAt(i);
            int offset = 8;
            while (index == -1 && offset < ds.data_.length) {
                if (ds.get16bit(offset) == cp) {
                    index = i;
                    continue;
                }
                offset += ds.get16bit(offset - 2);
            }
        }
        return index;
    }

    public DDMS38OpenFeedback openFile(int openType, int bf, String access) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        byte[] ufcb = this.createUFCB(openType, bf, access, false);
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38OPEN(ufcb, this.dclName_), this.newCorrelationId());
        int index = this.lookForCodePoint(54276, replys);
        if (index != -1) {
            DDMDataStream reply = (DDMDataStream)replys.elementAt(index);
            this.openFeedback_ = new DDMS38OpenFeedback(this.system_, reply.data_);
            if (Trace.traceOn_) {
                Trace.log(3, "AS400FileImplRemote.openFile()\n" + this.openFeedback_.toString());
            }
            if (index != 0) {
                this.logWarningMessages(replys, index);
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
        return this.openFeedback_;
    }

    public void padBytes(byte[] data, int start, int numBytes, byte padChar) {
        for (int i = 0; i < numBytes; ++i) {
            data[start + i] = padChar;
        }
    }

    public Record[] positionCursorAt(int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, searchType, shr, 0), this.newCorrelationId());
        int codePoint = ((DDMDataStream)replys.elementAt(0)).getCodePoint();
        if (codePoint == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        Record[] returned = this.processReadReply(replys, false);
        return returned;
    }

    public Record[] positionCursorAtLong(int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, searchType, shr, 0), this.newCorrelationId());
        int codePoint = ((DDMDataStream)replys.elementAt(0)).getCodePoint();
        if (codePoint == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        Record[] returned = this.processReadReplyLong(replys, false);
        return returned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsLastRecord()) {
            this.cache_.setPositionAfterLast();
            return;
        }
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.connect();
        int id = this.newCorrelationId();
        DDMRequestDataStream req = DDMRequestDataStream.getRequestS38FEOD(this.dclName_, 2, 2, 1);
        req.setIsChained(true);
        req.setHasSameRequestCorrelation(true);
        Vector replys = null;
        try {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.send(req, id);
                DDMObjectDataStream s38buf = new DDMObjectDataStream(11);
                System.arraycopy(s38Buffer, 0, s38buf.data_, 6, 5);
                replys = this.sendRequestAndReceiveReplies(s38buf, id);
            }
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "ConnectionDroppedException:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            this.resetState();
            throw e;
        }
        if (((DDMDataStream)replys.elementAt(0)).getCodePoint() == 54274) {
            if (replys.size() != 1 && !this.verifyS38MSGRM((DDMDataStream)replys.elementAt(1), "CPF5001", 0)) {
                this.handleErrorReply(replys, 1);
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsFirstRecord()) {
            this.cache_.setPositionBeforeFirst();
            return;
        }
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.connect();
        int id = this.newCorrelationId();
        DDMRequestDataStream req = DDMRequestDataStream.getRequestS38FEOD(this.dclName_, 1, 2, 1);
        req.setIsChained(true);
        req.setHasSameRequestCorrelation(true);
        Vector replys = null;
        try {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.send(req, id);
                DDMObjectDataStream s38buf = new DDMObjectDataStream(11);
                System.arraycopy(s38Buffer, 0, s38buf.data_, 6, 5);
                replys = this.sendRequestAndReceiveReplies(s38buf, id);
            }
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "ConnectionDroppedException:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            this.resetState();
            throw e;
        }
        if (((DDMDataStream)replys.elementAt(0)).getCodePoint() == 54274) {
            if (replys.size() != 1 && !this.verifyS38MSGRM((DDMDataStream)replys.elementAt(1), "CPF5001", 0)) {
                this.handleErrorReply(replys, 1);
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
    }

    public Record positionCursorToIndex(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr;
        Vector replys;
        int codePoint;
        if (this.cacheRecords_ && !this.cache_.setPosition(recordNumber)) {
            this.cache_.setIsEmpty();
        }
        if ((codePoint = ((DDMDataStream)(replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETD(this.dclName_, this.recordFormatCTLLName_, 8, shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, recordNumber, this.system_), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        Record[] returned = this.processReadReply(replys, false);
        return returned[0];
    }

    public Record positionCursorToIndexLong(long recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr;
        Vector replys;
        int codePoint;
        if (this.cacheRecords_ && !this.cache_.setPositionLong(recordNumber)) {
            this.cache_.setIsEmpty();
        }
        if ((codePoint = ((DDMDataStream)(replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETDLong(this.dclName_, this.recordFormatCTLLName_, 8, shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, recordNumber, this.system_), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        Record[] returned = this.processReadReplyLong(replys, false);
        return returned[0];
    }

    public Record positionCursorToKey(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr;
        Vector replys;
        int codePoint;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        if ((codePoint = ((DDMDataStream)(replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormat_, this.recordFormatCTLLName_, searchType, shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, key, this.system_), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        this.processReadReply(replys, true);
        return null;
    }

    public Record positionCursorToKeyLong(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr;
        Vector replys;
        int codePoint;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        if ((codePoint = ((DDMDataStream)(replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormat_, this.recordFormatCTLLName_, searchType, shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, key, this.system_), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        this.processReadReplyLong(replys, true);
        return null;
    }

    public Record positionCursorToKey(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr;
        Vector replys;
        int codePoint;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        if ((codePoint = ((DDMDataStream)(replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormatCTLLName_, searchType, shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, key, this.system_, numberOfKeyFields), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        this.processReadReply(replys, true);
        return null;
    }

    public Record positionCursorToKeyLong(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr;
        Vector replys;
        int codePoint;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        if ((codePoint = ((DDMDataStream)(replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormatCTLLName_, searchType, shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, key, this.system_, numberOfKeyFields), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && replys.size() > 1) {
            this.handleErrorReply(replys, 1);
        } else if (codePoint != 54277) {
            this.handleErrorReply(replys, 0);
        }
        this.processReadReplyLong(replys, true);
        return null;
    }

    public Record[] processReadReply(Vector replys, boolean discardRecords) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record[] returned = null;
        int recordIncrement = this.openFeedback_.getRecordIncrement();
        int codePoint = ((DDMDataStream)replys.elementAt(0)).getCodePoint();
        if (codePoint == 54274) {
            if (replys.size() > 1) {
                codePoint = ((DDMDataStream)replys.elementAt(1)).getCodePoint();
                if (codePoint == 53761) {
                    DDMAS400MessageReply err = new DDMAS400MessageReply(this.system_, ((DDMDataStream)replys.elementAt((int)1)).data_);
                    String msgId = err.getAS400Message().getID();
                    if (msgId.equals("CPF5006") || msgId.equals("CPF5001")) {
                        return returned;
                    }
                    this.handleErrorReply(replys, 1);
                } else {
                    this.handleErrorReply(replys, 1);
                }
            } else {
                this.handleErrorReply(replys, 0);
            }
        } else if (codePoint == 54277) {
            DDMS38IOFB ioFeedback;
            boolean largeBuffer;
            if (discardRecords) {
                return returned;
            }
            DDMDataStream reply = (DDMDataStream)replys.elementAt(0);
            boolean bl = largeBuffer = reply.get16bit(6) > Short.MAX_VALUE;
            if (reply.isChained()) {
                ioFeedback = new DDMS38IOFB(((DDMDataStream)replys.elementAt((int)1)).data_, 10);
            } else {
                int offset = largeBuffer ? reply.get32bit(10) + 18 : reply.get16bit(6) + 10;
                ioFeedback = new DDMS38IOFB(reply.data_, offset);
            }
            int numberOfRecords = ioFeedback.getNumberOfRecordsReturned();
            returned = new Record[numberOfRecords];
            int recordOffset = largeBuffer ? 14 : 10;
            int recordNumberOffset = recordOffset + ioFeedback.getRecordLength() + 2;
            int nullFieldMapOffset = recordOffset + this.openFeedback_.getNullFieldByteMapOffset();
            int numFields = this.recordFormat_.getNumberOfFields();
            boolean isNullCapable = this.openFeedback_.isNullCapable();
            for (int i = 0; i < numberOfRecords; ++i) {
                returned[i] = this.recordFormat_.getNewRecord(reply.data_, recordOffset + i * recordIncrement);
                if (isNullCapable) {
                    for (int j = 0; j < numFields; ++j) {
                        if (reply.data_[nullFieldMapOffset + j + i * recordIncrement] != -15) continue;
                        returned[i].setField(j, null);
                    }
                }
                try {
                    returned[i].setRecordNumber(BinaryConverter.byteArrayToInt(reply.data_, recordNumberOffset + i * recordIncrement));
                    continue;
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
        return returned;
    }

    public Record[] processReadReplyLong(Vector replys, boolean discardRecords) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record[] returned = null;
        int recordIncrement = this.openFeedback_.getRecordIncrement();
        int codePoint = ((DDMDataStream)replys.elementAt(0)).getCodePoint();
        if (codePoint == 54274) {
            if (replys.size() > 1) {
                codePoint = ((DDMDataStream)replys.elementAt(1)).getCodePoint();
                if (codePoint == 53761) {
                    DDMAS400MessageReply err = new DDMAS400MessageReply(this.system_, ((DDMDataStream)replys.elementAt((int)1)).data_);
                    String msgId = err.getAS400Message().getID();
                    if (msgId.equals("CPF5006") || msgId.equals("CPF5001")) {
                        return returned;
                    }
                    this.handleErrorReply(replys, 1);
                } else {
                    this.handleErrorReply(replys, 1);
                }
            } else {
                this.handleErrorReply(replys, 0);
            }
        } else if (codePoint == 54277) {
            DDMS38IOFB ioFeedback;
            boolean largeBuffer;
            if (discardRecords) {
                return returned;
            }
            DDMDataStream reply = (DDMDataStream)replys.elementAt(0);
            boolean bl = largeBuffer = reply.get16bit(6) > Short.MAX_VALUE;
            if (reply.isChained()) {
                ioFeedback = new DDMS38IOFB(((DDMDataStream)replys.elementAt((int)1)).data_, 10);
            } else {
                int offset = largeBuffer ? reply.get32bit(10) + 18 : reply.get16bit(6) + 10;
                ioFeedback = new DDMS38IOFB(reply.data_, offset);
            }
            int numberOfRecords = ioFeedback.getNumberOfRecordsReturned();
            returned = new Record[numberOfRecords];
            int recordOffset = largeBuffer ? 14 : 10;
            int recordNumberOffset = recordOffset + ioFeedback.getRecordLength() + 2;
            int nullFieldMapOffset = recordOffset + this.openFeedback_.getNullFieldByteMapOffset();
            int numFields = this.recordFormat_.getNumberOfFields();
            boolean isNullCapable = this.openFeedback_.isNullCapable();
            for (int i = 0; i < numberOfRecords; ++i) {
                returned[i] = this.recordFormat_.getNewRecord(reply.data_, recordOffset + i * recordIncrement);
                if (isNullCapable) {
                    for (int j = 0; j < numFields; ++j) {
                        if (reply.data_[nullFieldMapOffset + j + i * recordIncrement] != -15) continue;
                        returned[i].setField(j, null);
                    }
                }
                try {
                    returned[i].setRecordNumberLong(BinaryConverter.byteArrayToUnsignedInt(reply.data_, recordNumberOffset + i * recordIncrement));
                    continue;
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
        return returned;
    }

    public AS400Message[] processReplys(Vector replys) throws AS400SecurityException, InterruptedException, IOException {
        AS400Message[] msgs = null;
        Vector<AS400Message[]> as400MsgList = new Vector<AS400Message[]>();
        if (replys != null) {
            block4: for (int i = 0; i < replys.size(); ++i) {
                DDMDataStream reply = (DDMDataStream)replys.elementAt(i);
                int codePoint = reply.getCodePoint();
                switch (codePoint) {
                    case 53761: {
                        DDMAS400MessageReply msgReply = new DDMAS400MessageReply(this.system_, reply.data_);
                        as400MsgList.addElement(msgReply.getAS400MessageList());
                        continue block4;
                    }
                    case 4658: 
                    case 4659: 
                    case 4677: 
                    case 4684: 
                    case 4688: 
                    case 4689: 
                    case 4690: 
                    case 4692: 
                    case 4694: {
                        Trace.log(2, "handleErrorReply()", reply.data_);
                        throw new InternalErrorException(6, codePoint);
                    }
                    default: {
                        Trace.log(2, "handleErrorReply()", reply.data_);
                        throw new InternalErrorException(2, codePoint);
                    }
                }
            }
        }
        if (as400MsgList.size() > 0) {
            int numberOfMessages = 0;
            int msgListSize = as400MsgList.size();
            int msgNumber = 0;
            for (int i = 0; i < msgListSize; ++i) {
                numberOfMessages += ((AS400Message[])as400MsgList.elementAt(i)).length;
            }
            msgs = new AS400Message[numberOfMessages];
            for (int i = 0; i < msgListSize; ++i) {
                AS400Message[] m = (AS400Message[])as400MsgList.elementAt(i);
                for (int j = 0; j < m.length; ++j) {
                    msgs[msgNumber++] = m[j];
                }
            }
        }
        return msgs == null ? new AS400Message[]{} : msgs;
    }

    public Record read(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            return super.read(recordNumber);
        }
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETD(this.dclName_, this.recordFormatCTLLName_, 8, shr, 0, recordNumber, this.system_), this.newCorrelationId());
        Record[] returned = this.processReadReply(replys, false);
        return returned == null ? null : returned[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record[] readAll(String fileType, int bf) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Object[] recArray = new Record[]{};
        AS400FileImplRemote aS400FileImplRemote = this;
        synchronized (aS400FileImplRemote) {
            this.openFile2(0, bf, 3, fileType);
            Vector<Record> allRecords = new Vector<Record>();
            int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
            Record[] returned = this.processReadReply(this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, 1, shr, 0), this.newCorrelationId()), false);
            while (returned != null) {
                for (int i = 0; i < returned.length; ++i) {
                    allRecords.addElement(returned[i]);
                }
                returned = this.processReadReply(this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, 3, shr, 0), this.newCorrelationId()), false);
            }
            int numRecs = allRecords.size();
            if (numRecs > 0) {
                recArray = new Record[numRecs];
                allRecords.copyInto(recArray);
            }
            this.close();
        }
        return recArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record[] readAllLong(String fileType, int bf) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Object[] recArray = new Record[]{};
        AS400FileImplRemote aS400FileImplRemote = this;
        synchronized (aS400FileImplRemote) {
            this.openFile2(0, bf, 3, fileType);
            Vector<Record> allRecords = new Vector<Record>();
            int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
            Record[] returned = this.processReadReplyLong(this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, 1, shr, 0), this.newCorrelationId()), false);
            while (returned != null) {
                for (int i = 0; i < returned.length; ++i) {
                    allRecords.addElement(returned[i]);
                }
                returned = this.processReadReplyLong(this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, 3, shr, 0), this.newCorrelationId()), false);
            }
            int numRecs = allRecords.size();
            if (numRecs > 0) {
                recArray = new Record[numRecs];
                allRecords.copyInto(recArray);
            }
            this.close();
        }
        return recArray;
    }

    public Record read(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormat_, this.recordFormatCTLLName_, searchType, shr, 0, key, this.system_), this.newCorrelationId());
        Record[] returned = this.processReadReply(replys, false);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return returned == null ? null : returned[0];
    }

    public Record readLong(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormat_, this.recordFormatCTLLName_, searchType, shr, 0, key, this.system_), this.newCorrelationId());
        Record[] returned = this.processReadReplyLong(replys, false);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return returned == null ? null : returned[0];
    }

    public Record read(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormatCTLLName_, searchType, shr, 0, key, this.system_, numberOfKeyFields), this.newCorrelationId());
        Record[] returned = this.processReadReply(replys, false);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return returned == null ? null : returned[0];
    }

    public Record readLong(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormatCTLLName_, searchType, shr, 0, key, this.system_, numberOfKeyFields), this.newCorrelationId());
        Record[] returned = this.processReadReplyLong(replys, false);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return returned == null ? null : returned[0];
    }

    public Record readRecord(int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, searchType, shr, 0), this.newCorrelationId());
        Record[] returned = this.processReadReply(replys, false);
        return returned == null ? null : returned[0];
    }

    public Record readRecordLong(int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int shr = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, searchType, shr, 0), this.newCorrelationId());
        Record[] returned = this.processReadReplyLong(replys, false);
        return returned == null ? null : returned[0];
    }

    public Record[] readRecords(int direction) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int searchType = direction == 0 ? 3 : 4;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETM(this.dclName_, this.blockingFactor_, searchType, 0, 0, 1), this.newCorrelationId());
        return this.processReadReply(replys, false);
    }

    public Record[] readRecordsLong(int direction) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int searchType = direction == 0 ? 3 : 4;
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETM(this.dclName_, this.blockingFactor_, searchType, 0, 0, 1), this.newCorrelationId());
        return this.processReadReplyLong(replys, false);
    }

    public void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector replys = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestRLLBCKUOW(), this.newCorrelationId());
        if (replys.size() == 1 && ((DDMDataStream)replys.elementAt(0)).getCodePoint() == 8716) {
            DDMEndUnitOfWorkReply uowReply = new DDMEndUnitOfWorkReply(((DDMDataStream)replys.elementAt((int)0)).data_);
            if (uowReply.getStatus() != 2) {
                Trace.log(2, "AS400FileImplRemote.rollback()", uowReply.data_);
                throw new InternalErrorException(6, uowReply.getStatus());
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector sendRequestAndReceiveReplies(DDMDataStream req, int correlationId) throws InterruptedException, IOException, AS400SecurityException {
        this.connect();
        DDMDataStream reply = null;
        try {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.send(req, correlationId);
                reply = (DDMDataStream)this.server_.receive(correlationId);
            }
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "ConnectionDroppedException:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            this.resetState();
            throw e;
        }
        Vector<DDMDataStream> replys = new Vector<DDMDataStream>();
        while (reply.isChained()) {
            replys.addElement(reply);
            try {
                reply = (DDMDataStream)this.server_.receive(correlationId);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "ConnectionDroppedException:", (Throwable)e);
                this.system_.disconnectServer(this.server_);
                this.resetState();
                throw e;
            }
        }
        replys.addElement(reply);
        return replys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDCLName() {
        long nextDCLName;
        Object object = nextDCLNameLock_;
        synchronized (object) {
            nextDCLName = nextDCLName_++;
        }
        String nextDCLNameAsString = Long.toString(nextDCLName);
        for (int i = 0; i < nextDCLNameAsString.length(); ++i) {
            char c = nextDCLNameAsString.charAt(i);
            this.dclName_[i] = (byte)(c & 0xF | 0xF0);
        }
        this.padBytes(this.dclName_, nextDCLNameAsString.length(), 8 - nextDCLNameAsString.length(), (byte)64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record.getRecordLength() != this.openFeedback_.getRecordLength()) {
            Trace.log(2, "Incorrect record length for file :");
            Trace.log(2, "record.getRecordLength() :" + String.valueOf(record.getRecordLength()));
            throw new ExtendedIllegalArgumentException("record", 2);
        }
        this.connect();
        Record[] records = new Record[]{record};
        int correlationId = this.newCorrelationId();
        DDMRequestDataStream req = DDMRequestDataStream.getRequestS38UPDAT(33, 3, 0, this.dclName_);
        req.setIsChained(true);
        req.setHasSameRequestCorrelation(true);
        int maxNumberOfFieldsPerFormatInFile = -1;
        if (this.rfCache_ != null) {
            int numberOfRecordFormats = this.rfCache_.length;
            for (int i = 0; i < numberOfRecordFormats; ++i) {
                maxNumberOfFieldsPerFormatInFile = Math.max(maxNumberOfFieldsPerFormatInFile, this.rfCache_[i].getNumberOfFields());
            }
        }
        DDMObjectDataStream[] dataToSend = DDMObjectDataStream.getObjectS38BUF(records, this.openFeedback_, this.ssp_, maxNumberOfFieldsPerFormatInFile);
        Vector replys = null;
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            try {
                this.server_.send(req, correlationId);
                replys = this.sendRequestAndReceiveReplies(dataToSend[0], correlationId);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "ConnectionDroppedException:", (Throwable)e);
                this.system_.disconnectServer(this.server_);
                this.resetState();
                throw e;
            }
        }
        if (((DDMDataStream)replys.elementAt(0)).getCodePoint() == 54274) {
            if (replys.size() != 1) {
                this.handleErrorReply(replys, 1);
            }
        } else {
            this.handleErrorReply(replys, 0);
        }
    }

    public boolean verifyS38MSGRM(DDMDataStream replyParm, String msgId, int svrCode) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (replyParm instanceof DDMReplyDataStream) {
            DDMReplyDataStream reply = (DDMReplyDataStream)replyParm;
            DDMAS400MessageReply msgReply = new DDMAS400MessageReply(this.system_, reply.data_);
            AS400Message[] msgs = msgReply.getAS400MessageList();
            for (int i = 0; i < msgs.length; ++i) {
                if (!(msgId != null ? msgs[i].getID().equalsIgnoreCase(msgId) : msgs[i].getSeverity() == svrCode)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Record[] records) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (records[0].getRecordLength() != this.openFeedback_.getRecordLength()) {
            if (Trace.traceOn_) {
                Trace.log(2, "Incorrect record length for file: Expected " + String.valueOf(this.openFeedback_.getRecordLength()) + ", got " + String.valueOf(records[0].getRecordLength()));
            }
            throw new ExtendedIllegalArgumentException("records", 2);
        }
        this.connect();
        int correlationId = this.newCorrelationId();
        DDMRequestDataStream req = DDMRequestDataStream.getRequestS38PUTM(this.dclName_);
        req.setIsChained(true);
        req.setHasSameRequestCorrelation(true);
        int maxNumberOfFieldsPerFormatInFile = -1;
        if (this.rfCache_ != null) {
            int numberOfRecordFormats = this.rfCache_.length;
            for (int i = 0; i < numberOfRecordFormats; ++i) {
                maxNumberOfFieldsPerFormatInFile = Math.max(maxNumberOfFieldsPerFormatInFile, this.rfCache_[i].getNumberOfFields());
            }
        }
        DDMObjectDataStream[] dataToSend = DDMObjectDataStream.getObjectS38BUF(records, this.openFeedback_, this.ssp_, maxNumberOfFieldsPerFormatInFile);
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            for (int i = 0; i < dataToSend.length; ++i) {
                this.server_.send(req, correlationId);
                Vector replys = this.sendRequestAndReceiveReplies(dataToSend[i], correlationId);
                if (((DDMDataStream)replys.elementAt(0)).getCodePoint() == 54274) {
                    if (replys.size() == 1) continue;
                    this.handleErrorReply(replys, 1);
                    continue;
                }
                this.handleErrorReply(replys, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newCorrelationId() {
        Object object = correlationIdLock_;
        synchronized (object) {
            if (lastCorrelationId_ == Short.MAX_VALUE) {
                lastCorrelationId_ = 0;
            }
            return ++lastCorrelationId_;
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new DDMObjectDataStream(), 5);
        AS400Server.addReplyStream((DataStream)new DDMReplyDataStream(), 5);
    }
}

