/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImplBase;
import com.ibm.as400.access.AS400FileRecordDescriptionImpl;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.DBCSEitherFieldDescription;
import com.ibm.as400.access.DBCSGraphicFieldDescription;
import com.ibm.as400.access.DBCSOnlyFieldDescription;
import com.ibm.as400.access.DBCSOpenFieldDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QWHDRFFDFormat;
import com.ibm.as400.access.QWHFDACPFormat;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SaveFileAttrFormat;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.TimestampFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;

class AS400FileRecordDescriptionImplRemote
implements AS400FileRecordDescriptionImpl {
    static final long serialVersionUID = 4L;
    private String file_ = "";
    private String library_ = "";
    private String name_ = "";
    private AS400FileImplBase theFile_ = null;
    private AS400ImplRemote system_ = null;
    private static Object lockJT4FFD_ = new Object();
    private static Object lockJT4FD_ = new Object();

    AS400FileRecordDescriptionImplRemote() {
    }

    void addFieldDescription(RecordFormat rf, Record record) throws UnsupportedEncodingException {
        char fieldType = ((String)record.getField("WHFLDT")).charAt(0);
        FieldDescription fd = null;
        String fieldName = ((String)record.getField("WHFLDE")).trim();
        switch (fieldType) {
            case 'A': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new CharacterFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((CharacterFieldDescription)fd).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((CharacterFieldDescription)fd).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((CharacterFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((CharacterFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'B': {
                String dft;
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                if (digits < 5) {
                    fd = new BinaryFieldDescription(new AS400Bin2(), fieldName, fieldName, digits);
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    dft = ((String)record.getField("WHDFT")).trim();
                    if (dft.charAt(0) == '+') {
                        dft = dft.substring(1);
                    }
                    if (dft.indexOf("*NULL") != -1) {
                        ((BinaryFieldDescription)fd).setDFTNull();
                        break;
                    }
                    ((BinaryFieldDescription)fd).setDFT(new Short(dft));
                    break;
                }
                if (digits < 10) {
                    fd = new BinaryFieldDescription(new AS400Bin4(), fieldName, fieldName, digits);
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    dft = ((String)record.getField("WHDFT")).trim();
                    if (dft.charAt(0) == '+') {
                        dft = dft.substring(1);
                    }
                    if (dft.indexOf("*NULL") != -1) {
                        ((BinaryFieldDescription)fd).setDFTNull();
                        break;
                    }
                    ((BinaryFieldDescription)fd).setDFT(new Integer(dft));
                    break;
                }
                fd = new BinaryFieldDescription(new AS400Bin8(), fieldName, fieldName, digits);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                dft = ((String)record.getField("WHDFT")).trim();
                if (dft.charAt(0) == '+') {
                    dft = dft.substring(1);
                }
                if (dft.indexOf("*NULL") != -1) {
                    ((BinaryFieldDescription)fd).setDFTNull();
                    break;
                }
                ((BinaryFieldDescription)fd).setDFT(new Long(dft));
                break;
            }
            case 'E': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new DBCSEitherFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSEitherFieldDescription)fd).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSEitherFieldDescription)fd).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((DBCSEitherFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((DBCSEitherFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'F': {
                String dft;
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int decimalPositions = ((BigDecimal)record.getField("WHFLDP")).intValue();
                int byteLength = ((BigDecimal)record.getField("WHFLDB")).intValue();
                if (byteLength == 4) {
                    fd = new FloatFieldDescription(new AS400Float4(), fieldName, fieldName, digits, decimalPositions);
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    dft = ((String)record.getField("WHDFT")).trim();
                    if (dft.charAt(0) == '+') {
                        dft = dft.substring(1);
                    }
                    if (dft.indexOf("*NULL") != -1) {
                        ((FloatFieldDescription)fd).setDFTNull();
                        break;
                    }
                    ((FloatFieldDescription)fd).setDFT(new Float(dft));
                    break;
                }
                if (byteLength == 8) {
                    fd = new FloatFieldDescription(new AS400Float8(), fieldName, fieldName, digits, decimalPositions);
                    ((FloatFieldDescription)fd).setFLTPCN("*DOUBLE");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    dft = ((String)record.getField("WHDFT")).trim();
                    if (dft.charAt(0) == '+') {
                        dft = dft.substring(1);
                    }
                    if (dft.indexOf("*NULL") != -1) {
                        ((FloatFieldDescription)fd).setDFTNull();
                        break;
                    }
                    ((FloatFieldDescription)fd).setDFT(new Double(dft));
                    break;
                }
                Trace.log(2, "FloatFieldDescription error in byte length");
                throw new InternalErrorException(6);
            }
            case 'G': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new DBCSGraphicFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSGraphicFieldDescription)fd).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSGraphicFieldDescription)fd).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((DBCSGraphicFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((DBCSGraphicFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'H': {
                fd = new HexFieldDescription(new AS400ByteArray(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()), fieldName);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((HexFieldDescription)fd).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((HexFieldDescription)fd).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((HexFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                byte[] dftBytes = adjDft.getBytes();
                ((HexFieldDescription)fd).setDFT(dftBytes);
                break;
            }
            case 'J': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new DBCSOnlyFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSOnlyFieldDescription)fd).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSOnlyFieldDescription)fd).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((DBCSOnlyFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((DBCSOnlyFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'L': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new DateFieldDescription(new AS400Text(((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                ((DateFieldDescription)fd).setDATFMT((String)record.getField("WHFMT"));
                if (!((String)record.getField("WHFMT")).equals(" ")) {
                    ((DateFieldDescription)fd).setDATSEP((String)record.getField("WHSEP"));
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((DateFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("CURRENT_DATE") != -1) {
                    ((DateFieldDescription)fd).setDFTCurrent();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((DateFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'O': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new DBCSOpenFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSOpenFieldDescription)fd).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSOpenFieldDescription)fd).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((DBCSOpenFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((DBCSOpenFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'P': {
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int decimalPositions = ((BigDecimal)record.getField("WHFLDP")).intValue();
                fd = new PackedDecimalFieldDescription(new AS400PackedDecimal(digits, decimalPositions), fieldName);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = ((String)record.getField("WHDFT")).trim();
                if (dft.charAt(0) == '+') {
                    dft = dft.substring(1);
                }
                if (dft.indexOf("*NULL") != -1) {
                    ((PackedDecimalFieldDescription)fd).setDFTNull();
                    break;
                }
                ((PackedDecimalFieldDescription)fd).setDFT(new BigDecimal(dft));
                break;
            }
            case 'S': {
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int decimalPositions = ((BigDecimal)record.getField("WHFLDP")).intValue();
                fd = new ZonedDecimalFieldDescription(new AS400ZonedDecimal(digits, decimalPositions), fieldName);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = ((String)record.getField("WHDFT")).trim();
                if (dft.charAt(0) == '+') {
                    dft = dft.substring(1);
                }
                if (dft.indexOf("*NULL") != -1) {
                    ((ZonedDecimalFieldDescription)fd).setDFTNull();
                    break;
                }
                ((ZonedDecimalFieldDescription)fd).setDFT(new BigDecimal(dft));
                break;
            }
            case 'T': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new TimeFieldDescription(new AS400Text(((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                ((TimeFieldDescription)fd).setTIMFMT((String)record.getField("WHFMT"));
                if (!((String)record.getField("WHSEP")).equals(" ")) {
                    ((TimeFieldDescription)fd).setTIMSEP((String)record.getField("WHSEP"));
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((TimeFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("CURRENT_TIME") != -1) {
                    ((TimeFieldDescription)fd).setDFTCurrent();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((TimeFieldDescription)fd).setDFT(adjDft);
                break;
            }
            case 'Z': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                fd = new TimestampFieldDescription(new AS400Text(((BigDecimal)record.getField("WHFLDB")).intValue(), ccsid, this.system_), fieldName);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    ((TimestampFieldDescription)fd).setDFTNull();
                    break;
                }
                if (dft.indexOf("CURRENT_TIMESTAMP") != -1) {
                    ((TimestampFieldDescription)fd).setDFTCurrent();
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                ((TimestampFieldDescription)fd).setDFT(adjDft);
                break;
            }
            default: {
                Trace.log(2, "Unrecognized field type: " + fieldType);
                throw new InternalErrorException(6);
            }
        }
        if (((String)record.getField("WHNULL")).equals("Y")) {
            fd.setALWNULL(true);
        }
        fd.setTEXT(((String)record.getField("WHFTXT")).trim());
        String value = ((String)record.getField("WHALIS")).trim();
        if (value.length() != 0) {
            fd.setALIAS(value);
        }
        if ((value = ((String)record.getField("WHRFIL")).trim()).length() != 0) {
            fd.setREFFIL(value);
        }
        if ((value = ((String)record.getField("WHRFLD")).trim()).length() != 0) {
            fd.setREFFLD(value);
        }
        if ((value = ((String)record.getField("WHRFMT")).trim()).length() != 0) {
            fd.setREFFMT(value);
        }
        if ((value = ((String)record.getField("WHRLIB")).trim()).length() != 0) {
            fd.setREFLIB(value);
        }
        String colHdg1 = ((String)record.getField("WHCHD1")).trim();
        String colHdg2 = ((String)record.getField("WHCHD2")).trim();
        String colHdg3 = ((String)record.getField("WHCHD3")).trim();
        if (colHdg1.length() != 0 || colHdg2.length() != 0 || colHdg3.length() != 0) {
            StringBuffer sb = new StringBuffer();
            if (colHdg1.length() == 0) {
                sb.append("''");
            } else {
                sb.append("'" + colHdg1 + "'");
            }
            if (colHdg2.length() == 0) {
                if (colHdg3.length() != 0) {
                    sb.append(" ''");
                }
            } else {
                sb.append(" '" + colHdg2 + "'");
            }
            if (colHdg3.length() != 0) {
                sb.append(" '" + colHdg3 + "'");
            }
            fd.setCOLHDG(sb.toString());
        }
        rf.addFieldDescription(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createRecordFormatSource(String packageName) throws AS400Exception, AS400SecurityException, IOException, InterruptedException {
        Object msgs;
        String cmd = "DSPFFD FILE(" + this.library_ + "/" + this.file_ + ") OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FFD)";
        Record[] records = null;
        Object object = lockJT4FFD_;
        synchronized (object) {
            msgs = this.theFile_.execute(cmd);
            if (((AS400Message[])msgs).length > 0) {
                if (!msgs[0].getID().equals("CPF9861") && !msgs[0].getID().equals("CPF3030")) {
                    throw new AS400Exception((AS400Message[])msgs);
                }
            } else {
                Trace.log(2, "DSPFFD failed to return success message", cmd);
                throw new InternalErrorException(6);
            }
            AS400FileImplBase tempFile = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            tempFile.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FFD.FILE", new QWHDRFFDFormat(this.system_.getCcsid()), false, false, false);
            records = tempFile.readAll("seq", 100);
            tempFile.delete();
        }
        cmd = "DSPFD FILE(" + this.library_ + "/" + this.file_ + ") TYPE(*ACCPTH) OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FD)";
        Record[] keyRecords = null;
        msgs = lockJT4FD_;
        synchronized (msgs) {
            AS400Message[] msgs2 = this.theFile_.execute(cmd);
            if (msgs2.length > 0) {
                if (!msgs2[0].getID().equals("CPF9861") && !msgs2[0].getID().equals("CPF3030")) {
                    throw new AS400Exception(msgs2);
                }
            } else {
                Trace.log(2, "DSPFD failed to return success message", cmd);
                throw new InternalErrorException(6);
            }
            AS400FileImplBase tempFile = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            tempFile.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FD.FILE", new QWHFDACPFormat(this.system_.getCcsid()), false, false, false);
            keyRecords = tempFile.readAll("key", 100);
            tempFile.delete();
        }
        int numberOfRecordFormats = ((BigDecimal)records[0].getField("WHCNT")).intValue();
        int numberOfFields = 0;
        int numberOfKeyFields = 0;
        int recordNumber = 0;
        int keyRecordNumber = 0;
        String[] filesToWrite = new String[numberOfRecordFormats * 2];
        for (int i = 0; i < numberOfRecordFormats; ++i) {
            int j;
            String rfNameUntrimmed = (String)records[recordNumber].getField("WHNAME");
            String rfName = rfNameUntrimmed.replace('\"', ' ').trim();
            filesToWrite[i] = rfName + "Format.java";
            StringWriter sourceString = new StringWriter();
            PrintWriter sourceFile = new PrintWriter(sourceString);
            sourceFile.println("/*******************************************************************************");
            sourceFile.println(" This source is an example of the Java source necessary ");
            sourceFile.println(" to generate a RecordFormat subclass for file " + this.name_ + ".");
            sourceFile.println(" IBM grants you a nonexclusive license to use this source.");
            sourceFile.println(" You may change and use this souce as necessary.");
            sourceFile.println();
            sourceFile.println();
            sourceFile.println("                            DISCLAIMER");
            sourceFile.println("                            ----------");
            sourceFile.println();
            sourceFile.println(" This source code is provided by IBM for illustrative purposes only.");
            sourceFile.println(" The source has not been thoroughly tested under all conditions.");
            sourceFile.println(" IBM, therefore, cannot guarantee or imply reliability, serviceability,");
            sourceFile.println(" or function of the source.  All source contained herein are provided to you \"AS IS\"");
            sourceFile.println(" without any warranties of any kind.");
            sourceFile.println(" ALL WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED");
            sourceFile.println(" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR");
            sourceFile.println(" PURPOSE, ARE EXPRESSLY DISCLAIMED.");
            sourceFile.println();
            sourceFile.println();
            sourceFile.println(" Your license to this source code provides you no right or licenses to");
            sourceFile.println(" any IBM patents.  IBM has no obligation to defend or indemnify against");
            sourceFile.println(" any claim of infringement, including but not limited to: patents,");
            sourceFile.println(" copyright, trade secret, or intellectual property rights of any kind.");
            sourceFile.println();
            sourceFile.println();
            sourceFile.println("             COPYRIGHT");
            sourceFile.println("             ---------");
            sourceFile.println("Copyright (C) 1997-1999 International Business Machines Corporation and others.");
            sourceFile.println("All rights reserved.");
            sourceFile.println("US Government Users Restricted Rights -");
            sourceFile.println("Use, duplication or disclosure restricted");
            sourceFile.println("by GSA ADP Schedule Contract with IBM Corp.");
            sourceFile.println("Licensed Material - Property of IBM");
            sourceFile.println("********************************************************************************/");
            sourceFile.println();
            sourceFile.println("// Created by AS400FileRecordDescription on " + new Date());
            sourceFile.println();
            if (packageName != null) {
                sourceFile.println("package " + packageName + ";");
            }
            sourceFile.println();
            sourceFile.println("import java.math.BigDecimal;");
            sourceFile.println("import com.ibm.as400.access.RecordFormat;");
            sourceFile.println("import com.ibm.as400.access.AS400Bin2;");
            sourceFile.println("import com.ibm.as400.access.AS400Bin4;");
            sourceFile.println("import com.ibm.as400.access.AS400Bin8;");
            sourceFile.println("import com.ibm.as400.access.AS400ByteArray;");
            sourceFile.println("import com.ibm.as400.access.AS400Float4;");
            sourceFile.println("import com.ibm.as400.access.AS400Float8;");
            sourceFile.println("import com.ibm.as400.access.AS400PackedDecimal;");
            sourceFile.println("import com.ibm.as400.access.AS400Text;");
            sourceFile.println("import com.ibm.as400.access.AS400ZonedDecimal;");
            sourceFile.println("import com.ibm.as400.access.BinaryFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.CharacterFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.DateFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.DBCSEitherFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.DBCSGraphicFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.DBCSOnlyFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.DBCSOpenFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.FieldDescription;");
            sourceFile.println("import com.ibm.as400.access.FloatFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.HexFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.PackedDecimalFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.TimeFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.TimestampFieldDescription;");
            sourceFile.println("import com.ibm.as400.access.ZonedDecimalFieldDescription;");
            sourceFile.println();
            sourceFile.println("public class " + rfName + "Format extends RecordFormat");
            sourceFile.println("{");
            sourceFile.println();
            sourceFile.println("  public " + rfName + "Format()");
            sourceFile.println("  {");
            sourceFile.println("    super(\"" + rfName + "\");");
            numberOfFields = ((BigDecimal)records[recordNumber].getField("WHNFLD")).intValue();
            if (numberOfFields > 0) {
                sourceFile.println("    // Add field descriptions to this record format");
                j = 0;
                while (j < numberOfFields) {
                    this.writeFieldDescription(sourceFile, records[recordNumber]);
                    ++j;
                    ++recordNumber;
                }
            }
            if ((numberOfKeyFields = ((BigDecimal)keyRecords[keyRecordNumber].getField("APNKYF")).intValue()) > 0) {
                sourceFile.println("    // Add key field descriptions to this record format");
                j = 0;
                while (j < numberOfKeyFields) {
                    sourceFile.println("    addKeyFieldDescription(\"" + ((String)keyRecords[keyRecordNumber].getField("APKEYF")).trim() + "\");");
                    ++j;
                    ++keyRecordNumber;
                }
            }
            sourceFile.println("  }");
            sourceFile.println("}");
            if (sourceFile.checkError()) {
                sourceFile.close();
                Trace.log(2, "Error writing to sourceFile.");
                throw new InternalErrorException(6);
            }
            sourceFile.close();
            filesToWrite[i + 1] = sourceString.toString();
        }
        return filesToWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Record getSavefileAttributes() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        String cmd = "DSPFD FILE(" + this.library_ + "/" + this.file_ + ") TYPE(*ATR) FILEATR(*SAVF) OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FD)";
        Record[] attrRecords = null;
        Object object = lockJT4FD_;
        synchronized (object) {
            AS400Message[] msgs = this.theFile_.execute(cmd);
            if (msgs.length > 0) {
                if (!msgs[0].getID().equals("CPF9861") && !msgs[0].getID().equals("CPF3030")) {
                    throw new AS400Exception(msgs);
                }
            } else {
                Trace.log(2, "DSPFD failed to return success message", cmd);
                throw new InternalErrorException(6);
            }
            AS400FileImplBase tempFile = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            tempFile.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FD.FILE", new SaveFileAttrFormat(this.system_.getCcsid()), false, false, false);
            attrRecords = tempFile.readAll("seq", 100);
            if (attrRecords.length == 0) {
                Trace.log(2, "No records were returned from command " + cmd);
                throw new InternalErrorException(6);
            }
            tempFile.delete();
        }
        return attrRecords[0];
    }

    private void parseName(String name) {
        QSYSObjectPathName ifs = new QSYSObjectPathName(name);
        if (!ifs.getObjectType().equals("FILE") && !ifs.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(name, 1);
        }
        this.library_ = ifs.getLibraryName();
        this.file_ = ifs.getObjectName();
        this.name_ = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordFormat[] retrieveRecordFormat() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Object tempFile;
        String cmd = "DSPFFD FILE(" + this.library_ + "/" + this.file_ + ") OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FFD)";
        Record[] records = null;
        boolean neededToResetCcsid = false;
        Object object = lockJT4FFD_;
        synchronized (object) {
            tempFile = null;
            boolean done = false;
            for (int i = 0; !done && i < 2; ++i) {
                AS400Message[] msgs = this.theFile_.execute(cmd);
                if (msgs.length > 0) {
                    if (!msgs[0].getID().equals("CPF9861") && !msgs[0].getID().equals("CPF3030")) {
                        throw new AS400Exception(msgs);
                    }
                } else {
                    Trace.log(2, "DSPFFD failed to return success message", cmd);
                    throw new InternalErrorException(6);
                }
                if (tempFile == null) {
                    tempFile = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
                    ((AS400FileImplBase)tempFile).setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FFD.FILE", new QWHDRFFDFormat(this.system_.getCcsid()), false, false, false);
                }
                if ((records = ((AS400FileImplBase)tempFile).readAll("seq", 100)).length == 0) {
                    done = false;
                    neededToResetCcsid = true;
                    int ccsid = this.system_.getCcsid();
                    if (Trace.traceOn_) {
                        Trace.log(1, "No records were returned from command " + cmd + "; system CCSID is: " + ccsid + ". Resetting CCSID of DSPFFD OUTFILE to " + ccsid);
                    }
                    this.resetOutfileCCSID("QTEMP", "JT4FFD", ccsid);
                    continue;
                }
                done = true;
            }
            ((AS400FileImplBase)tempFile).delete();
        }
        if (records.length == 0) {
            Trace.log(2, "No records were returned from command " + cmd);
            throw new InternalErrorException(6);
        }
        cmd = "DSPFD FILE(" + this.library_ + "/" + this.file_ + ") TYPE(*ACCPTH) OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FD)";
        Record[] keyRecords = null;
        tempFile = lockJT4FD_;
        synchronized (tempFile) {
            AS400FileImplBase tempFile2 = null;
            boolean done = false;
            for (int i = 0; !done && i < 2; ++i) {
                AS400Message[] msgs = this.theFile_.execute(cmd);
                if (msgs.length > 0) {
                    if (!msgs[0].getID().equals("CPF9861") && !msgs[0].getID().equals("CPF3030")) {
                        throw new AS400Exception(msgs);
                    }
                } else {
                    Trace.log(2, "DSPFD failed to return success message", cmd);
                    throw new InternalErrorException(6);
                }
                if (tempFile2 == null) {
                    tempFile2 = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
                    tempFile2.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FD.FILE", new QWHFDACPFormat(this.system_.getCcsid()), false, false, false);
                }
                if ((keyRecords = tempFile2.readAll("key", 100)).length == 0 && neededToResetCcsid) {
                    done = false;
                    int ccsid = this.system_.getCcsid();
                    if (Trace.traceOn_) {
                        Trace.log(1, "No key records were returned from command " + cmd + "; system CCSID is: " + ccsid + ". Resetting CCSID of DSPFD OUTFILE to " + ccsid);
                    }
                    this.resetOutfileCCSID("QTEMP", "JT4FD", ccsid);
                    continue;
                }
                done = true;
            }
            tempFile2.delete();
        }
        int numberOfRecordFormats = ((BigDecimal)records[0].getField("WHCNT")).intValue();
        int numberOfFields = 0;
        int numberOfKeyFields = 0;
        int recordNumber = 0;
        int keyRecordNumber = 0;
        RecordFormat[] rfs = new RecordFormat[numberOfRecordFormats];
        for (int i = 0; i < numberOfRecordFormats; ++i) {
            int j;
            String rfNameUntrimmed = (String)records[recordNumber].getField("WHNAME");
            String rfName = rfNameUntrimmed.trim();
            rfs[i] = new RecordFormat(rfName);
            numberOfFields = ((BigDecimal)records[recordNumber].getField("WHNFLD")).intValue();
            if (numberOfFields > 0) {
                j = 0;
                while (j < numberOfFields) {
                    this.addFieldDescription(rfs[i], records[recordNumber]);
                    ++j;
                    ++recordNumber;
                }
            }
            if ((numberOfKeyFields = ((BigDecimal)keyRecords[keyRecordNumber].getField("APNKYF")).intValue()) <= 0) continue;
            j = 0;
            while (j < numberOfKeyFields) {
                rfs[i].addKeyFieldDescription(((String)keyRecords[keyRecordNumber].getField("APKEYF")).trim());
                ++j;
                ++keyRecordNumber;
            }
        }
        return rfs;
    }

    private final void resetOutfileCCSID(String library, String file, int ccsid) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        String cmd = "CHGPF FILE(" + library + "/" + file + ") SRCFILE(*NONE) CCSID(" + ccsid + ")";
        AS400Message[] msgs = this.theFile_.execute(cmd);
        if (msgs.length > 0) {
            if (!msgs[0].getID().equals("CPD3238") && !msgs[0].getID().equals("CPC7303")) {
                throw new AS400Exception(msgs);
            }
        } else {
            Trace.log(2, "CHGPF failed to return success message", cmd);
            throw new InternalErrorException(6);
        }
    }

    public void setPath(String name) {
        if (this.theFile_ != null) {
            this.theFile_.setPath(name);
        }
        this.parseName(name);
        this.name_ = name;
    }

    public void setSystem(AS400Impl system) {
        if (this.theFile_ == null) {
            this.theFile_ = (AS400FileImplBase)((AS400ImplRemote)system).loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            if (!this.name_.equals("")) {
                this.theFile_.setPath(this.name_);
            }
        }
        this.theFile_.setSystem(system);
        this.system_ = (AS400ImplRemote)system;
    }

    public void writeFieldDescription(PrintWriter sourceFile, Record record) throws UnsupportedEncodingException {
        char fieldType = ((String)record.getField("WHFLDT")).charAt(0);
        Object fd = null;
        String fieldName = ((String)record.getField("WHFLDE")).trim();
        switch (fieldType) {
            case 'A': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new CharacterFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        sourceFile.println("    ((CharacterFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        sourceFile.println("    ((CharacterFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((CharacterFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((CharacterFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'B': {
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                if (digits < 5) {
                    sourceFile.println("    addFieldDescription(new BinaryFieldDescription(new AS400Bin2(), \"" + fieldName + "\", \"" + fieldName + "\", " + String.valueOf(digits) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String dft = ((String)record.getField("WHDFT")).trim();
                        if (dft.charAt(0) == '+') {
                            dft = dft.substring(1);
                        }
                        if (dft.indexOf("*NULL") != -1) {
                            sourceFile.println("    ((BinaryFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                        } else {
                            sourceFile.println("    ((BinaryFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new Short(\"" + dft + "\"));");
                        }
                    }
                } else if (digits < 10) {
                    sourceFile.println("    addFieldDescription(new BinaryFieldDescription(new AS400Bin4(), \"" + fieldName + "\", \"" + fieldName + "\", " + String.valueOf(digits) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String dft = ((String)record.getField("WHDFT")).trim();
                        if (dft.charAt(0) == '+') {
                            dft = dft.substring(1);
                        }
                        if (dft.indexOf("*NULL") != -1) {
                            sourceFile.println("    ((BinaryFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                        } else {
                            sourceFile.println("    ((BinaryFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new Integer(\"" + dft + "\"));");
                        }
                    }
                } else {
                    sourceFile.println("    addFieldDescription(new BinaryFieldDescription(new AS400Bin8(), \"" + fieldName + "\", \"" + fieldName + "\", " + String.valueOf(digits) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String dft = ((String)record.getField("WHDFT")).trim();
                        if (dft.charAt(0) == '+') {
                            dft = dft.substring(1);
                        }
                        if (dft.indexOf("*NULL") != -1) {
                            sourceFile.println("    ((BinaryFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                        } else {
                            sourceFile.println("    ((BinaryFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new Long(\"" + dft + "\"));");
                        }
                    }
                }
                if (!((String)record.getField("WHNULL")).equals("Y")) break;
                sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                break;
            }
            case 'E': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new DBCSEitherFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        sourceFile.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        sourceFile.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'F': {
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int decimalPositions = ((BigDecimal)record.getField("WHFLDP")).intValue();
                int byteLength = ((BigDecimal)record.getField("WHFLDB")).intValue();
                if (byteLength == 4) {
                    sourceFile.println("    addFieldDescription(new FloatFieldDescription(new AS400Float4(), \"" + fieldName + "\", \"" + fieldName + "\", " + String.valueOf(digits) + ", " + String.valueOf(decimalPositions) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String dft = ((String)record.getField("WHDFT")).trim();
                        if (dft.charAt(0) == '+') {
                            dft = dft.substring(1);
                        }
                        if (dft.indexOf("*NULL") != -1) {
                            sourceFile.println("    ((FloatFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                        } else {
                            sourceFile.println("    ((FloatFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new Float(\"" + dft + "\"));");
                        }
                    }
                } else if (byteLength == 8) {
                    sourceFile.println("    addFieldDescription(new FloatFieldDescription(new AS400Float8(), \"" + fieldName + "\", \"" + fieldName + "\", " + String.valueOf(digits) + ", " + String.valueOf(decimalPositions) + "));");
                    sourceFile.println("    ((FloatFieldDescription)getFieldDescription(\"" + fieldName + "\")).setFLTPCN(\"*DOUBLE\");");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String dft = ((String)record.getField("WHDFT")).trim();
                        if (dft.charAt(0) == '+') {
                            dft = dft.substring(1);
                        }
                        if (dft.indexOf("*NULL") != -1) {
                            sourceFile.println("    ((FloatFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                        } else {
                            sourceFile.println("    ((FloatFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new Double(\"" + dft + "\"));");
                        }
                    }
                } else {
                    Trace.log(2, "FloatFieldDescription error in byte length");
                    throw new InternalErrorException(6);
                }
                if (!((String)record.getField("WHNULL")).equals("Y")) break;
                sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                break;
            }
            case 'G': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new DBCSGraphicFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        sourceFile.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        sourceFile.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'H': {
                sourceFile.println("    addFieldDescription(new HexFieldDescription(new AS400ByteArray(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        sourceFile.println("    ((HexFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        sourceFile.println("    ((HexFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((HexFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                byte[] byteDft = adjDft.getBytes();
                sourceFile.print("    ((HexFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new byte[] { ");
                sourceFile.print(byteDft[0]);
                for (int i = 1; i < byteDft.length; ++i) {
                    sourceFile.print(", ");
                    sourceFile.print(byteDft[i]);
                }
                sourceFile.println(" });");
                break;
            }
            case 'J': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new DBCSOnlyFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        sourceFile.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        sourceFile.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'L': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new DateFieldDescription(new AS400Text(" + String.valueOf(((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                sourceFile.println("    ((DateFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDATFMT(\"" + (String)record.getField("WHFMT") + "\");");
                if (!((String)record.getField("WHSEP")).equals(" ")) {
                    sourceFile.println("    ((DateFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDATSEP(\"" + (String)record.getField("WHSEP") + "\");");
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((DateFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("CURRENT_DATE") != -1) {
                    sourceFile.println("    ((DateFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTCurrent();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((DateFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'O': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new DBCSOpenFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        sourceFile.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        sourceFile.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + fieldName + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'P': {
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int decimalPositions = ((BigDecimal)record.getField("WHFLDP")).intValue();
                sourceFile.println("    addFieldDescription(new PackedDecimalFieldDescription(new AS400PackedDecimal(" + String.valueOf(digits) + ", " + String.valueOf(decimalPositions) + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = ((String)record.getField("WHDFT")).trim();
                if (dft.charAt(0) == '+') {
                    dft = dft.substring(1);
                }
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((PackedDecimalFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                sourceFile.println("    ((PackedDecimalFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new BigDecimal(\"" + dft + "\"));");
                break;
            }
            case 'S': {
                int digits = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int decimalPositions = ((BigDecimal)record.getField("WHFLDP")).intValue();
                sourceFile.println("    addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(" + String.valueOf(digits) + ", " + String.valueOf(decimalPositions) + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = ((String)record.getField("WHDFT")).trim();
                if (dft.charAt(0) == '+') {
                    dft = dft.substring(1);
                }
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((ZonedDecimalFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                sourceFile.println("    ((ZonedDecimalFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(new BigDecimal(\"" + dft + "\"));");
                break;
            }
            case 'T': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new TimeFieldDescription(new AS400Text(" + String.valueOf(((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                sourceFile.println("    ((TimeFieldDescription)getFieldDescription(\"" + fieldName + "\")).setTIMFMT(\"" + (String)record.getField("WHFMT") + "\");");
                if (!((String)record.getField("WHSEP")).equals(" ")) {
                    sourceFile.println("    ((TimeFieldDescription)getFieldDescription(\"" + fieldName + "\")).setTIMSEP(\"" + (String)record.getField("WHSEP") + "\");");
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((TimeFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("CURRENT_TIME") != -1) {
                    sourceFile.println("    ((TimeFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTCurrent();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((TimeFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
                break;
            }
            case 'Z': {
                int ccsid = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (ccsid == 65535) {
                    ccsid = this.system_.getCcsid();
                }
                sourceFile.println("    addFieldDescription(new TimestampFieldDescription(new AS400Text(" + String.valueOf(((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + ccsid + "), \"" + fieldName + "\"));");
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    sourceFile.println("    getFieldDescription(\"" + fieldName + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String dft = (String)record.getField("WHDFT");
                if (dft.indexOf("*NULL") != -1) {
                    sourceFile.println("    ((TimestampFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTNull();");
                    break;
                }
                if (dft.indexOf("CURRENT_TIMESTAMP") != -1) {
                    sourceFile.println("    ((TimestampFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFTCurrent();");
                    break;
                }
                if (dft.indexOf("'") == -1) break;
                String adjDft = dft.substring(dft.indexOf("'") + 1, dft.lastIndexOf("'"));
                sourceFile.println("    ((TimestampFieldDescription)getFieldDescription(\"" + fieldName + "\")).setDFT(\"" + adjDft + "\");");
            }
        }
    }
}

