/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Float8
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 8;
    private static final double defaultValue = 0.0;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 8;
    }

    public Object getDefaultValue() {
        return new Double(0.0);
    }

    public int getInstanceType() {
        return 6;
    }

    public Class getJavaType() {
        return Double.class;
    }

    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[8];
        BinaryConverter.doubleToByteArray((Double)javaValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(double doubleValue) {
        byte[] as400Value = new byte[8];
        BinaryConverter.doubleToByteArray(doubleValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        BinaryConverter.doubleToByteArray((Double)javaValue, as400Value, 0);
        return 8;
    }

    public int toBytes(double doubleValue, byte[] as400Value) {
        BinaryConverter.doubleToByteArray(doubleValue, as400Value, 0);
        return 8;
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        BinaryConverter.doubleToByteArray((Double)javaValue, as400Value, offset);
        return 8;
    }

    public int toBytes(double doubleValue, byte[] as400Value, int offset) {
        BinaryConverter.doubleToByteArray(doubleValue, as400Value, offset);
        return 8;
    }

    public double toDouble(byte[] as400Value) {
        return BinaryConverter.byteArrayToDouble(as400Value, 0);
    }

    public double toDouble(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToDouble(as400Value, offset);
    }

    public Object toObject(byte[] as400Value) {
        return new Double(BinaryConverter.byteArrayToDouble(as400Value, 0));
    }

    public Object toObject(byte[] as400Value, int offset) {
        return new Double(BinaryConverter.byteArrayToDouble(as400Value, offset));
    }
}

