/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocatorOutputStream;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class AS400JDBCBlobLocator
implements Blob {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    JDLobLocator locator_;
    Object savedObject_;
    int savedScale_;
    private byte[] cache_;
    private int cacheOffset_;
    private static final byte[] INIT_CACHE = new byte[0];
    private int maxLength_;

    AS400JDBCBlobLocator(JDLobLocator locator, Object savedObject, int savedScale) {
        this.locator_ = locator;
        this.savedObject_ = savedObject;
        this.savedScale_ = savedScale;
        this.maxLength_ = this.locator_.getMaxLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            return new AS400JDBCInputStream(this.locator_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long position, int length) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            int lengthToUse;
            int offset;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((offset = (int)position - 1) < 0 || length < 0 || (long)(offset + length) > this.locator_.getLength()) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if ((lengthToUse = (int)this.locator_.getLength() - offset) <= 0) {
                return new byte[0];
            }
            if (lengthToUse > length) {
                lengthToUse = length;
            }
            DBLobData data = this.locator_.retrieveData(offset, lengthToUse);
            int actualLength = data.getLength();
            byte[] bytes = new byte[actualLength];
            System.arraycopy(data.getRawBytes(), data.getOffset(), bytes, 0, actualLength);
            return bytes;
        }
    }

    public int getHandle() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return this.locator_.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            return this.locator_.getLength();
        }
    }

    private void initCache() {
        this.cacheOffset_ = 0;
        this.cache_ = INIT_CACHE;
    }

    private int getCachedByte(int index) throws SQLException {
        int realIndex = index - this.cacheOffset_;
        if (realIndex >= this.cache_.length) {
            int blockSize = 1000000;
            int len = (int)this.locator_.getLength();
            if (len < 0) {
                len = Integer.MAX_VALUE;
            }
            if (blockSize + index > len) {
                blockSize = len - index;
            }
            this.cache_ = this.getBytes(index + 1, blockSize);
            this.cacheOffset_ = index;
            realIndex = 0;
        }
        if (this.cache_.length == 0) {
            return -1;
        }
        return this.cache_[realIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] pattern, long position) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            int offset = (int)position - 1;
            if (pattern == null || offset < 0 || (long)offset >= this.locator_.getLength()) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int end = (int)this.locator_.getLength() - pattern.length;
            this.initCache();
            for (int i = offset; i <= end; ++i) {
                int j = 0;
                int cachedByte = this.getCachedByte(i + j);
                while (j < pattern.length && cachedByte != -1 && pattern[j] == (byte)cachedByte) {
                    cachedByte = this.getCachedByte(i + ++j);
                }
                if (j != pattern.length) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Blob pattern, long position) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            int locatorLength;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            int offset = (int)position - 1;
            if (pattern == null || offset < 0 || (long)offset >= this.locator_.getLength()) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int patternLength = (int)pattern.length();
            if (patternLength > (locatorLength = (int)this.locator_.getLength()) || patternLength < 0) {
                return -1L;
            }
            int end = locatorLength - patternLength;
            byte[] bytePattern = pattern.getBytes(1L, patternLength);
            this.initCache();
            for (int i = offset; i <= end; ++i) {
                int j = 0;
                int cachedByte = this.getCachedByte(i + j);
                while (j < patternLength && cachedByte != -1 && bytePattern[j] == (byte)cachedByte) {
                    cachedByte = this.getCachedByte(i + ++j);
                }
                if (j != patternLength) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    public OutputStream setBinaryStream(long position) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (position <= 0L || position > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return new AS400JDBCBlobLocatorOutputStream(this, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long position, byte[] bytesToWrite) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            int numBytes;
            int offset;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((offset = (int)position - 1) < 0 || offset >= this.maxLength_ || bytesToWrite == null) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int newSize = offset + bytesToWrite.length;
            if (newSize < 0) {
                newSize = Integer.MAX_VALUE;
            }
            if ((numBytes = newSize - offset) != bytesToWrite.length) {
                byte[] temp = bytesToWrite;
                bytesToWrite = new byte[numBytes];
                System.arraycopy(temp, 0, bytesToWrite, 0, numBytes);
            }
            this.locator_.writeData((long)offset, bytesToWrite, false);
            return bytesToWrite.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long position, byte[] bytesToWrite, int offset, int lengthOfWrite) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            int numBytes;
            int newSize;
            int blobOffset;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((blobOffset = (int)position - 1) < 0 || blobOffset >= this.maxLength_ || bytesToWrite == null || offset < 0 || lengthOfWrite < 0 || offset + lengthOfWrite > bytesToWrite.length || blobOffset + lengthOfWrite > this.maxLength_) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if ((newSize = blobOffset + lengthOfWrite) < 0) {
                newSize = Integer.MAX_VALUE;
            }
            int realLength = (numBytes = newSize - blobOffset) < lengthOfWrite ? numBytes : lengthOfWrite;
            byte[] newData = new byte[realLength];
            System.arraycopy(bytesToWrite, offset, newData, 0, lengthOfWrite);
            this.locator_.writeData((long)blobOffset, newData, false);
            return newData.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long lengthOfBLOB) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            int length;
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            if ((length = (int)lengthOfBLOB) < 0 || length > this.maxLength_) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            this.locator_.writeData(length, new byte[0], 0, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            if (this.locator_ == null) {
                return;
            }
            this.locator_.free();
            this.locator_ = null;
            this.savedObject_ = null;
            this.cache_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        AS400JDBCBlobLocator aS400JDBCBlobLocator = this;
        synchronized (aS400JDBCBlobLocator) {
            if (this.locator_ == null) {
                JDError.throwSQLException((Object)this, "HY010");
            }
            return new AS400JDBCInputStream(this.locator_, pos, length);
        }
    }

    public int getLocator() {
        return this.locator_.getHandle();
    }
}

