/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400JDBCStatementLock;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLLocator;
import com.ibm.as400.access.ToolboxWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class AS400JDBCResultSet
extends ToolboxWrapper
implements ResultSet {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    static final int HOLDABILITY_NOT_SPECIFIED = -9999;
    static final int HOLD_CURSORS_OVER_COMMIT = 1;
    static final int CLOSE_CURSORS_AT_COMMIT = 2;
    private String catalog_;
    private boolean closed_;
    private int columnCount_;
    private int concurrency_;
    private AS400JDBCConnection connection_;
    private String correlationName_;
    private String cursorName_;
    private boolean dataTruncation_;
    private PreparedStatement deleteStatement_;
    private int fetchDirection_;
    private int fetchSize_;
    private AS400JDBCStatementLock internalLock_;
    private int maxRows_;
    private InputStream openInputStream_;
    private Reader openReader_;
    private JDRow row_;
    private JDRowCache rowCache_;
    private String selectTable_;
    private SQLWarning sqlWarning_;
    private AS400JDBCStatement statement_;
    private int type_;
    private boolean[] updateNulls_;
    private boolean[] updateDefaults_;
    private boolean[] updateUnassigned_;
    private JDRow updateRow_;
    private boolean[] updateSet_;
    private boolean wasNull_;
    private boolean wasDataMappingError_;
    boolean isMetadataResultSet = false;
    private DBReplyRequestedDS reply_ = null;
    private Class byteArrayClass_ = null;
    private SQLException savedException_;
    DBExtendedColumnDescriptors extendedDescriptors_;
    SQLConversionSettings settings_;
    private static final int NOT_KNOWN = -9999;
    private int positionFromFirst_ = 0;
    private int positionFromLast_ = -1;
    private boolean positionInsert_ = false;
    private boolean positionValid_ = false;
    private int totalRows_ = -9999;
    private int highestKnownRow_ = -9999;

    AS400JDBCResultSet(AS400JDBCStatement statement, JDSQLStatement sqlStatement, JDRowCache rowCache, String catalog, String cursorName, int maxRows, int type, int concurrency, int fetchDirection, int fetchSize, DBExtendedColumnDescriptors extendedDescriptors) throws SQLException {
        this.catalog_ = catalog;
        this.closed_ = false;
        this.concurrency_ = concurrency;
        this.connection_ = (AS400JDBCConnection)(statement != null ? statement.getConnection() : null);
        this.settings_ = this.connection_ != null ? SQLConversionSettings.getConversionSettings(this.connection_) : null;
        this.cursorName_ = cursorName;
        this.deleteStatement_ = null;
        this.fetchDirection_ = fetchDirection;
        this.fetchSize_ = fetchSize;
        this.internalLock_ = statement != null ? statement.getInternalLock() : new AS400JDBCStatementLock();
        this.maxRows_ = maxRows;
        this.openInputStream_ = null;
        this.openReader_ = null;
        this.row_ = rowCache.getRow();
        this.rowCache_ = rowCache;
        this.sqlWarning_ = null;
        this.statement_ = statement;
        this.type_ = type;
        this.wasNull_ = false;
        this.wasDataMappingError_ = false;
        this.columnCount_ = this.row_.getFieldCount();
        this.rowCache_.setResultSet(this);
        this.rowCache_.open();
        this.extendedDescriptors_ = extendedDescriptors;
        if (this.connection_ == null || sqlStatement == null || this.connection_.getMustSpecifyForUpdate() && !sqlStatement.isForUpdate()) {
            this.selectTable_ = null;
            this.correlationName_ = null;
            this.concurrency_ = 1007;
        } else {
            this.selectTable_ = sqlStatement.getSelectTable();
            this.correlationName_ = sqlStatement.getCorrelationName();
        }
        if (this.concurrency_ == 1008) {
            this.updateRow_ = new JDSimpleRow(this.row_, true);
            this.updateSet_ = new boolean[this.columnCount_];
            this.updateNulls_ = new boolean[this.columnCount_];
            this.updateDefaults_ = new boolean[this.columnCount_];
            this.updateUnassigned_ = new boolean[this.columnCount_];
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
                this.updateNulls_[i] = true;
            }
        }
        this.dataTruncation_ = this.connection_ != null ? this.connection_.getProperties().getBoolean(33) : false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, this.statement_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Conncurrency", this.concurrency_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Fetch direction", this.fetchDirection_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Fetch size", this.fetchSize_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Max rows", this.maxRows_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Type", this.type_);
        }
    }

    AS400JDBCResultSet(JDRowCache rowCache, String catalog, String cursorName, AS400JDBCConnection con, DBReplyRequestedDS reply) throws SQLException {
        this(null, null, rowCache, catalog, cursorName, 0, 1004, 1007, 1000, 0, reply == null ? null : reply.getExtendedColumnDescriptors());
        this.reply_ = reply;
        if (con != null) {
            this.connection_ = con;
        }
    }

    void checkOpen() throws SQLException {
        if (this.closed_) {
            JDError.throwSQLException("24000");
        }
    }

    private void clearCurrentRow() throws SQLException {
        this.clearCurrentValue();
        this.clearWarnings();
        if (this.concurrency_ == 1008) {
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateNulls_[i] = true;
                this.updateDefaults_[i] = false;
                this.updateUnassigned_[i] = false;
                this.updateSet_[i] = false;
            }
        }
    }

    private void clearCurrentValue() {
        if (this.openInputStream_ != null) {
            try {
                this.openInputStream_.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.openInputStream_ = null;
        }
        if (this.openReader_ != null) {
            try {
                this.openReader_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openReader_ = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.isClosed()) {
                return;
            }
            this.rowCache_.close();
            if (this.reply_ != null) {
                this.reply_.returnToPool();
                this.reply_ = null;
            }
            this.closed_ = true;
            if (this.statement_ != null) {
                this.statement_.notifyClose();
            }
            if (this.deleteStatement_ != null) {
                this.deleteStatement_.close();
            }
            if (this.isMetadataResultSet) {
                this.statement_.close();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logClose(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed_) {
                JDTrace.logInformation(this, "WARNING: Finalizer thread closing result set object.");
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.row_.findField(columnName != null ? columnName : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.statement_ != null) {
                JDCursor cursor = this.statement_.getCursor();
                if (cursor.getCursorAttributeUpdatable() == 0) {
                    return 1007;
                }
                if (cursor.getCursorAttributeUpdatable() == 1) {
                    return 1008;
                }
                return this.concurrency_;
            }
            return this.concurrency_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.cursorName_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.fetchDirection_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.fetchSize_;
        }
    }

    JDRowCache getRowCache() {
        return this.rowCache_;
    }

    public Statement getStatement() throws SQLException {
        if (this.isMetadataResultSet) {
            return null;
        }
        return this.statement_;
    }

    void setStatement(AS400JDBCStatement statement) {
        this.statement_ = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.type_ == 1003) {
                return 1003;
            }
            if (this.statement_ != null) {
                JDCursor cursor = this.statement_.getCursor();
                if (cursor.getCursorAttributeScrollable() == 0) {
                    return 1003;
                }
                if (cursor.getCursorAttributeSensitive() == 0) {
                    return 1004;
                }
                if (cursor.getCursorAttributeSensitive() == 1) {
                    return 1005;
                }
                return this.type_;
            }
            return this.type_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            try {
                String string = this.getString(columnIndex);
                if (string == null) {
                    return null;
                }
                return new URL(string);
            }
            catch (MalformedURLException e) {
                JDError.throwSQLException("07006", e);
                return null;
            }
        }
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    void postWarning(SQLWarning sqlWarning) {
        try {
            if (this.statement_ != null && this.statement_.getConnection() != null && ((AS400JDBCConnection)this.statement_.getConnection()).ignoreWarning(sqlWarning)) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sqlWarning;
        } else {
            this.sqlWarning_.setNextWarning(sqlWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int fetchDirection) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (fetchDirection != 1000 && fetchDirection != 1001 && fetchDirection != 1002 || this.getType() == 1003 && fetchDirection != 1000) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchDirection_ = fetchDirection;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "setFetchDirection", "Fetch direction", this.fetchDirection_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int fetchSize) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (fetchSize < 0 || fetchSize > this.maxRows_ && this.maxRows_ > 0) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchSize_ = fetchSize;
            if (this.rowCache_ instanceof JDServerRowCache) {
                ((JDServerRowCache)this.rowCache_).setFetchSize(this.fetchSize_);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "setFetchSize", "Fetch size", this.fetchSize_);
            }
        }
    }

    public String toString() {
        return this.cursorName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int rowNumber) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (rowNumber == 0) {
                this.beforeFirst();
                return false;
            }
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                if (rowNumber > 0) {
                    if (rowNumber > this.maxRows_) {
                        this.afterLast();
                        return false;
                    }
                } else {
                    int distanceFromFirst;
                    if (this.totalRows_ == -9999) {
                        this.findLastRow();
                    }
                    if ((distanceFromFirst = this.totalRows_ + rowNumber) < 0) {
                        this.beforeFirst();
                        return false;
                    }
                    rowNumber = distanceFromFirst + 1;
                }
            }
            this.rowCache_.absolute(rowNumber);
            this.positionValid_ = this.rowCache_.isValid();
            if (rowNumber > 0) {
                this.positionFromFirst_ = this.positionValid_ ? rowNumber : -1;
                int n = this.positionFromLast_ = this.positionValid_ ? -1 : 0;
                if (this.positionValid_) {
                    if (this.highestKnownRow_ < rowNumber) {
                        this.highestKnownRow_ = rowNumber;
                    }
                    if (this.totalRows_ != -9999) {
                        this.positionFromLast_ = this.totalRows_ - rowNumber + 1;
                    }
                }
            } else {
                this.positionFromFirst_ = this.positionValid_ ? -1 : 0;
                int n = this.positionFromLast_ = this.positionValid_ ? -rowNumber : -1;
                if (this.positionValid_ && this.totalRows_ != -9999) {
                    int currentRow = this.totalRows_ + rowNumber;
                    if (this.highestKnownRow_ < currentRow) {
                        this.highestKnownRow_ = currentRow;
                    }
                    this.positionFromFirst_ = currentRow + 1;
                }
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.last();
            this.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.first();
            this.previous();
            this.positionFromLast_ = -1;
        }
    }

    private void beforePositioning(boolean scrollable) throws SQLException {
        if (this.savedException_ != null) {
            SQLException nextException = this.savedException_;
            this.savedException_ = null;
            JDError.throwSQLException((Object)this, nextException);
        }
        this.checkOpen();
        if (scrollable && this.getType() == 1003) {
            JDError.throwSQLException("24000");
        }
        this.clearCurrentRow();
        this.positionInsert_ = false;
    }

    private void findLastRow() throws SQLException {
        this.checkOpen();
        if (this.totalRows_ != -9999) {
            return;
        }
        if (this.highestKnownRow_ > 0) {
            if (this.highestKnownRow_ >= this.maxRows_) {
                this.highestKnownRow_ = this.maxRows_;
            } else {
                this.rowCache_.absolute(this.highestKnownRow_);
                this.rowCache_.next();
                while (this.rowCache_.isValid()) {
                    ++this.highestKnownRow_;
                    if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                        this.rowCache_.next();
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.rowCache_.first();
            if (!this.rowCache_.isValid()) {
                return;
            }
            this.highestKnownRow_ = 0;
            while (this.rowCache_.isValid()) {
                ++this.highestKnownRow_;
                if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                    this.rowCache_.next();
                    continue;
                }
                break;
            }
        }
        this.totalRows_ = this.highestKnownRow_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            this.rowCache_.first();
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = 1;
                this.positionFromLast_ = this.totalRows_ == -9999 ? -1 : this.totalRows_;
                this.positionValid_ = true;
                if (this.highestKnownRow_ < 1) {
                    this.highestKnownRow_ = 1;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.positionInsert_ || !this.positionValid_ || this.isBeforeFirst() || this.isAfterLast()) {
                return 0;
            }
            if (this.positionFromFirst_ > 0) {
                return this.positionFromFirst_;
            }
            if (this.isLast()) {
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                    return this.positionFromFirst_;
                }
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.previous();
                return this.positionFromFirst_;
            }
            if (this.positionFromLast_ > 0) {
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_ - this.positionFromLast_ + 1;
                    return this.positionFromFirst_;
                }
                int currentPositionFromLast = this.positionFromLast_;
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.absolute(this.totalRows_ - currentPositionFromLast + 1);
                return this.positionFromFirst_;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Could not determine row number in getRow().");
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionFromLast_ == 0 && this.positionFromFirst_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionFromFirst_ == 0 && this.positionFromLast_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionFromFirst_ == 1 && !this.positionInsert_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.positionInsert_ || this.positionFromLast_ > 1 || !this.positionValid_) {
                return false;
            }
            if (this.positionFromLast_ == 1 || this.positionFromFirst_ == this.maxRows_ && this.maxRows_ > 0) {
                return true;
            }
            boolean returnValue = !this.next();
            this.previous();
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                this.findLastRow();
                if (this.totalRows_ >= this.maxRows_) {
                    this.rowCache_.absolute(this.maxRows_);
                } else {
                    this.rowCache_.last();
                }
            } else {
                this.rowCache_.last();
            }
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 1;
                this.positionValid_ = true;
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            this.beforeUpdate();
            this.positionInsert_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(false);
            if (this.maxRows_ > 0 && this.positionFromFirst_ >= this.maxRows_) {
                block15: {
                    try {
                        this.rowCache_.absolute(this.maxRows_ + 1);
                    }
                    catch (Exception e) {
                        if (!JDTrace.isTraceOn()) break block15;
                        JDTrace.logException(this, "Warning: Exception encountered on going to last  ", e);
                    }
                }
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 0;
                this.positionValid_ = false;
                this.totalRows_ = this.maxRows_;
                this.highestKnownRow_ = this.maxRows_;
                return false;
            }
            this.rowCache_.next();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    ++this.positionFromFirst_;
                }
                if (this.positionFromLast_ > 0) {
                    --this.positionFromLast_;
                }
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
                this.positionValid_ = true;
            } else {
                if (!this.rowCache_.isEmpty()) {
                    if (this.positionFromLast_ != 0 && this.positionFromFirst_ >= 0) {
                        this.totalRows_ = this.positionFromFirst_++;
                    }
                    this.positionFromLast_ = 0;
                } else if (this.highestKnownRow_ > 0) {
                    this.positionFromFirst_ = this.totalRows_ = this.highestKnownRow_;
                    this.positionFromLast_ = 0;
                }
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            this.rowCache_.previous();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ > 0) {
                    --this.positionFromFirst_;
                }
                if (this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionValid_ = true;
            } else {
                if (this.positionFromFirst_ != 0 && this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionFromFirst_ = 0;
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            this.beforePositioning(true);
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.concurrency_ == 1008) {
                for (int i = 0; i < this.columnCount_; ++i) {
                    this.updateSet_[i] = false;
                }
            }
            this.rowCache_.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int rowNumber) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            if (rowNumber < 0 && this.isBeforeFirst()) {
                return false;
            }
            if (this.maxRows_ > 0 && this.positionFromFirst_ == -1) {
                this.getRow();
            }
            if (this.positionFromFirst_ >= 0 && this.positionFromFirst_ + rowNumber > this.maxRows_ && this.maxRows_ > 0) {
                this.afterLast();
                return false;
            }
            this.rowCache_.relative(rowNumber);
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    this.positionFromFirst_ += rowNumber;
                }
                if (this.positionFromLast_ >= 0) {
                    this.positionFromLast_ -= rowNumber;
                }
                this.positionValid_ = true;
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
            } else {
                if (rowNumber >= 0) {
                    this.positionFromFirst_ = -1;
                    this.positionFromLast_ = 0;
                } else {
                    this.positionFromFirst_ = 0;
                    this.positionFromLast_ = -1;
                }
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    public Array getArray(int columnIndex) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
        return null;
    }

    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            InputStream value;
            SQLData data = this.getValue(columnIndex);
            this.openInputStream_ = value = data == null ? null : data.getAsciiStream();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            BigDecimal value = data == null ? null : data.getBigDecimal(-1);
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (scale < 0) {
            JDError.throwSQLException("HY094", "" + scale);
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            BigDecimal value = data == null ? null : data.getBigDecimal(scale);
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            InputStream value;
            SQLData data = this.getValue(columnIndex);
            this.openInputStream_ = value = data == null ? null : data.getBinaryStream();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            Blob value = data == null ? null : data.getBlob();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            boolean value = data == null ? false : data.getBoolean();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            byte value = data == null ? (byte)0 : data.getByte();
            this.testDataTruncation(columnIndex, data, true);
            return value;
        }
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            byte[] value;
            SQLData data = this.getValue(columnIndex);
            int sqlType = 0;
            if (data != null) {
                sqlType = data.getSQLType();
            }
            if (data != null && sqlType != 2 && sqlType != 29 && sqlType != 3 && sqlType != 4 && sqlType != 6 && sqlType != 20 && sqlType != 31 && sqlType != 25 && sqlType != 40 && this.row_ instanceof JDServerRow) {
                value = ((JDServerRow)this.row_).getRawBytes(columnIndex);
                if (sqlType == 30 || sqlType == 32 || sqlType == 36 || sqlType == 9) {
                    if (value != null && value.length >= 2) {
                        int newLength = 256 * (value[0] & 0xFF) + (value[1] & 0xFF);
                        if (sqlType == 32 || sqlType == 36) {
                            newLength *= 2;
                        }
                        byte[] newValue = new byte[newLength];
                        for (int i = 0; i < newLength; ++i) {
                            newValue[i] = value[i + 2];
                        }
                        value = newValue;
                    }
                } else if (sqlType == 8) {
                    String x = data.getString();
                    try {
                        value = x.getBytes("ISO8859_1");
                    }
                    catch (Exception cpException) {}
                } else if (sqlType == 12 || sqlType == 34) {
                    String x = data.getString();
                    try {
                        value = x.getBytes("UTF-16BE");
                    }
                    catch (Exception cpException) {}
                }
            } else {
                value = data == null ? null : data.getBytes();
                this.testDataTruncation(columnIndex, data, false);
            }
            return value;
        }
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            Reader value;
            SQLData data = this.getValue(columnIndex);
            this.openReader_ = value = data == null ? null : data.getCharacterStream();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            Clob value = data == null ? null : data.getClob();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.internalGetDate(columnIndex, null);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.internalGetDate(this.findColumn(columnName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date internalGetDate(int columnIndex, Calendar calendar) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            Date value = data == null ? null : data.getDate(calendar);
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetDate(columnIndex, calendar);
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnName), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            double value = data == null ? 0.0 : data.getDouble();
            this.testDataTruncation(columnIndex, data, true);
            return value;
        }
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            float value = data == null ? 0.0f : data.getFloat();
            this.testDataTruncation(columnIndex, data, true);
            return value;
        }
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            int value = data == null ? 0 : data.getInt();
            this.testDataTruncation(columnIndex, data, true);
            return value;
        }
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            long value = data == null ? 0L : data.getLong();
            this.testDataTruncation(columnIndex, data, true);
            return value;
        }
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            ConvTable convTable = null;
            if (this.extendedDescriptors_ != null) {
                convTable = this.connection_.getConverter();
            }
            return new AS400JDBCResultSetMetaData(this.catalog_, this.concurrency_, this.cursorName_, this.row_, this.extendedDescriptors_, convTable, this.connection_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            Object value = data == null ? null : data.getObject();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex, Map typeMap) throws SQLException {
        if (typeMap == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(columnIndex);
    }

    public Object getObject(String columnName, Map typeMap) throws SQLException {
        if (typeMap == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(this.findColumn(columnName));
    }

    public Ref getRef(int columnIndex) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
        return null;
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            short value = data == null ? (short)0 : data.getShort();
            this.testDataTruncation(columnIndex, data, true);
            return value;
        }
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            String value = data == null ? null : data.getString();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.internalGetTime(columnIndex, null);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.internalGetTime(this.findColumn(columnName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time internalGetTime(int columnIndex, Calendar calendar) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            Time value = data == null ? null : data.getTime(calendar);
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTime(columnIndex, calendar);
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(columnName), calendar);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.internalGetTimestamp(columnIndex, null);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.internalGetTimestamp(this.findColumn(columnName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp internalGetTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            Timestamp value = data == null ? null : data.getTimestamp(calendar);
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTimestamp(columnIndex, calendar);
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            InputStream value;
            SQLData data = this.getValue(columnIndex);
            this.openInputStream_ = value = data == null ? null : data.getUnicodeStream();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    private SQLData getValue(int columnIndex) throws SQLException {
        this.checkOpen();
        this.clearCurrentValue();
        if (!this.positionValid_ && !this.positionInsert_) {
            JDError.throwSQLException("HY109");
        }
        if (columnIndex < 1) {
            JDError.throwSQLException("07009", columnIndex + "<1");
        }
        if (columnIndex > this.columnCount_) {
            JDError.throwSQLException("07009", columnIndex + ">" + this.columnCount_);
        }
        if (this.concurrency_ == 1008 && (this.updateSet_[columnIndex - 1] || this.positionInsert_)) {
            this.wasNull_ = this.updateNulls_[columnIndex - 1];
            this.wasDataMappingError_ = false;
            if (this.wasNull_) {
                return null;
            }
            return this.updateRow_.getSQLData(columnIndex);
        }
        this.wasNull_ = this.row_.isNull(columnIndex);
        this.wasDataMappingError_ = this.row_.isDataMappingError(columnIndex);
        SQLData sqlData = this.row_.getSQLType(columnIndex);
        int sqlType = sqlData.getSQLType();
        if ((sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) && this.statement_ != null) {
            this.statement_.setAssociatedWithLocators(true);
        }
        if (this.wasNull_ || this.wasDataMappingError_) {
            return null;
        }
        return this.row_.getSQLData(columnIndex);
    }

    private void testDataTruncation(int columnIndex, SQLData data, boolean exceptionOnTrunc) throws SQLException {
        int truncated;
        if (this.wasDataMappingError_) {
            this.postWarning(new DataTruncation(columnIndex, false, true, -1, -1));
        }
        if (data != null && (truncated = data.getTruncated()) > 0) {
            if (this.connection_.getVRM() >= JDUtilities.vrm610 && exceptionOnTrunc) {
                JDError.throwSQLException((Object)this, "07006", "C#=" + columnIndex);
            }
            int actualSize = data.getActualSize();
            this.postWarning(new DataTruncation(columnIndex, false, true, actualSize, actualSize - truncated));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.wasNull_;
        }
    }

    private void beforeUpdate() throws SQLException {
        this.checkOpen();
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Deleting a row.");
            }
            if (this.deleteStatement_ == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("DELETE FROM ");
                buffer.append(this.selectTable_);
                buffer.append(" WHERE CURRENT OF \"");
                buffer.append(this.cursorName_);
                buffer.append("\"");
                this.deleteStatement_ = this.connection_.prepareStatement(buffer.toString());
            }
            this.deleteStatement_.execute();
            this.positionValid_ = false;
            this.rowCache_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            if (!this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO ");
            buffer.append(this.selectTable_);
            buffer.append(" (");
            StringBuffer values = new StringBuffer();
            int columnsSet = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                if (columnsSet++ > 0) {
                    buffer.append(",");
                    values.append(",");
                }
                buffer.append("\"");
                buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                buffer.append("\"");
                values.append("?");
            }
            if (columnsSet == 0) {
                buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(1)));
            }
            buffer.append(") VALUES (");
            if (columnsSet == 0) {
                buffer.append("NULL");
            } else {
                buffer.append(values.toString());
            }
            buffer.append(")");
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Inserting a row: " + buffer);
            }
            PreparedStatement insertStatement = this.connection_.prepareStatement(buffer.toString());
            int columnsSet2 = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                Object columnValue = this.updateRow_.getSQLData(i + 1).getObject();
                if (this.updateNulls_[i]) {
                    insertStatement.setNull(++columnsSet2, this.row_.getSQLType(i + 1).getType());
                } else if (this.updateDefaults_[i]) {
                    ((AS400JDBCPreparedStatement)insertStatement).setDB2Default(++columnsSet2);
                } else if (this.updateUnassigned_[i]) {
                    ((AS400JDBCPreparedStatement)insertStatement).setDB2Unassigned(++columnsSet2);
                } else {
                    insertStatement.setObject(++columnsSet2, columnValue);
                }
                this.updateSet_[i] = false;
            }
            insertStatement.executeUpdate();
            SQLWarning warnings = insertStatement.getWarnings();
            if (warnings != null) {
                this.postWarning(warnings);
            }
            insertStatement.close();
            this.rowCache_.flush();
        }
    }

    private static final String prepareQuotes(String name) {
        return JDUtilities.prepareForDoubleQuotes(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowDeleted() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            return !this.positionValid_ && !this.positionInsert_ && (this.positionFromFirst_ > 0 || this.positionFromLast_ > 0);
        }
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    private void testDataTruncation2(int columnIndex, SQLData data) throws SQLException {
        if (data != null) {
            this.connection_.testDataTruncation(null, this, columnIndex, false, data, null);
        }
    }

    public void updateArray(int columnIndex, Array columnValue) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
    }

    public void updateArray(String columnName, Array columnValue) throws SQLException {
        this.updateArray(this.findColumn(columnName), columnValue);
    }

    public void updateAsciiStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        if (length < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, columnValue == null ? null : JDUtilities.streamToString(columnValue, length, "ISO8859_1"), null, -1);
    }

    public void updateAsciiStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), columnValue, length);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateBigDecimal(String columnName, BigDecimal columnValue) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), columnValue);
    }

    public void updateBinaryStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        if (length < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, columnValue == null ? null : JDUtilities.streamToBytes(columnValue, length), null, -1);
    }

    public void updateBinaryStream(String columnName, InputStream columnValue, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), columnValue, length);
    }

    public void updateBoolean(int columnIndex, boolean columnValue) throws SQLException {
        this.updateValue(columnIndex, new Short((short)(columnValue ? 1 : 0)), null, -1);
    }

    public void updateBoolean(String columnName, boolean columnValue) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), columnValue);
    }

    public void updateBlob(int columnIndex, Blob columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateBlob(String columnName, Blob columnValue) throws SQLException {
        this.updateValue(this.findColumn(columnName), columnValue, null, -1);
    }

    public void updateByte(int columnIndex, byte columnValue) throws SQLException {
        this.updateValue(columnIndex, new Short(columnValue), null, -1);
    }

    public void updateByte(String columnName, byte columnValue) throws SQLException {
        this.updateByte(this.findColumn(columnName), columnValue);
    }

    public void updateBytes(int columnIndex, byte[] columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateBytes(String columnName, byte[] columnValue) throws SQLException {
        this.updateBytes(this.findColumn(columnName), columnValue);
    }

    public void updateCharacterStream(int columnIndex, Reader columnValue, int length) throws SQLException {
        if (length < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, columnValue == null ? null : JDUtilities.readerToString(columnValue, length), null, -1);
    }

    public void updateCharacterStream(String columnName, Reader columnValue, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), columnValue, length);
    }

    public void updateClob(int columnIndex, Clob columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateClob(String columnName, Clob columnValue) throws SQLException {
        this.updateValue(this.findColumn(columnName), columnValue, null, -1);
    }

    public void updateDate(int columnIndex, Date columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateDate(String columnName, Date columnValue) throws SQLException {
        this.updateDate(this.findColumn(columnName), columnValue);
    }

    public void updateDouble(int columnIndex, double columnValue) throws SQLException {
        this.updateValue(columnIndex, new Double(columnValue), null, -1);
    }

    public void updateDouble(String columnName, double columnValue) throws SQLException {
        this.updateDouble(this.findColumn(columnName), columnValue);
    }

    public void updateFloat(int columnIndex, float columnValue) throws SQLException {
        this.updateValue(columnIndex, new Float(columnValue), null, -1);
    }

    public void updateFloat(String columnName, float columnValue) throws SQLException {
        this.updateFloat(this.findColumn(columnName), columnValue);
    }

    public void updateInt(int columnIndex, int columnValue) throws SQLException {
        this.updateValue(columnIndex, new Integer(columnValue), null, -1);
    }

    public void updateInt(String columnName, int columnValue) throws SQLException {
        this.updateInt(this.findColumn(columnName), columnValue);
    }

    public void updateLong(int columnIndex, long columnValue) throws SQLException {
        this.updateValue(columnIndex, new Long(columnValue), null, -1);
    }

    public void updateLong(String columnName, long columnValue) throws SQLException {
        this.updateLong(this.findColumn(columnName), columnValue);
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.updateValue(columnIndex, null, null, -1);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateDB2Default(int columnIndex) throws SQLException {
        this.updateValueExtendedIndicator(columnIndex, 1);
    }

    public void updateDBDefault(int columnIndex) throws SQLException {
        this.updateDB2Default(columnIndex);
    }

    public void updateDB2Default(String columnName) throws SQLException {
        this.updateDB2Default(this.findColumn(columnName));
    }

    public void updateDBDefault(String columnName) throws SQLException {
        this.updateDB2Default(this.findColumn(columnName));
    }

    public void updateDB2Unassigned(int columnIndex) throws SQLException {
        this.updateValueExtendedIndicator(columnIndex, 2);
    }

    public void updateDBUnassigned(int columnIndex) throws SQLException {
        this.updateDB2Unassigned(columnIndex);
    }

    public void updateDB2Unassigned(String columnName) throws SQLException {
        this.updateDB2Unassigned(this.findColumn(columnName));
    }

    public void updateDBUnassigned(String columnName) throws SQLException {
        this.updateDB2Unassigned(this.findColumn(columnName));
    }

    public void updateObject(int columnIndex, Object columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateObject(String columnName, Object columnValue) throws SQLException {
        this.updateObject(this.findColumn(columnName), columnValue);
    }

    public void updateObject(int columnIndex, Object columnValue, int scale) throws SQLException {
        if (scale < 0) {
            JDError.throwSQLException("HY094");
        }
        if (columnValue instanceof SQLXML) {
            this.updateSQLXML(columnIndex, (SQLXML)columnValue);
        } else {
            this.updateValue(columnIndex, columnValue, null, scale);
        }
    }

    public void updateObject(String columnName, Object columnValue, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), columnValue, scale);
    }

    public void updateRef(int columnIndex, Ref columnValue) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + columnIndex);
    }

    public void updateRef(String columnName, Ref columnValue) throws SQLException {
        this.updateRef(this.findColumn(columnName), columnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        this.beforeUpdate();
        ConvTable convTable = null;
        if (this.positionInsert_ || !this.positionValid_) {
            JDError.throwSQLException("24000");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ");
        buffer.append(this.selectTable_);
        if (this.correlationName_ != null) {
            buffer.append(" AS ");
            buffer.append(this.correlationName_);
        }
        buffer.append(" SET ");
        int columnsSet = 0;
        for (int i = 0; i < this.columnCount_; ++i) {
            if (!this.updateSet_[i]) continue;
            if (columnsSet++ > 0) {
                buffer.append(",");
            }
            buffer.append("\"");
            if (this.statement_ != null) {
                if (this.extendedDescriptors_ != null) {
                    convTable = this.connection_.getConverter();
                    String columnName = this.extendedDescriptors_.getColumnDescriptors(i + 1, convTable, this.settings_).getBaseColumnName(convTable);
                    if (columnName != null) {
                        if (this.connection_.getVRM() < JDUtilities.vrm540) {
                            buffer.append(JDUtilities.stripOuterDoubleQuotes(columnName));
                        } else {
                            buffer.append(AS400JDBCResultSet.prepareQuotes(columnName));
                        }
                    } else {
                        buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                    }
                } else {
                    buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                }
            } else {
                buffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
            }
            buffer.append("\"=?");
        }
        buffer.append(" WHERE CURRENT OF \"");
        buffer.append(this.cursorName_);
        buffer.append("\"");
        if (columnsSet > 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Updating a row: " + buffer);
            }
            PreparedStatement updateStatement = this.connection_.prepareStatement(buffer.toString());
            try {
                int columnsSet2 = 0;
                for (int i = 0; i < this.columnCount_; ++i) {
                    if (!this.updateSet_[i]) continue;
                    Object columnValue = this.updateRow_.getSQLData(i + 1).getObject();
                    if (this.updateNulls_[i]) {
                        updateStatement.setNull(++columnsSet2, this.row_.getSQLType(i + 1).getType());
                        continue;
                    }
                    if (this.updateDefaults_[i]) {
                        ((AS400JDBCPreparedStatement)updateStatement).setDB2Default(++columnsSet2);
                        continue;
                    }
                    if (this.updateUnassigned_[i]) {
                        ((AS400JDBCPreparedStatement)updateStatement).setDB2Unassigned(++columnsSet2);
                        continue;
                    }
                    updateStatement.setObject(++columnsSet2, columnValue);
                }
                updateStatement.executeUpdate();
                SQLWarning warnings = updateStatement.getWarnings();
                if (warnings != null) {
                    this.postWarning(warnings);
                }
            }
            finally {
                updateStatement.close();
            }
            this.rowCache_.flush();
        }
    }

    public void updateShort(int columnIndex, short columnValue) throws SQLException {
        this.updateValue(columnIndex, new Short(columnValue), null, -1);
    }

    public void updateShort(String columnName, short columnValue) throws SQLException {
        this.updateShort(this.findColumn(columnName), columnValue);
    }

    public void updateString(int columnIndex, String columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateString(String columnName, String columnValue) throws SQLException {
        this.updateString(this.findColumn(columnName), columnValue);
    }

    public void updateTime(int columnIndex, Time columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateTime(String columnName, Time columnValue) throws SQLException {
        this.updateTime(this.findColumn(columnName), columnValue);
    }

    public void updateTimestamp(int columnIndex, Timestamp columnValue) throws SQLException {
        this.updateValue(columnIndex, columnValue, null, -1);
    }

    public void updateTimestamp(String columnName, Timestamp columnValue) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), columnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(int columnIndex, Object columnValue, Calendar calendar, int scale) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            if (!this.positionValid_ && !this.positionInsert_) {
                JDError.throwSQLException("HY109");
            }
            if (columnIndex < 1) {
                JDError.throwSQLException("07009", columnIndex + "<1");
            }
            if (columnIndex > this.columnCount_) {
                JDError.throwSQLException("07009", columnIndex + ">" + this.columnCount_);
            }
            SQLData sqlData = this.updateRow_.getSQLType(columnIndex);
            int columnIndex0 = columnIndex - 1;
            int sqlType = sqlData.getSQLType();
            if (columnValue != null && (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40)) {
                if (columnValue instanceof AS400JDBCBlobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCBlobLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException cce) {}
                } else if (columnValue instanceof AS400JDBCClobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCClobLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException cce) {}
                } else if (columnValue instanceof AS400JDBCNClobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCNClobLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException cce) {}
                } else if (columnValue instanceof AS400JDBCSQLXMLLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(((AS400JDBCSQLXMLLocator)columnValue).getHandle());
                    }
                    catch (ClassCastException cce) {
                        // empty catch block
                    }
                }
            }
            if (columnValue != null) {
                sqlData.set(columnValue, calendar, scale);
            }
            this.updateNulls_[columnIndex0] = columnValue == null;
            this.updateDefaults_[columnIndex0] = false;
            this.updateUnassigned_[columnIndex0] = false;
            this.updateSet_[columnIndex0] = true;
            if (this.dataTruncation_) {
                this.testDataTruncation2(columnIndex, sqlData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHoldability() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.statement_ != null) {
                JDCursor cursor;
                int vrm = 0;
                if (this.connection_ != null) {
                    vrm = this.connection_.getVRM();
                }
                if ((cursor = this.statement_.getCursor()).getCursorAttributeHoldable() == 0 && (vrm <= JDUtilities.vrm610 || vrm >= JDUtilities.vrm710 && cursor.getCursorIsolationLevel() != 0)) {
                    return 2;
                }
                if (cursor.getCursorAttributeHoldable() == 1 || vrm >= JDUtilities.vrm710 && cursor.getCursorIsolationLevel() == 0) {
                    return 1;
                }
                int resultSetHoldability = this.statement_.getInternalResultSetHoldability();
                if (resultSetHoldability == 1 || resultSetHoldability == 2) {
                    return resultSetHoldability;
                }
            }
            if (this.connection_ instanceof AS400JDBCConnection && this.connection_ != null) {
                return this.connection_.getHoldability();
            }
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            Reader value;
            SQLData data = this.getValue(columnIndex);
            this.openReader_ = value = data == null ? null : data.getNCharacterStream();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NClob getNClob(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            NClob value = data == null ? null : data.getNClob();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNString(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            String value = data == null ? null : data.getNString();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowId getRowId(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            RowId value = data == null ? null : data.getRowId();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData data = this.getValue(columnIndex);
            SQLXML value = data == null ? null : data.getSQLXML();
            this.testDataTruncation(columnIndex, data, false);
            return value;
        }
    }

    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateValue(columnIndex, nClob, null, -1);
    }

    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnName), nClob);
    }

    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateValue(columnIndex, nString, null, -1);
    }

    public void updateNString(String columnName, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnName), nString);
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.updateValue(columnIndex, x, null, -1);
    }

    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnName), x);
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.updateValue(columnIndex, xmlObject, null, -1);
            return;
        }
        int sqlDataType = this.updateRow_ != null ? this.updateRow_.getSQLData(columnIndex).getType() : 2009;
        switch (sqlDataType) {
            case 2005: {
                this.updateCharacterStream(columnIndex, xmlObject.getCharacterStream());
                break;
            }
            case 2004: {
                this.updateBinaryStream(columnIndex, xmlObject.getBinaryStream());
                break;
            }
            default: {
                this.updateValue(columnIndex, xmlObject, null, -1);
            }
        }
    }

    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), xmlObject);
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCResultSet", "java.sql.ResultSet"};
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToString(x, (int)length, "ISO8859_1"), null, -1);
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToBytes(x, (int)length), null, -1);
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, inputStream == null ? null : JDUtilities.streamToBytes(inputStream, (int)length), null, -1);
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x, (int)length), null, -1);
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader, (int)length), null, -1);
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x, (int)length), null, -1);
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader, (int)length), null, -1);
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToBytes(x), null, -1);
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateValue(columnIndex, x == null ? null : JDUtilities.streamToBytes(x), null, -1);
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateValue(columnIndex, inputStream == null ? null : JDUtilities.streamToBytes(inputStream), null, -1);
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x), null, -1);
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateValue(columnIndex, x == null ? null : JDUtilities.readerToString(x), null, -1);
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateValue(columnIndex, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueExtendedIndicator(int columnIndex, int columnValue) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            if (!this.positionValid_ && !this.positionInsert_) {
                JDError.throwSQLException("HY109");
            }
            if (columnIndex < 1) {
                JDError.throwSQLException("07009", columnIndex + "<1");
            }
            if (columnIndex > this.columnCount_) {
                JDError.throwSQLException("07009", columnIndex + ">" + this.columnCount_);
            }
            int columnIndex0 = columnIndex - 1;
            this.updateNulls_[columnIndex0] = false;
            this.updateDefaults_[columnIndex0] = columnValue == 1;
            this.updateUnassigned_[columnIndex0] = columnValue == 2;
            this.updateSet_[columnIndex0] = true;
        }
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        if (type == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byteArray = new byte[1];
            this.byteArrayClass_ = byteArray.getClass();
        }
        if (type == String.class) {
            return this.getString(columnIndex);
        }
        if (type == Byte.class) {
            byte b = this.getByte(columnIndex);
            if (b == 0 && this.wasNull()) {
                return null;
            }
            return new Byte(b);
        }
        if (type == Short.class) {
            short s = this.getShort(columnIndex);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (type == Integer.class) {
            int i = this.getInt(columnIndex);
            if (i == 0 && this.wasNull()) {
                return null;
            }
            return new Integer(i);
        }
        if (type == Long.class) {
            long l = this.getLong(columnIndex);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (type == Float.class) {
            float f = this.getFloat(columnIndex);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (type == Double.class) {
            double d = this.getDouble(columnIndex);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (type == BigDecimal.class) {
            return this.getBigDecimal(columnIndex);
        }
        if (type == Boolean.class) {
            boolean b = this.getBoolean(columnIndex);
            if (!b && this.wasNull()) {
                return null;
            }
            return new Boolean(b);
        }
        if (type == Date.class) {
            return this.getDate(columnIndex);
        }
        if (type == Time.class) {
            return this.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return this.getTimestamp(columnIndex);
        }
        if (type == this.byteArrayClass_) {
            return this.getBytes(columnIndex);
        }
        if (type == InputStream.class) {
            return this.getBinaryStream(columnIndex);
        }
        if (type == Reader.class) {
            return this.getCharacterStream(columnIndex);
        }
        if (type == Clob.class) {
            return this.getClob(columnIndex);
        }
        if (type == Array.class) {
            return this.getArray(columnIndex);
        }
        if (type == Blob.class) {
            return this.getBlob(columnIndex);
        }
        if (type == Ref.class) {
            return this.getRef(columnIndex);
        }
        if (type == URL.class) {
            return this.getURL(columnIndex);
        }
        if (type == NClob.class) {
            return this.getNClob(columnIndex);
        }
        if (type == RowId.class) {
            return this.getRowId(columnIndex);
        }
        if (type == SQLXML.class) {
            return this.getSQLXML(columnIndex);
        }
        if (type == Object.class) {
            return this.getObject(columnIndex);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    protected void addSavedException(SQLException savedException) {
        this.savedException_ = savedException;
    }

    static int getDBSQLRequestDSCursorType(String cursorSensitivityProperty, int resultSetType, int resultSetConcurrency) {
        switch (resultSetType) {
            case 1003: {
                if (cursorSensitivityProperty.equalsIgnoreCase("insensitive") && resultSetConcurrency == 1007) {
                    return 5;
                }
                if (cursorSensitivityProperty.equalsIgnoreCase("sensitive")) {
                    return 4;
                }
                return 0;
            }
            case 1005: {
                if (cursorSensitivityProperty.equalsIgnoreCase("sensitive")) {
                    return 3;
                }
                if (cursorSensitivityProperty.equalsIgnoreCase("asensitive")) {
                    return 1;
                }
                return 3;
            }
        }
        return 2;
    }

    int mapSQLType(Object targetSqlType) throws SQLException {
        return 0;
    }

    public void updateObject(int columnIndex, Object x, Object targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnIndex, x, scaleOrLength);
    }

    public void updateObject(String columnLabel, Object x, Object targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnLabel, x, scaleOrLength);
    }

    public void updateObject(int columnIndex, Object x, Object targetSqlType) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    public void updateObject(String columnLabel, Object x, Object targetSqlType) throws SQLException {
        this.updateObject(columnLabel, x);
    }
}

