/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCXid;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplyXids;
import com.ibm.as400.access.DBXARequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class AS400JDBCXAResource
implements XAResource {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static int COUNT_ = 64;
    static byte[] DEFAULT_XA_INFORMATION_ = new byte[256];
    private static int nextResourceManagerID_ = 49153;
    private static Object nextResourceManagerIDLock_ = new Object();
    private AS400JDBCConnection connection_;
    private int resourceManagerID_ = -1;
    private Xid started_ = null;
    private Vector allXids = new Vector();
    private JDTransactionManager transactionManager_;
    private int transactionTimeout_ = 0;
    private int lockWait_ = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AS400JDBCXAResource(AS400JDBCConnection connection) throws XAException {
        this.connection_ = connection;
        this.transactionManager_ = this.connection_.getTransactionManager();
        Object object = nextResourceManagerIDLock_;
        synchronized (object) {
            this.resourceManagerID_ = nextResourceManagerID_++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            int returnCode;
            DBReplyRequestedDS reply;
            block12: {
                if (xid == null) {
                    throw new XAException(-5);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_commit");
                }
                DBXARequestDS request = null;
                reply = null;
                returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6305, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setXid(AS400JDBCXid.xidToBytes(xid));
                    request.setFlags(onePhase ? 0x40000000 : 0);
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    Object var7_8 = null;
                    if (request == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            this.transactionManager_.markGlobalTransactionBoundary();
            this.transactionManager_.resetXAServer();
            if (this.connection_.getTransactionManager().getHoldIndicator() == 0 || this.connection_.getCheckStatementHoldability() && this.connection_.getVRM() >= JDUtilities.vrm520) {
                this.connection_.markCursorsClosed(false);
            }
            if (returnCode != 0) {
                throw new XAException(returnCode);
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        try {
            int returnCode;
            DBReplyRequestedDS reply;
            block13: {
                if (xid == null) {
                    throw new XAException(-5);
                }
                if (!this.allXids.contains(xid)) {
                    throw new XAException(-6);
                }
                if (this.connection_.getServerFunctionalLevel() < 11 && flags != 0x4000000 && flags != 0x20000000) {
                    throw new XAException(-5);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_end");
                }
                DBXARequestDS request = null;
                reply = null;
                returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6307, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setXid(AS400JDBCXid.xidToBytes(xid));
                    request.setFlags(flags);
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    Object var7_8 = null;
                    if (request == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            this.transactionManager_.setLocalTransaction(true);
            this.started_ = null;
            this.insertRemoveXidByFlag(xid, flags);
            if (returnCode != 0) {
                throw new XAException(returnCode);
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        try {
            int returnCode;
            DBReplyRequestedDS reply;
            block11: {
                if (xid == null) {
                    throw new XAException(-5);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_forget");
                }
                DBXARequestDS request = null;
                reply = null;
                returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6308, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setXid(AS400JDBCXid.xidToBytes(xid));
                    request.setFlags(0);
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    Object var6_7 = null;
                    if (request == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            if (returnCode < 0) {
                throw new XAException(returnCode);
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout_;
    }

    private void insertRemoveXidByFlag(Xid xid, int flags) {
        if (flags == 0) {
            if (!this.allXids.contains(xid)) {
                this.allXids.add(xid);
            }
        } else if ((flags & 0x200000) == 0x200000) {
            if (!this.allXids.contains(xid)) {
                this.allXids.add(xid);
            }
        } else if ((flags & 0x4000000) == 0x4000000) {
            this.allXids.remove(xid);
        } else if ((flags & 0x20000000) == 0x20000000) {
            this.allXids.remove(xid);
        }
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        if (!(xaResource instanceof AS400JDBCXAResource)) {
            return false;
        }
        try {
            return this.connection_.getCatalog().equalsIgnoreCase(((AS400JDBCXAResource)xaResource).connection_.getCatalog());
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        try {
            int returnCode;
            DBReplyRequestedDS reply;
            block11: {
                if (xid == null) {
                    throw new XAException(-5);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_prepare");
                }
                DBXARequestDS request = null;
                reply = null;
                returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6310, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setXid(AS400JDBCXid.xidToBytes(xid));
                    request.setFlags(0);
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    Object var6_7 = null;
                    if (request == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            if (returnCode == 0 || returnCode == 3) {
                return returnCode;
            }
            throw new XAException(returnCode);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
            return -1;
        }
    }

    private int processXAReturnCode(DBReplyRequestedDS reply) throws XAException {
        int errorClass = reply.getErrorClass();
        int returnValue = reply.getReturnCode();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "xa error class = " + errorClass + ", return code = " + returnValue);
        }
        if (returnValue < 0) {
            if (errorClass == 9) {
                throw new XAException(returnValue);
            }
            if (errorClass != 0) {
                throw new XAException(-7);
            }
            return returnValue;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int flags) throws XAException {
        try {
            Xid[] xidArray;
            DBReplyRequestedDS reply;
            block10: {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_recover");
                }
                DBXARequestDS request = null;
                reply = null;
                int returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6311, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setCount(COUNT_);
                    request.setFlags(flags);
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    DBReplyXids xids = reply.getXids();
                    if (returnCode < 0) {
                        throw new XAException(returnCode);
                    }
                    xidArray = xids.getXidArray();
                    Object var8_9 = null;
                    if (request == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                return xidArray;
            }
            return xidArray;
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            int returnCode;
            DBReplyRequestedDS reply;
            block11: {
                if (xid == null) {
                    throw new XAException(-5);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_rollback");
                }
                DBXARequestDS request = null;
                reply = null;
                returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6312, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setXid(AS400JDBCXid.xidToBytes(xid));
                    request.setFlags(0);
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    Object var6_7 = null;
                    if (request == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            this.transactionManager_.markGlobalTransactionBoundary();
            this.transactionManager_.resetXAServer();
            if (returnCode != 0) {
                throw new XAException(returnCode);
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
        }
    }

    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        try {
            if (this.connection_.getVRM() < JDUtilities.vrm530) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (this.transactionTimeout_ < 0) {
                JDError.throwSQLException("HY024");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transactionTimeout_ = transactionTimeout;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        try {
            int returnCode;
            DBReplyRequestedDS reply;
            block16: {
                if (xid == null) {
                    throw new XAException(-5);
                }
                if (this.started_ != null) {
                    throw new XAException(-6);
                }
                if (flags != 0 && flags != 0x200000 && this.connection_.getVRM() < JDUtilities.vrm540) {
                    throw new XAException(-5);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "xa_start");
                }
                DBXARequestDS request = null;
                reply = null;
                returnCode = 0;
                try {
                    request = DBDSPool.getDBXARequestDS(6313, 0, Integer.MIN_VALUE, 0);
                    request.setResourceManagerID(this.resourceManagerID_);
                    request.setXid(AS400JDBCXid.xidToBytes(xid));
                    request.setFlags(flags);
                    if (this.connection_.getServerFunctionalLevel() >= 11) {
                        request.setCtlTimeout(this.transactionTimeout_);
                        if (this.lockWait_ != -1) {
                            request.setLockWait(this.lockWait_);
                        }
                    }
                    if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                        int lcs = this.connection_.getProperties().getInt(70);
                        request.setXALooselyCoupledSupport(lcs);
                    }
                    reply = this.connection_.sendAndReceive(request);
                    returnCode = this.processXAReturnCode(reply);
                    Object var8_9 = null;
                    if (request == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            this.transactionManager_.setLocalTransaction(false);
            this.started_ = xid;
            this.insertRemoveXidByFlag(xid, flags);
            if (returnCode != 0) {
                throw new XAException(returnCode);
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwXAException(e);
        }
    }

    public void setLockWait(int lockWait) throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm530) {
            return;
        }
        if (lockWait < 0) {
            JDError.throwSQLException("HY024");
        }
        this.lockWait_ = lockWait;
    }

    private void throwXAException(Exception e) throws XAException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logException(this, "throwing XAException(XAER_RMFAIL) because of", e);
        }
        XAException xaex = new XAException(-7);
        try {
            xaex.initCause(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw xaex;
    }

    public String toString() {
        return this.connection_.toString() + "-XA:RMID#" + this.resourceManagerID_;
    }
}

