/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400UnsignedBin4
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 4;
    private static final long MIN_VALUE = 0L;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final long defaultValue = 0L;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 4;
    }

    public Object getDefaultValue() {
        return new Long(0L);
    }

    public int getInstanceType() {
        return 11;
    }

    public Class getJavaType() {
        return Long.class;
    }

    public byte[] toBytes(Object javaValue) {
        long longValue = (Long)javaValue;
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        byte[] as400Value = new byte[4];
        BinaryConverter.unsignedIntToByteArray(longValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(long longValue) {
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("longValue (" + String.valueOf(longValue) + ")", 4);
        }
        byte[] as400Value = new byte[4];
        BinaryConverter.unsignedIntToByteArray(longValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        long longValue = (Long)javaValue;
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(longValue, as400Value, 0);
        return 4;
    }

    public int toBytes(long longValue, byte[] as400Value) {
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("longValue (" + String.valueOf(longValue) + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(longValue, as400Value, 0);
        return 4;
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        long longValue = (Long)javaValue;
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(longValue, as400Value, offset);
        return 4;
    }

    public int toBytes(long longValue, byte[] as400Value, int offset) {
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new ExtendedIllegalArgumentException("longValue (" + String.valueOf(longValue) + ")", 4);
        }
        BinaryConverter.unsignedIntToByteArray(longValue, as400Value, offset);
        return 4;
    }

    public long toLong(byte[] as400Value) {
        return BinaryConverter.byteArrayToUnsignedInt(as400Value, 0);
    }

    public long toLong(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToUnsignedInt(as400Value, offset);
    }

    public Object toObject(byte[] as400Value) {
        return new Long(BinaryConverter.byteArrayToUnsignedInt(as400Value, 0));
    }

    public Object toObject(byte[] as400Value, int offset) {
        return new Long(BinaryConverter.byteArrayToUnsignedInt(as400Value, offset));
    }
}

