/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;

class ConvTable1208
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    ConvTable1208() {
        super(1208);
    }

    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] out = new char[length];
        int outCount = 0;
        for (int i = offset; i < offset + length && i < buf.length; ++i) {
            int b = buf[i] & 0xFF;
            int c = 0;
            if ((b & 0x80) == 0) {
                c = b;
            } else if ((b & 0xE0) == 192) {
                c = (b & 0x1F) << 6;
                c = ++i < buf.length ? (c |= buf[i] & 0x3F) : 65533;
            } else if ((b & 0xF0) == 224) {
                c = (b & 0xF) << 12;
                if (++i < buf.length) {
                    c |= (buf[i] & 0x3F) << 6;
                    c = ++i < buf.length ? (c |= buf[i] & 0x3F) : 65533;
                } else {
                    c = 65533;
                }
            } else {
                c = (b & 7) << 18;
                if (++i < buf.length) {
                    c |= (buf[i] & 0x3F) << 12;
                    if (++i < buf.length) {
                        c |= (buf[i] & 0x3F) << 6;
                        c = ++i < buf.length ? (c |= buf[i] & 0x3F) : 65533;
                    } else {
                        c = 65533;
                    }
                } else {
                    c = 65533;
                }
            }
            if (c > 65535) {
                out[outCount++] = (char)((c - 65536) / 1024 + 55296);
                out[outCount++] = (char)((c - 65536) % 1024 + 56320);
                continue;
            }
            out[outCount++] = (char)c;
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(out));
        }
        return String.copyValueOf(out, 0, outCount);
    }

    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(source.toCharArray(), 0, source.length()));
        }
        int len = source.length();
        byte[] buf = new byte[len * 4];
        int bufCount = 0;
        for (int i = 0; i < len; ++i) {
            int c = source.charAt(i) & 0xFFFF;
            if (c > 55295 && c < 56320) {
                if (++i < len) {
                    c = (c - 55296) * 1024 + ((source.charAt(i) & 0xFFFF) - 56320) + 65536;
                } else {
                    if (!CharConverter.isFaultTolerantConversion()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    byte[] ret = new byte[bufCount];
                    System.arraycopy(buf, 0, ret, 0, bufCount);
                    if (Trace.traceConversion_) {
                        Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, ret);
                    }
                    return ret;
                }
            }
            if (c < 128) {
                buf[bufCount++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                buf[bufCount++] = (byte)(0xC0 | c >> 6);
                buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 65536) {
                buf[bufCount++] = (byte)(0xE0 | c >> 12);
                buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            buf[bufCount++] = (byte)(0xF0 | c >> 18);
            buf[bufCount++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[bufCount++] = (byte)(0x80 | c & 0x3F);
        }
        byte[] ret = new byte[bufCount];
        System.arraycopy(buf, 0, ret, 0, bufCount);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, ret);
        }
        return ret;
    }

    public final byte[] stringToByteArray(char[] src, int offset, int length) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src, offset, length));
        }
        byte[] buf = new byte[src.length * 4];
        int bufCount = 0;
        int len = offset + length;
        for (int i = offset; i < len; ++i) {
            int c = src[i] & 0xFFFF;
            if (c > 55295 && c < 56320) {
                if (++i < len) {
                    c = (c - 55296) * 1024 + ((src[i] & 0xFFFF) - 56320) + 65536;
                } else {
                    if (!CharConverter.isFaultTolerantConversion()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    byte[] ret = new byte[bufCount];
                    System.arraycopy(buf, 0, ret, 0, bufCount);
                    if (Trace.traceConversion_) {
                        Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, ret);
                    }
                    return ret;
                }
            }
            if (c < 128) {
                buf[bufCount++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                buf[bufCount++] = (byte)(0xC0 | c >> 6);
                buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 65536) {
                buf[bufCount++] = (byte)(0xE0 | c >> 12);
                buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            buf[bufCount++] = (byte)(0xF0 | c >> 18);
            buf[bufCount++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[bufCount++] = (byte)(0x80 | c & 0x3F);
        }
        byte[] ret = new byte[bufCount];
        System.arraycopy(buf, 0, ret, 0, bufCount);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, ret);
        }
        return ret;
    }

    public final void stringToByteArray(String source, byte[] buf, int offset) throws CharConversionException {
        int bufCount = offset;
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(source.toCharArray()));
        }
        try {
            int len = source.length();
            for (int i = 0; i < len; ++i) {
                int c = source.charAt(i) & 0xFFFF;
                if (c > 55295 && c < 56320) {
                    if (++i < len) {
                        c = (c - 55296) * 1024 + ((source.charAt(i) & 0xFFFF) - 56320) + 65536;
                    } else {
                        if (!CharConverter.isFaultTolerantConversion()) {
                            throw new CharConversionException();
                        }
                        if (Trace.traceConversion_) {
                            Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, buf, offset, bufCount - offset);
                        }
                        return;
                    }
                }
                if (c < 128) {
                    buf[bufCount++] = (byte)c;
                    continue;
                }
                if (c < 2048) {
                    buf[bufCount++] = (byte)(0xC0 | c >> 6);
                    buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (c < 65536) {
                    buf[bufCount++] = (byte)(0xE0 | c >> 12);
                    buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                    buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                buf[bufCount++] = (byte)(0xF0 | c >> 18);
                buf[bufCount++] = (byte)(0x80 | c >> 12 & 0x3F);
                buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[bufCount++] = (byte)(0x80 | c & 0x3F);
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, buf, offset, bufCount - offset);
        }
    }

    public final void stringToByteArray(String source, byte[] buf, int offset, int length) throws CharConversionException {
        this.stringToByteArrayTruncation(source, buf, offset, length);
    }

    final int stringToByteArrayTruncation(String source, byte[] buf, int offset, int length) throws CharConversionException {
        int truncated = 0;
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(source.toCharArray()));
        }
        try {
            int len = source.length();
            int bufCount = offset;
            int max = offset + length;
            for (int i = 0; i < len; ++i) {
                int c = source.charAt(i) & 0xFFFF;
                if (c > 55295 && c < 56320) {
                    if (++i < len) {
                        c = (c - 55296) * 1024 + ((source.charAt(i) & 0xFFFF) - 56320) + 65536;
                    } else {
                        if (!CharConverter.isFaultTolerantConversion()) {
                            throw new CharConversionException();
                        }
                        if (Trace.traceConversion_) {
                            Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, buf, offset, length);
                        }
                        return truncated;
                    }
                }
                if (c < 128) {
                    if (bufCount < max) {
                        buf[bufCount++] = (byte)c;
                        continue;
                    }
                    if (c == 32) continue;
                    ++truncated;
                    continue;
                }
                if (c < 2048) {
                    if (bufCount < max) {
                        buf[bufCount++] = (byte)(0xC0 | c >> 6);
                    } else {
                        ++truncated;
                    }
                    if (bufCount < max) {
                        buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                        continue;
                    }
                    ++truncated;
                    continue;
                }
                if (c < 65536) {
                    if (bufCount < max) {
                        buf[bufCount++] = (byte)(0xE0 | c >> 12);
                    } else {
                        ++truncated;
                    }
                    if (bufCount < max) {
                        buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                    } else {
                        ++truncated;
                    }
                    if (bufCount < max) {
                        buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                        continue;
                    }
                    ++truncated;
                    continue;
                }
                if (bufCount < max) {
                    buf[bufCount++] = (byte)(0xF0 | c >> 18);
                } else {
                    ++truncated;
                }
                if (bufCount < max) {
                    buf[bufCount++] = (byte)(0x80 | c >> 12 & 0x3F);
                } else {
                    ++truncated;
                }
                if (bufCount < max) {
                    buf[bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                } else {
                    ++truncated;
                }
                if (bufCount < max) {
                    buf[bufCount++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                ++truncated;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, buf, offset, length);
        }
        return truncated;
    }

    public final int stringToByteArray(String source, byte[] buf, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        return this.stringToByteArrayTruncation(source, buf, offset, length);
    }
}

