/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;

public abstract class ConvTableAsciiMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public char[] toUnicode_ = null;
    public byte[] fromUnicode_ = null;

    ConvTableAsciiMap(int ccsid, char[] toUnicode, char[] fromUnicode) {
        super(ccsid);
        this.ccsid_ = ccsid;
        this.toUnicode_ = toUnicode;
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing single-byte ASCII conversion table for ccsid: " + this.ccsid_, fromUnicode.length);
        }
        this.fromUnicode_ = this.decompressSB(fromUnicode, (byte)26);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded single-byte ASCII map for ccsid: " + this.ccsid_);
        }
    }

    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        int i = 0;
        while (i < length) {
            dest[i] = this.toUnicode_[0xFF & buf[offset + i++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest);
    }

    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        char[] src = source.toCharArray();
        return this.stringToByteArray(src, 0, src.length);
    }

    public final byte[] stringToByteArray(char[] src, int offset, int length) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src, offset, length));
        }
        byte[] dest = new byte[length];
        int i = offset;
        while (i < length) {
            dest[i] = this.fromUnicode_[src[i++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, dest);
        }
        return dest;
    }
}

