/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConvTableDoubleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private char[] toUnicode_ = null;
    private char[] fromUnicode_ = null;
    char[][] toUnicodeSurrogate_ = null;
    public static final int LEADING_SURROGATE_BASE = 55296;
    public static final int TRAILING_SURROGATE_BASE = 56320;
    public static final int FROM_UNICODE_SURROGATE_DIMENSION_LENGTH = 1024;
    char[][] fromUnicodeSurrogate_ = null;
    char[] combiningCharacters_;
    char[][] combiningCombinations_;

    ConvTableDoubleMap(int ccsid, char[] toUnicode, char[] fromUnicode, char[][] toUnicodeSurrogateMapping) {
        this(ccsid, toUnicode, fromUnicode);
        this.toUnicodeSurrogate_ = new char[65535][];
        this.fromUnicodeSurrogate_ = new char[1024][];
        ArrayList<char[]> combiningCombinationArrayList = new ArrayList<char[]>();
        Hashtable<Integer, char[]> combiningCharacterHashtable = new Hashtable<Integer, char[]>();
        for (int i = 0; i < toUnicodeSurrogateMapping.length; ++i) {
            char ebcdicChar = toUnicodeSurrogateMapping[i][0];
            char leadingSurrogate = toUnicodeSurrogateMapping[i][1];
            char trailingSurrogate = toUnicodeSurrogateMapping[i][2];
            char[] pair = new char[]{leadingSurrogate, trailingSurrogate};
            this.toUnicodeSurrogate_[0xFFFF & ebcdicChar] = pair;
            int leadingIndex = leadingSurrogate - 55296;
            int trailingIndex = trailingSurrogate - 56320;
            if (leadingIndex >= 0 && leadingIndex < 1024) {
                if (this.fromUnicodeSurrogate_[leadingIndex] == null) {
                    this.fromUnicodeSurrogate_[leadingIndex] = new char[1024];
                }
                char[] fromUnicodeSurrogate2 = this.fromUnicodeSurrogate_[leadingIndex];
                if (trailingIndex < 0 || trailingIndex >= 1024) continue;
                fromUnicodeSurrogate2[trailingIndex] = ebcdicChar;
                continue;
            }
            char[] triplet = new char[]{leadingSurrogate, trailingSurrogate, ebcdicChar};
            combiningCombinationArrayList.add(triplet);
            combiningCharacterHashtable.put(new Integer(trailingSurrogate), pair);
        }
        int combiningCharacterSize = combiningCharacterHashtable.size();
        this.combiningCharacters_ = new char[combiningCharacterSize];
        int i = 0;
        Enumeration keys = combiningCharacterHashtable.keys();
        while (keys.hasMoreElements()) {
            Integer x = (Integer)keys.nextElement();
            this.combiningCharacters_[i] = (char)x.intValue();
            ++i;
        }
        int combiningCombinationSize = combiningCombinationArrayList.size();
        this.combiningCombinations_ = new char[combiningCombinationSize][];
        for (i = 0; i < combiningCombinationSize; ++i) {
            this.combiningCombinations_[i] = (char[])combiningCombinationArrayList.get(i);
        }
    }

    ConvTableDoubleMap(int ccsid, char[] toUnicode, char[] fromUnicode) {
        super(ccsid);
        this.toUnicode_ = this.decompress(toUnicode);
        this.fromUnicode_ = this.decompress(fromUnicode);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded double-byte map for ccsid: " + this.ccsid_);
        }
    }

    ConvTableDoubleMap(ConvTableDoubleMap oldMap) {
        super(oldMap.ccsid_);
        this.toUnicode_ = oldMap.toUnicode_;
        this.fromUnicode_ = oldMap.fromUnicode_;
        this.toUnicodeSurrogate_ = oldMap.toUnicodeSurrogate_;
        this.fromUnicodeSurrogate_ = oldMap.fromUnicodeSurrogate_;
        this.combiningCharacters_ = oldMap.combiningCharacters_;
        this.combiningCombinations_ = oldMap.combiningCombinations_;
    }

    char[] decompress(char[] arr) {
        return ConvTableDoubleMap.decompress(arr, this.ccsid_);
    }

    static char[] decompress(char[] arr, int ccsid) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing double-byte conversion table for ccsid: " + ccsid, arr.length);
        }
        char[] buf = new char[65536];
        int c = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '\uffff') {
                if (arr[i + 1] == '\u0000') {
                    buf[c++] = arr[i++];
                    continue;
                }
                long max = (0xFFFF & arr[i + 1]) + (0xFFFF & c);
                char ch = arr[i + 2];
                while ((long)c < max) {
                    buf[c++] = ch;
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\ufffe') {
                if (arr[i + 1] == '\u0000') {
                    buf[c++] = arr[i++];
                    continue;
                }
                int start = 0xFFFF & arr[i + 2];
                int num = 0xFFFF & arr[i + 1];
                for (int j = start; j < num + start; ++j) {
                    buf[c++] = (char)j;
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\u0000') {
                if (arr[i + 1] == '\u0000') {
                    buf[c++] = arr[i++];
                    continue;
                }
                int hbNum = 0xFFFF & arr[++i];
                char firstChar = arr[++i];
                char highByteMask = (char)(0xFF00 & firstChar);
                buf[c++] = firstChar;
                ++i;
                for (int j = 0; j < hbNum; ++j) {
                    char both = arr[i + j];
                    buf[c++] = (char)(highByteMask + ((0xFF00 & both) >>> 8));
                    buf[c++] = (char)(highByteMask + (0xFF & both));
                }
                i = i + hbNum - 1;
                continue;
            }
            buf[c++] = arr[i];
        }
        return buf;
    }

    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        int to = 0;
        for (int i = 0; i < length / 2; ++i) {
            try {
                int fromIndex = ((0xFF & buf[i * 2 + offset]) << 8) + (0xFF & buf[i * 2 + 1 + offset]);
                int unicodeLength = this.toUnicode(dest, to, fromIndex);
                to += unicodeLength;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw aioobe;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest, 0, to);
    }

    public int toUnicode(char[] dest, int to, int fromIndex) {
        int length = 0;
        dest[to] = this.toUnicode_[fromIndex];
        if (dest[to] == '\ud800') {
            if (this.toUnicodeSurrogate_ != null) {
                char[] surrogates = this.toUnicodeSurrogate_[fromIndex];
                if (surrogates != null) {
                    dest[to] = surrogates[0];
                    ++length;
                    dest[++to] = surrogates[1];
                    ++to;
                    ++length;
                } else {
                    dest[to] = 65533;
                    ++to;
                    ++length;
                }
            } else {
                dest[to] = 65533;
                ++to;
                ++length;
            }
        } else {
            ++to;
            ++length;
        }
        return length;
    }

    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        char[] src = source.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src));
        }
        byte[] dest = new byte[src.length * 2];
        int destIndex = 0;
        int[] increment = new int[1];
        int i = 0;
        while (i < src.length) {
            char c = this.fromUnicode(src, i, increment);
            dest[destIndex * 2] = (byte)(c >>> 8);
            dest[destIndex * 2 + 1] = (byte)(0xFF & c);
            if (increment[0] > 1) {
                ++i;
            }
            ++i;
            ++destIndex;
        }
        if (destIndex * 2 != dest.length) {
            byte[] newDest = new byte[destIndex * 2];
            System.arraycopy(dest, 0, newDest, 0, destIndex * 2);
            dest = newDest;
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, dest);
        }
        return dest;
    }

    public char fromUnicode(char[] src, int i, int[] increment) {
        int incrementValue = 1;
        int returnChar = 0;
        char currentChar = src[i];
        if (currentChar < '\ud800' || currentChar >= '\udc00') {
            int next = i + 1;
            boolean found = false;
            if (this.combiningCharacters_ != null && next < src.length) {
                char nextChar = src[next];
                for (int j = 0; !found && j < this.combiningCharacters_.length; ++j) {
                    if (nextChar != this.combiningCharacters_[j]) continue;
                    for (int k = 0; !found && k < this.combiningCombinations_.length; ++k) {
                        if (currentChar != this.combiningCombinations_[k][0] || nextChar != this.combiningCombinations_[k][1]) continue;
                        found = true;
                        returnChar = this.combiningCombinations_[k][2];
                        ++i;
                        ++incrementValue;
                    }
                }
            }
            if (!found) {
                returnChar = this.fromUnicode_[src[i]];
            }
        } else {
            int trailingIndex;
            char[] fromUnicodeSurrogate2;
            int leadingIndex = src[i] - 55296;
            ++incrementValue;
            returnChar = this.fromUnicodeSurrogate_ != null ? ((fromUnicodeSurrogate2 = this.fromUnicodeSurrogate_[leadingIndex]) != null ? ((trailingIndex = src[++i] - 56320) >= 0 && trailingIndex < 1024 && fromUnicodeSurrogate2[trailingIndex] != '\u0000' ? fromUnicodeSurrogate2[trailingIndex] : 65278) : 65278) : 65278;
        }
        increment[0] = incrementValue;
        return (char)returnChar;
    }

    public char[] getFromUnicode() {
        return this.fromUnicode_;
    }

    void setFromUnicode(char[] fromUnicode) {
        this.fromUnicode_ = fromUnicode;
    }

    public char[] getToUnicode() {
        return this.toUnicode_;
    }

    void setToUnicode(char[] toUnicode) {
        this.toUnicode_ = toUnicode;
    }
}

