/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableDoubleMap;
import com.ibm.as400.access.ConvTableSingleMap;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public abstract class ConvTableMixedMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public ConvTableSingleMap sbTable_ = null;
    public ConvTableDoubleMap dbTable_ = null;
    static final byte shiftOut_ = 14;
    static final byte shiftIn_ = 15;

    ConvTableMixedMap(int ccsid, int sbCcsid, int dbCcsid) throws UnsupportedEncodingException {
        super(ccsid);
        this.sbTable_ = (ConvTableSingleMap)ConvTable.getTable(sbCcsid, null);
        this.dbTable_ = (ConvTableDoubleMap)ConvTable.getTable(dbCcsid, null);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded mixed-byte map for ccsid: " + this.ccsid_);
        }
    }

    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        boolean inSBMode = true;
        int destPos = 0;
        for (int srcPos = offset; srcPos < offset + length; ++srcPos) {
            byte curByte = buf[srcPos];
            if (inSBMode) {
                if (curByte == 14) {
                    inSBMode = false;
                    continue;
                }
                dest[destPos++] = this.sbTable_.toUnicode_[0xFF & curByte];
                continue;
            }
            if (curByte == 15) {
                inSBMode = true;
                continue;
            }
            try {
                if (srcPos + 1 < offset + length) {
                    int unicodeLength = this.dbTable_.toUnicode(dest, destPos, ((0xFF & curByte) << 8) + (0xFF & buf[++srcPos]));
                    destPos += unicodeLength;
                    continue;
                }
                dest[destPos++] = 65533;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw aioobe;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_ + ": 0," + destPos, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest, 0, destPos);
    }

    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        char[] src = source.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src));
        }
        byte[] dest = new byte[(src.length * 5 + 3) / 2];
        boolean inSBMode = true;
        byte sbLookup = 0;
        char dbLookup = '\u0000';
        int[] increment = new int[1];
        int destPos = 0;
        for (int srcPos = 0; srcPos < src.length; ++srcPos) {
            char curChar = src[srcPos];
            if ((curChar & 0xFF00) == 0 || curChar == '\u20ac') {
                sbLookup = this.sbTable_.fromUnicode_[curChar];
                if (sbLookup == 63 && curChar != '\u001a') {
                    dbLookup = this.dbTable_.fromUnicode(src, srcPos, increment);
                    if (increment[0] == 2) {
                        ++srcPos;
                    }
                    if (dbLookup == '\ufefe') {
                        if (!inSBMode) {
                            inSBMode = true;
                            dest[destPos++] = 15;
                        }
                        dest[destPos++] = 63;
                        continue;
                    }
                    if (inSBMode) {
                        inSBMode = false;
                        dest[destPos++] = 14;
                    }
                    dest[destPos++] = (byte)((0xFFFF & dbLookup) >>> 8);
                    dest[destPos++] = (byte)(0xFF & dbLookup);
                    continue;
                }
                if (!inSBMode) {
                    inSBMode = true;
                    dest[destPos++] = 15;
                }
                dest[destPos++] = sbLookup;
                continue;
            }
            dbLookup = this.dbTable_.fromUnicode(src, srcPos, increment);
            if (increment[0] == 2) {
                ++srcPos;
            }
            if (dbLookup == '\ufefe' && curChar != '\ufffd') {
                sbLookup = this.sbTable_.fromUnicode_[curChar];
                if (sbLookup == 63) {
                    if (inSBMode) {
                        dest[destPos++] = 63;
                        continue;
                    }
                    dest[destPos++] = -2;
                    dest[destPos++] = -2;
                    continue;
                }
                if (!inSBMode) {
                    inSBMode = true;
                    dest[destPos++] = 15;
                }
                dest[destPos++] = sbLookup;
                continue;
            }
            if (inSBMode) {
                inSBMode = false;
                dest[destPos++] = 14;
            }
            dest[destPos++] = (byte)((0xFFFF & dbLookup) >>> 8);
            dest[destPos++] = (byte)(0xFF & dbLookup);
        }
        if (!inSBMode) {
            dest[destPos++] = 15;
        }
        byte[] ret = new byte[destPos];
        System.arraycopy(dest, 0, ret, 0, destPos);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, ret);
        }
        return ret;
    }
}

