/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBExtendedData;
import com.ibm.as400.access.DBExtendedDataFormat;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.DBOriginalData;
import com.ibm.as400.access.DBOriginalDataFormat;
import com.ibm.as400.access.DBReplyPackageInfo;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBReplyServerAttributes;
import com.ibm.as400.access.DBReplyXids;
import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.DBSuperExtendedDataFormat;
import com.ibm.as400.access.DBVariableData;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

abstract class DBBaseReplyDS
extends ClientAccessDataStream {
    private static final String NODATA_ = "0";
    private static final int TEMPLATE_LENGTH_ = 20;
    private int errorClass_ = 0;
    private int returnCode_ = 0;
    private int byteCount_ = -1;
    private long currentLOBLength_ = -1L;
    private DBDataFormat dataFormat_ = null;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_ = null;
    private String firstLevelMessageText_ = null;
    private DBLobData lobData_ = null;
    private String messageId_ = null;
    private DBReplyPackageInfo packageInfo_ = null;
    private DBDataFormat parameterMarkerFormat_ = null;
    private DBData resultData_ = null;
    private boolean rleCompressed_ = false;
    private String secondLevelMessageText_ = null;
    private DBReplyServerAttributes serverAttributes_ = null;
    private DBReplySQLCA sqlca_ = null;
    private DBReplyXids xids_ = null;
    DBStorage storage_ = DBDSPool.storagePool_.getUnpooledStorage();
    private boolean inPool_ = false;
    private int holdable = -1;
    private int scrollable = -1;
    private int updatable = -1;
    private int sensitive = -1;
    private int isolationLevel = -1;

    DBBaseReplyDS() {
    }

    final void initialize() {
        this.data_ = this.storage_.getData();
        this.errorClass_ = 0;
        this.returnCode_ = 0;
        this.byteCount_ = -1;
        this.currentLOBLength_ = -1L;
        this.dataFormat_ = null;
        this.firstLevelMessageText_ = null;
        this.lobData_ = null;
        this.messageId_ = null;
        this.packageInfo_ = null;
        this.parameterMarkerFormat_ = null;
        this.resultData_ = null;
        this.rleCompressed_ = false;
        this.secondLevelMessageText_ = null;
        this.serverAttributes_ = null;
        this.sqlca_ = null;
        this.xids_ = null;
        this.holdable = -1;
        this.scrollable = -1;
        this.updatable = -1;
        this.sensitive = -1;
        this.extendedColumnDescriptors_ = null;
        this.isolationLevel = -1;
    }

    void dump(PrintStream ps) {
        DBBaseRequestDS.dump(ps, this.data_, this.data_.length);
        if (this.rleCompressed_) {
            ps.println("Reply was received RLE compressed.");
        }
    }

    public long getCurrentLOBLength() {
        return this.currentLOBLength_;
    }

    public int getCursorAttributeHoldable() {
        return this.holdable;
    }

    public int getCursorAttributeScrollable() {
        return this.scrollable;
    }

    public int getCursorAttributeUpdatable() {
        return this.updatable;
    }

    public int getCursorAttributeSensitive() {
        return this.sensitive;
    }

    public DBDataFormat getDataFormat() {
        return this.dataFormat_;
    }

    public int getErrorClass() {
        return this.errorClass_;
    }

    public DBExtendedColumnDescriptors getExtendedColumnDescriptors() {
        return this.extendedColumnDescriptors_;
    }

    public String getFirstLevelMessageText() {
        return this.firstLevelMessageText_;
    }

    public int getCursorIsolationLevel() {
        return this.isolationLevel;
    }

    public DBLobData getLOBData() {
        return this.lobData_;
    }

    public String getMessageId() {
        return this.messageId_;
    }

    public DBReplyPackageInfo getPackageInfo() {
        return this.packageInfo_;
    }

    public DBDataFormat getParameterMarkerFormat() {
        return this.parameterMarkerFormat_;
    }

    public DBData getResultData() {
        return this.resultData_;
    }

    public int getReturnCode() {
        return this.returnCode_;
    }

    public int getReturnDataFunctionId() {
        return this.get16bit(30);
    }

    public String getSecondLevelMessageText() {
        return this.secondLevelMessageText_;
    }

    public DBReplyServerAttributes getServerAttributes() {
        return this.serverAttributes_;
    }

    public DBReplySQLCA getSQLCA() {
        return this.sqlca_;
    }

    public DBReplyXids getXids() {
        return this.xids_;
    }

    public int readAfterHeader(InputStream in) throws IOException {
        this.byteCount_ = super.readAfterHeader(in);
        return this.byteCount_;
    }

    void parse(int dataCompression) throws IOException {
        int parmLength;
        boolean vlfCompressed = (this.get16bit(20) & 1) == 1;
        boolean dataCompressed = (this.get32bit(24) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        boolean oldCompressed = dataCompressed && dataCompression == 1;
        boolean bl = this.rleCompressed_ = dataCompressed && dataCompression == 14386;
        if (this.rleCompressed_) {
            int compressionSchemeCP = this.get16bit(44);
            if (compressionSchemeCP != 14386) {
                throw new IOException();
            }
            int lengthOfDecompressedData = this.get32bit(46);
            byte[] newData = new byte[lengthOfDecompressedData + 40];
            BinaryConverter.intToByteArray(newData.length, newData, 0);
            System.arraycopy(this.data_, 4, newData, 4, 36);
            DataStreamCompression.decompressRLE(this.data_, 50, this.get32bit(0) - 50, newData, 40, (byte)27, true);
            this.data_ = newData;
            this.byteCount_ = this.data_.length - 20;
        }
        this.errorClass_ = this.get16bit(34);
        this.returnCode_ = this.get32bit(36);
        block24: for (int offset = 40; offset < this.byteCount_ + 20; offset += parmLength) {
            parmLength = this.get32bit(offset);
            int codePoint = this.get16bit(offset + 4);
            switch (codePoint) {
                case 14337: {
                    if (parmLength != 6) {
                        ConverterImplRemote converter = ConverterImplRemote.getConverter(this.get16bit(offset + 6), this.system_);
                        this.messageId_ = converter.byteArrayToString(this.data_, offset + 8, parmLength - 8);
                        continue block24;
                    }
                    this.messageId_ = NODATA_;
                    continue block24;
                }
                case 14338: {
                    if (parmLength != 6) {
                        ConverterImplRemote converter = ConverterImplRemote.getConverter(this.get16bit(offset + 6), this.system_);
                        this.firstLevelMessageText_ = converter.byteArrayToString(this.data_, offset + 10, parmLength - 10);
                        continue block24;
                    }
                    this.firstLevelMessageText_ = NODATA_;
                    continue block24;
                }
                case 14339: {
                    if (parmLength != 6) {
                        ConverterImplRemote converter = ConverterImplRemote.getConverter(this.get16bit(offset + 6), this.system_);
                        this.secondLevelMessageText_ = converter.byteArrayToString(this.data_, offset + 10, parmLength - 10);
                        continue block24;
                    }
                    this.secondLevelMessageText_ = NODATA_;
                    continue block24;
                }
                case 14340: {
                    try {
                        this.serverAttributes_ = new DBReplyServerAttributes(this.data_, offset + 8, parmLength);
                        continue block24;
                    }
                    catch (DBDataStreamException x) {
                        throw new IOException();
                    }
                }
                case 14341: {
                    if (parmLength != 6) {
                        this.dataFormat_ = new DBOriginalDataFormat();
                        this.dataFormat_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty data format.");
                    continue block24;
                }
                case 14342: {
                    if (parmLength != 6) {
                        this.resultData_ = new DBOriginalData(parmLength, oldCompressed);
                        this.resultData_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty result data.");
                    continue block24;
                }
                case 14343: {
                    this.sqlca_ = new DBReplySQLCA(this.data_, offset + 6, parmLength);
                    continue block24;
                }
                case 14344: {
                    if (parmLength != 6) {
                        this.parameterMarkerFormat_ = new DBOriginalDataFormat();
                        this.parameterMarkerFormat_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty parameter marker format.");
                    continue block24;
                }
                case 14347: {
                    this.packageInfo_ = new DBReplyPackageInfo(this.data_, offset + 6, parmLength, this.system_.getCcsid());
                    continue block24;
                }
                case 14348: {
                    if (parmLength != 6) {
                        this.dataFormat_ = new DBExtendedDataFormat();
                        this.dataFormat_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty extended data format.");
                    continue block24;
                }
                case 14349: {
                    if (parmLength != 6) {
                        this.parameterMarkerFormat_ = new DBExtendedDataFormat();
                        this.parameterMarkerFormat_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty extended parameter marker format.");
                    continue block24;
                }
                case 14350: {
                    if (parmLength != 6) {
                        this.resultData_ = new DBExtendedData(parmLength, oldCompressed, vlfCompressed);
                        this.resultData_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty extended result data.");
                    continue block24;
                }
                case 14351: {
                    if (parmLength != 6) {
                        int length = this.get32bit(offset + 8);
                        this.lobData_ = new DBLobData(length, parmLength - 12, oldCompressed);
                        this.lobData_.overlay(this.data_, offset + 12);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty lob locator.");
                    continue block24;
                }
                case 14352: {
                    int sl = this.get16bit(offset + 6);
                    if (sl == 0) {
                        this.currentLOBLength_ = 0L;
                        continue block24;
                    }
                    if (sl == 4) {
                        this.currentLOBLength_ = this.get32bit(offset + 8);
                        continue block24;
                    }
                    this.currentLOBLength_ = this.get64bit(offset + 8);
                    continue block24;
                }
                case 14497: {
                    this.xids_ = new DBReplyXids(this.data_, offset, parmLength);
                    continue block24;
                }
                case 14353: {
                    if (parmLength != 6) {
                        this.extendedColumnDescriptors_ = new DBExtendedColumnDescriptors(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty extended column descriptor.");
                    continue block24;
                }
                case 14354: {
                    if (parmLength != 6) {
                        this.dataFormat_ = new DBSuperExtendedDataFormat();
                        this.dataFormat_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty super extended data format.");
                    continue block24;
                }
                case 14355: {
                    if (parmLength != 6) {
                        this.parameterMarkerFormat_ = new DBSuperExtendedDataFormat();
                        this.parameterMarkerFormat_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty parameter marker format.");
                    continue block24;
                }
                case 14356: {
                    if (parmLength != 6) {
                        int attrs = this.get32bit(offset + 6);
                        this.holdable = attrs >> 24 & 1;
                        this.scrollable = attrs >> 16 & 1;
                        this.updatable = attrs >> 8 & 1;
                        this.sensitive = (attrs >> 0 & 1) == 1 ? 0 : 1;
                        attrs = this.get32bit(offset + 10);
                        this.isolationLevel = attrs >> 24 & 0xF;
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty cursor attributes.");
                    continue block24;
                }
                case 14593: {
                    if (parmLength != 6) {
                        this.resultData_ = new DBVariableData();
                        this.resultData_.overlay(this.data_, offset + 6);
                        continue block24;
                    }
                    if (!Trace.traceOn_) continue block24;
                    Trace.log(1, "Received empty extended result data.");
                }
            }
        }
    }

    void setInPool(boolean inPool) {
        this.inPool_ = inPool;
    }

    synchronized void returnToPool() {
        this.data_ = this.storage_.getData();
        super.returnToPool();
        if (!this.inPool_) {
            this.storage_ = null;
            this.data_ = null;
        }
    }

    protected synchronized void finalize() throws Throwable {
        this.storage_ = null;
        this.data_ = null;
        super.finalize();
    }
}

