/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class DataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected static ConverterImplRemote converter_;
    protected int connectionID_;
    static boolean traceOpened;
    protected AS400ImplRemote system_;
    protected byte[] data_;
    protected int headerLength_;

    static ConverterImplRemote getDefaultConverter() {
        return converter_;
    }

    static void setDefaultConverter(ConverterImplRemote converter) {
        converter_ = converter;
    }

    static final int readFromStream(InputStream in, byte[] buf, int offset, int length, int connectionID) throws IOException {
        boolean endOfFile = false;
        int bytesRead = 0;
        while (bytesRead < length && !endOfFile) {
            int temp = in.read(buf, offset + bytesRead, length - bytesRead);
            if (temp == -1) {
                endOfFile = true;
                continue;
            }
            bytesRead += temp;
        }
        if (Trace.traceOn_) {
            Trace.log(0, "Data stream data received (connID=" + connectionID + ") ...", buf, offset, bytesRead);
        }
        return bytesRead;
    }

    static final int readFromStreamDebug(InputStream in, byte[] buf, int offset, int length, int connectionID) throws IOException {
        long lastReadTime = System.currentTimeMillis();
        boolean endOfFile = false;
        int bytesRead = 0;
        while (bytesRead < length && !endOfFile) {
            int availableCount = in.available();
            if (availableCount > 0) {
                int temp = in.read(buf, offset + bytesRead, length - bytesRead);
                if (temp == -1) {
                    endOfFile = true;
                } else {
                    bytesRead += temp;
                }
                lastReadTime = System.currentTimeMillis();
                continue;
            }
            if (System.currentTimeMillis() > lastReadTime + 120000L) {
                if (!traceOpened) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
                    Trace.setFileName("/tmp/toolboxTrace." + sdf.format(new Date()) + ".txt");
                    traceOpened = true;
                }
                boolean traceTurnedOn = false;
                if (!Trace.traceOn_) {
                    traceTurnedOn = true;
                    Trace.setTraceAllOn(true);
                    Trace.setTraceOn(true);
                }
                if (traceTurnedOn) {
                    Trace.setTraceAllOn(false);
                    Trace.setTraceOn(false);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {}
        }
        if (Trace.traceOn_) {
            Trace.log(0, "Data stream data received (connID=" + connectionID + ") ...", buf, offset, bytesRead);
        }
        return bytesRead;
    }

    final int readFromStream(InputStream in, byte[] buf, int offset, int length) throws IOException {
        return DataStream.readFromStream(in, buf, offset, length, this.connectionID_);
    }

    final int readFromStreamDebug(InputStream in, byte[] buf, int offset, int length) throws IOException {
        return DataStream.readFromStreamDebug(in, buf, offset, length, this.connectionID_);
    }

    DataStream(int headerLength) {
        this.headerLength_ = headerLength;
        this.data_ = new byte[this.headerLength_];
        this.setLength(this.headerLength_);
    }

    DataStream(int headerLength, byte[] data) {
        this.headerLength_ = headerLength;
        this.data_ = data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataStream) {
            return this.hashCode() == ((DataStream)obj).hashCode();
        }
        return false;
    }

    abstract int getCorrelation();

    abstract int getLength();

    public Object getNewDataStream() {
        return null;
    }

    AS400ImplRemote getSystem() {
        return this.system_;
    }

    protected final int get16bit(int offset) {
        return ((this.data_[offset] & 0xFF) << 8) + (this.data_[offset + 1] & 0xFF);
    }

    protected final int get32bit(int offset) {
        return ((this.data_[offset] & 0xFF) << 24) + ((this.data_[offset + 1] & 0xFF) << 16) + ((this.data_[offset + 2] & 0xFF) << 8) + (this.data_[offset + 3] & 0xFF);
    }

    protected final long get64bit(int offset) {
        return BinaryConverter.byteArrayToLong(this.data_, offset);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected int readAfterHeader(InputStream in) throws IOException {
        int bytesRead = this.readFromStream(in, this.data_, this.headerLength_, this.data_.length - this.headerLength_);
        if (bytesRead < this.data_.length - this.headerLength_) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the data stream.");
            }
            throw new ConnectionDroppedException(2);
        }
        return bytesRead;
    }

    void setConnectionID(int connectionID) {
        this.connectionID_ = connectionID;
    }

    abstract void setCorrelation(int var1);

    abstract void setLength(int var1);

    void setSystem(AS400ImplRemote system) {
        this.system_ = system;
    }

    protected final void set16bit(int i, int offset) {
        this.data_[offset] = (byte)(i >>> 8);
        this.data_[offset + 1] = (byte)i;
    }

    protected final void set32bit(int i, int offset) {
        this.data_[offset] = (byte)(i >>> 24);
        this.data_[offset + 1] = (byte)(i >>> 16);
        this.data_[offset + 2] = (byte)(i >>> 8);
        this.data_[offset + 3] = (byte)i;
    }

    protected final void set32bit(long i, int offset) {
        int bits = (int)i;
        this.data_[offset] = (byte)(bits >>> 24);
        this.data_[offset + 1] = (byte)(bits >>> 16);
        this.data_[offset + 2] = (byte)(bits >>> 8);
        this.data_[offset + 3] = (byte)bits;
    }

    protected final void set64bit(long longVal, int offset) {
        BinaryConverter.longToByteArray(longVal, this.data_, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(OutputStream out) throws IOException {
        OutputStream outputStream = out;
        synchronized (outputStream) {
            out.write(this.data_);
            out.flush();
        }
        if (Trace.traceOn_) {
            Trace.log(0, "Data stream sent (connID=" + this.connectionID_ + ") ...", this.data_);
        }
    }

    static {
        traceOpened = false;
    }
}

