/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DirectoryEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DirectoryEntryList {
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String keyValue_ = null;
    private final Hashtable selectionValues_ = new Hashtable();
    public static final String ADDRESS1 = "ADDR1";
    public static final String ADDRESS2 = "ADDR2";
    public static final String ADDRESS3 = "ADDR3";
    public static final String ADDRESS4 = "ADDR4";
    public static final String BUILDING = "BLDG";
    public static final String COMPANY = "CMPNY";
    public static final String DEPARTMENT = "DEPT";
    public static final String FAX = "FAXTELNBR";
    public static final String FIRST_NAME = "FSTNAM";
    public static final String FIRST_OR_PREFERRED_NAME = "FSTPREFNAM";
    public static final String FULL_NAME = "FULNAM";
    public static final String JOB_TITLE = "TITLE";
    public static final String LAST_NAME = "LSTNAM";
    public static final String LOCATION = "LOC";
    public static final String MIDDLE_NAME = "MIDNAM";
    public static final String NETWORK_USER_ID = "NETUSRID";
    public static final String OFFICE = "OFC";
    public static final String PREFERRED_NAME = "PREFNAM";
    public static final String SYSTEM_GROUP = "SYSGRP";
    public static final String SYSTEM_NAME = "SYSNAME";
    public static final String TELEPHONE1 = "TELNBR1";
    public static final String TELEPHONE2 = "TELNBR2";
    public static final String TEXT = "TEXT";
    public static final String USER_ADDRESS = "USRADDR";
    public static final String USER_DESCRIPTION = "USRD";
    public static final String USER_ID = "USRID";
    public static final String USER_PROFILE = "USER";

    public DirectoryEntryList(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public void addSelection(String selectionID, String value) {
        if (selectionID == null) {
            throw new NullPointerException("selectionID");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.selectionValues_.isEmpty()) {
            this.keyValue_ = selectionID;
        }
        this.selectionValues_.put(selectionID, value);
    }

    public void clearSelection() {
        this.selectionValues_.clear();
        this.keyValue_ = null;
    }

    public DirectoryEntry[] getEntries() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        AS400Text textConv;
        int len;
        String val;
        String selectionID;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.selectionValues_.isEmpty()) {
            this.addSelection(USER_PROFILE, "*");
        }
        ProgramParameter[] parms = new ProgramParameter[9];
        int bufferSize = 12753;
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        AS400Text text10 = new AS400Text(10, ccsid);
        parms[0] = new ProgramParameter(bufferSize);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(bufferSize));
        parms[2] = new ProgramParameter(conv.stringToByteArray("SRCV0100"));
        parms[3] = new ProgramParameter(text10.toBytes("*SEARCH"));
        parms[4] = new ProgramParameter(new byte[]{-16});
        int numValues = this.selectionValues_.size();
        Enumeration list = this.selectionValues_.keys();
        int totalSelectionLength = 0;
        while (list.hasMoreElements()) {
            String selectionID2 = (String)list.nextElement();
            String val2 = (String)this.selectionValues_.get(selectionID2);
            totalSelectionLength += val2.length();
        }
        byte[] request = new byte[130 + numValues * 28 + totalSelectionLength];
        conv.stringToByteArray("*   ", request, 12, 4);
        request[16] = -15;
        request[17] = -16;
        request[18] = -15;
        request[19] = -16;
        conv.stringToByteArray("                ", request, 20, 16);
        conv.stringToByteArray("SREQ0101", request, 36, 8);
        BinaryConverter.intToByteArray(130, request, 44);
        BinaryConverter.intToByteArray(numValues, request, 48);
        conv.stringToByteArray("SREQ0103", request, 52, 8);
        BinaryConverter.intToByteArray(100, request, 60);
        BinaryConverter.intToByteArray(3, request, 64);
        conv.stringToByteArray("SRCV0101", request, 68, 8);
        BinaryConverter.intToByteArray(65535, request, 76);
        conv.stringToByteArray("SRCV0112", request, 80, 8);
        conv.stringToByteArray("        ", request, 88, 8);
        request[96] = -16;
        conv.stringToByteArray("   ", request, 97, 3);
        text10.toBytes("*SYSDIR", request, 100);
        text10.toBytes("*SMTP", request, 110);
        text10.toBytes("*ORNAME", request, 120);
        int offset = 130;
        if (this.keyValue_ != null) {
            selectionID = this.keyValue_;
            val = (String)this.selectionValues_.remove(selectionID);
            len = val.length();
            BinaryConverter.intToByteArray(28 + len, request, offset);
            request[offset + 4] = -15;
            text10.toBytes(selectionID, request, offset + 5);
            conv.stringToByteArray("*IBM   ", request, offset + 15, 7);
            request[offset + 22] = 64;
            request[offset + 23] = 64;
            BinaryConverter.intToByteArray(len, request, offset + 24);
            textConv = new AS400Text(len, ccsid);
            textConv.toBytes(val, request, offset + 28);
            offset += 28 + len;
        }
        list = this.selectionValues_.keys();
        while (list.hasMoreElements()) {
            selectionID = (String)list.nextElement();
            val = (String)this.selectionValues_.get(selectionID);
            len = val.length();
            BinaryConverter.intToByteArray(28 + len, request, offset);
            request[offset + 4] = -15;
            text10.toBytes(selectionID, request, offset + 5);
            conv.stringToByteArray("*IBM   ", request, offset + 15, 7);
            request[offset + 22] = 64;
            request[offset + 23] = 64;
            BinaryConverter.intToByteArray(len, request, offset + 24);
            textConv = new AS400Text(len, ccsid);
            textConv.toBytes(val, request, offset + 28);
            offset += 28 + len;
        }
        parms[5] = new ProgramParameter(request);
        parms[6] = new ProgramParameter(BinaryConverter.intToByteArray(request.length));
        parms[7] = new ProgramParameter(conv.stringToByteArray("SREQ0100"));
        parms[8] = errorCode_;
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QOKSCHD.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parms[0].getOutputData();
        int numReturned = BinaryConverter.byteArrayToInt(data, 0);
        while (bufferSize - numReturned <= 636) {
            bufferSize *= 2;
            try {
                parms[0].setOutputDataLength(bufferSize);
                parms[1].setInputData(BinaryConverter.intToByteArray(bufferSize));
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parms[0].getOutputData();
            numReturned = BinaryConverter.byteArrayToInt(data, 0);
        }
        int userArrayOffset = BinaryConverter.byteArrayToInt(data, 8);
        int numEntries = BinaryConverter.byteArrayToInt(data, 12);
        byte continuationHandle = data[16];
        String resourceHandle = conv.byteArrayToString(data, 17, 16);
        DirectoryEntry[] entries = new DirectoryEntry[numEntries];
        offset = userArrayOffset;
        for (int i = 0; i < numEntries; ++i) {
            int dataLength = BinaryConverter.byteArrayToInt(data, offset);
            int numFields = BinaryConverter.byteArrayToInt(data, offset + 4);
            offset += 8;
            String[] fieldValues = new String[numFields];
            for (int j = 0; j < numFields; ++j) {
                int charset = BinaryConverter.byteArrayToInt(data, offset);
                int codepage = BinaryConverter.byteArrayToInt(data, offset + 4);
                int fieldLength = BinaryConverter.byteArrayToInt(data, offset + 8);
                fieldValues[j] = conv.byteArrayToString(data, offset + 12, fieldLength);
                offset += 12 + fieldLength;
            }
            entries[i] = new DirectoryEntry(this.system_, fieldValues);
        }
        return entries;
    }

    public String getKey() {
        return this.keyValue_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public void setKey(String selectionID) {
        this.keyValue_ = selectionID;
    }

    public void setSystem(AS400 system) {
        this.system_ = system;
    }
}

