/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.FTPEvent;
import com.ibm.as400.access.FTPInputStream;
import com.ibm.as400.access.FTPListener;
import com.ibm.as400.access.FTPOutputStream;
import com.ibm.as400.access.FTPThread;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class FTP
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    private String server_;
    private String user_;
    private transient String clearPassword_ = null;
    private transient byte[] encryptedPassword_ = null;
    private transient byte[] mask_ = null;
    private transient byte[] adder_ = null;
    private transient boolean encrypted_ = false;
    private static final int PARKED = 0;
    private static final int ACTIVE = 1;
    private static final int FAILED = 2;
    private transient int connectionState_ = 0;
    private transient boolean inConnect_ = false;
    transient String lastMessage_ = "";
    private int port_ = 21;
    private transient Socket controlSocket_;
    private transient BufferedReader reader_;
    private transient PrintWriter ps_;
    private transient boolean externallyConnected_ = false;
    boolean reuseSocket_ = true;
    transient PropertyChangeSupport changes_ = null;
    transient VetoableChangeSupport vetos_ = null;
    transient Vector listeners_ = null;
    private transient Object listenerLock_ = new Object();
    private int bufferSize_ = 4096;
    private int mode_ = 11;
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    public static final int ACTIVE_MODE = 10;
    public static final int PASSIVE_MODE = 11;
    private transient FTPThread activeModeObject_;
    private transient Thread activeModeThread_;

    public FTP() {
        this.checkSocketProperty();
    }

    public FTP(String server) {
        try {
            this.setServer(server);
            this.checkSocketProperty();
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
        }
    }

    public FTP(String server, String user, String password) {
        try {
            this.setServer(server);
            this.setUser(user);
            this.setPassword(password);
            this.checkSocketProperty();
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            Object object = this.listenerLock_;
            synchronized (object) {
                if (this.changes_ == null) {
                    this.changes_ = new PropertyChangeSupport(this);
                }
            }
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFTPListener(FTPListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.listeners_ == null) {
            Object object = this.listenerLock_;
            synchronized (object) {
                if (this.listeners_ == null) {
                    this.listeners_ = new Vector();
                }
            }
        }
        this.listeners_.addElement(listener);
    }

    public synchronized OutputStream append(String fileName) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering append(file)");
        }
        if (fileName == null) {
            throw new NullPointerException("file");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("file");
        }
        return this.doAppendOrPut(fileName, "APPE");
    }

    public synchronized boolean append(String sourceFileName, String targetFileName) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering append(String, String)");
        }
        if (sourceFileName == null) {
            throw new NullPointerException("source");
        }
        if (sourceFileName.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (targetFileName == null) {
            throw new NullPointerException("target");
        }
        if (targetFileName.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        boolean result = this.append(new File(sourceFileName), targetFileName);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving append(String, String)");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean append(File sourceFileName, String targetFileName) throws IOException {
        Object v1;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering append(File, String)");
        }
        if (sourceFileName == null) {
            throw new NullPointerException("source");
        }
        if (targetFileName == null) {
            throw new NullPointerException("target");
        }
        if (targetFileName.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        this.connect();
        byte[] buffer = new byte[this.bufferSize_];
        FileInputStream f = null;
        OutputStream out = null;
        try {
            f = new FileInputStream(sourceFileName);
            out = this.append(targetFileName);
            int length = f.read(buffer);
            while (length > 0) {
                out.write(buffer, 0, length);
                length = f.read(buffer);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var8_8 = null;
            try {
                if (out != null) {
                    out.close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var10_12;
                v0 = var10_12 = null;
            }
            if (f == null) throw throwable;
            f.close();
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var10_11;
            v1 = var10_11 = null;
        }
        if (f != null) {
            f.close();
        }
        if (!Trace.isTraceOn()) return true;
        Trace.log(1, "leaving append(String, String)");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            Object object = this.listenerLock_;
            synchronized (object) {
                if (this.vetos_ == null) {
                    this.vetos_ = new VetoableChangeSupport(this);
                }
            }
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public synchronized boolean cd(String directory) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering cd()");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (directory.length() == 0) {
            throw new IllegalArgumentException("directory");
        }
        this.connect();
        this.issueCommand("CWD " + directory);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving cd()");
        }
        return this.lastMessage_.startsWith("250");
    }

    public synchronized boolean connect() throws UnknownHostException, IOException, IllegalStateException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering connect()");
        }
        this.inConnect_ = true;
        if (this.connectionState_ == 2) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "leaving  connect(), state=failed");
            }
            this.inConnect_ = false;
            return false;
        }
        if (this.connectionState_ == 1) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "leaving  connect(), state=active");
            }
            this.inConnect_ = false;
            return true;
        }
        if (this.server_ == null || this.server_.length() == 0) {
            this.inConnect_ = false;
            throw new IllegalStateException("server");
        }
        if (this.user_ == null || this.user_.length() == 0) {
            this.inConnect_ = false;
            throw new IllegalStateException("user");
        }
        String password_ = this.getPassword();
        if (password_ == null || password_.length() == 0) {
            this.inConnect_ = false;
            throw new IllegalStateException("password");
        }
        this.controlSocket_ = new Socket(this.server_, this.port_);
        this.reader_ = new BufferedReader(new InputStreamReader(this.controlSocket_.getInputStream()));
        this.ps_ = new PrintWriter(this.controlSocket_.getOutputStream(), true);
        this.readReply();
        this.login(this.user_, password_);
        if (!this.lastMessage_.startsWith("230")) {
            this.ps_.close();
            this.reader_.close();
            this.controlSocket_.close();
            this.connectionState_ = 0;
            this.inConnect_ = false;
            throw new SecurityException();
        }
        this.connectionState_ = 1;
        this.inConnect_ = false;
        if (this.connectionState_ == 1) {
            this.fireEvent(0);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving  connect(), state = " + this.connectionState_);
        }
        return this.connectionState_ == 1;
    }

    private byte[] decode(byte[] data, byte[] mask, byte[] adder) {
        return this.decode(data, 0, data.length, mask, adder);
    }

    private byte[] decode(byte[] data, int offset, int len, byte[] mask, byte[] adder) {
        int i;
        byte[] b = new byte[len];
        for (i = 0; i < len; ++i) {
            b[i] = (byte)(mask[i % mask.length] ^ data[offset + i]);
        }
        for (i = 0; i < len; ++i) {
            b[i] = (byte)(b[i] - adder[i % adder.length]);
        }
        return b;
    }

    public synchronized String[] dir() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering dir(), (note, no exit dir() entry)");
        }
        return this.list(true, null);
    }

    public synchronized String[] dir(String criteria) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering dir(), (note, no exit dir() entry)");
        }
        return this.list(true, criteria);
    }

    public synchronized void disconnect() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering disconnect()");
        }
        if (this.connectionState_ == 1) {
            try {
                this.issueCommand("QUIT");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.activeModeThread_ != null) {
                    this.activeModeThread_.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ps_.close();
            this.reader_.close();
            this.controlSocket_.close();
            this.connectionState_ = 0;
            this.fireEvent(1);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving disconnect()");
        }
    }

    OutputStream doAppendOrPut(String fileName, String command) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering doAppendOrPut(file)");
        }
        this.connect();
        Socket dataSocket = null;
        if (this.mode_ == 11) {
            dataSocket = this.getDataSocket();
        } else {
            this.initiateActiveMode();
        }
        String result = this.issueCommand(command + " " + fileName);
        if (result.startsWith("4") || result.startsWith("5")) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "put failed " + result);
            }
            if (dataSocket != null) {
                dataSocket.close();
            }
            throw new IOException(result);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving put(file)");
        }
        if (dataSocket == null) {
            dataSocket = this.activeModeObject_.getSocket();
        }
        this.fireEvent(3);
        return new FTPOutputStream(dataSocket, this);
    }

    private byte[] encode(byte[] b, byte[] mask, byte[] adder) {
        int i;
        byte[] buf = new byte[b.length];
        for (i = 0; i < b.length; ++i) {
            buf[i] = (byte)(b[i] + adder[i % adder.length]);
        }
        for (i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(buf[i] ^ mask[i % mask.length]);
        }
        return buf;
    }

    void externallyConnected(String system, Socket socket, BufferedReader reader, PrintWriter writer) {
        this.connectionState_ = 1;
        this.externallyConnected_ = true;
        this.server_ = system;
        this.controlSocket_ = socket;
        this.reader_ = reader;
        this.ps_ = writer;
    }

    private int extractPortAddress(String s) throws IOException {
        int returnValue;
        StringTokenizer tokens;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering extractPortAddress() " + s);
        }
        if ((tokens = new StringTokenizer(s, ",")).countTokens() < 6) {
            throw new IOException("Unable to extract port address from PASV response: " + s);
        }
        for (int i = 0; i < 4; ++i) {
            tokens.nextToken();
        }
        try {
            int highOrderPort = Integer.parseInt(tokens.nextToken());
            String lowOrder = tokens.nextToken();
            int index = lowOrder.indexOf(")");
            int lowOrderPort = index != -1 ? Integer.parseInt(lowOrder.substring(0, index)) : Integer.parseInt(lowOrder);
            returnValue = highOrderPort * 256 + lowOrderPort;
        }
        catch (NumberFormatException e) {
            throw new IOException("Unable to extract port address from PASV response: " + s);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving extractPortAddress()");
        }
        return returnValue;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }

    void fireEvent(int event) {
        if (this.listeners_ != null && !this.listeners_.isEmpty()) {
            Vector targets = (Vector)this.listeners_.clone();
            FTPEvent ftpEvent = new FTPEvent(this, event);
            for (int i = 0; i < targets.size(); ++i) {
                FTPListener listener = (FTPListener)targets.elementAt(i);
                if (event == 0) {
                    listener.connected(ftpEvent);
                    continue;
                }
                if (event == 1) {
                    listener.disconnected(ftpEvent);
                    continue;
                }
                if (event == 2) {
                    listener.retrieved(ftpEvent);
                    continue;
                }
                if (event == 3) {
                    listener.put(ftpEvent);
                    continue;
                }
                if (event != 4) continue;
                listener.listed(ftpEvent);
            }
        }
    }

    public synchronized InputStream get(String fileName) throws IOException, FileNotFoundException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering get(file)");
        }
        if (fileName == null) {
            throw new NullPointerException("file");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("file");
        }
        this.connect();
        Socket dataSocket = null;
        if (this.mode_ == 11) {
            dataSocket = this.getDataSocket();
        } else {
            this.initiateActiveMode();
        }
        this.issueCommand("RETR " + fileName);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving get(file)");
        }
        if (this.lastMessage_.startsWith("426") || this.lastMessage_.startsWith("501") || this.lastMessage_.startsWith("550")) {
            if (dataSocket != null) {
                dataSocket.close();
            }
            throw new FileNotFoundException();
        }
        if (dataSocket == null) {
            dataSocket = this.activeModeObject_.getSocket();
        }
        this.fireEvent(2);
        return new FTPInputStream(dataSocket, this);
    }

    public synchronized boolean get(String sourceFileName, String targetFileName) throws IOException, FileNotFoundException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering get(String, String");
        }
        if (sourceFileName == null) {
            throw new NullPointerException("source");
        }
        if (sourceFileName.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (targetFileName == null) {
            throw new NullPointerException("target");
        }
        if (targetFileName.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        boolean result = this.get(sourceFileName, new File(targetFileName));
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving get(String, String");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean get(String sourceFileName, File targetFile) throws IOException, FileNotFoundException {
        boolean result;
        block15: {
            block14: {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "entering get(String, file)");
                }
                if (sourceFileName == null) {
                    throw new NullPointerException("source");
                }
                if (sourceFileName.length() == 0) {
                    throw new IllegalArgumentException("source");
                }
                if (targetFile == null) {
                    throw new NullPointerException("target");
                }
                result = true;
                this.connect();
                byte[] buffer = new byte[this.bufferSize_];
                InputStream in = this.get(sourceFileName);
                if (in == null) break block14;
                FileOutputStream f = null;
                try {
                    f = new FileOutputStream(targetFile);
                    int length = in.read(buffer);
                    while (length > 0) {
                        f.write(buffer, 0, length);
                        length = in.read(buffer);
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        Trace.log(2, t);
                    }
                    if (f != null) {
                        f.close();
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (Throwable t) {
                    Trace.log(2, t);
                }
                if (f != null) {
                    f.close();
                }
                break block15;
            }
            result = false;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving get(String, file");
        }
        return result;
    }

    public int getBufferSize() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getBufferSize(), (no leaving entry)");
        }
        return this.bufferSize_;
    }

    public synchronized String getCurrentDirectory() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering pwd(), (no leaving entry)");
        }
        return this.pwd();
    }

    public synchronized String getLastMessage() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering lastMessage(), (no leaving entry)");
        }
        return this.lastMessage_;
    }

    public int getMode() {
        return this.mode_;
    }

    private String getPassword() {
        if (this.encrypted_) {
            if (this.encryptedPassword_ == null) {
                return null;
            }
            return new String(this.decode(this.encryptedPassword_, this.mask_, this.adder_));
        }
        return this.clearPassword_;
    }

    public int getPort() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getPort(), (no leaving entry)");
        }
        return this.port_;
    }

    public String getServer() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getServer(), (no leaving entry)");
        }
        return this.server_;
    }

    public String getUser() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getUser(), (no leaving entry)");
        }
        return this.user_;
    }

    public boolean isReuseSocket() {
        return this.reuseSocket_;
    }

    public synchronized String issueCommand(String cmd) throws IOException {
        int retryCount = 10;
        if (Trace.isTraceOn()) {
            String traceString = cmd;
            if (cmd.startsWith("PASS")) {
                traceString = "PASS " + "********************".substring(0, cmd.length() - 5);
            }
            Trace.log(1, "entering issueCommand(), command is: " + traceString);
        }
        while (retryCount > 0) {
            if (!this.inConnect_) {
                this.connect();
            }
            this.ps_.print(cmd + "\r\n");
            this.ps_.flush();
            this.readReply();
            if (this.lastMessage_ != null && this.lastMessage_.indexOf("425 ") == 0) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "retrying issueCommand(), message is: " + this.lastMessage_);
                }
                --retryCount;
                continue;
            }
            retryCount = 0;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving  issueCommand(), message is: " + this.lastMessage_);
        }
        return this.lastMessage_;
    }

    private void initiateActiveMode() throws IOException {
        if (!this.activeModeThread_.isAlive()) {
            this.activeModeObject_.setLocalAddress(this.controlSocket_.getLocalAddress());
            this.activeModeThread_.start();
            this.activeModeObject_.waitUntilStarted();
        }
        this.activeModeObject_.issuePortCommand();
    }

    String[] list(boolean details, String criteria) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering list");
        }
        this.connect();
        Socket dataSocket = null;
        if (this.mode_ == 11) {
            dataSocket = this.getDataSocket();
        } else {
            this.initiateActiveMode();
        }
        String FTPCommand = details ? "LIST" : "NLST";
        if (criteria != null) {
            FTPCommand = FTPCommand + " " + criteria;
        }
        this.issueCommand(FTPCommand);
        Object[] result = new String[]{};
        if (this.lastMessage_.startsWith("125") || this.lastMessage_.startsWith("150")) {
            String s;
            if (dataSocket == null) {
                dataSocket = this.activeModeObject_.getSocket();
            }
            InputStream in = dataSocket.getInputStream();
            Vector<String> v = new Vector<String>();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            while ((s = rdr.readLine()) != null) {
                v.addElement(s);
            }
            result = new String[v.size()];
            v.copyInto(result);
            rdr.close();
            in.close();
            dataSocket.close();
            this.readReply();
            this.fireEvent(4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving list()");
        }
        return result;
    }

    private String login(String user, String password) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering login");
        }
        String s1 = this.issueCommand("USER " + user);
        String s2 = this.issueCommand("PASS " + password);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving login");
        }
        return s1 + "\n" + s2;
    }

    public synchronized String[] ls() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering ls(), (no leaving entry)");
        }
        return this.list(false, null);
    }

    public synchronized String[] ls(String criteria) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering ls(), (no leaving entry)");
        }
        return this.list(false, criteria);
    }

    public synchronized boolean noop() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering noop");
        }
        if (!this.inConnect_) {
            this.connect();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving noop()");
        }
        return this.issueCommand("NOOP").startsWith("200");
    }

    public synchronized OutputStream put(String fileName) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering put(file)");
        }
        if (fileName == null) {
            throw new NullPointerException("file");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("file");
        }
        return this.doAppendOrPut(fileName, "STOR");
    }

    public synchronized boolean put(String sourceFileName, String targetFileName) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering put(String, String)");
        }
        if (sourceFileName == null) {
            throw new NullPointerException("source");
        }
        if (sourceFileName.length() == 0) {
            throw new IllegalArgumentException("source");
        }
        if (targetFileName == null) {
            throw new NullPointerException("target");
        }
        if (targetFileName.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        boolean result = this.put(new File(sourceFileName), targetFileName);
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving put(String, String)");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(File sourceFileName, String targetFileName) throws IOException {
        Object v1;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering put(File, String)");
        }
        if (sourceFileName == null) {
            throw new NullPointerException("source");
        }
        if (targetFileName == null) {
            throw new NullPointerException("target");
        }
        if (targetFileName.length() == 0) {
            throw new IllegalArgumentException("target");
        }
        this.connect();
        byte[] buffer = new byte[this.bufferSize_];
        FileInputStream f = null;
        OutputStream out = null;
        try {
            f = new FileInputStream(sourceFileName);
            out = this.put(targetFileName);
            int length = f.read(buffer);
            while (length > 0) {
                out.write(buffer, 0, length);
                length = f.read(buffer);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var8_8 = null;
            try {
                if (out != null) {
                    out.close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var10_12;
                v0 = var10_12 = null;
            }
            if (f != null) {
                f.close();
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var10_11;
            v1 = var10_11 = null;
        }
        if (f != null) {
            f.close();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving put(String, String)");
        }
        return true;
    }

    public synchronized String pwd() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering pwd(), (no leaving entry)");
        }
        this.connect();
        return this.issueCommand("PWD");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeFTPListener(FTPListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.listeners_ != null) {
            this.listeners_.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.connectionState_ = 0;
        this.inConnect_ = false;
        this.lastMessage_ = "";
        this.changes_ = null;
        this.vetos_ = null;
        this.listeners_ = null;
        this.listenerLock_ = new Object();
        this.externallyConnected_ = false;
    }

    String readReply() throws IOException {
        String currentLine;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering readReply()");
        }
        if ((currentLine = this.reader_.readLine()) == null || currentLine.length() == 0) {
            throw new IOException();
        }
        String code = currentLine.substring(0, 3);
        StringBuffer buf = new StringBuffer(currentLine);
        boolean Continue = true;
        while (Continue) {
            if (currentLine.length() > 3 && currentLine.substring(0, 3).equals(code) && currentLine.charAt(3) == ' ') {
                Continue = false;
                continue;
            }
            currentLine = this.reader_.readLine();
            buf.append("\n" + currentLine);
        }
        this.lastMessage_ = buf.toString();
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving readReply()");
        }
        return this.lastMessage_;
    }

    public synchronized void setBufferSize(int bufferSize) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setBufferSize()");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize");
        }
        int oldValue = this.bufferSize_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("bufferSize", new Integer(oldValue), new Integer(bufferSize));
        }
        this.bufferSize_ = bufferSize;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bufferSize", new Integer(oldValue), new Integer(bufferSize));
        }
    }

    public synchronized boolean setCurrentDirectory(String directory) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setCurrentDirectory(), (no leaving entry)");
        }
        return this.cd(directory);
    }

    public synchronized void setDataTransferType(int transferType) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setDataTransferType()");
        }
        if (transferType == 0 || transferType == 1) {
            this.connect();
            if (transferType == 0) {
                this.issueCommand("TYPE A");
            } else {
                this.issueCommand("TYPE I");
            }
        } else {
            throw new IllegalArgumentException("transferType");
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving setDataTransferType()");
        }
    }

    public void setMode(int mode) {
        if (mode != 10 && mode != 11) {
            throw new IllegalArgumentException("mode");
        }
        if (mode == 10 && this.activeModeThread_ == null) {
            this.activeModeObject_ = new FTPThread(this);
            this.activeModeThread_ = new Thread(this.activeModeObject_);
            this.activeModeThread_.setDaemon(true);
        }
        this.mode_ = mode;
    }

    public synchronized void setPassword(String password) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setPassword(), (no leaving entry)");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() == 0) {
            throw new IllegalArgumentException("password");
        }
        try {
            Date d = new Date();
            Random r = new Random(d.getTime());
            this.mask_ = new byte[7];
            r.nextBytes(this.mask_);
            this.adder_ = new byte[9];
            r.nextBytes(this.adder_);
            this.encryptedPassword_ = this.encode(password.getBytes(), this.mask_, this.adder_);
            this.encrypted_ = true;
        }
        catch (Exception e) {
            this.encrypted_ = false;
            this.clearPassword_ = password;
        }
    }

    public synchronized void setPort(int port) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setPort()");
        }
        if (port < 1) {
            throw new IllegalArgumentException("port");
        }
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        int oldValue = this.port_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("port", new Integer(oldValue), new Integer(port));
        }
        this.port_ = port;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("port", new Integer(oldValue), new Integer(port));
        }
    }

    public void setReuseSocket(boolean reuse) {
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        this.reuseSocket_ = reuse;
    }

    public synchronized void setServer(String server) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering setServer(), (no leaving entry)");
        }
        if (server == null) {
            throw new NullPointerException("server");
        }
        if (server.length() == 0) {
            throw new IllegalArgumentException("server");
        }
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        String oldServer = this.server_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("server", oldServer, server);
        }
        this.server_ = server;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("server", oldServer, server);
        }
    }

    public synchronized void setUser(String user) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering getUser(), (no leaving entry)");
        }
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("user");
        }
        if (this.connectionState_ != 0) {
            throw new IllegalStateException("connected");
        }
        String oldUser = this.user_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("user", oldUser, user);
        }
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.user_ = user;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("user", oldUser, user);
        }
    }

    public synchronized int ren(String fromName, String toName) throws IOException {
        int renamedCount = 0;
        if (Trace.isTraceOn()) {
            Trace.log(1, "entering ren(), from file name is " + fromName + ", to file name is " + toName + ".");
        }
        if (fromName == null) {
            throw new NullPointerException("fromName");
        }
        if (toName == null) {
            throw new NullPointerException("toName");
        }
        if (fromName.trim().length() == 0) {
            throw new IllegalArgumentException("fromName");
        }
        if (toName.trim().length() == 0) {
            throw new IllegalArgumentException("toName");
        }
        String[] entries = this.ls(fromName);
        for (int i = 0; i < entries.length; ++i) {
            this.issueCommand("RNFR " + entries[i]);
            if (!this.lastMessage_.startsWith("35")) continue;
            this.issueCommand("RNTO " + FTP.generateNewName(entries[i], toName));
            if (!this.lastMessage_.startsWith("25")) continue;
            ++renamedCount;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "leaving ren(). renamedCount = " + renamedCount);
        }
        return renamedCount;
    }

    public static String generateNewName(String fromName, String toName) {
        if (fromName == null) {
            throw new NullPointerException("fromName");
        }
        if (toName == null) {
            throw new NullPointerException("toName");
        }
        if ((fromName = fromName.trim()).length() < 1) {
            throw new IllegalArgumentException("fromName");
        }
        if ((toName = toName.trim()).length() < 1) {
            throw new IllegalArgumentException("toName");
        }
        if (toName.indexOf(42) < 0) {
            return toName;
        }
        if (toName.indexOf(46) < 0) {
            return FTP.newNamePart(fromName, toName);
        }
        String[] fromParts = FTP.splitName(fromName, '.');
        String[] toParts = FTP.splitName(toName, '.');
        String theFront = FTP.newNamePart(fromParts[0], toParts[0]);
        String theBack = FTP.newNamePart(fromParts[1], toParts[1]);
        String theNewName = theFront;
        if (theBack.length() > 0) {
            theNewName = theNewName + "." + theBack;
        }
        return theNewName;
    }

    static String newNamePart(String fromName, String toName) {
        int indexA = toName.indexOf(42);
        if (indexA < 0) {
            return toName;
        }
        if (indexA < toName.length() - 1 && toName.indexOf(42, indexA + 1) > 0) {
            throw new IllegalArgumentException("toName");
        }
        StringBuffer nameBuff = new StringBuffer();
        if (indexA > 0) {
            nameBuff.append(toName.substring(0, indexA));
        }
        nameBuff.append(fromName);
        if (indexA < toName.length() - 1) {
            nameBuff.append(toName.substring(indexA + 1));
        }
        return nameBuff.toString();
    }

    static String[] splitName(String stringValue, char c) {
        String[] pieces = new String[2];
        int splitIndex = stringValue.lastIndexOf(c);
        if (splitIndex >= 0) {
            pieces[0] = stringValue.substring(0, splitIndex);
            pieces[1] = splitIndex < stringValue.length() - 1 ? stringValue.substring(splitIndex + 1) : "";
        } else {
            pieces[0] = stringValue;
            pieces[1] = "";
        }
        return pieces;
    }

    final Socket getDataSocket() throws IOException {
        String response = this.issueCommand("EPSV");
        if (response.startsWith("229")) {
            int end;
            int ii;
            int begin = response.indexOf(40);
            if (begin == -1) {
                Trace.log(2, "FTP server response does not contain a left parenthesis.");
                throw new InternalErrorException(5, response, null);
            }
            int responseLength = response.length();
            for (ii = begin + 1; ii < responseLength && !Character.isDigit(response.charAt(ii)); ++ii) {
            }
            if (ii == responseLength) {
                Trace.log(2, "FTP server response does not contain a port number.");
                throw new InternalErrorException(5, response, null);
            }
            begin = ii;
            for (end = begin + 1; end < responseLength && Character.isDigit(response.charAt(end)); ++end) {
            }
            int port = Integer.parseInt(response.substring(begin, end));
            return new Socket(this.server_, port);
        }
        response = this.issueCommand("PASV");
        int p = this.extractPortAddress(response);
        return new Socket(this.server_, p);
    }

    private void checkSocketProperty() {
        String property = SystemProperties.getProperty("com.ibm.as400.access.FTP.reuseSocket");
        if (Trace.traceOn_) {
            Trace.log(1, "FTP.reuseSocket system property: " + property);
        }
        if (property != null) {
            this.reuseSocket_ = property.equalsIgnoreCase("true");
        }
    }
}

