/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.Copyright;
import com.ibm.as400.access.NLSTableDownload;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Date;

public class GenerateConverterTable {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    static AS400 sys = null;
    static boolean compress_ = true;
    static boolean codePointPerLine_ = false;
    static boolean ascii_ = false;
    static boolean bidi_ = false;
    static boolean showOffsets_ = false;
    private static final char repSig = '\uffff';
    private static final char cic_ = '\uffff';
    private static final char rampSig = '\ufffe';
    private static final char ric_ = '\ufffe';
    private static final char hbSig = '\u0000';
    private static final char pad = '\u0000';
    static int numRepeats;
    static int numRamps;
    static int hbRepeats;
    static int charRepeats;

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: java com.ibm.as400.access.GenerateConverterTable system uid pwd [-nocompress] [-ascii] [-bidi] [-showOffsets] [-codePointPerLine] ccsid [ccsid2] [ccsid3] [ccsid4] ...");
            System.exit(0);
        }
        try {
            sys = new AS400(args[0], args[1], args[2]);
            sys.connectService(6);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        int start = 3;
        if (args[start].equals("-nocompress")) {
            compress_ = false;
            ++start;
        }
        if (args[start].equals("-ascii")) {
            ascii_ = true;
            ++start;
        }
        if (args[start].equals("-bidi")) {
            bidi_ = true;
            ++start;
        }
        if (args[start].equals("-showOffsets")) {
            showOffsets_ = true;
            ++start;
        }
        if (args[start].equals("-codePointPerLine")) {
            codePointPerLine_ = true;
            ++start;
        }
        for (int i = start; i < args.length; ++i) {
            GenerateConverterTable.go(new Integer(args[i]));
        }
    }

    static String formattedChar(char x) {
        int num = 0xFFFF & x;
        String s = "\\u";
        if (num < 16) {
            s = s + "0";
        }
        if (num < 256) {
            s = s + "0";
        }
        if (num < 4096) {
            s = s + "0";
        }
        s = s + Integer.toHexString(num).toUpperCase();
        return s;
    }

    static void go(int ccsid) {
        char num;
        int i;
        String fName;
        int c;
        char[] tableToUnicode = new char[]{};
        char[] tableToEbcdic = new char[]{};
        Object surrogateTable = null;
        boolean ebcdicIsDBCS = false;
        int doubleByteFormat = 2;
        int originalCcsid = ccsid;
        try {
            AS400ImplRemote impl = (AS400ImplRemote)sys.getImpl();
            NLSTableDownload down = new NLSTableDownload(impl);
            down.connect();
            if (ccsid == 1089) {
                System.out.println("Special case for ccsid 1089.");
                System.out.println("Retrieving " + ccsid + "->61952 table...");
                tableToUnicode = down.download(ccsid, 61952, 1);
            } else if (ccsid == 61175) {
                System.out.println("Special case for ccsid 61175.");
                System.out.println("Retrieving 1026->13488 table and adjusting...");
                tableToUnicode = down.download(1026, 13488, 1);
                tableToUnicode[252] = tableToUnicode[127];
                tableToUnicode[127] = 34;
            } else if (ccsid == 1376) {
                tableToUnicode = null;
            } else if (ccsid == 1371) {
                tableToUnicode = null;
                doubleByteFormat = 3;
            } else {
                System.out.println("Retrieving " + ccsid + "->13488 table...");
                tableToUnicode = down.download(ccsid, 13488, 1);
            }
            if (tableToUnicode == null || tableToUnicode.length == 0) {
                String reason = "";
                reason = tableToUnicode == null ? "tableToUnicode is null" : "tableToUnicode.length is 0";
                if (ccsid == 1175) {
                    System.out.println("Aborting since CCSD 1175 failed to download");
                    throw new Exception("Aborting since CCSD 1175 failed to download");
                }
                System.out.println(ccsid + " must be double-byte because download failed (" + reason + "). Performing secondary retrieve of " + ccsid + "->1200 table...");
                ebcdicIsDBCS = true;
                down.disconnect();
                down.connect();
                tableToUnicode = down.download(ccsid, 1200, doubleByteFormat);
            }
            System.out.println("  Size: " + tableToUnicode.length);
            if (tableToUnicode.length > 65536) {
                System.out.println("Size is > 65536.  Fixing table");
                int from = 0;
                char[] newTable = new char[65536];
                for (int next = 0; from < tableToUnicode.length && next < 65536; ++next) {
                    int c2 = 0xFFFF & tableToUnicode[from];
                    if (next > 60586 && next <= 60624) {
                        System.out.println("Next=0x" + Integer.toHexString(next) + " to=" + Integer.toHexString(c2));
                    }
                    int nextchar = 0;
                    if (from + 1 < tableToUnicode.length) {
                        nextchar = 0xFFFF & tableToUnicode[from + 1];
                    }
                    if (c2 >= 55296 && c2 <= 57343 || nextchar == 12442 && c2 != 12441 || c2 != 65533 && nextchar == 768 || c2 != 4093 && c2 != 768 && nextchar == 769 || c2 == 741 && nextchar == 745 || c2 == 745 && nextchar == 741) {
                        newTable[next] = 55296;
                        if (surrogateTable == null) {
                            surrogateTable = new char[65536][];
                        }
                        char[] pair = new char[2];
                        surrogateTable[next] = pair;
                        pair[0] = (char)(0xFFFF & tableToUnicode[from]);
                        pair[1] = (char)(0xFFFF & tableToUnicode[from + 1]);
                        from += 2;
                        continue;
                    }
                    newTable[next] = (char)c2;
                    ++from;
                }
                tableToUnicode = newTable;
            }
            down.disconnect();
            down.connect();
            if (ccsid == 1089) {
                System.out.println("Special case for ccsid 1089.");
                System.out.println("Retrieving 61952->" + ccsid + " table...");
                tableToEbcdic = down.download(61952, ccsid, 2);
            } else {
                System.out.println("Retrieving 1200->" + ccsid + " table...");
                tableToEbcdic = down.download(1200, ccsid, 2);
            }
            System.out.println("  Size: " + tableToEbcdic.length);
            if (doubleByteFormat == 3) {
                char[] newTableToEbcdic = new char[65536];
                byte[] oldTableToEbcdic = new byte[tableToEbcdic.length * 2];
                for (int i2 = 0; i2 < tableToEbcdic.length; ++i2) {
                    oldTableToEbcdic[2 * i2] = (byte)(0xFF & tableToEbcdic[i2] >> 8);
                    oldTableToEbcdic[2 * i2 + 1] = (byte)(tableToEbcdic[i2] & 0xFF);
                }
                boolean singleByte = true;
                int newTableOffset = 0;
                for (int i3 = 0; i3 < oldTableToEbcdic.length; ++i3) {
                    int b = 0xFF & oldTableToEbcdic[i3];
                    while (i3 > 15 && i3 < oldTableToEbcdic.length && (b == 14 || b == 15)) {
                        if (b == 14) {
                            singleByte = false;
                            ++i3;
                        } else {
                            singleByte = true;
                            ++i3;
                        }
                        if (i3 >= oldTableToEbcdic.length) continue;
                        b = 0xFF & oldTableToEbcdic[i3];
                    }
                    if (i3 >= oldTableToEbcdic.length) continue;
                    if (singleByte) {
                        if (newTableOffset >= newTableToEbcdic.length) continue;
                        newTableToEbcdic[newTableOffset] = (char)b;
                        ++newTableOffset;
                        continue;
                    }
                    if (++i3 >= oldTableToEbcdic.length) continue;
                    int c3 = 0xFF & oldTableToEbcdic[i3];
                    if (newTableOffset >= newTableToEbcdic.length) continue;
                    if (newTableOffset == 1073) {
                        newTableToEbcdic[newTableOffset] = (char)((b << 8) + c3);
                        ++newTableOffset;
                        continue;
                    }
                    newTableToEbcdic[newTableOffset] = (char)((b << 8) + c3);
                    ++newTableOffset;
                }
                while (newTableOffset < newTableToEbcdic.length) {
                    newTableToEbcdic[newTableOffset] = 65278;
                    ++newTableOffset;
                }
                tableToEbcdic = newTableToEbcdic;
            }
            sys.disconnectAllServices();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (ccsid == 290) {
            tableToUnicode[225] = 8364;
            char toEbcdic = tableToEbcdic[4182];
            tableToEbcdic[4182] = toEbcdic = (char)(0xE100 | toEbcdic & 0xFF);
        }
        GenerateConverterTable.verifyRoundTrip(tableToUnicode, tableToEbcdic, ebcdicIsDBCS);
        System.out.println("****************************************");
        System.out.println("Verify round 2 ");
        System.out.println("****************************************");
        GenerateConverterTable.verifyRoundTrip(tableToUnicode, tableToEbcdic, ebcdicIsDBCS);
        if (ebcdicIsDBCS && compress_) {
            System.out.println("Compressing " + ccsid + "->13488 conversion table...");
            char[] arr = GenerateConverterTable.compress(tableToUnicode);
            System.out.println("Old compression length: " + arr.length + " characters.");
            char[] temparr = GenerateConverterTable.compressBetter(tableToUnicode);
            System.out.println("New compression length: " + temparr.length + " characters.");
            if (temparr.length > arr.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            arr = GenerateConverterTable.decompressBetter(temparr);
            if (arr.length != tableToUnicode.length) {
                int c4;
                System.out.println("Verification failed, lengths not equal: " + arr.length + " != " + tableToUnicode.length);
                for (c4 = 0; c4 < arr.length && arr[c4] == tableToUnicode[c4]; ++c4) {
                }
                System.out.println("First mismatch at index " + c4 + ": " + arr[c4] + " != " + tableToUnicode[c4]);
            } else {
                boolean bad = false;
                for (c = 0; c < arr.length; ++c) {
                    if (arr[c] == tableToUnicode[c]) continue;
                    bad = true;
                    System.out.println(c + ": " + Integer.toHexString(arr[c]) + " != " + Integer.toHexString(tableToUnicode[c]));
                }
                if (bad) {
                    System.out.println("Mismatches found in table.");
                } else {
                    tableToUnicode = temparr;
                    System.out.println("Table verified.");
                }
            }
        }
        int fileCcsid = ccsid;
        if (doubleByteFormat == 3) {
            fileCcsid = ccsid + 1100000;
            System.out.println("Create file using " + fileCcsid + " since MIXED CCSID ");
        }
        try {
            fName = "ConvTable" + fileCcsid + ".java";
            FileWriter f = new FileWriter(fName);
            GenerateConverterTable.writeHeader(f, fileCcsid, sys.getSystemName());
            if (ascii_) {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableAsciiMap\n{\n");
            } else if (bidi_) {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableBidiMap\n{\n");
            } else if (ebcdicIsDBCS) {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableDoubleMap\n{\n");
            } else {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableSingleMap\n{\n");
            }
            f.write("  private static char[] toUnicodeArray_;  \n");
            f.write("  private static final String copyright = \"Copyright (C) 1997-2016 International Business Machines Corporation and others.\";\n");
            f.write("  private static final String toUnicode_ = \n");
            System.out.print("Writing table for conversion from " + ccsid + " to 13488... to " + fName + "\n");
            for (i = 0; i < tableToUnicode.length; i += 16) {
                if (showOffsets_) {
                    f.write("/* " + Integer.toHexString(i) + " */ \"");
                } else {
                    f.write("    \"");
                }
                for (int j = 0; j < 16 && i + j < tableToUnicode.length; ++j) {
                    num = tableToUnicode[i + j];
                    if (num == '\b') {
                        f.write("\\b");
                    } else if (num == '\t') {
                        f.write("\\t");
                    } else if (num == '\n') {
                        f.write("\\n");
                    } else if (num == '\f') {
                        f.write("\\f");
                    } else if (num == '\r') {
                        f.write("\\r");
                    } else if (num == '\"') {
                        f.write("\\\"");
                    } else if (num == '\'') {
                        f.write("\\'");
                    } else if (num == '\\') {
                        f.write("\\\\");
                    } else {
                        String s = "\\u";
                        if (num < '\u0010') {
                            s = s + "0";
                        }
                        if (num < '\u0100') {
                            s = s + "0";
                        }
                        if (num < '\u1000') {
                            s = s + "0";
                        }
                        s = s + Integer.toHexString(num).toUpperCase();
                        f.write(s);
                    }
                    if (!codePointPerLine_ || j >= 15) continue;
                    if (showOffsets_) {
                        f.write("\" +\n/* " + Integer.toHexString(i + j + 1) + " */ \"");
                        continue;
                    }
                    f.write("\" +\n    \"");
                }
                if (i + 16 < tableToUnicode.length) {
                    f.write("\" +\n");
                    continue;
                }
                f.write("\";\n");
            }
            f.write("\n");
            f.write("\n");
            if (surrogateTable != null) {
                f.write("\n");
                f.write("  private static final char[][] toUnicodeSurrogateMappings = { \n");
                System.out.print("Writing surrogate table for conversion from " + ccsid + " to 13488... to " + fName + "\n");
                for (i = 0; i < ((char[][])surrogateTable).length; ++i) {
                    char[] pair = surrogateTable[i];
                    if (pair == null) continue;
                    f.write("{'" + GenerateConverterTable.formattedChar((char)i) + "','" + GenerateConverterTable.formattedChar(pair[0]) + "','" + GenerateConverterTable.formattedChar(pair[1]) + "'},\n");
                }
                f.write("};\n");
                f.write("\n");
                f.write("\n");
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (compress_) {
            System.out.println("Compressing 13488->" + ccsid + " conversion table...");
            char[] arr = GenerateConverterTable.compress(tableToEbcdic);
            System.out.println("Old compression length: " + arr.length + " characters.");
            char[] temparr = GenerateConverterTable.compressBetter(tableToEbcdic);
            System.out.println("New compression length: " + temparr.length + " characters.");
            if (temparr.length > arr.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            arr = GenerateConverterTable.decompressBetter(temparr);
            if (arr.length != tableToEbcdic.length) {
                System.out.println("Verification failed, lengths not equal: " + arr.length + " != " + tableToEbcdic.length);
                for (c = 0; c < arr.length && arr[c] == tableToEbcdic[c]; ++c) {
                }
                System.out.println("First mismatch at index " + c + ": " + arr[c] + " != " + tableToEbcdic[c]);
                tableToEbcdic = temparr;
            } else {
                boolean bad = false;
                for (int c5 = 0; c5 < arr.length; ++c5) {
                    if (arr[c5] == tableToEbcdic[c5]) continue;
                    bad = true;
                    System.out.println(c5 + ": " + Integer.toHexString(arr[c5]) + " != " + Integer.toHexString(tableToEbcdic[c5]));
                }
                if (bad) {
                    System.out.println("Mismatches found in table.");
                } else {
                    tableToEbcdic = temparr;
                    System.out.println("Table verified.");
                }
            }
        }
        try {
            fName = "ConvTable" + fileCcsid + ".java";
            FileWriter f = new FileWriter(fName, true);
            f.write("  private static char[] fromUnicodeArray_; \n");
            f.write("  private static final String fromUnicode_ = \n");
            System.out.print("Writing table for conversion from 13488 to " + ccsid + "... to " + fName + "\n");
            for (i = 0; i < tableToEbcdic.length; i += 16) {
                if (showOffsets_) {
                    f.write("/* " + Integer.toHexString(i) + " */ \"");
                } else {
                    f.write("    \"");
                }
                for (int j = 0; j < 16 && i + j < tableToEbcdic.length; ++j) {
                    num = tableToEbcdic[i + j];
                    if (num == '\b') {
                        f.write("\\b");
                    } else if (num == '\t') {
                        f.write("\\t");
                    } else if (num == '\n') {
                        f.write("\\n");
                    } else if (num == '\f') {
                        f.write("\\f");
                    } else if (num == '\r') {
                        f.write("\\r");
                    } else if (num == '\"') {
                        f.write("\\\"");
                    } else if (num == '\'') {
                        f.write("\\'");
                    } else if (num == '\\') {
                        f.write("\\\\");
                    } else {
                        String s = "\\u";
                        if (num < '\u0010') {
                            s = s + "0";
                        }
                        if (num < '\u0100') {
                            s = s + "0";
                        }
                        if (num < '\u1000') {
                            s = s + "0";
                        }
                        s = s + Integer.toHexString(num).toUpperCase();
                        f.write(s);
                    }
                    if (!codePointPerLine_ || j >= 15) continue;
                    if (showOffsets_) {
                        f.write("\" +\n/* " + Integer.toHexString(i + j + 1) + " */ \"");
                        continue;
                    }
                    f.write("\" +\n    \"");
                }
                if (i + 16 < tableToEbcdic.length) {
                    f.write("\" +\n");
                    continue;
                }
                f.write("\";\n");
            }
            f.write("\n");
            f.write("  static {\n");
            f.write("    toUnicodeArray_ = toUnicode_.toCharArray();\n");
            f.write("    fromUnicodeArray_ = fromUnicode_.toCharArray();\n");
            f.write("  }\n");
            f.write("\n  ConvTable" + fileCcsid + "()\n  {\n");
            f.write("    super(" + fileCcsid + ", ");
            f.write("toUnicodeArray_, ");
            if (surrogateTable != null) {
                f.write("fromUnicodeArray_,");
                f.write("toUnicodeSurrogateMappings);\n");
            } else {
                f.write("fromUnicodeArray_);\n");
            }
            f.write("  }\n\n");
            f.write("\n  ConvTable" + fileCcsid + "(int ccsid)\n  {\n");
            f.write("    super(ccsid, ");
            f.write("toUnicodeArray_, ");
            if (surrogateTable != null) {
                f.write("fromUnicodeArray_,");
                f.write("toUnicodeSurrogateMappings);\n");
            } else {
                f.write("fromUnicodeArray_);\n");
            }
            f.write("  }\n}\n");
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print("Done.\n");
    }

    private static boolean verifyRoundTrip(char[] tableToUnicode, char[] tableToEbcdic, boolean ebcdicIsDBCS) {
        int i;
        int piece;
        String ebcdicPrefix = "X";
        if (ebcdicIsDBCS) {
            ebcdicPrefix = "GX";
        }
        if (!ebcdicIsDBCS && (piece = 0xFFFF & tableToEbcdic[13]) >> 8 != 63) {
            System.out.println("Fixing sub char in tableToEbcdic == sub was 0x" + Integer.toHexString(piece >> 8));
            piece = 0x3F00 | 0xFF & piece;
            tableToEbcdic[13] = (char)piece;
        }
        System.out.println("Checking round trip");
        boolean passed = true;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb3 = new StringBuffer();
        for (i = 0; i < tableToUnicode.length; ++i) {
            int piece2;
            int ebcdicChar;
            int unicodeChar = 0xFFFF & tableToUnicode[i];
            if (unicodeChar == 65533 || unicodeChar == 55296) continue;
            if (ebcdicIsDBCS) {
                ebcdicChar = 0xFFFF & tableToEbcdic[unicodeChar];
            } else {
                piece2 = 0xFFFF & tableToEbcdic[unicodeChar / 2];
                ebcdicChar = unicodeChar % 2 == 0 ? piece2 >> 8 : piece2 & 0xFF;
            }
            if (i == ebcdicChar) continue;
            if (unicodeChar != 26 && (ebcdicChar == 65278 || ebcdicChar == 63)) {
                sb1.append("Fixing up EBCDIC RoundTrip Failure " + ebcdicPrefix + "'" + Integer.toHexString(i) + "'" + " -> UX'" + Integer.toHexString(unicodeChar) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'\n");
                if (ebcdicIsDBCS) {
                    tableToEbcdic[unicodeChar] = (char)i;
                } else {
                    piece2 = 0xFFFF & tableToEbcdic[unicodeChar / 2];
                    piece2 = unicodeChar % 2 == 0 ? i << 8 | piece2 & 0xFF : piece2 & 0xFF00 | i;
                    tableToEbcdic[unicodeChar / 2] = (char)piece2;
                }
                passed = false;
                continue;
            }
            int unicodeChar2 = 0;
            try {
                unicodeChar2 = 0xFFFF & tableToUnicode[ebcdicChar];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("ERROR.. ArrayIndexOutOfBounds");
                System.out.println("ebcdicChar=0x" + Integer.toHexString(ebcdicChar));
                System.out.println("i=" + i);
                System.out.println("unicodeChar=0x" + Integer.toHexString(unicodeChar));
                throw e;
            }
            if (unicodeChar2 == unicodeChar) {
                sb2.append("Secondary EBCDIC mapping " + ebcdicPrefix + "'" + Integer.toHexString(i) + "'" + " -> UX'" + Integer.toHexString(unicodeChar) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'" + " -> UX'" + Integer.toHexString(unicodeChar2) + "'\n");
                continue;
            }
            sb3.append("EBCDIC RoundTrip Failure2 " + ebcdicPrefix + "'" + Integer.toHexString(i) + "'" + " -> UX'" + Integer.toHexString(unicodeChar) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'" + " -> UX'" + Integer.toHexString(unicodeChar2) + "'\n");
            passed = false;
        }
        System.out.println(sb2);
        System.out.println(sb1);
        System.out.println(sb3);
        sb1.setLength(0);
        sb2.setLength(0);
        sb3.setLength(0);
        for (i = 0; i < tableToEbcdic.length; ++i) {
            int ebcdicChar2;
            int unicodeChar;
            int ebcdicChar;
            if (ebcdicIsDBCS) {
                ebcdicChar = 0xFFFF & tableToEbcdic[i];
            } else {
                int piece3 = 0xFFFF & tableToEbcdic[i / 2];
                ebcdicChar = i % 2 == 0 ? piece3 >> 8 : piece3 & 0xFF;
            }
            if (ebcdicChar == 65278 || ebcdicChar == 63 || i == (unicodeChar = 0xFFFF & tableToUnicode[ebcdicChar])) continue;
            if (unicodeChar == 65533) {
                sb1.append("Unicode RoundTrip Failure UX'" + Integer.toHexString(i) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'" + " -> UX'" + Integer.toHexString(unicodeChar) + "'\n");
                passed = false;
                continue;
            }
            if (ebcdicIsDBCS) {
                ebcdicChar2 = 0xFFFF & tableToEbcdic[unicodeChar];
            } else {
                int piece4 = 0xFFFF & tableToEbcdic[unicodeChar / 2];
                ebcdicChar2 = unicodeChar % 2 == 0 ? piece4 >> 8 : piece4 & 0xFF;
            }
            if (ebcdicChar2 == ebcdicChar) {
                sb2.append("Secondary Unicode mapping UX'" + Integer.toHexString(i) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'" + " -> UX'" + Integer.toHexString(unicodeChar) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar2) + "'\n");
                continue;
            }
            sb3.append("Unicode RoundTrip Failure2 UX'" + Integer.toHexString(i) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'" + " -> UX'" + Integer.toHexString(unicodeChar) + "'" + " -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar2) + "'\n");
            passed = false;
        }
        System.out.println(sb2);
        System.out.println(sb1);
        System.out.println(sb3);
        return passed;
    }

    static int repeatCheck(char[] arr, int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < arr.length && arr[index] == arr[index - 1]; ++index) {
        }
        return index - startingIndex;
    }

    static final int rampCheck(char[] arr, int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < arr.length && arr[index] == arr[index - 1] + '\u0001'; ++index) {
        }
        return index - startingIndex;
    }

    static int hbCheck(char[] arr, int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < arr.length; ++index) {
            if (GenerateConverterTable.repeatCheck(arr, index) > 6) {
                return index - startingIndex;
            }
            if (GenerateConverterTable.rampCheck(arr, index) > 6) {
                return index - startingIndex;
            }
            if ((arr[index] & 0xFF00) == (arr[index - 1] & 0xFF00)) continue;
            return index - startingIndex;
        }
        return index - startingIndex;
    }

    static char[] compressBetter(char[] arr) {
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            int repNum = GenerateConverterTable.repeatCheck(arr, i);
            if (repNum > 3) {
                ++numRepeats;
                buf.append('\uffff');
                buf.append((char)repNum);
                buf.append(arr[i]);
                i += repNum - 1;
                continue;
            }
            int rampNum = GenerateConverterTable.rampCheck(arr, i);
            if (rampNum > 3) {
                ++numRamps;
                buf.append('\ufffe');
                buf.append((char)rampNum);
                buf.append(arr[i]);
                i += rampNum - 1;
                continue;
            }
            int hbNum = GenerateConverterTable.hbCheck(arr, i);
            if (--hbNum >= 6) {
                ++hbRepeats;
                buf.append('\u0000');
                if (hbNum % 2 == 1) {
                    --hbNum;
                }
                buf.append((char)(hbNum / 2));
                buf.append(arr[i++]);
                for (int j = 0; j < hbNum / 2; ++j) {
                    char x = (char)((0xFF & arr[i + j * 2]) * 256 + (0xFF & arr[i + j * 2 + 1]));
                    buf.append(x);
                }
                i = i + hbNum - 1;
                continue;
            }
            buf.append(arr[i]);
            ++charRepeats;
            if (arr[i] != '\uffff' && arr[i] != '\ufffe' && arr[i] != '\u0000') continue;
            buf.append('\u0000');
        }
        System.out.println("Compression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return buf.toString().toCharArray();
    }

    static char[] decompressBetter(char[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            int j;
            if (arr[i] == '\uffff') {
                if (arr[i + 1] == '\u0000') {
                    buf.append('\uffff');
                    ++i;
                    continue;
                }
                ++numRepeats;
                int repNum = arr[i + 1];
                char repChar = arr[i + 2];
                for (j = 0; j < repNum; ++j) {
                    buf.append(repChar);
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\ufffe') {
                if (arr[i + 1] == '\u0000') {
                    buf.append('\ufffe');
                    ++i;
                    continue;
                }
                ++numRamps;
                int rampNum = arr[i + 1];
                char rampStart = arr[i + 2];
                for (j = 0; j < rampNum; ++j) {
                    buf.append((char)(j + rampStart));
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\u0000') {
                if (arr[i + 1] == '\u0000') {
                    buf.append('\u0000');
                    ++i;
                    continue;
                }
                ++hbRepeats;
                int hbNum = 0xFFFF & arr[++i];
                char firstChar = arr[++i];
                char highByteMask = (char)(0xFF00 & firstChar);
                buf.append(firstChar);
                ++i;
                for (int j2 = 0; j2 < hbNum; ++j2) {
                    char both = arr[i + j2];
                    char c1 = (char)(highByteMask + ((0xFF00 & both) >>> 8));
                    char c2 = (char)(highByteMask + (0xFF & both));
                    buf.append(c1);
                    buf.append(c2);
                }
                i = i + hbNum - 1;
                continue;
            }
            buf.append(arr[i]);
            ++charRepeats;
        }
        System.out.println("Decompression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return buf.toString().toCharArray();
    }

    static char[] compress(char[] arr) {
        if (arr.length < 3) {
            return arr;
        }
        StringBuffer buf = new StringBuffer();
        char oldold = arr[0];
        char old = arr[1];
        int count = 0;
        boolean inCompression = false;
        boolean inRamp = false;
        for (int i = 2; i < arr.length; ++i) {
            if (!inCompression && !inRamp) {
                if (arr[i] == old && arr[i] == oldold) {
                    inCompression = true;
                    buf.append('\uffff');
                    buf.append(oldold);
                    count = 3;
                } else if (arr[i] == old + '\u0001' && arr[i] == oldold + 2) {
                    inRamp = true;
                    buf.append('\ufffe');
                    buf.append(oldold);
                } else if (oldold == '\uffff') {
                    buf.append('\uffff');
                } else if (oldold == '\ufffe') {
                    buf.append('\ufffe');
                } else {
                    buf.append(oldold);
                }
                oldold = old;
                old = arr[i];
                continue;
            }
            if (inCompression) {
                if (arr[i] == old && arr[i] == oldold) {
                    ++count;
                    oldold = old;
                    old = arr[i];
                    continue;
                }
                inCompression = false;
                int c = count;
                if (count == 8) {
                    c = 8;
                } else if (count == 9) {
                    c = 9;
                } else if (count == 10) {
                    c = 10;
                } else if (count == 12) {
                    c = 12;
                } else if (count == 13) {
                    c = 13;
                } else if (count == 34) {
                    c = 34;
                } else if (count == 39) {
                    c = 39;
                } else if (count == 92) {
                    c = 92;
                }
                buf.append((char)c);
                oldold = arr[i++];
                old = arr[i];
                continue;
            }
            if (arr[i] == old + '\u0001' && arr[i] == oldold + 2) {
                oldold = old;
                old = arr[i];
                continue;
            }
            inRamp = false;
            buf.append(old);
            oldold = arr[i++];
            old = arr[i];
        }
        if (inCompression) {
            int c = count;
            if (count == 8) {
                c = 8;
            } else if (count == 9) {
                c = 9;
            } else if (count == 10) {
                c = 10;
            } else if (count == 12) {
                c = 12;
            } else if (count == 13) {
                c = 13;
            } else if (count == 34) {
                c = 34;
            } else if (count == 39) {
                c = 39;
            } else if (count == 92) {
                c = 92;
            }
            buf.append((char)c);
        }
        if (inRamp) {
            buf.append(old);
        }
        return buf.toString().toCharArray();
    }

    static void writeHeader(FileWriter f, int ccsid, String system) throws Exception {
        int dotIndex = system.indexOf(46);
        if (dotIndex > 0) {
            system = system.substring(0, dotIndex);
        }
        Date currentDate = new Date();
        Class<Copyright> copyrightClass = Copyright.class;
        Field field = copyrightClass.getField("version");
        String jtopenVersion = (String)field.get(null);
        f.write("///////////////////////////////////////////////////////////////////////////////\n");
        f.write("//\n");
        f.write("// JTOpen (IBM Toolbox for Java - OSS version)\n");
        f.write("//\n");
        f.write("// Filename:  ConvTable" + ccsid + ".java\n");
        f.write("//\n");
        f.write("// The source code contained herein is licensed under the IBM Public License\n");
        f.write("// Version 1.0, which has been approved by the Open Source Initiative.\n");
        f.write("// Copyright (C) 1997-2016 International Business Machines Corporation and\n");
        f.write("// others.  All rights reserved.\n");
        f.write("//\n");
        f.write("// Generated " + currentDate + " from " + system + "\n");
        f.write("// Using " + jtopenVersion + "\n");
        f.write("///////////////////////////////////////////////////////////////////////////////\n\n");
        f.write("package com.ibm.as400.access;\n\n");
    }
}

